package com.amity.socialcloud.sdk.video.data.moderation

import androidx.room.Dao
import androidx.room.Query
import com.amity.socialcloud.sdk.entity.video.stream.StreamModerationEntity
import com.ekoapp.ekosdk.internal.data.dao.EkoObjectDao
import io.reactivex.rxjava3.core.Flowable


@Dao
abstract class StreamModerationDao : EkoObjectDao<StreamModerationEntity>() {

    @Query("SELECT * from stream_moderation where moderationId = :moderationId")
    abstract fun getByIdImpl(moderationId: String): Flowable<StreamModerationEntity>
    fun getById(moderationId: String): Flowable<StreamModerationEntity> {
        return getByIdImpl(moderationId)
    }

    @Query("SELECT * from stream_moderation where moderationId = :moderationId")
    abstract fun getByIdNowImpl(moderationId: String): StreamModerationEntity?

    override fun getByIdNow(moderationId: String): StreamModerationEntity? {
        return getByIdNowImpl(moderationId)
    }

    @Query("DELETE from stream_moderation")
    abstract override fun deleteAll()


}
