package com.amity.socialcloud.sdk.model.core.file

import android.os.Parcelable
import co.amity.rxupload.FileProperties
import com.ekoapp.ekosdk.FilePropertiesParceler
import com.google.gson.JsonArray
import com.google.gson.JsonObject
import kotlinx.parcelize.Parcelize
import kotlinx.parcelize.TypeParceler


@Parcelize
@TypeParceler<FileProperties, FilePropertiesParceler>
class AmityRawFile(
    private val fileId: String,
    private val fileType: AmityFileType,
    private val filePath: String?,
    private val properties: FileProperties
) : Parcelable {

    fun getFileId(): String {
        return fileId
    }

    fun getFileType(): AmityFileType {
        return fileType
    }

    private fun getResponseBody(): JsonObject? {
        return when {
            properties.responseBody.isJsonArray -> {
                val jsonResponseBody = (properties.responseBody as? JsonArray)?.first()
                (jsonResponseBody as? JsonObject)
            }
            properties.responseBody.isJsonObject -> {
                (properties.responseBody as? JsonObject)
            }
            else -> {
                null
            }
        }
    }

    internal fun getAttributes(): JsonObject? {
        return (getResponseBody()?.get("attributes") as? JsonObject)
    }

    internal fun getMetaData(): JsonObject? {
        return (getAttributes()?.get("metadata") as? JsonObject)
    }

    internal fun getUrl(): String? {
        return getResponseBody()?.get("fileUrl")?.asString
    }

    internal fun getFileExtension(): String? {
        return getAttributes()?.get("extension")?.asString ?: ""
    }

    internal fun getFileName(): String {
        return properties.fileName
    }

    internal fun getMimeType(): String {
        return properties.mimeType
    }

    internal fun getFileSize(): Long {
        return properties.fileSize
    }

    internal fun getFilePath(): String? {
        return filePath
    }

    internal fun getProgressPercentage(): Int {
        return properties.progress
    }

    internal fun getAccessType(): AmityFileAccessType {
        return AmityFileAccessType.enumOf(
            getResponseBody()?.get("accessType")?.asString ?: ""
        )
    }
}