package com.amity.socialcloud.sdk.infra.mqtt.listener

import com.amity.socialcloud.sdk.api.core.AmityCoreClient
import com.amity.socialcloud.sdk.core.data.session.SessionLocalDataStore
import com.amity.socialcloud.sdk.social.data.post.PostEventPersister
import com.amity.socialcloud.sdk.social.data.post.PostLocalDataStore
import com.ekoapp.ekosdk.internal.api.dto.EkoPostQueryDto
import io.reactivex.rxjava3.core.Flowable
import io.reactivex.rxjava3.schedulers.Schedulers

internal class PostDeleted : PostEventListener() {

    override fun getEventName(): String {
        return "post.deleted"
    }

    override fun processEvent(dto: EkoPostQueryDto) {
        val activeUser = SessionLocalDataStore().getActiveUserId()
        PostEventPersister().persist(dto)
            .subscribeOn(Schedulers.io())
            .andThen(
                dto.posts
                    .filter { it.postedUserId != activeUser }
                    .let { posts ->
                        Flowable.fromIterable(posts)
                    }
                    .flatMapCompletable {
                        PostLocalDataStore()
                            .hardDelete(it.postId)
                            .onErrorComplete()
                    }
            )
            .subscribeOn(Schedulers.io())
            .subscribe()
    }
}