package com.amity.socialcloud.sdk.infra.mqtt.listener

import com.amity.socialcloud.sdk.chat.data.message.MessageEventPersister
import com.amity.socialcloud.sdk.chat.data.message.MessageLocalDataStore
import com.amity.socialcloud.sdk.log.AmityLog
import com.ekoapp.ekosdk.internal.api.dto.MessageQueryDto
import io.reactivex.rxjava3.schedulers.Schedulers
import kotlin.reflect.KClass


internal abstract class MessageEventListener: MqttEventListener<MessageQueryDto>()  {

    override val type: KClass<MessageQueryDto>
        get() = MessageQueryDto::class

    override fun processEvent(dto: MessageQueryDto) {
        MessageEventPersister().persist(dto)
            .subscribeOn(Schedulers.io())
            .doOnError {
                AmityLog.e(it)
            }
            .subscribe()
    }

    override fun shouldProcessEvent(dto: MessageQueryDto): Boolean {
        var shouldProcessEvent = false
        val messageId = dto.messages?.first()?.messageId
        messageId?.let {
            shouldProcessEvent = MessageLocalDataStore().hasInLocal(it)
        }
        return shouldProcessEvent
    }

}