package com.amity.socialcloud.sdk.core.data.follow

import com.amity.socialcloud.sdk.common.QueryPersister
import com.amity.socialcloud.sdk.core.data.file.FileEntityMapper
import com.amity.socialcloud.sdk.core.data.file.FileLocalDataStore
import com.amity.socialcloud.sdk.core.data.follow.count.FollowCountEntityMapper
import com.amity.socialcloud.sdk.core.data.user.UserEntityMapper
import com.amity.socialcloud.sdk.core.data.user.UserLocalDataStore
import com.ekoapp.ekosdk.internal.api.dto.EkoFollowListDto
import io.reactivex.rxjava3.core.Completable

internal class FollowQueryPersister : QueryPersister<EkoFollowListDto>() {

    override fun persist(dto: EkoFollowListDto): Completable {
        return FileLocalDataStore().saveFiles(FileEntityMapper().map(dto.files))
            .andThen(UserLocalDataStore().saveUsers(UserEntityMapper().map(dto.users)))
            .andThen(FollowLocalDataStore().saveFollow(FollowEntityMapper().map(dto.follows)))
            .andThen(FollowLocalDataStore().saveFollowCount(FollowCountEntityMapper().map(dto.followCounts)))
    }
}