package com.amity.socialcloud.sdk.api.chat.member

import com.amity.socialcloud.sdk.chat.domain.channel.moderation.AddRoleUseCase
import com.amity.socialcloud.sdk.chat.domain.channel.moderation.BanUsersChannelUseCase
import com.amity.socialcloud.sdk.chat.domain.channel.moderation.MuteUsersChannelUseCase
import com.amity.socialcloud.sdk.chat.domain.channel.moderation.RemoveRoleUseCase
import com.amity.socialcloud.sdk.chat.domain.channel.moderation.UnBanUsersChannelUseCase
import com.amity.socialcloud.sdk.chat.domain.channel.moderation.UnMuteUsersChannelUseCase
import io.reactivex.rxjava3.core.Completable
import org.joda.time.Duration


class AmityChannelModeration internal constructor(private val channelId: String) {
    
    /* begin_public_function
	  id: channel.moderation.add_roles
	*/
    fun addRole(role: String, userIds: List<String>): Completable {
        return AddRoleUseCase().execute(channelId, role, userIds)
    }
    /* end_public_function */
    
    /* begin_public_function
	  id: channel.moderation.remove_roles
	*/
    fun removeRole(role: String, userIds: List<String>): Completable {
        return RemoveRoleUseCase().execute(channelId, role, userIds)
    }
    /* end_public_function */
    
    /* begin_public_function
	  id: channel.moderation.mute_members
	*/
    fun muteMembers(timeout: Duration, userIds: List<String>): Completable {
        return MuteUsersChannelUseCase().execute(channelId, timeout, userIds)
    }
    /* end_public_function */
    
    /* begin_public_function
	  id: channel.moderation.unmute_members
	*/
    fun unmuteMembers(userIds: List<String>): Completable {
        return UnMuteUsersChannelUseCase().execute(channelId, userIds)
    }
    /* end_public_function */


    /* begin_public_function
	  id: channel.moderation.ban_members
	*/
    fun banMembers(userIds: List<String>): Completable {
        return BanUsersChannelUseCase().execute(channelId, userIds)
    }
    /* end_public_function */
    
    /* begin_public_function
	  id: channel.moderation.unban_members
	*/
    fun unbanMembers(userIds: List<String>): Completable {
        return UnBanUsersChannelUseCase().execute(channelId, userIds)
    }
    /* end_public_function */

}