/*
 * Decompiled with CFR 0.152.
 */
package com.ekoapp.ekosdk.internal.api;

import android.os.Build;
import com.amity.socialcloud.sdk.api.core.endpoint.AmityEndpoint;
import com.ekoapp.ekosdk.internal.api.EkoEndpoint;
import com.ekoapp.ekosdk.internal.data.EkoDatabase;
import com.ekoapp.ekosdk.internal.data.model.AmityUploadUrl;
import com.ekoapp.ekosdk.internal.data.model.EkoHttpUrl;
import com.ekoapp.ekosdk.internal.data.model.EkoMqttUrl;
import io.reactivex.rxjava3.core.Flowable;
import io.reactivex.rxjava3.functions.Function;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\b\n\u0002\u0018\u0002\n\u0000\b\u00c0\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0006\u0010\u0007\u001a\u00020\u0004J\u0006\u0010\b\u001a\u00020\u0004J\u0006\u0010\t\u001a\u00020\u0004J\u000e\u0010\n\u001a\u00020\u00042\u0006\u0010\u000b\u001a\u00020\u0004J\f\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u00040\rR\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0004X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000e"}, d2={"Lcom/ekoapp/ekosdk/internal/api/EkoEndpoint;", "", "()V", "httpUrl", "", "mqttUrl", "uploadUrl", "getHttpUrl", "getMqttUrl", "getUploadUrl", "mapHttpUrlByDeviceVersion", "url", "observeHttpUrl", "Lio/reactivex/rxjava3/core/Flowable;", "amity-sdk_release"})
public final class EkoEndpoint {
    @NotNull
    public static final EkoEndpoint INSTANCE = new EkoEndpoint();
    @NotNull
    private static String httpUrl = "";
    @NotNull
    private static String mqttUrl = "";
    @NotNull
    private static String uploadUrl = "";

    private EkoEndpoint() {
    }

    @NotNull
    public final String getHttpUrl() {
        String string = ((EkoHttpUrl)EkoDatabase.get().httpUrlDao().getCurrentHttpUrl().defaultIfEmpty((Object)EkoHttpUrl.create(AmityEndpoint.SG.INSTANCE.getHttpEndpoint())).blockingGet()).getHttpUrl();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"get().httpUrlDao().curre\u2026\n                .httpUrl");
        String storedUrl = string;
        if (!Intrinsics.areEqual((Object)storedUrl, (Object)httpUrl)) {
            httpUrl = this.mapHttpUrlByDeviceVersion(storedUrl);
        }
        return httpUrl;
    }

    @NotNull
    public final String mapHttpUrlByDeviceVersion(@NotNull String url) {
        String string;
        Intrinsics.checkNotNullParameter((Object)url, (String)"url");
        return Build.VERSION.SDK_INT >= 26 ? url : (Intrinsics.areEqual((Object)(string = url), (Object)AmityEndpoint.SG.INSTANCE.getHttpEndpoint()) ? "https://api.sg.amity.co/" : (Intrinsics.areEqual((Object)string, (Object)AmityEndpoint.EU.INSTANCE.getHttpEndpoint()) ? "https://api.eu.amity.co/" : (Intrinsics.areEqual((Object)string, (Object)AmityEndpoint.US.INSTANCE.getHttpEndpoint()) ? "https://api.us.amity.co/" : (Intrinsics.areEqual((Object)string, (Object)"https://true-apix.amity.co") ? "https://true-api.amity.co" : url))));
    }

    @NotNull
    public final Flowable<String> observeHttpUrl() {
        Flowable flowable = EkoDatabase.get().httpUrlDao().observeCurrentHttpUrl().map((Function)observeHttpUrl.1.INSTANCE);
        Intrinsics.checkNotNullExpressionValue((Object)flowable, (String)"get().httpUrlDao().obser\u2026it.httpUrl)\n            }");
        return flowable;
    }

    @NotNull
    public final String getMqttUrl() {
        String string = ((EkoMqttUrl)EkoDatabase.get().mqttUrlDao().getCurrentMqttUrl().defaultIfEmpty((Object)EkoMqttUrl.create(AmityEndpoint.SG.INSTANCE.getMqttEndpoint())).blockingGet()).getMqttUrl();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"get().mqttUrlDao().curre\u2026et()\n            .mqttUrl");
        String storedUrl = string;
        if (!Intrinsics.areEqual((Object)storedUrl, (Object)mqttUrl)) {
            mqttUrl = storedUrl;
        }
        return mqttUrl;
    }

    @NotNull
    public final String getUploadUrl() {
        String storedUrl = ((AmityUploadUrl)EkoDatabase.get().uploadUrlDao().getCurrentUploadUrl().defaultIfEmpty((Object)AmityUploadUrl.Companion.create(AmityEndpoint.SG.INSTANCE.getUploadEndpoint())).blockingGet()).getUploadUrl();
        if (!Intrinsics.areEqual((Object)storedUrl, (Object)uploadUrl)) {
            uploadUrl = storedUrl;
        }
        return uploadUrl;
    }
}

