package com.amity.socialcloud.sdk.social.data.feed

import com.amity.socialcloud.sdk.common.EntityMapper
import com.ekoapp.ekosdk.internal.api.dto.EkoFeedDto
import com.ekoapp.ekosdk.internal.api.mapper.EkoFeedMapper
import com.ekoapp.ekosdk.internal.entity.FeedEntity
import java.util.*

internal class FeedEntityMapper : EntityMapper<EkoFeedDto, FeedEntity>() {

    override fun map(list: List<EkoFeedDto>): List<FeedEntity> {
        return list.map { map(it) }
    }

    private fun map(dto: EkoFeedDto) : FeedEntity {
        return FeedEntity().apply {
            feedId = dto.feedId ?: feedId
            feedType = dto.feedType
            targetId = dto.targetId
            targetType = dto.targetType
            postCount = dto.postCount ?: postCount
            createdAt = dto.createdAt
            updatedAt = dto.updatedAt
        }
    }

}