package com.amity.socialcloud.sdk.infra.mqtt.listener

import com.amity.socialcloud.sdk.chat.data.marker.sync.MarkerUserSyncPersister
import com.amity.socialcloud.sdk.core.MarkerEvent
import com.amity.socialcloud.sdk.core.session.eventbus.MarkerEventBus
import com.amity.socialcloud.sdk.log.AmityLog
import com.ekoapp.ekosdk.internal.api.dto.MarkerUpdatedDto
import com.ekoapp.ekosdk.internal.api.dto.MarkerUserSyncDto
import io.reactivex.rxjava3.schedulers.Schedulers
import kotlin.reflect.KClass

internal class MarkerUserSync: MqttEventListener<MarkerUserSyncDto>()  {

    override val type: KClass<MarkerUserSyncDto>
        get() = MarkerUserSyncDto::class

    override fun processEvent(dto: MarkerUserSyncDto) {
        MarkerUserSyncPersister()
                .persist(dto)
                .subscribeOn(Schedulers.io())
                .doOnError {
                    AmityLog.e("Fail to persist marker.user-sync events")
                }
                .subscribe()
    }

    override fun shouldProcessEvent(dto: MarkerUserSyncDto): Boolean {
        return true
    }
    
    override fun getEventName(): String {
        return "marker.user-sync"
    }
    
}