package com.amity.socialcloud.sdk.social.data.comment.flag

import com.amity.socialcloud.sdk.common.EntityMapper
import com.ekoapp.ekosdk.internal.api.dto.EkoCommentDto
import com.ekoapp.ekosdk.internal.data.model.EkoCommentFlagEntity


internal class CommentFlagEntityMapper : EntityMapper<EkoCommentDto, EkoCommentFlagEntity>() {

    override fun map(list: List<EkoCommentDto>): List<EkoCommentFlagEntity> {
        return list.map {
            EkoCommentFlagEntity(it.commentId).apply {
                flag = it.flag
            }
        }
    }

}