package com.amity.socialcloud.sdk.model.social.poll

import android.os.Parcelable
import com.google.common.base.Objects
import kotlinx.android.parcel.Parcelize
import org.amity.types.ObjectId

@Parcelize
class AmityPollAnswer : Parcelable {

    val id: String = ObjectId.get().toHexString()
    val data: String = ""
    val dataType: String = Data.UNKNOWN.apiKey
    val voteCount: Int = 0
    val isVotedByUser: Boolean = false

    override fun equals(other: Any?): Boolean {
        if (other == null) return false
        if (other === this) return true
        return (other as? AmityPollAnswer)?.let { answer ->
            (Objects.equal(id, answer.id)
                    && Objects.equal(data, answer.data)
                    && Objects.equal(dataType, answer.dataType)
                    && Objects.equal(voteCount, answer.voteCount)
                    && Objects.equal(isVotedByUser, answer.isVotedByUser))
        } ?: kotlin.run {
            false
        }
    }

    override fun hashCode(): Int {
        return Objects.hashCode(
            id,
            data,
            dataType,
            voteCount,
            isVotedByUser
        )
    }

    sealed class Data(val apiKey: String) : Parcelable {

        @Parcelize
        class TEXT(val data: String) : Data("text")

        @Parcelize
        internal object UNKNOWN : Data("unknown")
    }
}