package com.ekoapp.ekosdk.internal.data.model

import androidx.room.Entity
import androidx.room.PrimaryKey
import com.google.common.base.Objects

@Entity(tableName = "baidu_token")
class EkoBaiduToken(val apiKey: String) {
	@PrimaryKey
	var id = "SINGLETON_BAIDU_TOKEN"
	var token: String? = null
	var userId: String? = null
	var channelId: String? = null
	
	override fun equals(obj: Any?): Boolean {
		if (obj == null) return false
		if (obj === this) return true
		if (obj.javaClass != javaClass) return false
		val other = obj as EkoBaiduToken
		return (Objects.equal(id, other.id)
				&& Objects.equal(token, other.token)
				&& Objects.equal(userId, other.userId)
				&& Objects.equal(channelId, other.channelId)
				&& Objects.equal(apiKey, other.apiKey))
	}
	
	override fun hashCode(): Int {
		return Objects.hashCode(id, token, userId, channelId, apiKey)
	}
}