package com.amity.socialcloud.sdk.core.data.pin

import com.ekoapp.ekosdk.internal.api.AmityHttpClient
import com.ekoapp.ekosdk.internal.api.dto.PinnedPostQueryDto
import io.reactivex.rxjava3.core.Single

internal class PinRemoteDataStore {
	fun queryPinPost(
		communityId: String,
		placement: String? = null): Single<PinnedPostQueryDto> {
		return AmityHttpClient.get(PinApi::class).flatMap {
			if (placement == null) it.queryPinPost(communityId)
			else it.queryPinPostWithPlacement(communityId, placement)
		}
	}

	fun queryGlobalPinnedPosts(): Single<PinnedPostQueryDto> {
		return AmityHttpClient.get(PinApi::class).flatMap {
			it.queryGlobalPinnedPost()
		}
	}

}