package com.amity.socialcloud.sdk.chat.data.marker.readreceipt

import com.ekoapp.ekosdk.internal.ReadReceiptEntity
import com.ekoapp.ekosdk.internal.data.UserDatabase
import io.reactivex.rxjava3.core.Completable

internal class ReadReceiptRepository {
    
    fun getReadReceipt(subChannelId: String): ReadReceiptEntity? {
        return ReadReceiptLocalDataStore().getReadReceipt(subChannelId)
    }
    
    fun saveReadReceipts(
        readReceipts: List<ReadReceiptEntity>,
    ): Completable {
        return ReadReceiptLocalDataStore().saveReadReceipts(readReceipts)
    }
    
    fun updateLatestSegment(subChannelId: String, segment: Int) {
        ReadReceiptLocalDataStore().updateLatestSegment(subChannelId, segment)
    }
    
    fun updateLatestSyncSegment(subChannelId: String, segment: Int) {
        ReadReceiptLocalDataStore().updateLatestSyncSegment(subChannelId, segment)
    }
    
    fun deleteReadReceipt(subChannelId: String) {
        ReadReceiptLocalDataStore().deleteReadReceipt(subChannelId)
    }
    
    fun getUnsyncReadReceipt(): List<ReadReceiptEntity> {
        return ReadReceiptLocalDataStore().getUnsyncReadReceipt()
    }

}