package com.ekoapp.ekosdk.internal.usecase.message

import com.amity.socialcloud.sdk.chat.data.message.MessageRepository
import com.amity.socialcloud.sdk.chat.domain.message.MessageComposerUseCase
import com.amity.socialcloud.sdk.model.chat.message.AmityMessage
import io.reactivex.rxjava3.core.Flowable

internal class GetLatestMessageUseCase {

    fun execute(channelId: String, boolean: Boolean?): Flowable<AmityMessage> {
        return MessageRepository().observeLatestMessage(channelId, boolean)
            .map {
                MessageComposerUseCase().execute(it)
            }
    }

}