package com.amity.socialcloud.sdk.social.domain.community

import com.amity.socialcloud.sdk.model.social.community.AmityCommunity
import com.amity.socialcloud.sdk.social.data.community.CommunityRepository
import io.reactivex.rxjava3.core.Flowable


internal class RecommendedCommunityQueryUseCase {

    fun execute(): Flowable<List<AmityCommunity>> {
        return CommunityRepository().getRecommendedCommunities().map { communityList ->
            communityList.map { community ->
                CommunityComposerUseCase().execute(community)
            }
        }
    }
}