/*
 * Decompiled with CFR 0.152.
 */
package com.amity.socialcloud.sdk.core;

import com.amity.socialcloud.sdk.api.core.encryption.AmityDBEncryption;
import com.amity.socialcloud.sdk.api.core.endpoint.AmityEndpoint;
import com.amity.socialcloud.sdk.api.core.presence.AmityPresenceService;
import com.amity.socialcloud.sdk.api.core.presence.AmityUserPresenceRepository;
import com.amity.socialcloud.sdk.api.core.session.AmitySessionEstablisher;
import com.amity.socialcloud.sdk.chat.data.marker.user.ObserveUserMarker;
import com.amity.socialcloud.sdk.chat.data.marker.user.UserUnreadModelMapper;
import com.amity.socialcloud.sdk.core.CoreClient;
import com.amity.socialcloud.sdk.core.LogoutProcessState;
import com.amity.socialcloud.sdk.core.MarkReadEngine;
import com.amity.socialcloud.sdk.core.MarkerSyncEngine;
import com.amity.socialcloud.sdk.core.MessagePreviewEngine;
import com.amity.socialcloud.sdk.core.MessageReadReceiptSyncEngine;
import com.amity.socialcloud.sdk.core.MessageSyncEngine;
import com.amity.socialcloud.sdk.core.ObjectResolverEngine;
import com.amity.socialcloud.sdk.core.engine.analytics.AnalyticsEngine;
import com.amity.socialcloud.sdk.core.presence.PresenceSyncEngine;
import com.amity.socialcloud.sdk.core.session.SessionError;
import com.amity.socialcloud.sdk.core.session.SessionStateManager;
import com.amity.socialcloud.sdk.core.session.component.DatabaseSessionComponent;
import com.amity.socialcloud.sdk.core.session.component.TokenRenewalSessionComponent;
import com.amity.socialcloud.sdk.core.session.component.TokenWatcherSessionComponent;
import com.amity.socialcloud.sdk.core.session.component.UserSettingSessionComponent;
import com.amity.socialcloud.sdk.core.session.eventbus.AppEventBus;
import com.amity.socialcloud.sdk.core.session.eventbus.SessionLifeCycleEventBus;
import com.amity.socialcloud.sdk.core.session.eventbus.SessionStateEventBus;
import com.amity.socialcloud.sdk.core.session.model.AppEvent;
import com.amity.socialcloud.sdk.core.session.model.SessionState;
import com.amity.socialcloud.sdk.infra.mqtt.AmityMqttClient;
import com.amity.socialcloud.sdk.log.AmityLog;
import com.amity.socialcloud.sdk.model.chat.message.AmityMessageAttachment;
import com.amity.socialcloud.sdk.model.core.error.AmityError;
import com.amity.socialcloud.sdk.model.core.error.AmityException;
import com.amity.socialcloud.sdk.model.core.file.AmityFileAccessType;
import com.amity.socialcloud.sdk.model.core.session.SessionHandler;
import com.amity.socialcloud.sdk.model.core.unread.UserUnread;
import com.ekoapp.ekosdk.internal.EkoMessageEntity;
import com.ekoapp.ekosdk.internal.UserMarkerEntity;
import com.ekoapp.ekosdk.internal.api.AmityHttpClient;
import com.ekoapp.ekosdk.internal.api.http.AmityNetworkActivity;
import com.ekoapp.ekosdk.internal.data.EkoDatabase;
import com.ekoapp.ekosdk.internal.data.UserDatabase;
import com.ekoapp.ekosdk.internal.data.dao.AmityUploadUrlDao;
import com.ekoapp.ekosdk.internal.data.dao.EkoApiKeyDao;
import com.ekoapp.ekosdk.internal.data.dao.EkoHttpUrlDao;
import com.ekoapp.ekosdk.internal.data.dao.EkoMqttUrlDao;
import com.ekoapp.ekosdk.internal.data.model.AmityUploadUrl;
import com.ekoapp.ekosdk.internal.data.model.EkoAccount;
import com.ekoapp.ekosdk.internal.data.model.EkoApiKey;
import com.ekoapp.ekosdk.internal.data.model.EkoHttpUrl;
import com.ekoapp.ekosdk.internal.data.model.EkoMqttUrl;
import com.ekoapp.ekosdk.internal.init.AmityCoreSDKInitializer;
import com.ekoapp.ekosdk.internal.init.EkoSdkInitProvider;
import com.ekoapp.ekosdk.internal.util.AppContext;
import com.google.common.base.Objects;
import io.reactivex.rxjava3.core.BackpressureStrategy;
import io.reactivex.rxjava3.core.Completable;
import io.reactivex.rxjava3.core.CompletableEmitter;
import io.reactivex.rxjava3.core.CompletableObserver;
import io.reactivex.rxjava3.core.Flowable;
import io.reactivex.rxjava3.core.Maybe;
import io.reactivex.rxjava3.core.MaybeSource;
import io.reactivex.rxjava3.functions.Consumer;
import io.reactivex.rxjava3.functions.Function;
import io.reactivex.rxjava3.functions.Function4;
import io.reactivex.rxjava3.schedulers.Schedulers;
import io.reactivex.rxjava3.subjects.CompletableSubject;
import io.reactivex.rxjava3.subjects.PublishSubject;
import java.util.List;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.joda.time.DateTime;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\u00a0\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\b\u00c0\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u001e\u0010P\u001a\u00020Q2\u0006\u0010R\u001a\u00020S2\u0006\u0010T\u001a\u00020U2\u0006\u0010V\u001a\u00020WJ\u0016\u0010X\u001a\u00020Q2\u0006\u0010R\u001a\u00020S2\u0006\u0010T\u001a\u00020UJ\u0006\u0010Y\u001a\u00020ZJ\u0006\u0010[\u001a\u00020QJ\b\u0010\\\u001a\u0004\u0018\u00010\u0004J\b\u0010]\u001a\u0004\u0018\u00010\u0006J\n\u0010^\u001a\u0004\u0018\u00010_H\u0002J\r\u0010`\u001a\u00020aH\u0000\u00a2\u0006\u0002\bbJ\u0006\u0010c\u001a\u00020OJ\u0006\u0010d\u001a\u00020\u0012J\u0006\u0010\u0011\u001a\u00020\u0012J\u0018\u0010e\u001a\u00020f2\u0006\u0010g\u001a\u00020\u00042\b\u0010h\u001a\u0004\u0018\u00010iJ\u0016\u0010j\u001a\u00020Q2\u0006\u0010k\u001a\u00020\u00042\u0006\u0010l\u001a\u00020$J\u0006\u0010m\u001a\u00020nJ\f\u0010o\u001a\b\u0012\u0004\u0012\u00020-0pJ\f\u0010q\u001a\b\u0012\u0004\u0012\u00020\u000e0pJ\f\u0010r\u001a\b\u0012\u0004\u0012\u00020s0pJ\f\u0010t\u001a\b\u0012\u0004\u0012\u00020$0pJ\u0006\u0010u\u001a\u00020vJ\u0006\u0010w\u001a\u00020QJ\u0016\u0010x\u001a\u00020Q2\u0006\u0010y\u001a\u00020\u00042\u0006\u0010z\u001a\u00020{J\u001c\u0010x\u001a\u00020Q2\f\u0010|\u001a\b\u0012\u0004\u0012\u00020\u00040}2\u0006\u0010z\u001a\u00020{J\u000e\u0010~\u001a\u00020Q2\u0006\u0010\u007f\u001a\u00020OJ&\u0010\u0080\u0001\u001a\u00020Z2\u0007\u0010\u0081\u0001\u001a\u00020\u00042\b\u0010\u0082\u0001\u001a\u00030\u0083\u00012\n\b\u0002\u0010\u0084\u0001\u001a\u00030\u0085\u0001J\t\u0010\u0086\u0001\u001a\u00020QH\u0002J\u0007\u0010\u0087\u0001\u001a\u00020QJ\u0018\u0010\u0088\u0001\u001a\u00020Z2\u0006\u0010k\u001a\u00020\u00042\u0007\u0010\u0089\u0001\u001a\u00020\u0004J\u0007\u0010\u008a\u0001\u001a\u00020QJ\u0018\u0010\u008b\u0001\u001a\u00020Z2\u0006\u0010k\u001a\u00020\u00042\u0007\u0010\u0089\u0001\u001a\u00020\u0004R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0005\u001a\u0004\u0018\u00010\u0006X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001c\u0010\u0007\u001a\u0004\u0018\u00010\bX\u0080\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\t\u0010\n\"\u0004\b\u000b\u0010\fR\u0011\u0010\r\u001a\u00020\u000e8F\u00a2\u0006\u0006\u001a\u0004\b\u000f\u0010\u0010R\u000e\u0010\u0011\u001a\u00020\u0012X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0013\u001a\u00020\u0014X\u0080\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0015\u0010\u0016\"\u0004\b\u0017\u0010\u0018R\u0010\u0010\u0019\u001a\u0004\u0018\u00010\u001aX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u001b\u001a\u0004\u0018\u00010\u001cX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u001d\u001a\u0004\u0018\u00010\u001eX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u001f\u001a\u0004\u0018\u00010 X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010!\u001a\u0004\u0018\u00010\"X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001a\u0010#\u001a\u00020$X\u0080\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b%\u0010&\"\u0004\b'\u0010(R\u0010\u0010)\u001a\u0004\u0018\u00010*X\u0082\u000e\u00a2\u0006\u0002\n\u0000R'\u0010+\u001a\u0015\u0012\f\u0012\n .*\u0004\u0018\u00010-0-0,\u00a2\u0006\u0002\b/X\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b0\u00101R\u0010\u00102\u001a\u0004\u0018\u000103X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001c\u00104\u001a\u0004\u0018\u000105X\u0080\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b6\u00107\"\u0004\b8\u00109R\u0010\u0010:\u001a\u0004\u0018\u00010;X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001c\u0010<\u001a\u0004\u0018\u00010=X\u0080\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b>\u0010?\"\u0004\b@\u0010AR\u001c\u0010B\u001a\u0004\u0018\u00010CX\u0080\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\bD\u0010E\"\u0004\bF\u0010GR\u001c\u0010H\u001a\u0004\u0018\u00010IX\u0080\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\bJ\u0010K\"\u0004\bL\u0010MR\u000e\u0010N\u001a\u00020OX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u008c\u0001"}, d2={"Lcom/amity/socialcloud/sdk/core/CoreClient;", "", "()V", "TAG", "", "analyticsEngine", "Lcom/amity/socialcloud/sdk/core/engine/analytics/AnalyticsEngine;", "appEventBus", "Lcom/amity/socialcloud/sdk/core/session/eventbus/AppEventBus;", "getAppEventBus$amity_sdk_release", "()Lcom/amity/socialcloud/sdk/core/session/eventbus/AppEventBus;", "setAppEventBus$amity_sdk_release", "(Lcom/amity/socialcloud/sdk/core/session/eventbus/AppEventBus;)V", "currentSessionState", "Lcom/amity/socialcloud/sdk/core/session/model/SessionState;", "getCurrentSessionState", "()Lcom/amity/socialcloud/sdk/core/session/model/SessionState;", "isUnreadCountEnable", "", "logoutProcessState", "Lcom/amity/socialcloud/sdk/core/LogoutProcessState;", "getLogoutProcessState$amity_sdk_release", "()Lcom/amity/socialcloud/sdk/core/LogoutProcessState;", "setLogoutProcessState$amity_sdk_release", "(Lcom/amity/socialcloud/sdk/core/LogoutProcessState;)V", "markReadEngine", "Lcom/amity/socialcloud/sdk/core/MarkReadEngine;", "markerSyncEngine", "Lcom/amity/socialcloud/sdk/core/MarkerSyncEngine;", "messagePreviewEngine", "Lcom/amity/socialcloud/sdk/core/MessagePreviewEngine;", "messageReadReceiptSyncEngine", "Lcom/amity/socialcloud/sdk/core/MessageReadReceiptSyncEngine;", "messageSyncEngine", "Lcom/amity/socialcloud/sdk/core/MessageSyncEngine;", "millisTimeDiff", "", "getMillisTimeDiff$amity_sdk_release", "()I", "setMillisTimeDiff$amity_sdk_release", "(I)V", "mqttClient", "Lcom/amity/socialcloud/sdk/infra/mqtt/AmityMqttClient;", "networkActivityPublisher", "Lio/reactivex/rxjava3/subjects/PublishSubject;", "Lcom/ekoapp/ekosdk/internal/api/http/AmityNetworkActivity;", "kotlin.jvm.PlatformType", "Lio/reactivex/rxjava3/annotations/NonNull;", "getNetworkActivityPublisher$amity_sdk_release", "()Lio/reactivex/rxjava3/subjects/PublishSubject;", "objectResolverEngine", "Lcom/amity/socialcloud/sdk/core/ObjectResolverEngine;", "presenceSyncEngine", "Lcom/amity/socialcloud/sdk/core/presence/PresenceSyncEngine;", "getPresenceSyncEngine$amity_sdk_release", "()Lcom/amity/socialcloud/sdk/core/presence/PresenceSyncEngine;", "setPresenceSyncEngine$amity_sdk_release", "(Lcom/amity/socialcloud/sdk/core/presence/PresenceSyncEngine;)V", "renewalManager", "Lcom/amity/socialcloud/sdk/core/session/component/TokenRenewalSessionComponent;", "sessionLifeCycleEventBus", "Lcom/amity/socialcloud/sdk/core/session/eventbus/SessionLifeCycleEventBus;", "getSessionLifeCycleEventBus$amity_sdk_release", "()Lcom/amity/socialcloud/sdk/core/session/eventbus/SessionLifeCycleEventBus;", "setSessionLifeCycleEventBus$amity_sdk_release", "(Lcom/amity/socialcloud/sdk/core/session/eventbus/SessionLifeCycleEventBus;)V", "sessionStateEventBus", "Lcom/amity/socialcloud/sdk/core/session/eventbus/SessionStateEventBus;", "getSessionStateEventBus$amity_sdk_release", "()Lcom/amity/socialcloud/sdk/core/session/eventbus/SessionStateEventBus;", "setSessionStateEventBus$amity_sdk_release", "(Lcom/amity/socialcloud/sdk/core/session/eventbus/SessionStateEventBus;)V", "sessionStateManager", "Lcom/amity/socialcloud/sdk/core/session/SessionStateManager;", "getSessionStateManager$amity_sdk_release", "()Lcom/amity/socialcloud/sdk/core/session/SessionStateManager;", "setSessionStateManager$amity_sdk_release", "(Lcom/amity/socialcloud/sdk/core/session/SessionStateManager;)V", "uploadedFileAccessType", "Lcom/amity/socialcloud/sdk/model/core/file/AmityFileAccessType;", "createAttachmentMessage", "", "message", "Lcom/ekoapp/ekosdk/internal/EkoMessageEntity;", "emitter", "Lio/reactivex/rxjava3/core/CompletableEmitter;", "attachment", "Lcom/amity/socialcloud/sdk/model/chat/message/AmityMessageAttachment;", "createTextMessage", "disconnect", "Lio/reactivex/rxjava3/core/Completable;", "enableUnreadCount", "getAccessToken", "getAnalyticsEngine", "getCurrentAccount", "Lcom/ekoapp/ekosdk/internal/data/model/EkoAccount;", "getServerTime", "Lorg/joda/time/DateTime;", "getServerTime$amity_sdk_release", "getUploadedFileAccessType", "isConsistentMode", "login", "Lcom/amity/socialcloud/sdk/api/core/session/AmitySessionEstablisher$Builder;", "userId", "sessionHandler", "Lcom/amity/socialcloud/sdk/model/core/session/SessionHandler;", "markRead", "subChannelId", "segment", "newUserPresenceRepository", "Lcom/amity/socialcloud/sdk/api/core/presence/AmityUserPresenceRepository;", "observeNetworkActivities", "Lio/reactivex/rxjava3/core/Flowable;", "observeSessionState", "observeUserUnread", "Lcom/amity/socialcloud/sdk/model/core/unread/UserUnread;", "observeUserUnreadCount", "presence", "Lcom/amity/socialcloud/sdk/api/core/presence/AmityPresenceService;", "publishLogoutEvent", "resolve", "id", "referenceType", "Lcom/amity/socialcloud/sdk/core/ObjectResolverEngine$Companion$ReferenceType;", "ids", "", "setUploadedFileAccessType", "type", "setup", "apiKey", "endpoint", "Lcom/amity/socialcloud/sdk/api/core/endpoint/AmityEndpoint;", "dbEncryption", "Lcom/amity/socialcloud/sdk/api/core/encryption/AmityDBEncryption;", "setupSessionComponents", "startMarkerSyncing", "startReading", "channelId", "stopMarkerSyncing", "stopReading", "amity-sdk_release"})
public final class CoreClient {
    @NotNull
    public static final CoreClient INSTANCE = new CoreClient();
    @NotNull
    private static final String TAG = "AmityCoreClient";
    private static int millisTimeDiff;
    @NotNull
    private static final PublishSubject<AmityNetworkActivity> networkActivityPublisher;
    @Nullable
    private static AmityMqttClient mqttClient;
    @Nullable
    private static TokenRenewalSessionComponent renewalManager;
    @Nullable
    private static PresenceSyncEngine presenceSyncEngine;
    @Nullable
    private static AnalyticsEngine analyticsEngine;
    @Nullable
    private static SessionLifeCycleEventBus sessionLifeCycleEventBus;
    @Nullable
    private static AppEventBus appEventBus;
    @Nullable
    private static SessionStateEventBus sessionStateEventBus;
    @Nullable
    private static SessionStateManager sessionStateManager;
    @Nullable
    private static MarkerSyncEngine markerSyncEngine;
    @Nullable
    private static MarkReadEngine markReadEngine;
    @Nullable
    private static MessagePreviewEngine messagePreviewEngine;
    @Nullable
    private static MessageSyncEngine messageSyncEngine;
    @Nullable
    private static MessageReadReceiptSyncEngine messageReadReceiptSyncEngine;
    @Nullable
    private static ObjectResolverEngine objectResolverEngine;
    private static boolean isUnreadCountEnable;
    @NotNull
    private static AmityFileAccessType uploadedFileAccessType;
    @NotNull
    private static LogoutProcessState logoutProcessState;

    private CoreClient() {
    }

    public final int getMillisTimeDiff$amity_sdk_release() {
        return millisTimeDiff;
    }

    public final void setMillisTimeDiff$amity_sdk_release(int n) {
        millisTimeDiff = n;
    }

    @NotNull
    public final PublishSubject<AmityNetworkActivity> getNetworkActivityPublisher$amity_sdk_release() {
        return networkActivityPublisher;
    }

    @NotNull
    public final DateTime getServerTime$amity_sdk_release() {
        DateTime dateTime = DateTime.now().plusMillis(millisTimeDiff);
        Intrinsics.checkNotNullExpressionValue((Object)dateTime, (String)"now().plusMillis(millisTimeDiff)");
        return dateTime;
    }

    @Nullable
    public final PresenceSyncEngine getPresenceSyncEngine$amity_sdk_release() {
        return presenceSyncEngine;
    }

    public final void setPresenceSyncEngine$amity_sdk_release(@Nullable PresenceSyncEngine presenceSyncEngine) {
        CoreClient.presenceSyncEngine = presenceSyncEngine;
    }

    @Nullable
    public final SessionLifeCycleEventBus getSessionLifeCycleEventBus$amity_sdk_release() {
        return sessionLifeCycleEventBus;
    }

    public final void setSessionLifeCycleEventBus$amity_sdk_release(@Nullable SessionLifeCycleEventBus sessionLifeCycleEventBus) {
        CoreClient.sessionLifeCycleEventBus = sessionLifeCycleEventBus;
    }

    @Nullable
    public final AppEventBus getAppEventBus$amity_sdk_release() {
        return appEventBus;
    }

    public final void setAppEventBus$amity_sdk_release(@Nullable AppEventBus appEventBus) {
        CoreClient.appEventBus = appEventBus;
    }

    @Nullable
    public final SessionStateEventBus getSessionStateEventBus$amity_sdk_release() {
        return sessionStateEventBus;
    }

    public final void setSessionStateEventBus$amity_sdk_release(@Nullable SessionStateEventBus sessionStateEventBus) {
        CoreClient.sessionStateEventBus = sessionStateEventBus;
    }

    @Nullable
    public final SessionStateManager getSessionStateManager$amity_sdk_release() {
        return sessionStateManager;
    }

    public final void setSessionStateManager$amity_sdk_release(@Nullable SessionStateManager sessionStateManager) {
        CoreClient.sessionStateManager = sessionStateManager;
    }

    @NotNull
    public final SessionState getCurrentSessionState() {
        SessionStateManager sessionStateManager = CoreClient.sessionStateManager;
        Intrinsics.checkNotNull((Object)sessionStateManager);
        return sessionStateManager.getSessionState();
    }

    @NotNull
    public final LogoutProcessState getLogoutProcessState$amity_sdk_release() {
        return logoutProcessState;
    }

    public final void setLogoutProcessState$amity_sdk_release(@NotNull LogoutProcessState logoutProcessState) {
        Intrinsics.checkNotNullParameter((Object)((Object)logoutProcessState), (String)"<set-?>");
        CoreClient.logoutProcessState = logoutProcessState;
    }

    @NotNull
    public final Completable setup(@NotNull String apiKey, @NotNull AmityEndpoint endpoint, @NotNull AmityDBEncryption dbEncryption) {
        Intrinsics.checkNotNullParameter((Object)apiKey, (String)"apiKey");
        Intrinsics.checkNotNullParameter((Object)endpoint, (String)"endpoint");
        Intrinsics.checkNotNullParameter((Object)dbEncryption, (String)"dbEncryption");
        if (!EkoSdkInitProvider.Companion.isInitialized()) {
            Completable completable = Completable.never();
            Intrinsics.checkNotNullExpressionValue((Object)completable, (String)"never()");
            return completable;
        }
        EkoDatabase.init(AppContext.get(), dbEncryption);
        UserDatabase.init(AppContext.get(), dbEncryption);
        logoutProcessState = LogoutProcessState.IDLE;
        CompletableSubject completableSubject = CompletableSubject.create();
        Intrinsics.checkNotNullExpressionValue((Object)completableSubject, (String)"create()");
        CompletableSubject result = completableSubject;
        EkoDatabase database = EkoDatabase.get();
        EkoHttpUrlDao httpUrlDao = database.httpUrlDao();
        EkoMqttUrlDao mqttUrlDao = database.mqttUrlDao();
        AmityUploadUrlDao uploadUrlDao = database.uploadUrlDao();
        String newHttpUrl = endpoint.getHttpEndpoint();
        String newMqttUrl = endpoint.getMqttEndpoint();
        String newUploadUrl = endpoint.getUploadEndpoint();
        EkoApiKeyDao apiKeyDao = EkoDatabase.get().apiKeyDao();
        Maybe.zip((MaybeSource)((MaybeSource)apiKeyDao.getCurrentApiKey()), (MaybeSource)((MaybeSource)httpUrlDao.getCurrentHttpUrl()), (MaybeSource)((MaybeSource)mqttUrlDao.getCurrentMqttUrl()), (MaybeSource)((MaybeSource)uploadUrlDao.getCurrentUploadUrl()), (Function4)setup.1.INSTANCE).subscribeOn(Schedulers.io()).doOnSuccess(new Consumer(newHttpUrl, newMqttUrl, apiKey, newUploadUrl, httpUrlDao, mqttUrlDao, uploadUrlDao, apiKeyDao){
            final /* synthetic */ String $newHttpUrl;
            final /* synthetic */ String $newMqttUrl;
            final /* synthetic */ String $apiKey;
            final /* synthetic */ String $newUploadUrl;
            final /* synthetic */ EkoHttpUrlDao $httpUrlDao;
            final /* synthetic */ EkoMqttUrlDao $mqttUrlDao;
            final /* synthetic */ AmityUploadUrlDao $uploadUrlDao;
            final /* synthetic */ EkoApiKeyDao $apiKeyDao;
            {
                this.$newHttpUrl = $newHttpUrl;
                this.$newMqttUrl = $newMqttUrl;
                this.$apiKey = $apiKey;
                this.$newUploadUrl = $newUploadUrl;
                this.$httpUrlDao = $httpUrlDao;
                this.$mqttUrlDao = $mqttUrlDao;
                this.$uploadUrlDao = $uploadUrlDao;
                this.$apiKeyDao = $apiKeyDao;
            }

            public final void accept(@NotNull Pair<? extends EkoApiKey, ? extends AmityEndpoint> setupPair) {
                Intrinsics.checkNotNullParameter(setupPair, (String)"setupPair");
                String string = ((EkoApiKey)setupPair.getFirst()).getApiKey();
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"setupPair.first.apiKey");
                String storedApiKey = string;
                String storedHttpUrl = ((AmityEndpoint)setupPair.getSecond()).getHttpEndpoint();
                String storedMqttUrl = ((AmityEndpoint)setupPair.getSecond()).getMqttEndpoint();
                String storedUploadUrl = ((AmityEndpoint)setupPair.getSecond()).getUploadEndpoint();
                if (!(Objects.equal((Object)storedHttpUrl, (Object)this.$newHttpUrl) && Objects.equal((Object)storedMqttUrl, (Object)this.$newMqttUrl) && Objects.equal((Object)storedApiKey, (Object)this.$apiKey) && Objects.equal((Object)storedUploadUrl, (Object)this.$newUploadUrl))) {
                    Object[] objectArray = new Object[]{this.$apiKey, this.$newHttpUrl, this.$newMqttUrl, this.$newUploadUrl};
                    AmityLog.INSTANCE.tag("AmityCoreClient").e("Setup value changed. new api key: %s new http url: %s new mqtt url: %s new upload url: %s", objectArray);
                    AmityLog.INSTANCE.tag("AmityCoreClient").e("deleting user database", new Object[0]);
                    CoreClient.INSTANCE.publishLogoutEvent();
                    this.$httpUrlDao.insert(EkoHttpUrl.create(this.$newHttpUrl));
                    this.$mqttUrlDao.insert(EkoMqttUrl.create(this.$newMqttUrl));
                    this.$uploadUrlDao.insert(AmityUploadUrl.Companion.create(this.$newUploadUrl));
                    this.$apiKeyDao.insert(EkoApiKey.create(this.$apiKey));
                }
                AmityCoreSDKInitializer.INSTANCE.initApiService$amity_sdk_release();
            }
        }).doOnComplete(() -> CoreClient.setup$lambda$0(httpUrlDao, newHttpUrl, mqttUrlDao, newMqttUrl, uploadUrlDao, newUploadUrl, apiKeyDao, apiKey)).flatMapCompletable((Function)setup.4.INSTANCE).subscribe((CompletableObserver)result);
        this.setupSessionComponents();
        Completable completable = result.hide();
        Intrinsics.checkNotNullExpressionValue((Object)completable, (String)"result.hide()");
        return completable;
    }

    public static /* synthetic */ Completable setup$default(CoreClient coreClient, String string, AmityEndpoint amityEndpoint, AmityDBEncryption amityDBEncryption, int n, Object object) {
        if ((n & 4) != 0) {
            amityDBEncryption = AmityDBEncryption.NONE.INSTANCE;
        }
        return coreClient.setup(string, amityEndpoint, amityDBEncryption);
    }

    @NotNull
    public final Completable disconnect() {
        Completable completable;
        if (mqttClient == null) {
            Completable completable2 = Completable.complete();
            completable = completable2;
            Intrinsics.checkNotNullExpressionValue((Object)completable2, (String)"{\n            Completable.complete()\n        }");
        } else {
            AmityMqttClient amityMqttClient = mqttClient;
            Intrinsics.checkNotNull((Object)amityMqttClient);
            completable = amityMqttClient.disconnect();
        }
        return completable;
    }

    @NotNull
    public final AmitySessionEstablisher.Builder login(@NotNull String userId, @Nullable SessionHandler sessionHandler) {
        boolean isLegacyVersion;
        block2: {
            SessionState sessionState;
            Intrinsics.checkNotNullParameter((Object)userId, (String)"userId");
            isLegacyVersion = sessionHandler == null;
            SessionStateManager sessionStateManager = CoreClient.sessionStateManager;
            SessionState sessionState2 = sessionState = sessionStateManager != null ? sessionStateManager.getSessionState() : null;
            if (sessionState instanceof SessionState.Establishing) {
                throw SessionError.INSTANCE.fromState(sessionState);
            }
            SessionHandler sessionHandler2 = sessionHandler;
            if (sessionHandler2 == null) break block2;
            SessionHandler it = sessionHandler2;
            boolean bl = false;
            TokenRenewalSessionComponent tokenRenewalSessionComponent = renewalManager;
            if (tokenRenewalSessionComponent != null) {
                tokenRenewalSessionComponent.setSessionHandler(it);
            }
        }
        return new AmitySessionEstablisher.Builder(appEventBus, sessionLifeCycleEventBus, userId, isLegacyVersion);
    }

    public final void publishLogoutEvent() {
        block0: {
            AppEventBus appEventBus = CoreClient.appEventBus;
            if (appEventBus == null) break block0;
            appEventBus.publish(AppEvent.ManualLogout.INSTANCE);
        }
    }

    @NotNull
    public final Flowable<SessionState> observeSessionState() {
        Flowable flowable = sessionStateEventBus;
        if (flowable == null || (flowable = flowable.observe()) == null) {
            Flowable flowable2 = Flowable.error((Throwable)AmityException.Companion.create$default(AmityException.Companion, "This function cannot be called before setup()", null, AmityError.UNSUPPORTED, null, 8, null));
            flowable = flowable2;
            Intrinsics.checkNotNullExpressionValue((Object)flowable2, (String)"error(AmityException.cre\u2026 AmityError.UNSUPPORTED))");
        }
        return flowable;
    }

    @NotNull
    public final Completable startReading(@NotNull String subChannelId, @NotNull String channelId) {
        Intrinsics.checkNotNullParameter((Object)subChannelId, (String)"subChannelId");
        Intrinsics.checkNotNullParameter((Object)channelId, (String)"channelId");
        MarkReadEngine markReadEngine = CoreClient.markReadEngine;
        if (markReadEngine == null || (markReadEngine = markReadEngine.startReading(subChannelId, channelId)) == null) {
            Completable completable = Completable.never();
            markReadEngine = completable;
            Intrinsics.checkNotNullExpressionValue((Object)completable, (String)"never()");
        }
        return markReadEngine;
    }

    @NotNull
    public final Completable stopReading(@NotNull String subChannelId, @NotNull String channelId) {
        Intrinsics.checkNotNullParameter((Object)subChannelId, (String)"subChannelId");
        Intrinsics.checkNotNullParameter((Object)channelId, (String)"channelId");
        MarkReadEngine markReadEngine = CoreClient.markReadEngine;
        if (markReadEngine == null || (markReadEngine = markReadEngine.stopReading(subChannelId, channelId)) == null) {
            Completable completable = Completable.never();
            markReadEngine = completable;
            Intrinsics.checkNotNullExpressionValue((Object)completable, (String)"never()");
        }
        return markReadEngine;
    }

    public final void startMarkerSyncing() {
        block0: {
            MarkerSyncEngine markerSyncEngine = CoreClient.markerSyncEngine;
            if (markerSyncEngine == null) break block0;
            markerSyncEngine.startMarkerSync();
        }
    }

    public final void stopMarkerSyncing() {
        block0: {
            MarkerSyncEngine markerSyncEngine = CoreClient.markerSyncEngine;
            if (markerSyncEngine == null) break block0;
            markerSyncEngine.stopMarkerSync();
        }
    }

    @NotNull
    public final Flowable<Integer> observeUserUnreadCount() {
        Flowable flowable = new ObserveUserMarker().execute().map((Function)observeUserUnreadCount.1.INSTANCE);
        Intrinsics.checkNotNullExpressionValue((Object)flowable, (String)"ObserveUserMarker().exec\u2026().map { it.unreadCount }");
        return flowable;
    }

    @NotNull
    public final Flowable<UserUnread> observeUserUnread() {
        UserUnreadModelMapper userUnreadModelMapper = new UserUnreadModelMapper();
        Flowable flowable = new ObserveUserMarker().execute().map(new Function(userUnreadModelMapper){
            final /* synthetic */ UserUnreadModelMapper $tmp0;
            {
                this.$tmp0 = $tmp0;
            }

            @NotNull
            public final UserUnread apply(@NotNull UserMarkerEntity p0) {
                Intrinsics.checkNotNullParameter((Object)p0, (String)"p0");
                return this.$tmp0.map(p0);
            }
        });
        Intrinsics.checkNotNullExpressionValue((Object)flowable, (String)"ObserveUserMarker().exec\u2026UnreadModelMapper()::map)");
        return flowable;
    }

    @NotNull
    public final AmityPresenceService presence() {
        return new AmityPresenceService(presenceSyncEngine);
    }

    @NotNull
    public final AmityUserPresenceRepository newUserPresenceRepository() {
        return new AmityUserPresenceRepository();
    }

    @Nullable
    public final AnalyticsEngine getAnalyticsEngine() {
        return analyticsEngine;
    }

    public final void createTextMessage(@NotNull EkoMessageEntity message, @NotNull CompletableEmitter emitter) {
        block0: {
            Intrinsics.checkNotNullParameter((Object)message, (String)"message");
            Intrinsics.checkNotNullParameter((Object)emitter, (String)"emitter");
            MessageSyncEngine messageSyncEngine = CoreClient.messageSyncEngine;
            if (messageSyncEngine == null) break block0;
            messageSyncEngine.addTextMessageJob(message, emitter);
        }
    }

    public final void createAttachmentMessage(@NotNull EkoMessageEntity message, @NotNull CompletableEmitter emitter, @NotNull AmityMessageAttachment attachment) {
        block0: {
            Intrinsics.checkNotNullParameter((Object)message, (String)"message");
            Intrinsics.checkNotNullParameter((Object)emitter, (String)"emitter");
            Intrinsics.checkNotNullParameter((Object)attachment, (String)"attachment");
            MessageSyncEngine messageSyncEngine = CoreClient.messageSyncEngine;
            if (messageSyncEngine == null) break block0;
            messageSyncEngine.addAttachmentMessageJob(message, emitter, attachment);
        }
    }

    public final boolean isConsistentMode() {
        MarkerSyncEngine markerSyncEngine = CoreClient.markerSyncEngine;
        return markerSyncEngine != null ? markerSyncEngine.isConsistentMode() : true;
    }

    public final boolean isUnreadCountEnable() {
        return isUnreadCountEnable;
    }

    public final void enableUnreadCount() {
        isUnreadCountEnable = true;
    }

    public final void markRead(@NotNull String subChannelId, int segment) {
        block0: {
            Intrinsics.checkNotNullParameter((Object)subChannelId, (String)"subChannelId");
            MessageReadReceiptSyncEngine messageReadReceiptSyncEngine = CoreClient.messageReadReceiptSyncEngine;
            if (messageReadReceiptSyncEngine == null) break block0;
            messageReadReceiptSyncEngine.markRead(subChannelId, segment);
        }
    }

    public final void resolve(@NotNull String id, @NotNull ObjectResolverEngine.Companion.ReferenceType referenceType) {
        block0: {
            Intrinsics.checkNotNullParameter((Object)id, (String)"id");
            Intrinsics.checkNotNullParameter((Object)((Object)referenceType), (String)"referenceType");
            ObjectResolverEngine objectResolverEngine = CoreClient.objectResolverEngine;
            if (objectResolverEngine == null) break block0;
            objectResolverEngine.resolve(id, referenceType);
        }
    }

    public final void resolve(@NotNull List<String> ids, @NotNull ObjectResolverEngine.Companion.ReferenceType referenceType) {
        block0: {
            Intrinsics.checkNotNullParameter(ids, (String)"ids");
            Intrinsics.checkNotNullParameter((Object)((Object)referenceType), (String)"referenceType");
            ObjectResolverEngine objectResolverEngine = CoreClient.objectResolverEngine;
            if (objectResolverEngine == null) break block0;
            objectResolverEngine.resolve(ids, referenceType);
        }
    }

    public final void setUploadedFileAccessType(@NotNull AmityFileAccessType type) {
        Intrinsics.checkNotNullParameter((Object)((Object)type), (String)"type");
        uploadedFileAccessType = type;
    }

    @NotNull
    public final AmityFileAccessType getUploadedFileAccessType() {
        return uploadedFileAccessType;
    }

    @Nullable
    public final String getAccessToken() {
        EkoAccount ekoAccount = this.getCurrentAccount();
        return ekoAccount != null ? ekoAccount.getAccessToken() : null;
    }

    @NotNull
    public final Flowable<AmityNetworkActivity> observeNetworkActivities() {
        Flowable flowable = networkActivityPublisher.toFlowable(BackpressureStrategy.BUFFER);
        Intrinsics.checkNotNullExpressionValue((Object)flowable, (String)"networkActivityPublisher\u2026kpressureStrategy.BUFFER)");
        return flowable;
    }

    private final EkoAccount getCurrentAccount() {
        return EkoDatabase.get().accountDao().getCurrentAccountNow();
    }

    private final void setupSessionComponents() {
        logoutProcessState = LogoutProcessState.IDLE;
        if (sessionLifeCycleEventBus == null) {
            sessionLifeCycleEventBus = new SessionLifeCycleEventBus();
        }
        if (appEventBus == null) {
            appEventBus = new AppEventBus();
        }
        if (sessionStateEventBus == null) {
            sessionStateEventBus = new SessionStateEventBus();
        }
        if (sessionStateManager == null) {
            AppEventBus appEventBus = CoreClient.appEventBus;
            Intrinsics.checkNotNull((Object)appEventBus);
            AppEventBus appEventBus2 = appEventBus;
            SessionStateEventBus sessionStateEventBus = CoreClient.sessionStateEventBus;
            Intrinsics.checkNotNull((Object)sessionStateEventBus);
            SessionStateEventBus sessionStateEventBus2 = sessionStateEventBus;
            SessionLifeCycleEventBus sessionLifeCycleEventBus = CoreClient.sessionLifeCycleEventBus;
            Intrinsics.checkNotNull((Object)sessionLifeCycleEventBus);
            SessionLifeCycleEventBus sessionLifeCycleEventBus2 = sessionLifeCycleEventBus;
            sessionStateManager = new SessionStateManager(appEventBus2, sessionLifeCycleEventBus2, sessionStateEventBus2);
        }
        if (mqttClient == null || renewalManager == null) {
            SessionLifeCycleEventBus sessionLifeCycleEventBus = CoreClient.sessionLifeCycleEventBus;
            Intrinsics.checkNotNull((Object)sessionLifeCycleEventBus);
            SessionStateEventBus sessionStateEventBus = CoreClient.sessionStateEventBus;
            Intrinsics.checkNotNull((Object)sessionStateEventBus);
            mqttClient = new AmityMqttClient(sessionLifeCycleEventBus, sessionStateEventBus);
            AppEventBus appEventBus = CoreClient.appEventBus;
            Intrinsics.checkNotNull((Object)appEventBus);
            SessionLifeCycleEventBus sessionLifeCycleEventBus3 = CoreClient.sessionLifeCycleEventBus;
            Intrinsics.checkNotNull((Object)sessionLifeCycleEventBus3);
            SessionStateEventBus sessionStateEventBus3 = CoreClient.sessionStateEventBus;
            Intrinsics.checkNotNull((Object)sessionStateEventBus3);
            renewalManager = new TokenRenewalSessionComponent(appEventBus, sessionLifeCycleEventBus3, sessionStateEventBus3);
            SessionLifeCycleEventBus sessionLifeCycleEventBus4 = CoreClient.sessionLifeCycleEventBus;
            Intrinsics.checkNotNull((Object)sessionLifeCycleEventBus4);
            SessionStateEventBus sessionStateEventBus4 = CoreClient.sessionStateEventBus;
            Intrinsics.checkNotNull((Object)sessionStateEventBus4);
            presenceSyncEngine = new PresenceSyncEngine(sessionLifeCycleEventBus4, sessionStateEventBus4);
            SessionLifeCycleEventBus sessionLifeCycleEventBus5 = CoreClient.sessionLifeCycleEventBus;
            Intrinsics.checkNotNull((Object)sessionLifeCycleEventBus5);
            SessionStateEventBus sessionStateEventBus5 = CoreClient.sessionStateEventBus;
            Intrinsics.checkNotNull((Object)sessionStateEventBus5);
            analyticsEngine = new AnalyticsEngine(sessionLifeCycleEventBus5, sessionStateEventBus5);
            SessionLifeCycleEventBus sessionLifeCycleEventBus6 = CoreClient.sessionLifeCycleEventBus;
            Intrinsics.checkNotNull((Object)sessionLifeCycleEventBus6);
            SessionStateEventBus sessionStateEventBus6 = CoreClient.sessionStateEventBus;
            Intrinsics.checkNotNull((Object)sessionStateEventBus6);
            new AmityHttpClient(sessionLifeCycleEventBus6, sessionStateEventBus6);
            SessionLifeCycleEventBus sessionLifeCycleEventBus7 = CoreClient.sessionLifeCycleEventBus;
            Intrinsics.checkNotNull((Object)sessionLifeCycleEventBus7);
            SessionStateEventBus sessionStateEventBus7 = CoreClient.sessionStateEventBus;
            Intrinsics.checkNotNull((Object)sessionStateEventBus7);
            new DatabaseSessionComponent(sessionLifeCycleEventBus7, sessionStateEventBus7);
            SessionLifeCycleEventBus sessionLifeCycleEventBus8 = CoreClient.sessionLifeCycleEventBus;
            Intrinsics.checkNotNull((Object)sessionLifeCycleEventBus8);
            SessionStateEventBus sessionStateEventBus8 = CoreClient.sessionStateEventBus;
            Intrinsics.checkNotNull((Object)sessionStateEventBus8);
            new UserSettingSessionComponent(sessionLifeCycleEventBus8, sessionStateEventBus8);
            AppEventBus appEventBus3 = CoreClient.appEventBus;
            Intrinsics.checkNotNull((Object)appEventBus3);
            SessionLifeCycleEventBus sessionLifeCycleEventBus9 = CoreClient.sessionLifeCycleEventBus;
            Intrinsics.checkNotNull((Object)sessionLifeCycleEventBus9);
            SessionStateEventBus sessionStateEventBus9 = CoreClient.sessionStateEventBus;
            Intrinsics.checkNotNull((Object)sessionStateEventBus9);
            new TokenWatcherSessionComponent(appEventBus3, sessionLifeCycleEventBus9, sessionStateEventBus9);
            SessionLifeCycleEventBus sessionLifeCycleEventBus10 = CoreClient.sessionLifeCycleEventBus;
            Intrinsics.checkNotNull((Object)sessionLifeCycleEventBus10);
            SessionStateEventBus sessionStateEventBus10 = CoreClient.sessionStateEventBus;
            Intrinsics.checkNotNull((Object)sessionStateEventBus10);
            markerSyncEngine = new MarkerSyncEngine(sessionLifeCycleEventBus10, sessionStateEventBus10);
            SessionLifeCycleEventBus sessionLifeCycleEventBus11 = CoreClient.sessionLifeCycleEventBus;
            Intrinsics.checkNotNull((Object)sessionLifeCycleEventBus11);
            SessionStateEventBus sessionStateEventBus11 = CoreClient.sessionStateEventBus;
            Intrinsics.checkNotNull((Object)sessionStateEventBus11);
            markReadEngine = new MarkReadEngine(sessionLifeCycleEventBus11, sessionStateEventBus11);
            SessionLifeCycleEventBus sessionLifeCycleEventBus12 = CoreClient.sessionLifeCycleEventBus;
            Intrinsics.checkNotNull((Object)sessionLifeCycleEventBus12);
            SessionStateEventBus sessionStateEventBus12 = CoreClient.sessionStateEventBus;
            Intrinsics.checkNotNull((Object)sessionStateEventBus12);
            messagePreviewEngine = new MessagePreviewEngine(sessionLifeCycleEventBus12, sessionStateEventBus12);
            SessionLifeCycleEventBus sessionLifeCycleEventBus13 = CoreClient.sessionLifeCycleEventBus;
            Intrinsics.checkNotNull((Object)sessionLifeCycleEventBus13);
            SessionStateEventBus sessionStateEventBus13 = CoreClient.sessionStateEventBus;
            Intrinsics.checkNotNull((Object)sessionStateEventBus13);
            messageSyncEngine = new MessageSyncEngine(sessionLifeCycleEventBus13, sessionStateEventBus13);
            SessionLifeCycleEventBus sessionLifeCycleEventBus14 = CoreClient.sessionLifeCycleEventBus;
            Intrinsics.checkNotNull((Object)sessionLifeCycleEventBus14);
            SessionStateEventBus sessionStateEventBus14 = CoreClient.sessionStateEventBus;
            Intrinsics.checkNotNull((Object)sessionStateEventBus14);
            messageReadReceiptSyncEngine = new MessageReadReceiptSyncEngine(sessionLifeCycleEventBus14, sessionStateEventBus14);
            SessionLifeCycleEventBus sessionLifeCycleEventBus15 = CoreClient.sessionLifeCycleEventBus;
            Intrinsics.checkNotNull((Object)sessionLifeCycleEventBus15);
            SessionStateEventBus sessionStateEventBus15 = CoreClient.sessionStateEventBus;
            Intrinsics.checkNotNull((Object)sessionStateEventBus15);
            objectResolverEngine = new ObjectResolverEngine(sessionLifeCycleEventBus15, sessionStateEventBus15);
        }
    }

    private static final void setup$lambda$0(EkoHttpUrlDao $httpUrlDao, String $newHttpUrl, EkoMqttUrlDao $mqttUrlDao, String $newMqttUrl, AmityUploadUrlDao $uploadUrlDao, String $newUploadUrl, EkoApiKeyDao $apiKeyDao, String $apiKey) {
        Intrinsics.checkNotNullParameter((Object)$newHttpUrl, (String)"$newHttpUrl");
        Intrinsics.checkNotNullParameter((Object)$newMqttUrl, (String)"$newMqttUrl");
        Intrinsics.checkNotNullParameter((Object)$newUploadUrl, (String)"$newUploadUrl");
        Intrinsics.checkNotNullParameter((Object)$apiKey, (String)"$apiKey");
        logoutProcessState = LogoutProcessState.IDLE;
        $httpUrlDao.insert(EkoHttpUrl.create($newHttpUrl));
        $mqttUrlDao.insert(EkoMqttUrl.create($newMqttUrl));
        $uploadUrlDao.insert(AmityUploadUrl.Companion.create($newUploadUrl));
        $apiKeyDao.insert(EkoApiKey.create($apiKey));
        AmityCoreSDKInitializer.INSTANCE.initApiService$amity_sdk_release();
    }

    static {
        PublishSubject publishSubject = PublishSubject.create();
        Intrinsics.checkNotNullExpressionValue((Object)publishSubject, (String)"create<AmityNetworkActivity>()");
        networkActivityPublisher = publishSubject;
        isUnreadCountEnable = true;
        uploadedFileAccessType = AmityFileAccessType.PUBLIC;
        logoutProcessState = LogoutProcessState.IDLE;
    }
}

