package com.ekoapp.ekosdk.internal.mapper

import android.net.Uri
import co.amity.rxupload.FileProperties
import com.ekoapp.ekosdk.internal.data.converter.EkoGson
import com.ekoapp.ekosdk.internal.EkoFileEntity
import com.google.gson.JsonParser

internal class AmityFilePropertiesMapper {

    fun map(data: EkoFileEntity?): FileProperties? {
        return data?.let {
            val json = EkoGson.get().toJson(data)
            val jsonElement = JsonParser.parseString(json)
            val jsonObject = jsonElement.takeUnless { it.isJsonNull }?.asJsonObject
            val attributes = jsonObject?.getAsJsonObject("attributes")
            FileProperties(
                uri = Uri.EMPTY,
                fileName = attributes?.get("name")?.asString ?: "",
                fileSize = attributes?.get("size")?.asLong ?: 0L,
                mimeType = attributes?.get("mimeType")?.asString ?: "",
                accessType = jsonObject?.get("accessType")?.asString ?: "",
                responseBody = jsonElement
            )
        }
    }

}