package com.amity.socialcloud.sdk.video.domain.stream

import com.amity.socialcloud.sdk.model.video.stream.AmityStream
import com.amity.socialcloud.sdk.video.data.session.StreamSessionRepository
import com.amity.socialcloud.sdk.video.data.stream.StreamRepository
import io.reactivex.rxjava3.core.Single
import io.reactivex.rxjava3.schedulers.Schedulers
import org.amity.types.ObjectId
import org.joda.time.DateTime

internal class CreateStreamSessionUseCase {

    fun execute(streamId: String, title: String, startedAt: DateTime, resolution: String): Single<String> {
        return StreamRepository().observeStream(streamId)
            .firstOrError()
            .map { stream ->
                val prefix = if(stream.getStatus() == AmityStream.Status.LIVE) "live_" else "playback_"
                val sessionId = prefix + ObjectId().toHexString().prependIndent()
                insertSession(sessionId, streamId, title, startedAt, resolution)
                sessionId
            }.subscribeOn(Schedulers.io())
    }

    private fun insertSession(sessionId: String, streamId: String, title: String, startedAt: DateTime, resolution: String) {
        StreamSessionRepository().createStreamSession(sessionId, streamId, title, startedAt, resolution)
    }

}