package com.amity.socialcloud.sdk.core.data.ad

import com.amity.socialcloud.sdk.entity.core.ad.toModel
import com.amity.socialcloud.sdk.model.core.ad.AmityAdvertiser
import com.amity.socialcloud.sdk.model.core.ad.AmityNetworkAds
import com.amity.socialcloud.sdk.model.core.error.AmityError
import com.amity.socialcloud.sdk.model.core.error.AmityException
import io.reactivex.rxjava3.core.Single

internal class AdRepository {

    fun getNetworkAds() : Single<AmityNetworkAds> {
        return AdRemoteDataStore().getNetworkAds()
            .flatMap {
                AdLocalDataStore().deleteAllAds()
                    .andThen(NetworkAdsQueryPersister().persist(it))
                    .andThen(Single.defer {  getLocalNetworkAds() })
            }
            .onErrorResumeNext {
                getLocalNetworkAds()
            }
    }

    fun getAdvertiser(advertiserId: String): AmityAdvertiser? {
        return AdLocalDataStore().getAdvertiser(advertiserId)?.toModel()
    }

    private fun getLocalNetworkAds(): Single<AmityNetworkAds> {
        return Single.fromCallable {
            val ads = AdLocalDataStore().getAllAds().map {
                it.toModel()
            }
            val settings = AdLocalDataStore().getSettings()?.toModel() ?: throw AmityException.create("Ads settings not available", null, AmityError.ITEM_NOT_FOUND)
            AmityNetworkAds(ads, settings)
        }
    }

}