package com.amity.socialcloud.sdk.api.core.user.search

enum class AmityUserSortOption(val apiKey: String) {
    DISPLAYNAME("displayName"),
    FIRST_CREATED("firstCreated"),
    LAST_CREATED("lastCreated");

    companion object {
        fun enumOf(apiKey: String?): AmityUserSortOption {
            return values().find { it.apiKey == apiKey } ?: DISPLAYNAME
        }
    }

}