/*
 * Decompiled with CFR 0.152.
 */
package com.amity.socialcloud.sdk.api.social.post.query;

import androidx.paging.PagingData;
import com.amity.socialcloud.sdk.api.social.post.query.AmityCommunityFeedSortOption;
import com.amity.socialcloud.sdk.api.social.post.review.AmityReviewStatus;
import com.amity.socialcloud.sdk.model.social.feed.AmityFeedType;
import com.amity.socialcloud.sdk.model.social.post.AmityPost;
import com.ekoapp.ekosdk.internal.usecase.post.GetCommunityPostPagingDataUseCase;
import io.reactivex.rxjava3.core.Flowable;
import java.util.List;
import kotlin.Deprecated;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000>\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001:\u0001\u0013B7\b\u0000\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\b\u0010\u0006\u001a\u0004\u0018\u00010\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u0012\f\u0010\n\u001a\b\u0012\u0004\u0012\u00020\f0\u000b\u00a2\u0006\u0002\u0010\rJ\u0012\u0010\u000f\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00120\u00110\u0010R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0012\u0010\u0006\u001a\u0004\u0018\u00010\u0007X\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\u000eR\u0014\u0010\n\u001a\b\u0012\u0004\u0012\u00020\f0\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0014"}, d2={"Lcom/amity/socialcloud/sdk/api/social/post/query/AmityCommunityPostQuery;", "", "communityId", "", "sortOption", "Lcom/amity/socialcloud/sdk/api/social/post/query/AmityCommunityFeedSortOption;", "isDeleted", "", "feedType", "Lcom/amity/socialcloud/sdk/model/social/feed/AmityFeedType;", "postTypes", "", "Lcom/amity/socialcloud/sdk/model/social/post/AmityPost$DataType;", "(Ljava/lang/String;Lcom/amity/socialcloud/sdk/api/social/post/query/AmityCommunityFeedSortOption;Ljava/lang/Boolean;Lcom/amity/socialcloud/sdk/model/social/feed/AmityFeedType;Ljava/util/List;)V", "Ljava/lang/Boolean;", "query", "Lio/reactivex/rxjava3/core/Flowable;", "Landroidx/paging/PagingData;", "Lcom/amity/socialcloud/sdk/model/social/post/AmityPost;", "Builder", "amity-sdk_release"})
public final class AmityCommunityPostQuery {
    @NotNull
    private final String communityId;
    @NotNull
    private final AmityCommunityFeedSortOption sortOption;
    @Nullable
    private final Boolean isDeleted;
    @NotNull
    private final AmityFeedType feedType;
    @NotNull
    private final List<AmityPost.DataType> postTypes;

    public AmityCommunityPostQuery(@NotNull String communityId, @NotNull AmityCommunityFeedSortOption sortOption, @Nullable Boolean isDeleted, @NotNull AmityFeedType feedType, @NotNull List<? extends AmityPost.DataType> postTypes) {
        Intrinsics.checkNotNullParameter((Object)communityId, (String)"communityId");
        Intrinsics.checkNotNullParameter((Object)((Object)sortOption), (String)"sortOption");
        Intrinsics.checkNotNullParameter((Object)((Object)feedType), (String)"feedType");
        Intrinsics.checkNotNullParameter(postTypes, (String)"postTypes");
        this.communityId = communityId;
        this.sortOption = sortOption;
        this.isDeleted = isDeleted;
        this.feedType = feedType;
        this.postTypes = postTypes;
    }

    @NotNull
    public final Flowable<PagingData<AmityPost>> query() {
        return new GetCommunityPostPagingDataUseCase().execute(this.communityId, this.sortOption, this.isDeleted, this.feedType, this.postTypes);
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000@\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u00002\u00020\u0001B\u000f\b\u0000\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0006\u0010\u000f\u001a\u00020\u0010J\u0010\u0010\u0005\u001a\u00020\u00002\u0006\u0010\u0005\u001a\u00020\u0006H\u0007J\u000e\u0010\u0011\u001a\u00020\u00002\u0006\u0010\u0011\u001a\u00020\bJ\u000e\u0010\u0012\u001a\u00020\u00002\u0006\u0010\u0012\u001a\u00020\u0013J\u000e\u0010\u0014\u001a\u00020\u00002\u0006\u0010\r\u001a\u00020\u000eJ\u0014\u0010\u0015\u001a\u00020\u00002\f\u0010\n\u001a\b\u0012\u0004\u0012\u00020\f0\u000bR\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0012\u0010\u0007\u001a\u0004\u0018\u00010\bX\u0082\u000e\u00a2\u0006\u0004\n\u0002\u0010\tR\u0014\u0010\n\u001a\b\u0012\u0004\u0012\u00020\f0\u000bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\u000eX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0016"}, d2={"Lcom/amity/socialcloud/sdk/api/social/post/query/AmityCommunityPostQuery$Builder;", "", "communityId", "", "(Ljava/lang/String;)V", "feedType", "Lcom/amity/socialcloud/sdk/model/social/feed/AmityFeedType;", "isDeleted", "", "Ljava/lang/Boolean;", "postTypes", "", "Lcom/amity/socialcloud/sdk/model/social/post/AmityPost$DataType;", "sortOption", "Lcom/amity/socialcloud/sdk/api/social/post/query/AmityCommunityFeedSortOption;", "build", "Lcom/amity/socialcloud/sdk/api/social/post/query/AmityCommunityPostQuery;", "includeDeleted", "reviewStatus", "Lcom/amity/socialcloud/sdk/api/social/post/review/AmityReviewStatus;", "sortBy", "types", "amity-sdk_release"})
    public static final class Builder {
        @NotNull
        private final String communityId;
        @NotNull
        private AmityCommunityFeedSortOption sortOption;
        @Nullable
        private Boolean isDeleted;
        @NotNull
        private AmityFeedType feedType;
        @NotNull
        private List<? extends AmityPost.DataType> postTypes;

        public Builder(@NotNull String communityId) {
            Intrinsics.checkNotNullParameter((Object)communityId, (String)"communityId");
            this.communityId = communityId;
            this.sortOption = AmityCommunityFeedSortOption.LAST_CREATED;
            this.feedType = AmityFeedType.PUBLISHED;
            this.postTypes = CollectionsKt.emptyList();
        }

        @NotNull
        public final Builder sortBy(@NotNull AmityCommunityFeedSortOption sortOption) {
            Builder builder;
            Intrinsics.checkNotNullParameter((Object)((Object)sortOption), (String)"sortOption");
            Builder $this$sortBy_u24lambda_u2d0 = builder = this;
            boolean bl = false;
            $this$sortBy_u24lambda_u2d0.sortOption = sortOption;
            return builder;
        }

        @NotNull
        public final Builder includeDeleted(boolean includeDeleted) {
            this.isDeleted = includeDeleted;
            return this;
        }

        @Deprecated(message="Use reviewStatus() instead")
        @NotNull
        public final Builder feedType(@NotNull AmityFeedType feedType) {
            Builder builder;
            Intrinsics.checkNotNullParameter((Object)((Object)feedType), (String)"feedType");
            Builder $this$feedType_u24lambda_u2d1 = builder = this;
            boolean bl = false;
            $this$feedType_u24lambda_u2d1.feedType = feedType;
            return builder;
        }

        @NotNull
        public final Builder reviewStatus(@NotNull AmityReviewStatus reviewStatus) {
            Builder builder;
            Intrinsics.checkNotNullParameter((Object)((Object)reviewStatus), (String)"reviewStatus");
            Builder $this$reviewStatus_u24lambda_u2d2 = builder = this;
            boolean bl = false;
            $this$reviewStatus_u24lambda_u2d2.feedType = AmityFeedType.Companion.enumOf(reviewStatus.getApiKey());
            return builder;
        }

        @NotNull
        public final Builder types(@NotNull List<? extends AmityPost.DataType> postTypes) {
            Builder builder;
            Intrinsics.checkNotNullParameter(postTypes, (String)"postTypes");
            Builder $this$types_u24lambda_u2d3 = builder = this;
            boolean bl = false;
            $this$types_u24lambda_u2d3.postTypes = postTypes;
            return builder;
        }

        @NotNull
        public final AmityCommunityPostQuery build() {
            return new AmityCommunityPostQuery(this.communityId, this.sortOption, this.isDeleted, this.feedType, this.postTypes);
        }
    }
}

