/*
 * Decompiled with CFR 0.152.
 */
package com.amity.socialcloud.sdk.api.social.member;

import com.amity.socialcloud.sdk.social.domain.community.moderation.AddRolesUseCase;
import com.amity.socialcloud.sdk.social.domain.community.moderation.BanUsersCommunityUseCase;
import com.amity.socialcloud.sdk.social.domain.community.moderation.RemoveRolesUseCase;
import com.amity.socialcloud.sdk.social.domain.community.moderation.UnBanUsersCommunityUseCase;
import com.amity.socialcloud.sdk.social.domain.community.participation.AddUsersCommunityParticipationUseCase;
import com.amity.socialcloud.sdk.social.domain.community.participation.RemoveUsersCommunityParticipationUseCase;
import io.reactivex.rxjava3.core.Completable;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\b\u0007\u0018\u00002\u00020\u0001B\u000f\b\u0000\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0014\u0010\u0005\u001a\u00020\u00062\f\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\u00030\bJ\"\u0010\t\u001a\u00020\u00062\f\u0010\n\u001a\b\u0012\u0004\u0012\u00020\u00030\b2\f\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\u00030\bJ\u0014\u0010\u000b\u001a\u00020\u00062\f\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\u00030\bJ\u0014\u0010\f\u001a\u00020\u00062\f\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\u00030\bJ\"\u0010\r\u001a\u00020\u00062\f\u0010\n\u001a\b\u0012\u0004\u0012\u00020\u00030\b2\f\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\u00030\bJ\u0014\u0010\u000e\u001a\u00020\u00062\f\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\u00030\bR\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000f"}, d2={"Lcom/amity/socialcloud/sdk/api/social/member/AmityCommunityModeration;", "", "communityId", "", "(Ljava/lang/String;)V", "addMembers", "Lio/reactivex/rxjava3/core/Completable;", "userIds", "", "addRoles", "roles", "banMembers", "removeMembers", "removeRoles", "unbanMembers", "amity-sdk_release"})
public final class AmityCommunityModeration {
    @NotNull
    private final String communityId;

    public AmityCommunityModeration(@NotNull String communityId) {
        Intrinsics.checkNotNullParameter((Object)communityId, (String)"communityId");
        this.communityId = communityId;
    }

    @NotNull
    public final Completable addMembers(@NotNull List<String> userIds) {
        Intrinsics.checkNotNullParameter(userIds, (String)"userIds");
        return new AddUsersCommunityParticipationUseCase().execute(this.communityId, userIds);
    }

    @NotNull
    public final Completable removeMembers(@NotNull List<String> userIds) {
        Intrinsics.checkNotNullParameter(userIds, (String)"userIds");
        return new RemoveUsersCommunityParticipationUseCase().execute(this.communityId, userIds);
    }

    @NotNull
    public final Completable addRoles(@NotNull List<String> roles, @NotNull List<String> userIds) {
        Intrinsics.checkNotNullParameter(roles, (String)"roles");
        Intrinsics.checkNotNullParameter(userIds, (String)"userIds");
        return new AddRolesUseCase().execute(this.communityId, roles, userIds);
    }

    @NotNull
    public final Completable removeRoles(@NotNull List<String> roles, @NotNull List<String> userIds) {
        Intrinsics.checkNotNullParameter(roles, (String)"roles");
        Intrinsics.checkNotNullParameter(userIds, (String)"userIds");
        return new RemoveRolesUseCase().execute(this.communityId, roles, userIds);
    }

    @NotNull
    public final Completable banMembers(@NotNull List<String> userIds) {
        Intrinsics.checkNotNullParameter(userIds, (String)"userIds");
        return new BanUsersCommunityUseCase().execute(this.communityId, userIds);
    }

    @NotNull
    public final Completable unbanMembers(@NotNull List<String> userIds) {
        Intrinsics.checkNotNullParameter(userIds, (String)"userIds");
        return new UnBanUsersCommunityUseCase().execute(this.communityId, userIds);
    }
}

