/*
 * Decompiled with CFR 0.152.
 */
package com.amity.socialcloud.sdk.api.chat.channel;

import com.amity.socialcloud.sdk.api.chat.channel.create.AmityChannelCreationType;
import com.amity.socialcloud.sdk.api.chat.channel.query.AmityChannelQueryType;
import com.amity.socialcloud.sdk.api.chat.channel.update.AmityChannelUpdate;
import com.amity.socialcloud.sdk.api.chat.member.AmityChannelModeration;
import com.amity.socialcloud.sdk.api.chat.member.AmityChannelParticipation;
import com.amity.socialcloud.sdk.api.chat.notification.AmityChannelNotification;
import com.amity.socialcloud.sdk.chat.domain.channel.ChannelLiveObjectUseCase;
import com.amity.socialcloud.sdk.chat.domain.channel.JoinChannelUseCase;
import com.amity.socialcloud.sdk.chat.domain.channel.LeaveChannelUseCase;
import com.amity.socialcloud.sdk.chat.domain.channel.TotalChannelUnreadCountUseCase;
import com.amity.socialcloud.sdk.model.chat.channel.AmityChannel;
import io.reactivex.rxjava3.core.Completable;
import io.reactivex.rxjava3.core.Flowable;
import io.reactivex.rxjava3.core.Single;
import kotlin.Deprecated;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000T\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u0007\b\u0000\u00a2\u0006\u0002\u0010\u0002J\u000e\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006J\u0014\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\t0\b2\u0006\u0010\n\u001a\u00020\u0006J\u0006\u0010\u000b\u001a\u00020\fJ\f\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u000e0\bJ\u0014\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\t0\u00102\u0006\u0010\n\u001a\u00020\u0006J\u000e\u0010\u0011\u001a\u00020\u00122\u0006\u0010\n\u001a\u00020\u0006J\u000e\u0010\u0013\u001a\u00020\u00142\u0006\u0010\n\u001a\u00020\u0006J\u000e\u0010\u0015\u001a\u00020\u00162\u0006\u0010\n\u001a\u00020\u0006J\u0010\u0010\u0017\u001a\u00020\u00182\u0006\u0010\n\u001a\u00020\u0006H\u0007J\u000e\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\n\u001a\u00020\u0006\u00a8\u0006\u001b"}, d2={"Lcom/amity/socialcloud/sdk/api/chat/channel/AmityChannelRepository;", "", "()V", "createChannel", "Lcom/amity/socialcloud/sdk/api/chat/channel/create/AmityChannelCreationType;", "displayName", "", "getChannel", "Lio/reactivex/rxjava3/core/Flowable;", "Lcom/amity/socialcloud/sdk/model/chat/channel/AmityChannel;", "channelId", "getChannels", "Lcom/amity/socialcloud/sdk/api/chat/channel/query/AmityChannelQueryType;", "getTotalDefaultSubChannelUnreadCount", "", "joinChannel", "Lio/reactivex/rxjava3/core/Single;", "leaveChannel", "Lio/reactivex/rxjava3/core/Completable;", "membership", "Lcom/amity/socialcloud/sdk/api/chat/member/AmityChannelParticipation;", "moderation", "Lcom/amity/socialcloud/sdk/api/chat/member/AmityChannelModeration;", "notification", "Lcom/amity/socialcloud/sdk/api/chat/notification/AmityChannelNotification;", "updateChannel", "Lcom/amity/socialcloud/sdk/api/chat/channel/update/AmityChannelUpdate$Builder;", "amity-sdk_release"})
public final class AmityChannelRepository {
    @NotNull
    public final AmityChannelCreationType createChannel(@NotNull String displayName) {
        Intrinsics.checkNotNullParameter((Object)displayName, (String)"displayName");
        return new AmityChannelCreationType(displayName);
    }

    @NotNull
    public final AmityChannelQueryType getChannels() {
        return new AmityChannelQueryType();
    }

    @NotNull
    public final Flowable<AmityChannel> getChannel(@NotNull String channelId) {
        Intrinsics.checkNotNullParameter((Object)channelId, (String)"channelId");
        return new ChannelLiveObjectUseCase().execute(channelId);
    }

    @NotNull
    public final Single<AmityChannel> joinChannel(@NotNull String channelId) {
        Intrinsics.checkNotNullParameter((Object)channelId, (String)"channelId");
        return new JoinChannelUseCase().execute(channelId);
    }

    @NotNull
    public final Completable leaveChannel(@NotNull String channelId) {
        Intrinsics.checkNotNullParameter((Object)channelId, (String)"channelId");
        return new LeaveChannelUseCase().execute(channelId);
    }

    @NotNull
    public final AmityChannelUpdate.Builder updateChannel(@NotNull String channelId) {
        Intrinsics.checkNotNullParameter((Object)channelId, (String)"channelId");
        return new AmityChannelUpdate.Builder(channelId);
    }

    @NotNull
    public final Flowable<Integer> getTotalDefaultSubChannelUnreadCount() {
        return new TotalChannelUnreadCountUseCase().execute();
    }

    @NotNull
    public final AmityChannelParticipation membership(@NotNull String channelId) {
        Intrinsics.checkNotNullParameter((Object)channelId, (String)"channelId");
        return new AmityChannelParticipation(channelId);
    }

    @NotNull
    public final AmityChannelModeration moderation(@NotNull String channelId) {
        Intrinsics.checkNotNullParameter((Object)channelId, (String)"channelId");
        return new AmityChannelModeration(channelId);
    }

    @Deprecated(message="Use AmityCoreClient.notification.channel(channelId: String) instead")
    @NotNull
    public final AmityChannelNotification notification(@NotNull String channelId) {
        Intrinsics.checkNotNullParameter((Object)channelId, (String)"channelId");
        return new AmityChannelNotification(channelId);
    }
}

