/*
 * Decompiled with CFR 0.152.
 */
package com.ekoapp.ekosdk.internal.data.dao;

import android.database.Cursor;
import androidx.room.EntityDeletionOrUpdateAdapter;
import androidx.room.EntityInsertionAdapter;
import androidx.room.RoomDatabase;
import androidx.room.RoomSQLiteQuery;
import androidx.room.SharedSQLiteStatement;
import androidx.room.rxjava3.RxRoom;
import androidx.room.util.CursorUtil;
import androidx.room.util.DBUtil;
import androidx.sqlite.db.SupportSQLiteQuery;
import androidx.sqlite.db.SupportSQLiteStatement;
import com.amity.socialcloud.sdk.socket.util.DateTimeTypeConverter;
import com.ekoapp.ekosdk.internal.MessageMarkerEntity;
import com.ekoapp.ekosdk.internal.data.dao.MessageMarkerDao;
import io.reactivex.rxjava3.core.Flowable;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.Callable;
import org.joda.time.DateTime;

public final class MessageMarkerDao_Impl
extends MessageMarkerDao {
    private final RoomDatabase __db;
    private final EntityInsertionAdapter<MessageMarkerEntity> __insertionAdapterOfMessageMarkerEntity;
    private final DateTimeTypeConverter __dateTimeTypeConverter = new DateTimeTypeConverter();
    private final EntityDeletionOrUpdateAdapter<MessageMarkerEntity> __deletionAdapterOfMessageMarkerEntity;
    private final EntityDeletionOrUpdateAdapter<MessageMarkerEntity> __updateAdapterOfMessageMarkerEntity;
    private final SharedSQLiteStatement __preparedStmtOfUpdatePreviousMarkersReadCount;
    private final SharedSQLiteStatement __preparedStmtOfUpdatePreviousMarkersDeliveredCount;
    private final SharedSQLiteStatement __preparedStmtOfDeleteAll;
    private final SharedSQLiteStatement __preparedStmtOfDeleteById;

    public MessageMarkerDao_Impl(RoomDatabase __db) {
        this.__db = __db;
        this.__insertionAdapterOfMessageMarkerEntity = new EntityInsertionAdapter<MessageMarkerEntity>(__db){

            public String createQuery() {
                return "INSERT OR REPLACE INTO `message_marker` (`messageId`,`subChannelId`,`readCount`,`deliveredCount`,`createdAt`,`updatedAt`,`expiresAt`) VALUES (?,?,?,?,?,?,?)";
            }

            public void bind(SupportSQLiteStatement stmt, MessageMarkerEntity value) {
                if (value.getMessageId() == null) {
                    stmt.bindNull(1);
                } else {
                    stmt.bindString(1, value.getMessageId());
                }
                if (value.getSubChannelId() == null) {
                    stmt.bindNull(2);
                } else {
                    stmt.bindString(2, value.getSubChannelId());
                }
                stmt.bindLong(3, (long)value.getReadCount());
                stmt.bindLong(4, (long)value.getDeliveredCount());
                String _tmp = MessageMarkerDao_Impl.this.__dateTimeTypeConverter.dateTimeToString(value.getCreatedAt());
                if (_tmp == null) {
                    stmt.bindNull(5);
                } else {
                    stmt.bindString(5, _tmp);
                }
                String _tmp_1 = MessageMarkerDao_Impl.this.__dateTimeTypeConverter.dateTimeToString(value.getUpdatedAt());
                if (_tmp_1 == null) {
                    stmt.bindNull(6);
                } else {
                    stmt.bindString(6, _tmp_1);
                }
                String _tmp_2 = MessageMarkerDao_Impl.this.__dateTimeTypeConverter.dateTimeToString(value.getExpiresAt());
                if (_tmp_2 == null) {
                    stmt.bindNull(7);
                } else {
                    stmt.bindString(7, _tmp_2);
                }
            }
        };
        this.__deletionAdapterOfMessageMarkerEntity = new EntityDeletionOrUpdateAdapter<MessageMarkerEntity>(__db){

            public String createQuery() {
                return "DELETE FROM `message_marker` WHERE `messageId` = ?";
            }

            public void bind(SupportSQLiteStatement stmt, MessageMarkerEntity value) {
                if (value.getMessageId() == null) {
                    stmt.bindNull(1);
                } else {
                    stmt.bindString(1, value.getMessageId());
                }
            }
        };
        this.__updateAdapterOfMessageMarkerEntity = new EntityDeletionOrUpdateAdapter<MessageMarkerEntity>(__db){

            public String createQuery() {
                return "UPDATE OR ABORT `message_marker` SET `messageId` = ?,`subChannelId` = ?,`readCount` = ?,`deliveredCount` = ?,`createdAt` = ?,`updatedAt` = ?,`expiresAt` = ? WHERE `messageId` = ?";
            }

            public void bind(SupportSQLiteStatement stmt, MessageMarkerEntity value) {
                if (value.getMessageId() == null) {
                    stmt.bindNull(1);
                } else {
                    stmt.bindString(1, value.getMessageId());
                }
                if (value.getSubChannelId() == null) {
                    stmt.bindNull(2);
                } else {
                    stmt.bindString(2, value.getSubChannelId());
                }
                stmt.bindLong(3, (long)value.getReadCount());
                stmt.bindLong(4, (long)value.getDeliveredCount());
                String _tmp = MessageMarkerDao_Impl.this.__dateTimeTypeConverter.dateTimeToString(value.getCreatedAt());
                if (_tmp == null) {
                    stmt.bindNull(5);
                } else {
                    stmt.bindString(5, _tmp);
                }
                String _tmp_1 = MessageMarkerDao_Impl.this.__dateTimeTypeConverter.dateTimeToString(value.getUpdatedAt());
                if (_tmp_1 == null) {
                    stmt.bindNull(6);
                } else {
                    stmt.bindString(6, _tmp_1);
                }
                String _tmp_2 = MessageMarkerDao_Impl.this.__dateTimeTypeConverter.dateTimeToString(value.getExpiresAt());
                if (_tmp_2 == null) {
                    stmt.bindNull(7);
                } else {
                    stmt.bindString(7, _tmp_2);
                }
                if (value.getMessageId() == null) {
                    stmt.bindNull(8);
                } else {
                    stmt.bindString(8, value.getMessageId());
                }
            }
        };
        this.__preparedStmtOfUpdatePreviousMarkersReadCount = new SharedSQLiteStatement(__db){

            public String createQuery() {
                String _query = "Update message_marker set readCount = ? where subChannelId = ? and readCount < ? and createdAt <= ?";
                return "Update message_marker set readCount = ? where subChannelId = ? and readCount < ? and createdAt <= ?";
            }
        };
        this.__preparedStmtOfUpdatePreviousMarkersDeliveredCount = new SharedSQLiteStatement(__db){

            public String createQuery() {
                String _query = "Update message_marker set deliveredCount = ? where subChannelId = ? and deliveredCount < ? and createdAt <= ?";
                return "Update message_marker set deliveredCount = ? where subChannelId = ? and deliveredCount < ? and createdAt <= ?";
            }
        };
        this.__preparedStmtOfDeleteAll = new SharedSQLiteStatement(__db){

            public String createQuery() {
                String _query = "DELETE from message_marker";
                return "DELETE from message_marker";
            }
        };
        this.__preparedStmtOfDeleteById = new SharedSQLiteStatement(__db){

            public String createQuery() {
                String _query = "DELETE from message_marker where messageId = ?";
                return "DELETE from message_marker where messageId = ?";
            }
        };
    }

    @Override
    public void insertImpl(MessageMarkerEntity object) {
        this.__db.assertNotSuspendingTransaction();
        this.__db.beginTransaction();
        try {
            this.__insertionAdapterOfMessageMarkerEntity.insert((Object)object);
            this.__db.setTransactionSuccessful();
        }
        finally {
            this.__db.endTransaction();
        }
    }

    @Override
    public void insertImpl(List<? extends MessageMarkerEntity> objects) {
        this.__db.assertNotSuspendingTransaction();
        this.__db.beginTransaction();
        try {
            this.__insertionAdapterOfMessageMarkerEntity.insert(objects);
            this.__db.setTransactionSuccessful();
        }
        finally {
            this.__db.endTransaction();
        }
    }

    @Override
    public void delete(MessageMarkerEntity object) {
        this.__db.assertNotSuspendingTransaction();
        this.__db.beginTransaction();
        try {
            this.__deletionAdapterOfMessageMarkerEntity.handle((Object)object);
            this.__db.setTransactionSuccessful();
        }
        finally {
            this.__db.endTransaction();
        }
    }

    @Override
    public void delete(List<? extends MessageMarkerEntity> objects) {
        this.__db.assertNotSuspendingTransaction();
        this.__db.beginTransaction();
        try {
            this.__deletionAdapterOfMessageMarkerEntity.handleMultiple(objects);
            this.__db.setTransactionSuccessful();
        }
        finally {
            this.__db.endTransaction();
        }
    }

    @Override
    public void updateImpl(MessageMarkerEntity object) {
        this.__db.assertNotSuspendingTransaction();
        this.__db.beginTransaction();
        try {
            this.__updateAdapterOfMessageMarkerEntity.handle((Object)object);
            this.__db.setTransactionSuccessful();
        }
        finally {
            this.__db.endTransaction();
        }
    }

    @Override
    public void insert(MessageMarkerEntity object) {
        this.__db.beginTransaction();
        try {
            MessageMarkerDao_Impl.super.insert(object);
            this.__db.setTransactionSuccessful();
        }
        finally {
            this.__db.endTransaction();
        }
    }

    @Override
    public void insert(List<? extends MessageMarkerEntity> objects) {
        this.__db.beginTransaction();
        try {
            MessageMarkerDao_Impl.super.insert(objects);
            this.__db.setTransactionSuccessful();
        }
        finally {
            this.__db.endTransaction();
        }
    }

    @Override
    public void update(MessageMarkerEntity object) {
        this.__db.beginTransaction();
        try {
            MessageMarkerDao_Impl.super.update(object);
            this.__db.setTransactionSuccessful();
        }
        finally {
            this.__db.endTransaction();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void updatePreviousMarkersReadCount(String subChannelId, int readCout, DateTime createdAt) {
        this.__db.assertNotSuspendingTransaction();
        SupportSQLiteStatement _stmt = this.__preparedStmtOfUpdatePreviousMarkersReadCount.acquire();
        int _argIndex = 1;
        _stmt.bindLong(_argIndex, (long)readCout);
        _argIndex = 2;
        if (subChannelId == null) {
            _stmt.bindNull(_argIndex);
        } else {
            _stmt.bindString(_argIndex, subChannelId);
        }
        _argIndex = 3;
        _stmt.bindLong(_argIndex, (long)readCout);
        _argIndex = 4;
        String _tmp = this.__dateTimeTypeConverter.dateTimeToString(createdAt);
        if (_tmp == null) {
            _stmt.bindNull(_argIndex);
        } else {
            _stmt.bindString(_argIndex, _tmp);
        }
        this.__db.beginTransaction();
        try {
            _stmt.executeUpdateDelete();
            this.__db.setTransactionSuccessful();
        }
        finally {
            this.__db.endTransaction();
            this.__preparedStmtOfUpdatePreviousMarkersReadCount.release(_stmt);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void updatePreviousMarkersDeliveredCount(String subChannelId, int deliveredCount, DateTime createdAt) {
        this.__db.assertNotSuspendingTransaction();
        SupportSQLiteStatement _stmt = this.__preparedStmtOfUpdatePreviousMarkersDeliveredCount.acquire();
        int _argIndex = 1;
        _stmt.bindLong(_argIndex, (long)deliveredCount);
        _argIndex = 2;
        if (subChannelId == null) {
            _stmt.bindNull(_argIndex);
        } else {
            _stmt.bindString(_argIndex, subChannelId);
        }
        _argIndex = 3;
        _stmt.bindLong(_argIndex, (long)deliveredCount);
        _argIndex = 4;
        String _tmp = this.__dateTimeTypeConverter.dateTimeToString(createdAt);
        if (_tmp == null) {
            _stmt.bindNull(_argIndex);
        } else {
            _stmt.bindString(_argIndex, _tmp);
        }
        this.__db.beginTransaction();
        try {
            _stmt.executeUpdateDelete();
            this.__db.setTransactionSuccessful();
        }
        finally {
            this.__db.endTransaction();
            this.__preparedStmtOfUpdatePreviousMarkersDeliveredCount.release(_stmt);
        }
    }

    @Override
    public void deleteAll() {
        this.__db.assertNotSuspendingTransaction();
        SupportSQLiteStatement _stmt = this.__preparedStmtOfDeleteAll.acquire();
        this.__db.beginTransaction();
        try {
            _stmt.executeUpdateDelete();
            this.__db.setTransactionSuccessful();
        }
        finally {
            this.__db.endTransaction();
            this.__preparedStmtOfDeleteAll.release(_stmt);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void deleteById(String messageId) {
        this.__db.assertNotSuspendingTransaction();
        SupportSQLiteStatement _stmt = this.__preparedStmtOfDeleteById.acquire();
        int _argIndex = 1;
        if (messageId == null) {
            _stmt.bindNull(_argIndex);
        } else {
            _stmt.bindString(_argIndex, messageId);
        }
        this.__db.beginTransaction();
        try {
            _stmt.executeUpdateDelete();
            this.__db.setTransactionSuccessful();
        }
        finally {
            this.__db.endTransaction();
            this.__preparedStmtOfDeleteById.release(_stmt);
        }
    }

    @Override
    public Flowable<MessageMarkerEntity> getById(String messageId) {
        String _sql = "SELECT * from message_marker where messageId = ? LIMIT 1";
        final RoomSQLiteQuery _statement = RoomSQLiteQuery.acquire((String)"SELECT * from message_marker where messageId = ? LIMIT 1", (int)1);
        int _argIndex = 1;
        if (messageId == null) {
            _statement.bindNull(_argIndex);
        } else {
            _statement.bindString(_argIndex, messageId);
        }
        return RxRoom.createFlowable((RoomDatabase)this.__db, (boolean)false, (String[])new String[]{"message_marker"}, (Callable)new Callable<MessageMarkerEntity>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public MessageMarkerEntity call() throws Exception {
                try (Cursor _cursor = DBUtil.query((RoomDatabase)MessageMarkerDao_Impl.this.__db, (SupportSQLiteQuery)_statement, (boolean)false, null);){
                    MessageMarkerEntity _result;
                    int _cursorIndexOfMessageId = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"messageId");
                    int _cursorIndexOfSubChannelId = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"subChannelId");
                    int _cursorIndexOfReadCount = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"readCount");
                    int _cursorIndexOfDeliveredCount = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"deliveredCount");
                    int _cursorIndexOfCreatedAt = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"createdAt");
                    int _cursorIndexOfUpdatedAt = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"updatedAt");
                    int _cursorIndexOfExpiresAt = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"expiresAt");
                    if (_cursor.moveToFirst()) {
                        _result = new MessageMarkerEntity();
                        String _tmpMessageId = _cursor.isNull(_cursorIndexOfMessageId) ? null : _cursor.getString(_cursorIndexOfMessageId);
                        _result.setMessageId(_tmpMessageId);
                        String _tmpSubChannelId = _cursor.isNull(_cursorIndexOfSubChannelId) ? null : _cursor.getString(_cursorIndexOfSubChannelId);
                        _result.setSubChannelId(_tmpSubChannelId);
                        int _tmpReadCount = _cursor.getInt(_cursorIndexOfReadCount);
                        _result.setReadCount(_tmpReadCount);
                        int _tmpDeliveredCount = _cursor.getInt(_cursorIndexOfDeliveredCount);
                        _result.setDeliveredCount(_tmpDeliveredCount);
                        String _tmp = _cursor.isNull(_cursorIndexOfCreatedAt) ? null : _cursor.getString(_cursorIndexOfCreatedAt);
                        DateTime _tmpCreatedAt = MessageMarkerDao_Impl.this.__dateTimeTypeConverter.stringToDateTime(_tmp);
                        _result.setCreatedAt(_tmpCreatedAt);
                        String _tmp_1 = _cursor.isNull(_cursorIndexOfUpdatedAt) ? null : _cursor.getString(_cursorIndexOfUpdatedAt);
                        DateTime _tmpUpdatedAt = MessageMarkerDao_Impl.this.__dateTimeTypeConverter.stringToDateTime(_tmp_1);
                        _result.setUpdatedAt(_tmpUpdatedAt);
                        String _tmp_2 = _cursor.isNull(_cursorIndexOfExpiresAt) ? null : _cursor.getString(_cursorIndexOfExpiresAt);
                        DateTime _tmpExpiresAt = MessageMarkerDao_Impl.this.__dateTimeTypeConverter.stringToDateTime(_tmp_2);
                        _result.setExpiresAt(_tmpExpiresAt);
                    } else {
                        _result = null;
                    }
                    MessageMarkerEntity messageMarkerEntity = _result;
                    return messageMarkerEntity;
                }
            }

            protected void finalize() {
                _statement.release();
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public MessageMarkerEntity getByIdNow(String messageId) {
        String _sql = "SELECT * from message_marker where messageId = ? LIMIT 1";
        RoomSQLiteQuery _statement = RoomSQLiteQuery.acquire((String)"SELECT * from message_marker where messageId = ? LIMIT 1", (int)1);
        int _argIndex = 1;
        if (messageId == null) {
            _statement.bindNull(_argIndex);
        } else {
            _statement.bindString(_argIndex, messageId);
        }
        this.__db.assertNotSuspendingTransaction();
        Cursor _cursor = DBUtil.query((RoomDatabase)this.__db, (SupportSQLiteQuery)_statement, (boolean)false, null);
        try {
            MessageMarkerEntity _result;
            int _cursorIndexOfMessageId = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"messageId");
            int _cursorIndexOfSubChannelId = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"subChannelId");
            int _cursorIndexOfReadCount = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"readCount");
            int _cursorIndexOfDeliveredCount = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"deliveredCount");
            int _cursorIndexOfCreatedAt = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"createdAt");
            int _cursorIndexOfUpdatedAt = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"updatedAt");
            int _cursorIndexOfExpiresAt = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"expiresAt");
            if (_cursor.moveToFirst()) {
                _result = new MessageMarkerEntity();
                String _tmpMessageId = _cursor.isNull(_cursorIndexOfMessageId) ? null : _cursor.getString(_cursorIndexOfMessageId);
                _result.setMessageId(_tmpMessageId);
                String _tmpSubChannelId = _cursor.isNull(_cursorIndexOfSubChannelId) ? null : _cursor.getString(_cursorIndexOfSubChannelId);
                _result.setSubChannelId(_tmpSubChannelId);
                int _tmpReadCount = _cursor.getInt(_cursorIndexOfReadCount);
                _result.setReadCount(_tmpReadCount);
                int _tmpDeliveredCount = _cursor.getInt(_cursorIndexOfDeliveredCount);
                _result.setDeliveredCount(_tmpDeliveredCount);
                String _tmp = _cursor.isNull(_cursorIndexOfCreatedAt) ? null : _cursor.getString(_cursorIndexOfCreatedAt);
                DateTime _tmpCreatedAt = this.__dateTimeTypeConverter.stringToDateTime(_tmp);
                _result.setCreatedAt(_tmpCreatedAt);
                String _tmp_1 = _cursor.isNull(_cursorIndexOfUpdatedAt) ? null : _cursor.getString(_cursorIndexOfUpdatedAt);
                DateTime _tmpUpdatedAt = this.__dateTimeTypeConverter.stringToDateTime(_tmp_1);
                _result.setUpdatedAt(_tmpUpdatedAt);
                String _tmp_2 = _cursor.isNull(_cursorIndexOfExpiresAt) ? null : _cursor.getString(_cursorIndexOfExpiresAt);
                DateTime _tmpExpiresAt = this.__dateTimeTypeConverter.stringToDateTime(_tmp_2);
                _result.setExpiresAt(_tmpExpiresAt);
            } else {
                _result = null;
            }
            MessageMarkerEntity messageMarkerEntity = _result;
            return messageMarkerEntity;
        }
        finally {
            _cursor.close();
            _statement.release();
        }
    }

    public static List<Class<?>> getRequiredConverters() {
        return Collections.emptyList();
    }
}

