/*
 * Decompiled with CFR 0.152.
 */
package com.ekoapp.ekosdk.internal.data.dao;

import android.database.Cursor;
import androidx.room.EntityDeletionOrUpdateAdapter;
import androidx.room.EntityInsertionAdapter;
import androidx.room.RoomDatabase;
import androidx.room.RoomSQLiteQuery;
import androidx.room.SharedSQLiteStatement;
import androidx.room.rxjava3.RxRoom;
import androidx.room.util.CursorUtil;
import androidx.room.util.DBUtil;
import androidx.sqlite.db.SupportSQLiteQuery;
import androidx.sqlite.db.SupportSQLiteStatement;
import com.amity.socialcloud.sdk.socket.util.DateTimeTypeConverter;
import com.ekoapp.ekosdk.internal.ChannelReadReceiptEntity;
import com.ekoapp.ekosdk.internal.data.dao.ChannelReadReceiptDao;
import io.reactivex.rxjava3.core.Flowable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.Callable;
import org.joda.time.DateTime;

public final class ChannelReadReceiptDao_Impl
extends ChannelReadReceiptDao {
    private final RoomDatabase __db;
    private final EntityInsertionAdapter<ChannelReadReceiptEntity> __insertionAdapterOfChannelReadReceiptEntity;
    private final DateTimeTypeConverter __dateTimeTypeConverter = new DateTimeTypeConverter();
    private final EntityDeletionOrUpdateAdapter<ChannelReadReceiptEntity> __deletionAdapterOfChannelReadReceiptEntity;
    private final EntityDeletionOrUpdateAdapter<ChannelReadReceiptEntity> __updateAdapterOfChannelReadReceiptEntity;
    private final SharedSQLiteStatement __preparedStmtOfDeleteAll;
    private final SharedSQLiteStatement __preparedStmtOfDeleteByChannelId;
    private final SharedSQLiteStatement __preparedStmtOfUpdateLatestSegment;
    private final SharedSQLiteStatement __preparedStmtOfUpdateLatestSyncSegment;

    public ChannelReadReceiptDao_Impl(RoomDatabase __db) {
        this.__db = __db;
        this.__insertionAdapterOfChannelReadReceiptEntity = new EntityInsertionAdapter<ChannelReadReceiptEntity>(__db){

            public String createQuery() {
                return "INSERT OR REPLACE INTO `channel_read_receipt` (`channelId`,`latestSegment`,`latestSyncSegment`,`createdAt`,`updatedAt`,`expiresAt`) VALUES (?,?,?,?,?,?)";
            }

            public void bind(SupportSQLiteStatement stmt, ChannelReadReceiptEntity value) {
                if (value.getChannelId() == null) {
                    stmt.bindNull(1);
                } else {
                    stmt.bindString(1, value.getChannelId());
                }
                stmt.bindLong(2, (long)value.getLatestSegment());
                stmt.bindLong(3, (long)value.getLatestSyncSegment());
                String _tmp = ChannelReadReceiptDao_Impl.this.__dateTimeTypeConverter.dateTimeToString(value.getCreatedAt());
                if (_tmp == null) {
                    stmt.bindNull(4);
                } else {
                    stmt.bindString(4, _tmp);
                }
                String _tmp_1 = ChannelReadReceiptDao_Impl.this.__dateTimeTypeConverter.dateTimeToString(value.getUpdatedAt());
                if (_tmp_1 == null) {
                    stmt.bindNull(5);
                } else {
                    stmt.bindString(5, _tmp_1);
                }
                String _tmp_2 = ChannelReadReceiptDao_Impl.this.__dateTimeTypeConverter.dateTimeToString(value.getExpiresAt());
                if (_tmp_2 == null) {
                    stmt.bindNull(6);
                } else {
                    stmt.bindString(6, _tmp_2);
                }
            }
        };
        this.__deletionAdapterOfChannelReadReceiptEntity = new EntityDeletionOrUpdateAdapter<ChannelReadReceiptEntity>(__db){

            public String createQuery() {
                return "DELETE FROM `channel_read_receipt` WHERE `channelId` = ?";
            }

            public void bind(SupportSQLiteStatement stmt, ChannelReadReceiptEntity value) {
                if (value.getChannelId() == null) {
                    stmt.bindNull(1);
                } else {
                    stmt.bindString(1, value.getChannelId());
                }
            }
        };
        this.__updateAdapterOfChannelReadReceiptEntity = new EntityDeletionOrUpdateAdapter<ChannelReadReceiptEntity>(__db){

            public String createQuery() {
                return "UPDATE OR ABORT `channel_read_receipt` SET `channelId` = ?,`latestSegment` = ?,`latestSyncSegment` = ?,`createdAt` = ?,`updatedAt` = ?,`expiresAt` = ? WHERE `channelId` = ?";
            }

            public void bind(SupportSQLiteStatement stmt, ChannelReadReceiptEntity value) {
                if (value.getChannelId() == null) {
                    stmt.bindNull(1);
                } else {
                    stmt.bindString(1, value.getChannelId());
                }
                stmt.bindLong(2, (long)value.getLatestSegment());
                stmt.bindLong(3, (long)value.getLatestSyncSegment());
                String _tmp = ChannelReadReceiptDao_Impl.this.__dateTimeTypeConverter.dateTimeToString(value.getCreatedAt());
                if (_tmp == null) {
                    stmt.bindNull(4);
                } else {
                    stmt.bindString(4, _tmp);
                }
                String _tmp_1 = ChannelReadReceiptDao_Impl.this.__dateTimeTypeConverter.dateTimeToString(value.getUpdatedAt());
                if (_tmp_1 == null) {
                    stmt.bindNull(5);
                } else {
                    stmt.bindString(5, _tmp_1);
                }
                String _tmp_2 = ChannelReadReceiptDao_Impl.this.__dateTimeTypeConverter.dateTimeToString(value.getExpiresAt());
                if (_tmp_2 == null) {
                    stmt.bindNull(6);
                } else {
                    stmt.bindString(6, _tmp_2);
                }
                if (value.getChannelId() == null) {
                    stmt.bindNull(7);
                } else {
                    stmt.bindString(7, value.getChannelId());
                }
            }
        };
        this.__preparedStmtOfDeleteAll = new SharedSQLiteStatement(__db){

            public String createQuery() {
                String _query = "DELETE from channel_read_receipt";
                return "DELETE from channel_read_receipt";
            }
        };
        this.__preparedStmtOfDeleteByChannelId = new SharedSQLiteStatement(__db){

            public String createQuery() {
                String _query = "DELETE from channel_read_receipt where channelId = ?";
                return "DELETE from channel_read_receipt where channelId = ?";
            }
        };
        this.__preparedStmtOfUpdateLatestSegment = new SharedSQLiteStatement(__db){

            public String createQuery() {
                String _query = "UPDATE channel_read_receipt set latestSegment = ? where channelId = ? and latestSegment < ?";
                return "UPDATE channel_read_receipt set latestSegment = ? where channelId = ? and latestSegment < ?";
            }
        };
        this.__preparedStmtOfUpdateLatestSyncSegment = new SharedSQLiteStatement(__db){

            public String createQuery() {
                String _query = "UPDATE channel_read_receipt set latestSyncSegment = ? where channelId = ? and latestSyncSegment < ?";
                return "UPDATE channel_read_receipt set latestSyncSegment = ? where channelId = ? and latestSyncSegment < ?";
            }
        };
    }

    @Override
    public void insertImpl(ChannelReadReceiptEntity object) {
        this.__db.assertNotSuspendingTransaction();
        this.__db.beginTransaction();
        try {
            this.__insertionAdapterOfChannelReadReceiptEntity.insert((Object)object);
            this.__db.setTransactionSuccessful();
        }
        finally {
            this.__db.endTransaction();
        }
    }

    @Override
    public void insertImpl(List<? extends ChannelReadReceiptEntity> objects) {
        this.__db.assertNotSuspendingTransaction();
        this.__db.beginTransaction();
        try {
            this.__insertionAdapterOfChannelReadReceiptEntity.insert(objects);
            this.__db.setTransactionSuccessful();
        }
        finally {
            this.__db.endTransaction();
        }
    }

    @Override
    public void delete(ChannelReadReceiptEntity object) {
        this.__db.assertNotSuspendingTransaction();
        this.__db.beginTransaction();
        try {
            this.__deletionAdapterOfChannelReadReceiptEntity.handle((Object)object);
            this.__db.setTransactionSuccessful();
        }
        finally {
            this.__db.endTransaction();
        }
    }

    @Override
    public void delete(List<? extends ChannelReadReceiptEntity> objects) {
        this.__db.assertNotSuspendingTransaction();
        this.__db.beginTransaction();
        try {
            this.__deletionAdapterOfChannelReadReceiptEntity.handleMultiple(objects);
            this.__db.setTransactionSuccessful();
        }
        finally {
            this.__db.endTransaction();
        }
    }

    @Override
    public void updateImpl(ChannelReadReceiptEntity object) {
        this.__db.assertNotSuspendingTransaction();
        this.__db.beginTransaction();
        try {
            this.__updateAdapterOfChannelReadReceiptEntity.handle((Object)object);
            this.__db.setTransactionSuccessful();
        }
        finally {
            this.__db.endTransaction();
        }
    }

    @Override
    public void insert(ChannelReadReceiptEntity object) {
        this.__db.beginTransaction();
        try {
            ChannelReadReceiptDao_Impl.super.insert(object);
            this.__db.setTransactionSuccessful();
        }
        finally {
            this.__db.endTransaction();
        }
    }

    @Override
    public void insert(List<? extends ChannelReadReceiptEntity> objects) {
        this.__db.beginTransaction();
        try {
            ChannelReadReceiptDao_Impl.super.insert(objects);
            this.__db.setTransactionSuccessful();
        }
        finally {
            this.__db.endTransaction();
        }
    }

    @Override
    public void update(ChannelReadReceiptEntity object) {
        this.__db.beginTransaction();
        try {
            ChannelReadReceiptDao_Impl.super.update(object);
            this.__db.setTransactionSuccessful();
        }
        finally {
            this.__db.endTransaction();
        }
    }

    @Override
    public void deleteAll() {
        this.__db.assertNotSuspendingTransaction();
        SupportSQLiteStatement _stmt = this.__preparedStmtOfDeleteAll.acquire();
        this.__db.beginTransaction();
        try {
            _stmt.executeUpdateDelete();
            this.__db.setTransactionSuccessful();
        }
        finally {
            this.__db.endTransaction();
            this.__preparedStmtOfDeleteAll.release(_stmt);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void deleteByChannelId(String channelId) {
        this.__db.assertNotSuspendingTransaction();
        SupportSQLiteStatement _stmt = this.__preparedStmtOfDeleteByChannelId.acquire();
        int _argIndex = 1;
        if (channelId == null) {
            _stmt.bindNull(_argIndex);
        } else {
            _stmt.bindString(_argIndex, channelId);
        }
        this.__db.beginTransaction();
        try {
            _stmt.executeUpdateDelete();
            this.__db.setTransactionSuccessful();
        }
        finally {
            this.__db.endTransaction();
            this.__preparedStmtOfDeleteByChannelId.release(_stmt);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void updateLatestSegment(String channelId, int segment) {
        this.__db.assertNotSuspendingTransaction();
        SupportSQLiteStatement _stmt = this.__preparedStmtOfUpdateLatestSegment.acquire();
        int _argIndex = 1;
        _stmt.bindLong(_argIndex, (long)segment);
        _argIndex = 2;
        if (channelId == null) {
            _stmt.bindNull(_argIndex);
        } else {
            _stmt.bindString(_argIndex, channelId);
        }
        _argIndex = 3;
        _stmt.bindLong(_argIndex, (long)segment);
        this.__db.beginTransaction();
        try {
            _stmt.executeUpdateDelete();
            this.__db.setTransactionSuccessful();
        }
        finally {
            this.__db.endTransaction();
            this.__preparedStmtOfUpdateLatestSegment.release(_stmt);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void updateLatestSyncSegment(String channelId, int segment) {
        this.__db.assertNotSuspendingTransaction();
        SupportSQLiteStatement _stmt = this.__preparedStmtOfUpdateLatestSyncSegment.acquire();
        int _argIndex = 1;
        _stmt.bindLong(_argIndex, (long)segment);
        _argIndex = 2;
        if (channelId == null) {
            _stmt.bindNull(_argIndex);
        } else {
            _stmt.bindString(_argIndex, channelId);
        }
        _argIndex = 3;
        _stmt.bindLong(_argIndex, (long)segment);
        this.__db.beginTransaction();
        try {
            _stmt.executeUpdateDelete();
            this.__db.setTransactionSuccessful();
        }
        finally {
            this.__db.endTransaction();
            this.__preparedStmtOfUpdateLatestSyncSegment.release(_stmt);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ChannelReadReceiptEntity getByIdNow(String id) {
        String _sql = "SELECT * from channel_read_receipt where channelId = ? LIMIT 1";
        RoomSQLiteQuery _statement = RoomSQLiteQuery.acquire((String)"SELECT * from channel_read_receipt where channelId = ? LIMIT 1", (int)1);
        int _argIndex = 1;
        if (id == null) {
            _statement.bindNull(_argIndex);
        } else {
            _statement.bindString(_argIndex, id);
        }
        this.__db.assertNotSuspendingTransaction();
        Cursor _cursor = DBUtil.query((RoomDatabase)this.__db, (SupportSQLiteQuery)_statement, (boolean)false, null);
        try {
            ChannelReadReceiptEntity _result;
            int _cursorIndexOfChannelId = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"channelId");
            int _cursorIndexOfLatestSegment = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"latestSegment");
            int _cursorIndexOfLatestSyncSegment = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"latestSyncSegment");
            int _cursorIndexOfCreatedAt = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"createdAt");
            int _cursorIndexOfUpdatedAt = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"updatedAt");
            int _cursorIndexOfExpiresAt = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"expiresAt");
            if (_cursor.moveToFirst()) {
                _result = new ChannelReadReceiptEntity();
                String _tmpChannelId = _cursor.isNull(_cursorIndexOfChannelId) ? null : _cursor.getString(_cursorIndexOfChannelId);
                _result.setChannelId(_tmpChannelId);
                int _tmpLatestSegment = _cursor.getInt(_cursorIndexOfLatestSegment);
                _result.setLatestSegment(_tmpLatestSegment);
                int _tmpLatestSyncSegment = _cursor.getInt(_cursorIndexOfLatestSyncSegment);
                _result.setLatestSyncSegment(_tmpLatestSyncSegment);
                String _tmp = _cursor.isNull(_cursorIndexOfCreatedAt) ? null : _cursor.getString(_cursorIndexOfCreatedAt);
                DateTime _tmpCreatedAt = this.__dateTimeTypeConverter.stringToDateTime(_tmp);
                _result.setCreatedAt(_tmpCreatedAt);
                String _tmp_1 = _cursor.isNull(_cursorIndexOfUpdatedAt) ? null : _cursor.getString(_cursorIndexOfUpdatedAt);
                DateTime _tmpUpdatedAt = this.__dateTimeTypeConverter.stringToDateTime(_tmp_1);
                _result.setUpdatedAt(_tmpUpdatedAt);
                String _tmp_2 = _cursor.isNull(_cursorIndexOfExpiresAt) ? null : _cursor.getString(_cursorIndexOfExpiresAt);
                DateTime _tmpExpiresAt = this.__dateTimeTypeConverter.stringToDateTime(_tmp_2);
                _result.setExpiresAt(_tmpExpiresAt);
            } else {
                _result = null;
            }
            ChannelReadReceiptEntity channelReadReceiptEntity = _result;
            return channelReadReceiptEntity;
        }
        finally {
            _cursor.close();
            _statement.release();
        }
    }

    @Override
    public Flowable<ChannelReadReceiptEntity> getById(String channelId) {
        String _sql = "SELECT * from channel_read_receipt where channelId = ? LIMIT 1";
        final RoomSQLiteQuery _statement = RoomSQLiteQuery.acquire((String)"SELECT * from channel_read_receipt where channelId = ? LIMIT 1", (int)1);
        int _argIndex = 1;
        if (channelId == null) {
            _statement.bindNull(_argIndex);
        } else {
            _statement.bindString(_argIndex, channelId);
        }
        return RxRoom.createFlowable((RoomDatabase)this.__db, (boolean)false, (String[])new String[]{"channel_read_receipt"}, (Callable)new Callable<ChannelReadReceiptEntity>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public ChannelReadReceiptEntity call() throws Exception {
                try (Cursor _cursor = DBUtil.query((RoomDatabase)ChannelReadReceiptDao_Impl.this.__db, (SupportSQLiteQuery)_statement, (boolean)false, null);){
                    ChannelReadReceiptEntity _result;
                    int _cursorIndexOfChannelId = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"channelId");
                    int _cursorIndexOfLatestSegment = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"latestSegment");
                    int _cursorIndexOfLatestSyncSegment = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"latestSyncSegment");
                    int _cursorIndexOfCreatedAt = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"createdAt");
                    int _cursorIndexOfUpdatedAt = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"updatedAt");
                    int _cursorIndexOfExpiresAt = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"expiresAt");
                    if (_cursor.moveToFirst()) {
                        _result = new ChannelReadReceiptEntity();
                        String _tmpChannelId = _cursor.isNull(_cursorIndexOfChannelId) ? null : _cursor.getString(_cursorIndexOfChannelId);
                        _result.setChannelId(_tmpChannelId);
                        int _tmpLatestSegment = _cursor.getInt(_cursorIndexOfLatestSegment);
                        _result.setLatestSegment(_tmpLatestSegment);
                        int _tmpLatestSyncSegment = _cursor.getInt(_cursorIndexOfLatestSyncSegment);
                        _result.setLatestSyncSegment(_tmpLatestSyncSegment);
                        String _tmp = _cursor.isNull(_cursorIndexOfCreatedAt) ? null : _cursor.getString(_cursorIndexOfCreatedAt);
                        DateTime _tmpCreatedAt = ChannelReadReceiptDao_Impl.this.__dateTimeTypeConverter.stringToDateTime(_tmp);
                        _result.setCreatedAt(_tmpCreatedAt);
                        String _tmp_1 = _cursor.isNull(_cursorIndexOfUpdatedAt) ? null : _cursor.getString(_cursorIndexOfUpdatedAt);
                        DateTime _tmpUpdatedAt = ChannelReadReceiptDao_Impl.this.__dateTimeTypeConverter.stringToDateTime(_tmp_1);
                        _result.setUpdatedAt(_tmpUpdatedAt);
                        String _tmp_2 = _cursor.isNull(_cursorIndexOfExpiresAt) ? null : _cursor.getString(_cursorIndexOfExpiresAt);
                        DateTime _tmpExpiresAt = ChannelReadReceiptDao_Impl.this.__dateTimeTypeConverter.stringToDateTime(_tmp_2);
                        _result.setExpiresAt(_tmpExpiresAt);
                    } else {
                        _result = null;
                    }
                    ChannelReadReceiptEntity channelReadReceiptEntity = _result;
                    return channelReadReceiptEntity;
                }
            }

            protected void finalize() {
                _statement.release();
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<ChannelReadReceiptEntity> getUnsyncReadReceipts() {
        String _sql = "SELECT * from channel_read_receipt where latestSyncSegment < latestSegment";
        RoomSQLiteQuery _statement = RoomSQLiteQuery.acquire((String)"SELECT * from channel_read_receipt where latestSyncSegment < latestSegment", (int)0);
        this.__db.assertNotSuspendingTransaction();
        Cursor _cursor = DBUtil.query((RoomDatabase)this.__db, (SupportSQLiteQuery)_statement, (boolean)false, null);
        try {
            int _cursorIndexOfChannelId = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"channelId");
            int _cursorIndexOfLatestSegment = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"latestSegment");
            int _cursorIndexOfLatestSyncSegment = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"latestSyncSegment");
            int _cursorIndexOfCreatedAt = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"createdAt");
            int _cursorIndexOfUpdatedAt = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"updatedAt");
            int _cursorIndexOfExpiresAt = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"expiresAt");
            ArrayList<ChannelReadReceiptEntity> _result = new ArrayList<ChannelReadReceiptEntity>(_cursor.getCount());
            while (_cursor.moveToNext()) {
                ChannelReadReceiptEntity _item = new ChannelReadReceiptEntity();
                String _tmpChannelId = _cursor.isNull(_cursorIndexOfChannelId) ? null : _cursor.getString(_cursorIndexOfChannelId);
                _item.setChannelId(_tmpChannelId);
                int _tmpLatestSegment = _cursor.getInt(_cursorIndexOfLatestSegment);
                _item.setLatestSegment(_tmpLatestSegment);
                int _tmpLatestSyncSegment = _cursor.getInt(_cursorIndexOfLatestSyncSegment);
                _item.setLatestSyncSegment(_tmpLatestSyncSegment);
                String _tmp = _cursor.isNull(_cursorIndexOfCreatedAt) ? null : _cursor.getString(_cursorIndexOfCreatedAt);
                DateTime _tmpCreatedAt = this.__dateTimeTypeConverter.stringToDateTime(_tmp);
                _item.setCreatedAt(_tmpCreatedAt);
                String _tmp_1 = _cursor.isNull(_cursorIndexOfUpdatedAt) ? null : _cursor.getString(_cursorIndexOfUpdatedAt);
                DateTime _tmpUpdatedAt = this.__dateTimeTypeConverter.stringToDateTime(_tmp_1);
                _item.setUpdatedAt(_tmpUpdatedAt);
                String _tmp_2 = _cursor.isNull(_cursorIndexOfExpiresAt) ? null : _cursor.getString(_cursorIndexOfExpiresAt);
                DateTime _tmpExpiresAt = this.__dateTimeTypeConverter.stringToDateTime(_tmp_2);
                _item.setExpiresAt(_tmpExpiresAt);
                _result.add(_item);
            }
            ArrayList<ChannelReadReceiptEntity> arrayList = _result;
            return arrayList;
        }
        finally {
            _cursor.close();
            _statement.release();
        }
    }

    public static List<Class<?>> getRequiredConverters() {
        return Collections.emptyList();
    }
}

