package com.amity.socialcloud.sdk.core.data.follow.info

import com.amity.socialcloud.sdk.common.ModelMapper
import com.amity.socialcloud.sdk.model.core.follow.AmityMyFollowInfo
import com.ekoapp.ekosdk.internal.data.model.EkoFollowCountEntity

internal class MyFollowInfoModelMapper : ModelMapper<EkoFollowCountEntity, AmityMyFollowInfo>() {

    override fun map(entity: EkoFollowCountEntity): AmityMyFollowInfo {
        return AmityMyFollowInfo(
            followerCount = entity.followerCount ?: 0,
            followingCount = entity.followingCount ?: 0,
            pendingRequestCount = entity.pendingCount ?: 0
        )
    }
}