package com.amity.socialcloud.sdk.chat.data.channel.paging

import androidx.paging.PagingSource
import androidx.room.Dao
import androidx.room.RawQuery
import androidx.sqlite.db.SimpleSQLiteQuery
import co.amity.rxremotemediator.AmityPagingDao
import co.amity.rxremotemediator.AmityPagingId
import com.amity.socialcloud.sdk.model.chat.channel.AmityChannel
import com.amity.socialcloud.sdk.model.chat.channel.AmityChannelFilter
import com.amity.socialcloud.sdk.model.core.tag.AmityTags
import com.ekoapp.ekosdk.internal.EkoChannelEntity
import com.ekoapp.ekosdk.internal.data.AmityNonce
import com.ekoapp.ekosdk.internal.paging.DynamicQueryStreamPagingDao


@Dao
internal interface ChannelPagingDao : DynamicQueryStreamPagingDao<EkoChannelEntity> {

    @RawQuery(observedEntities = [EkoChannelEntity::class, AmityPagingId::class])
    override fun queryPagingData(sqlQuery: SimpleSQLiteQuery): PagingSource<Int, EkoChannelEntity>

    fun getChannelPagingSource(
        types: Set<AmityChannel.Type>,
        filter: AmityChannelFilter,
        includingTags: AmityTags,
        excludingTags: AmityTags,
        isDeleted: Boolean?,
    ): PagingSource<Int, EkoChannelEntity> {
        val order = AmityPagingDao.Order.DESC
        return queryPagingData(
            generateQueryStreamSQL(
                tableName = "channel",
                primaryKeyColumnName = "channelId",
                nonce = AmityNonce.CHANNEL_LIST,
                sortColumn = "lastActivity",
                order = order,
                dynamicQueryStreamKeyCreator = ChannelKeyCreator(
                    types = types,
                    filter = filter,
                    includingTags = includingTags,
                    excludingTags = excludingTags,
                    isDeleted = isDeleted
                )
            )
        )
    }

}