package com.ekoapp.ekosdk.internal.api.mapper

import com.amity.socialcloud.sdk.entity.social.category.CommunityCategoryEntity
import com.ekoapp.ekosdk.internal.api.dto.EkoCommunityCategoryDto

interface EkoCommunityCategoryMapper : EkoObjectMapper<EkoCommunityCategoryDto, CommunityCategoryEntity> {
	companion object {
		val MAPPER: EkoCommunityCategoryMapper = object: EkoCommunityCategoryMapper {
			override fun map(dto: EkoCommunityCategoryDto): CommunityCategoryEntity {
				val communityCategory = CommunityCategoryEntity()
				communityCategory.createdAt = dto.createdAt
				communityCategory.updatedAt = dto.updatedAt
				communityCategory.categoryId = dto.categoryId
				communityCategory.name = dto.name
				communityCategory.avatarFileId = dto.avatarFileId
				communityCategory.metadata = dto.metadata
				communityCategory.isDeleted = dto.deleted
				return communityCategory
			}
		}
	}
}