package com.amity.socialcloud.sdk.core.data.reaction

import com.amity.socialcloud.sdk.common.QueryPersister
import com.amity.socialcloud.sdk.core.data.file.FileEntityMapper
import com.amity.socialcloud.sdk.core.data.file.FileLocalDataStore
import com.amity.socialcloud.sdk.core.data.user.UserEntityMapper
import com.amity.socialcloud.sdk.core.data.user.UserLocalDataStore
import com.amity.socialcloud.sdk.core.data.user.flag.UserFlagEntityMapper
import com.amity.socialcloud.sdk.core.data.user.flag.UserFlagLocalDataStore
import com.amity.socialcloud.sdk.model.core.reaction.AmityReactionReferenceType
import com.ekoapp.ekosdk.internal.api.dto.EkoReactionAndUserListDto
import io.reactivex.rxjava3.core.Completable

internal class ReactionQueryPersister(
    val referenceType: AmityReactionReferenceType,
    val referenceId: String
) : QueryPersister<EkoReactionAndUserListDto>() {

    override fun persist(dto: EkoReactionAndUserListDto): Completable {
        return FileLocalDataStore().saveFiles(FileEntityMapper().map(dto.files))
            .andThen(UserLocalDataStore().saveUsers(UserEntityMapper().map(dto.users)))
            .andThen(UserFlagLocalDataStore().saveFlags(UserFlagEntityMapper().map(dto.users)))
            .andThen(ReactionLocalDataStore().saveReactions(ReactionEntityMapper().map(dto)))
    }
}