package com.amity.socialcloud.sdk.core.data.pin

import com.amity.socialcloud.sdk.common.EntitySingleMapper
import com.ekoapp.ekosdk.internal.api.dto.EkoReactionAndUserListDto
import com.ekoapp.ekosdk.internal.api.dto.PinnedPostQueryDto
import com.ekoapp.ekosdk.internal.data.model.EkoReactionEntity
import com.ekoapp.ekosdk.internal.data.model.PinEntity
import org.joda.time.DateTime

internal class PinnedPostEntityMapper :
    EntitySingleMapper<PinnedPostQueryDto, PinEntity>() {
    override fun map(dto: PinnedPostQueryDto): List<PinEntity> {
        val entities = mutableListOf<PinEntity>()
        dto.pinTargets.firstOrNull()?.let { target ->
            dto.pins.forEach { pin ->
                val entity = PinEntity(
                    pinId = pin.getId(target),
                    referenceId = pin.referenceId ?: "",
                    referenceType = pin.referenceType ?: "",
                    placement = pin.placement ?: "",
                    targetId = target.targetId ?: "",
                    targetType = target.targetType ?: "",
                    pinnedBy = pin.pinnedBy ?: "",
                    pinnedAt = pin.pinnedAt ?: DateTime.now(),
                    lastPinsUpdatedAt = target.lastPinsUpdatedAt ?: DateTime.now(),
                )
                entities.add(entity)
            }
        }
        return entities
    }
}