package com.amity.socialcloud.sdk.core.data.auth

import com.amity.socialcloud.sdk.AmityOkHttp.Companion.newBuilder
import com.amity.socialcloud.sdk.api.core.endpoint.AmityEndpoint
import com.amity.socialcloud.sdk.infra.retrofit.conveter.Rx3ErrorHandlingCallAdapterFactory
import com.amity.socialcloud.sdk.socket.util.EkoGson
import com.ekoapp.ekosdk.internal.api.EkoEndpoint
import retrofit2.Retrofit
import retrofit2.converter.gson.GsonConverterFactory

internal object TokenApi {

    private val tokenApiHolder = TokenApiHolder()

    fun token(endpoint: AmityEndpoint): AmityTokenApi {
        return tokenApiHolder.getApi(endpoint)
    }

    class TokenApiHolder : ApiHolder<AmityTokenApi>() {
        override var clazz: Class<AmityTokenApi> = AmityTokenApi::class.java
    }

    abstract class ApiHolder<T> {

        private var currentHttpUrl: String = ""
        private var apiImpl: T? = null
        abstract var clazz: Class<T>

        fun getApi(endpoint: AmityEndpoint): T {
            return createApi(endpoint)
        }

        private fun createApi(endpoint: AmityEndpoint): T {
            if (currentHttpUrl != endpoint.httpEndpoint) {
                currentHttpUrl = endpoint.httpEndpoint
                apiImpl = getRetrofit(currentHttpUrl).create(clazz)
            }
            return apiImpl!!
        }
    }

    private fun getRetrofit(url: String): Retrofit {
        return createRetrofit(url)
    }

    private fun createRetrofit(url: String): Retrofit {
        return Retrofit.Builder()
            .baseUrl(EkoEndpoint.mapHttpUrlByDeviceVersion(url))
            .client(newBuilder().build())
            .addCallAdapterFactory(Rx3ErrorHandlingCallAdapterFactory.create())
            .addConverterFactory(GsonConverterFactory.create(EkoGson.get()))
            .build()
    }
}
