package com.amity.socialcloud.sdk.social.domain.category.get

import com.amity.socialcloud.sdk.common.AmityObjectRepository
import com.amity.socialcloud.sdk.entity.social.category.CommunityCategoryEntity
import com.amity.socialcloud.sdk.model.social.category.AmityCommunityCategory
import com.amity.socialcloud.sdk.social.data.category.CategoryRepository
import com.amity.socialcloud.sdk.social.domain.category.CategoryComposerUseCase
import com.ekoapp.ekosdk.internal.TombstoneModelType
import com.ekoapp.ekosdk.internal.usecase.LiveObjectUseCase


internal class CategoryLiveObjectUseCase : LiveObjectUseCase<CommunityCategoryEntity, AmityCommunityCategory>() {

    override fun createRepository(): AmityObjectRepository<CommunityCategoryEntity, AmityCommunityCategory> =
        CategoryRepository()

    override fun composeModel(model: AmityCommunityCategory): AmityCommunityCategory =
        CategoryComposerUseCase().execute(model)

    override fun tombstoneModelType(): TombstoneModelType = TombstoneModelType.CATEGORY

}