package com.amity.socialcloud.sdk.social.data.storytarget

import com.amity.socialcloud.sdk.dto.social.story.StoryQueryDto
import io.reactivex.rxjava3.core.Single
import retrofit2.http.GET
import retrofit2.http.Query
import retrofit2.http.QueryMap


interface StoryTargetApi {

    @GET("api/v4/stories/seen")
    fun queryStoryTargets(
        @QueryMap targets: Map<String, String>
    ): Single<StoryQueryDto>

    @GET("api/v5/me/global-story-targets")
    fun queryGlobalFeed(
        @Query("seenState") seenState: String? = null,
        @Query("limit") limit: Int? = null,
        @Query("token") token: String? = null
    ): Single<StoryQueryDto>

}