/*
 * Decompiled with CFR 0.152.
 */
package com.amity.socialcloud.sdk.core.data.follow;

import androidx.paging.PagingConfig;
import androidx.paging.PagingData;
import androidx.paging.PagingSource;
import co.amity.rxbridge.FlowableKt;
import com.amity.socialcloud.sdk.api.core.AmityCoreClient;
import com.amity.socialcloud.sdk.common.AmityObjectRepository;
import com.amity.socialcloud.sdk.common.ModelMapper;
import com.amity.socialcloud.sdk.core.data.follow.FollowLocalDataStore;
import com.amity.socialcloud.sdk.core.data.follow.FollowQueryPersister;
import com.amity.socialcloud.sdk.core.data.follow.FollowRemoteDataStore;
import com.amity.socialcloud.sdk.core.data.follow.FollowRepository;
import com.amity.socialcloud.sdk.core.data.follow.info.MyFollowInfoModelMapper;
import com.amity.socialcloud.sdk.core.data.follow.paging.BlockedMediator;
import com.amity.socialcloud.sdk.core.data.follow.paging.FollowerMediator;
import com.amity.socialcloud.sdk.core.data.follow.paging.FollowingMediator;
import com.amity.socialcloud.sdk.model.core.error.AmityError;
import com.amity.socialcloud.sdk.model.core.follow.AmityFollowRelationship;
import com.amity.socialcloud.sdk.model.core.follow.AmityFollowStatus;
import com.amity.socialcloud.sdk.model.core.follow.AmityFollowStatusFilter;
import com.amity.socialcloud.sdk.model.core.follow.AmityMyFollowInfo;
import com.amity.socialcloud.sdk.model.core.follow.AmityUserFollowInfo;
import com.amity.socialcloud.sdk.social.data.follow.FollowRelationshipModelMapper;
import com.ekoapp.ekosdk.internal.api.dto.EkoFollowDto;
import com.ekoapp.ekosdk.internal.api.dto.EkoFollowListDto;
import com.ekoapp.ekosdk.internal.data.model.EkoFollowCountEntity;
import com.ekoapp.ekosdk.internal.data.model.EkoUserFollowStatusEntity;
import com.ekoapp.ekosdk.internal.paging.DynamicQueryStreamPagerCreator;
import io.reactivex.rxjava3.core.Completable;
import io.reactivex.rxjava3.core.CompletableSource;
import io.reactivex.rxjava3.core.Flowable;
import io.reactivex.rxjava3.core.Single;
import io.reactivex.rxjava3.core.SingleEmitter;
import io.reactivex.rxjava3.core.SingleSource;
import io.reactivex.rxjava3.functions.BiFunction;
import io.reactivex.rxjava3.functions.Consumer;
import io.reactivex.rxjava3.functions.Function;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.reactivestreams.Publisher;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000Z\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0000\u0018\u00002\u000e\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u00030\u0001B\u0005\u00a2\u0006\u0002\u0010\u0004J\u000e\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bJ\u000e\u0010\t\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bJ\u000e\u0010\n\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bJ\u0010\u0010\u000b\u001a\u00020\u00062\u0006\u0010\f\u001a\u00020\bH\u0016J\u0012\u0010\r\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00100\u000f0\u000eJ\b\u0010\u0011\u001a\u00020\u0012H\u0002J\"\u0010\u0013\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00100\u000f0\u000e2\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\u0014\u001a\u00020\u0015J\"\u0010\u0016\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00100\u000f0\u000e2\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\u0014\u001a\u00020\u0015J\u001c\u0010\u0017\u001a\b\u0012\u0004\u0012\u00020\u00100\u000e2\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\u0014\u001a\u00020\u0015J\u001c\u0010\u0018\u001a\b\u0012\u0004\u0012\u00020\u00100\u000e2\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\u0014\u001a\u00020\u0015J\u0014\u0010\u0019\u001a\b\u0012\u0004\u0012\u00020\u001a0\u000e2\u0006\u0010\u0007\u001a\u00020\bJ\u0014\u0010\u001b\u001a\u000e\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u00030\u001cH\u0016J\u0016\u0010\u001d\u001a\b\u0012\u0004\u0012\u00020\u00020\u000e2\u0006\u0010\f\u001a\u00020\bH\u0016J\u0012\u0010\u001e\u001a\u0004\u0018\u00010\u00022\u0006\u0010\f\u001a\u00020\bH\u0016J\u000e\u0010\u001f\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bJ\u0014\u0010 \u001a\b\u0012\u0004\u0012\u00020\"0!2\u0006\u0010\u0007\u001a\u00020\bJ\u000e\u0010#\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bJ\u000e\u0010$\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b\u00a8\u0006%"}, d2={"Lcom/amity/socialcloud/sdk/core/data/follow/FollowRepository;", "Lcom/amity/socialcloud/sdk/common/AmityObjectRepository;", "Lcom/ekoapp/ekosdk/internal/data/model/EkoFollowCountEntity;", "Lcom/amity/socialcloud/sdk/model/core/follow/AmityMyFollowInfo;", "()V", "acceptFollow", "Lio/reactivex/rxjava3/core/Completable;", "userId", "", "blockUser", "declineFollow", "fetchAndSave", "objectId", "getBlockedUsersPagingData", "Lio/reactivex/rxjava3/core/Flowable;", "Landroidx/paging/PagingData;", "Lcom/amity/socialcloud/sdk/model/core/follow/AmityFollowRelationship;", "getDefaultPageSize", "", "getFollowersPagingData", "filter", "Lcom/amity/socialcloud/sdk/model/core/follow/AmityFollowStatusFilter;", "getFollowingsPagingData", "getLatestFollower", "getLatestFollowing", "getUserFollowInfo", "Lcom/amity/socialcloud/sdk/model/core/follow/AmityUserFollowInfo;", "mapper", "Lcom/amity/socialcloud/sdk/common/ModelMapper;", "observeFromCache", "queryFromCache", "removeFollower", "requestFollow", "Lio/reactivex/rxjava3/core/Single;", "Lcom/amity/socialcloud/sdk/model/core/follow/AmityFollowStatus;", "unblockUser", "unfollow", "amity-sdk_release"})
public final class FollowRepository
extends AmityObjectRepository<EkoFollowCountEntity, AmityMyFollowInfo> {
    @Override
    @NotNull
    public Completable fetchAndSave(@NotNull String objectId) {
        Intrinsics.checkNotNullParameter((Object)objectId, (String)"objectId");
        Completable completable = new FollowRemoteDataStore().getMyFollowInfo().flatMapCompletable((Function)fetchAndSave.1.INSTANCE);
        Intrinsics.checkNotNullExpressionValue((Object)completable, (String)"FollowRemoteDataStore().\u2026persist(it)\n            }");
        return completable;
    }

    @Override
    @Nullable
    public EkoFollowCountEntity queryFromCache(@NotNull String objectId) {
        Intrinsics.checkNotNullParameter((Object)objectId, (String)"objectId");
        return new FollowLocalDataStore().getFollowCount(objectId);
    }

    @Override
    @NotNull
    public ModelMapper<EkoFollowCountEntity, AmityMyFollowInfo> mapper() {
        return new MyFollowInfoModelMapper();
    }

    @Override
    @NotNull
    public Flowable<EkoFollowCountEntity> observeFromCache(@NotNull String objectId) {
        Intrinsics.checkNotNullParameter((Object)objectId, (String)"objectId");
        return new FollowLocalDataStore().observeFollowCount(objectId);
    }

    @NotNull
    public final Flowable<AmityUserFollowInfo> getUserFollowInfo(@NotNull String userId) {
        Intrinsics.checkNotNullParameter((Object)userId, (String)"userId");
        String myUserId = AmityCoreClient.INSTANCE.getUserId();
        Flowable flowable = new FollowRemoteDataStore().getUserFollowInfo(userId).flatMapCompletable((Function)getUserFollowInfo.1.INSTANCE).andThen((Publisher)Flowable.combineLatest((Publisher)((Publisher)new FollowLocalDataStore().observeUserFollow(myUserId, userId)), (Publisher)((Publisher)new FollowLocalDataStore().observeFollowCount(userId)), (BiFunction)getUserFollowInfo.2.INSTANCE));
        Intrinsics.checkNotNullExpressionValue((Object)flowable, (String)"FollowRemoteDataStore().\u2026          }\n            )");
        return flowable;
    }

    @NotNull
    public final Single<AmityFollowStatus> requestFollow(@NotNull String userId) {
        Intrinsics.checkNotNullParameter((Object)userId, (String)"userId");
        Single single = new FollowRemoteDataStore().requestFollow(userId).flatMap(new Function(userId){
            final /* synthetic */ String $userId;
            {
                this.$userId = $userId;
            }

            @NotNull
            public final SingleSource<? extends AmityFollowStatus> apply(@NotNull EkoFollowListDto followListDto) {
                Intrinsics.checkNotNullParameter((Object)followListDto, (String)"followListDto");
                return (SingleSource)new FollowQueryPersister().persist(followListDto).andThen((SingleSource)Single.create(arg_0 -> requestFollow.1.apply$lambda$2(followListDto, this.$userId, arg_0)));
            }

            private static final void apply$lambda$2(EkoFollowListDto $followListDto, String $userId, SingleEmitter it) {
                Intrinsics.checkNotNullParameter((Object)$followListDto, (String)"$followListDto");
                Intrinsics.checkNotNullParameter((Object)$userId, (String)"$userId");
                Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                AmityFollowStatus status = AmityFollowStatus.Companion.enumOf(((EkoFollowDto)CollectionsKt.first($followListDto.getFollows())).getStatus());
                if (status == AmityFollowStatus.ACCEPTED) {
                    EkoFollowCountEntity targetFollowCountEntity;
                    Object object;
                    FollowLocalDataStore followLocalDataStore = new FollowLocalDataStore();
                    String myUserId = AmityCoreClient.INSTANCE.getUserId();
                    EkoFollowCountEntity sourceFollowCountEntity = followLocalDataStore.getFollowCountByIdNow(myUserId);
                    Object object2 = sourceFollowCountEntity;
                    if (object2 != null && (object2 = ((EkoFollowCountEntity)object2).getFollowingCount()) != null) {
                        int count = ((Number)object2).intValue();
                        boolean bl = false;
                        followLocalDataStore.updateFollowingCount(myUserId, count + 1);
                    }
                    if ((object = (targetFollowCountEntity = followLocalDataStore.getFollowCountByIdNow($userId))) != null && (object = ((EkoFollowCountEntity)object).getFollowerCount()) != null) {
                        int count = ((Number)object).intValue();
                        boolean bl = false;
                        followLocalDataStore.updateFollowerCount($userId, count + 1);
                    }
                }
                it.onSuccess((Object)((Object)status));
            }
        });
        Intrinsics.checkNotNullExpressionValue((Object)single, (String)"userId: String): Single<\u2026         })\n            }");
        return single;
    }

    @NotNull
    public final Completable acceptFollow(@NotNull String userId) {
        Intrinsics.checkNotNullParameter((Object)userId, (String)"userId");
        Completable completable = new FollowRemoteDataStore().acceptFollow(userId).flatMapCompletable(new Function(userId){
            final /* synthetic */ String $userId;
            {
                this.$userId = $userId;
            }

            @NotNull
            public final CompletableSource apply(@NotNull EkoFollowListDto it) {
                Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                return (CompletableSource)new FollowQueryPersister().persist(it).andThen((CompletableSource)Completable.fromAction(() -> acceptFollow.1.apply$lambda$3(this.$userId)));
            }

            private static final void apply$lambda$3(String $userId) {
                block3: {
                    Object object;
                    int count;
                    Intrinsics.checkNotNullParameter((Object)$userId, (String)"$userId");
                    FollowLocalDataStore followLocalDataStore = new FollowLocalDataStore();
                    EkoFollowCountEntity sourceFollowCountEntity = followLocalDataStore.getFollowCountByIdNow($userId);
                    Object object2 = sourceFollowCountEntity;
                    if (object2 != null && (object2 = ((EkoFollowCountEntity)object2).getFollowingCount()) != null) {
                        int count2 = ((Number)object2).intValue();
                        boolean bl = false;
                        followLocalDataStore.updateFollowingCount($userId, count2 + 1);
                    }
                    String myUserId = AmityCoreClient.INSTANCE.getUserId();
                    EkoFollowCountEntity targetFollowCountEntity = followLocalDataStore.getFollowCountByIdNow(myUserId);
                    Object object3 = targetFollowCountEntity;
                    if (object3 != null && (object3 = ((EkoFollowCountEntity)object3).getFollowerCount()) != null) {
                        count = ((Number)object3).intValue();
                        boolean bl = false;
                        followLocalDataStore.updateFollowerCount(myUserId, count + 1);
                    }
                    if ((object = targetFollowCountEntity) == null || (object = ((EkoFollowCountEntity)object).getPendingCount()) == null) break block3;
                    count = ((Number)object).intValue();
                    boolean bl = false;
                    if (count > 0) {
                        followLocalDataStore.updatePendingCount(myUserId, count + -1);
                    }
                }
            }
        }).doOnError(new Consumer(userId){
            final /* synthetic */ String $userId;
            {
                this.$userId = $userId;
            }

            public final void accept(@NotNull Throwable it) {
                Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                if (AmityError.Companion.from(it) == AmityError.ITEM_NOT_FOUND) {
                    new FollowLocalDataStore().updateFollower(this.$userId, AmityFollowStatus.NONE);
                } else {
                    new FollowLocalDataStore().updateFollower(this.$userId, AmityFollowStatus.PENDING);
                }
            }
        });
        Intrinsics.checkNotNullExpressionValue((Object)completable, (String)"userId: String): Complet\u2026          }\n            }");
        return completable;
    }

    @NotNull
    public final Completable declineFollow(@NotNull String userId) {
        Intrinsics.checkNotNullParameter((Object)userId, (String)"userId");
        Completable completable = new FollowRemoteDataStore().declineFollow(userId).flatMapCompletable((Function)declineFollow.1.INSTANCE).doOnError(new Consumer(userId){
            final /* synthetic */ String $userId;
            {
                this.$userId = $userId;
            }

            public final void accept(@NotNull Throwable it) {
                Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                if (AmityError.Companion.from(it) == AmityError.ITEM_NOT_FOUND) {
                    new FollowLocalDataStore().updateFollower(this.$userId, AmityFollowStatus.NONE);
                } else {
                    new FollowLocalDataStore().updateFollower(this.$userId, AmityFollowStatus.PENDING);
                }
            }
        });
        Intrinsics.checkNotNullExpressionValue((Object)completable, (String)"userId: String): Complet\u2026          }\n            }");
        return completable;
    }

    @NotNull
    public final Completable removeFollower(@NotNull String userId) {
        Intrinsics.checkNotNullParameter((Object)userId, (String)"userId");
        Completable completable = new FollowRemoteDataStore().declineFollow(userId).flatMapCompletable(new Function(userId){
            final /* synthetic */ String $userId;
            {
                this.$userId = $userId;
            }

            @NotNull
            public final CompletableSource apply(@NotNull EkoFollowListDto it) {
                Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                return (CompletableSource)new FollowQueryPersister().persist(it).andThen((CompletableSource)Completable.fromAction(() -> removeFollower.1.apply$lambda$2(this.$userId)));
            }

            private static final void apply$lambda$2(String $userId) {
                block3: {
                    EkoFollowCountEntity targetFollowCountEntity;
                    Object object;
                    Intrinsics.checkNotNullParameter((Object)$userId, (String)"$userId");
                    FollowLocalDataStore followLocalDataStore = new FollowLocalDataStore();
                    String myUserId = AmityCoreClient.INSTANCE.getUserId();
                    EkoFollowCountEntity sourceFollowCountEntity = followLocalDataStore.getFollowCountByIdNow($userId);
                    Object object2 = sourceFollowCountEntity;
                    if (object2 != null && (object2 = ((EkoFollowCountEntity)object2).getFollowingCount()) != null) {
                        int count = ((Number)object2).intValue();
                        boolean bl = false;
                        if (count > 0) {
                            followLocalDataStore.updateFollowingCount($userId, count + -1);
                        }
                    }
                    if ((object = (targetFollowCountEntity = followLocalDataStore.getFollowCountByIdNow(myUserId))) == null || (object = ((EkoFollowCountEntity)object).getFollowerCount()) == null) break block3;
                    int count = ((Number)object).intValue();
                    boolean bl = false;
                    if (count > 0) {
                        followLocalDataStore.updateFollowerCount(myUserId, count + -1);
                    }
                }
            }
        }).doOnError(new Consumer(userId){
            final /* synthetic */ String $userId;
            {
                this.$userId = $userId;
            }

            public final void accept(@NotNull Throwable it) {
                Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                if (AmityError.Companion.from(it) == AmityError.ITEM_NOT_FOUND) {
                    new FollowLocalDataStore().updateFollower(this.$userId, AmityFollowStatus.NONE);
                } else {
                    new FollowLocalDataStore().updateFollower(this.$userId, AmityFollowStatus.ACCEPTED);
                }
            }
        });
        Intrinsics.checkNotNullExpressionValue((Object)completable, (String)"userId: String): Complet\u2026          }\n            }");
        return completable;
    }

    @NotNull
    public final Completable unfollow(@NotNull String userId) {
        Intrinsics.checkNotNullParameter((Object)userId, (String)"userId");
        Completable completable = new FollowRemoteDataStore().unfollow(userId).flatMapCompletable(new Function(userId){
            final /* synthetic */ String $userId;
            {
                this.$userId = $userId;
            }

            @NotNull
            public final CompletableSource apply(@NotNull EkoFollowListDto it) {
                Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                return (CompletableSource)new FollowQueryPersister().persist(it).andThen((CompletableSource)Completable.fromAction(() -> unfollow.1.apply$lambda$2(this.$userId)));
            }

            private static final void apply$lambda$2(String $userId) {
                block3: {
                    EkoFollowCountEntity targetFollowCountEntity;
                    Object object;
                    Intrinsics.checkNotNullParameter((Object)$userId, (String)"$userId");
                    FollowLocalDataStore followLocalDataStore = new FollowLocalDataStore();
                    String myUserId = AmityCoreClient.INSTANCE.getUserId();
                    EkoFollowCountEntity sourceFollowCountEntity = followLocalDataStore.getFollowCountByIdNow(myUserId);
                    Object object2 = sourceFollowCountEntity;
                    if (object2 != null && (object2 = ((EkoFollowCountEntity)object2).getFollowingCount()) != null) {
                        int count = ((Number)object2).intValue();
                        boolean bl = false;
                        if (count > 0) {
                            followLocalDataStore.updateFollowingCount(myUserId, count + -1);
                        }
                    }
                    if ((object = (targetFollowCountEntity = followLocalDataStore.getFollowCountByIdNow($userId))) == null || (object = ((EkoFollowCountEntity)object).getFollowerCount()) == null) break block3;
                    int count = ((Number)object).intValue();
                    boolean bl = false;
                    if (count > 0) {
                        followLocalDataStore.updateFollowerCount($userId, count + -1);
                    }
                }
            }
        }).doOnError(new Consumer(userId){
            final /* synthetic */ String $userId;
            {
                this.$userId = $userId;
            }

            public final void accept(@NotNull Throwable it) {
                Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                if (AmityError.Companion.from(it) == AmityError.ITEM_NOT_FOUND) {
                    new FollowLocalDataStore().updateFollowing(this.$userId, AmityFollowStatus.NONE);
                } else {
                    new FollowLocalDataStore().updateFollowing(this.$userId, AmityFollowStatus.ACCEPTED);
                }
            }
        });
        Intrinsics.checkNotNullExpressionValue((Object)completable, (String)"userId: String): Complet\u2026          }\n            }");
        return completable;
    }

    @NotNull
    public final Flowable<PagingData<AmityFollowRelationship>> getFollowingsPagingData(@NotNull String userId, @NotNull AmityFollowStatusFilter filter) {
        Intrinsics.checkNotNullParameter((Object)userId, (String)"userId");
        Intrinsics.checkNotNullParameter((Object)((Object)filter), (String)"filter");
        DynamicQueryStreamPagerCreator pagerCreator2 = new DynamicQueryStreamPagerCreator(new PagingConfig(this.getDefaultPageSize(), 0, false, 0, 0, 0, 58, null), null, new FollowingMediator(userId, filter), (Function0)new Function0<PagingSource<Integer, EkoUserFollowStatusEntity>>(userId, filter){
            final /* synthetic */ String $userId;
            final /* synthetic */ AmityFollowStatusFilter $filter;
            {
                this.$userId = $userId;
                this.$filter = $filter;
                super(0);
            }

            @NotNull
            public final PagingSource<Integer, EkoUserFollowStatusEntity> invoke() {
                return new FollowLocalDataStore().getFollowingsPagingSource(this.$userId, this.$filter);
            }
        }, (ModelMapper)new FollowRelationshipModelMapper(), 2, null);
        return FlowableKt.toRx3(pagerCreator2.create());
    }

    @NotNull
    public final Flowable<PagingData<AmityFollowRelationship>> getFollowersPagingData(@NotNull String userId, @NotNull AmityFollowStatusFilter filter) {
        Intrinsics.checkNotNullParameter((Object)userId, (String)"userId");
        Intrinsics.checkNotNullParameter((Object)((Object)filter), (String)"filter");
        DynamicQueryStreamPagerCreator pagerCreator2 = new DynamicQueryStreamPagerCreator(new PagingConfig(this.getDefaultPageSize(), 0, false, 0, 0, 0, 58, null), null, new FollowerMediator(userId, filter), (Function0)new Function0<PagingSource<Integer, EkoUserFollowStatusEntity>>(userId, filter){
            final /* synthetic */ String $userId;
            final /* synthetic */ AmityFollowStatusFilter $filter;
            {
                this.$userId = $userId;
                this.$filter = $filter;
                super(0);
            }

            @NotNull
            public final PagingSource<Integer, EkoUserFollowStatusEntity> invoke() {
                return new FollowLocalDataStore().getFollowersPagingSource(this.$userId, this.$filter);
            }
        }, (ModelMapper)new FollowRelationshipModelMapper(), 2, null);
        return FlowableKt.toRx3(pagerCreator2.create());
    }

    @NotNull
    public final Flowable<AmityFollowRelationship> getLatestFollowing(@NotNull String userId, @NotNull AmityFollowStatusFilter filter) {
        Intrinsics.checkNotNullParameter((Object)userId, (String)"userId");
        Intrinsics.checkNotNullParameter((Object)((Object)filter), (String)"filter");
        Flowable flowable = new FollowLocalDataStore().getLatestFollowing(userId, filter).map((Function)getLatestFollowing.1.INSTANCE);
        Intrinsics.checkNotNullExpressionValue((Object)flowable, (String)"FollowLocalDataStore().g\u2026ipModelMapper().map(it) }");
        return flowable;
    }

    @NotNull
    public final Flowable<AmityFollowRelationship> getLatestFollower(@NotNull String userId, @NotNull AmityFollowStatusFilter filter) {
        Intrinsics.checkNotNullParameter((Object)userId, (String)"userId");
        Intrinsics.checkNotNullParameter((Object)((Object)filter), (String)"filter");
        Flowable flowable = new FollowLocalDataStore().getLatestFollower(userId, filter).map((Function)getLatestFollower.1.INSTANCE);
        Intrinsics.checkNotNullExpressionValue((Object)flowable, (String)"FollowLocalDataStore().g\u2026ipModelMapper().map(it) }");
        return flowable;
    }

    @NotNull
    public final Completable blockUser(@NotNull String userId) {
        Intrinsics.checkNotNullParameter((Object)userId, (String)"userId");
        Completable completable = new FollowRemoteDataStore().blockUser(userId).flatMapCompletable((Function)blockUser.1.INSTANCE);
        Intrinsics.checkNotNullExpressionValue((Object)completable, (String)"FollowRemoteDataStore().\u2026persist(it)\n            }");
        return completable;
    }

    @NotNull
    public final Completable unblockUser(@NotNull String userId) {
        Intrinsics.checkNotNullParameter((Object)userId, (String)"userId");
        Completable completable = new FollowRemoteDataStore().unblockUser(userId).flatMapCompletable((Function)unblockUser.1.INSTANCE);
        Intrinsics.checkNotNullExpressionValue((Object)completable, (String)"FollowRemoteDataStore().\u2026persist(it)\n            }");
        return completable;
    }

    @NotNull
    public final Flowable<PagingData<AmityFollowRelationship>> getBlockedUsersPagingData() {
        String userId = AmityCoreClient.INSTANCE.getUserId();
        DynamicQueryStreamPagerCreator pagerCreator2 = new DynamicQueryStreamPagerCreator(new PagingConfig(this.getDefaultPageSize(), 0, false, 0, 0, 0, 58, null), null, new BlockedMediator(userId), (Function0)new Function0<PagingSource<Integer, EkoUserFollowStatusEntity>>(userId){
            final /* synthetic */ String $userId;
            {
                this.$userId = $userId;
                super(0);
            }

            @NotNull
            public final PagingSource<Integer, EkoUserFollowStatusEntity> invoke() {
                return new FollowLocalDataStore().getBlockedPagingSource(this.$userId);
            }
        }, (ModelMapper)new FollowRelationshipModelMapper(), 2, null);
        return FlowableKt.toRx3(pagerCreator2.create());
    }

    private final int getDefaultPageSize() {
        return 20;
    }
}

