package com.ekoapp.ekosdk.internal.api.mapper

import com.amity.socialcloud.sdk.model.chat.settings.AmityMessagePreviewSetting
import com.ekoapp.ekosdk.internal.ChatSettingsEntity
import com.ekoapp.ekosdk.internal.api.dto.ChatSettingsDto

interface EkoChatSettingsMapper : EkoObjectMapper<ChatSettingsDto, ChatSettingsEntity> {
	companion object {
		val MAPPER: EkoChatSettingsMapper = object: EkoChatSettingsMapper {
			override fun map(dto: ChatSettingsDto): ChatSettingsEntity {
				val entity = ChatSettingsEntity()
				entity.enabled = dto.enabled
				if (dto.mention != null) {
					entity.isAllowMentionedChannelEnabled = dto.mention.isAllowMentionedChannelEnabled
				}
				if (dto.messagePreview != null) {
					entity.messagePreviewSetting = AmityMessagePreviewSetting.fromMessagePreviewSettingDto(dto.messagePreview).name
				}
				return entity
			}
		}
	}
}