package com.amity.socialcloud.sdk.chat.data.marker.reader

import com.ekoapp.ekosdk.internal.api.AmityHttpClient
import com.ekoapp.ekosdk.internal.api.dto.MarkerSyncDto
import com.ekoapp.ekosdk.internal.api.dto.SubChannelMarkingDto
import com.google.gson.JsonObject
import io.reactivex.rxjava3.core.Single

internal class MarkReadRemoteDataStore {

    fun startSubChannelReading(subChannelId: String): Single<SubChannelMarkingDto> {
        return AmityHttpClient.get(MessageReaderApi::class).flatMap {
            it.startSubChannelReading(subChannelId)
        }
    }
    
    fun readSubChannel(subChannelIds: List<String>): Single<SubChannelMarkingDto> {
        val request = ReadSubChannelRequest(subChannelIds)
        return AmityHttpClient.get(MessageReaderApi::class).flatMap {
            it.readSubChannel(request)
        }
    }
    
    fun stopSubChannelReading(subChannelId: String): Single<SubChannelMarkingDto> {
        return AmityHttpClient.get(MessageReaderApi::class).flatMap {
            it.stopSubChannelReading(subChannelId)
        }
    }
    
    fun markMessageDelivered(subChannelId: String, messageId: String): Single<SubChannelMarkingDto> {
        val request = MarkMessageDeliveredRequest(messageId)
        return AmityHttpClient.get(MessageReaderApi::class).flatMap {
            it.markMessageDelivered(subChannelId, request)
        }
    }
    
    fun markMessageRead(subChannelId: String,readToSegment: Int): Single<JsonObject> {
        val request = MarkMessageReadRequest(subChannelId, readToSegment)
        return AmityHttpClient.get(MessageReaderApi::class).flatMap {
            it.markMessageRead(subChannelId, request)
        }
    }

}