package com.amity.socialcloud.sdk.api.social.post.update

import com.amity.socialcloud.sdk.model.core.file.AmityFile
import com.amity.socialcloud.sdk.model.core.file.AmityImage
import com.amity.socialcloud.sdk.model.core.file.AmityVideo
import com.amity.socialcloud.sdk.model.social.post.AmityPost
import com.amity.socialcloud.sdk.model.social.post.AmityPostAttachment
import com.google.gson.JsonObject

class AmityTextPostUpdate internal constructor(
    postId: String,
    private val text: String?,
    metadata: JsonObject?,
    mentionees: List<String>?,
    attachments: List<AmityPostAttachment>?
) : AmityLegacyPostUpdate(postId, metadata, mentionees, attachments) {

    override fun getData(): JsonObject {
        val data = JsonObject()
        text?.let {
            data.addProperty("text", text)
        }
        return data
    }

    class Builder internal constructor(private val postId: String): AmityLegacyPostUpdate.Builder(postId) {

        private var text: String? = null
        private var metadata: JsonObject? = null
        private var mentionees: List<String>? = null
        private var attachments: List<AmityPostAttachment>? = null

        override fun text(text: String?): Builder {
            return apply {
                this.text = text
            }
        }

        override fun metadata(metadata: JsonObject): Builder {
            this.metadata = metadata
            return this
        }

        override fun mentionUsers(userIds: List<String>): Builder {
            this.mentionees = userIds
            return this
        }

        fun videoAttachments(attachments: List<AmityVideo>): Builder {
            this.attachments = attachments.map { AmityPostAttachment(it.getFileId(),  AmityPost.DataType.VIDEO.getApiKey()) }
            return this
        }

        fun imageAttachments(attachments: List<AmityImage>): Builder {
            this.attachments = attachments.map { AmityPostAttachment(it.getFileId(),  AmityPost.DataType.IMAGE.getApiKey()) }
            return this
        }

        fun fileAttachments(attachments: List<AmityFile>): Builder {
            this.attachments = attachments.map { AmityPostAttachment(it.getFileId(),  AmityPost.DataType.FILE.getApiKey()) }
            return this
        }

        override fun build(): AmityTextPostUpdate {
            return AmityTextPostUpdate(postId, text, metadata, mentionees, attachments)
        }
    }

}