/*
 * Decompiled with CFR 0.152.
 */
package com.ekoapp.ekosdk.internal.keycreator;

import com.amity.socialcloud.sdk.model.social.post.AmityPost;
import com.amity.socialcloud.sdk.social.data.post.PostRepositoryHelper;
import com.ekoapp.ekosdk.internal.keycreator.DynamicQueryStreamKeyCreator;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0010$\n\u0002\u0010\u0000\n\u0000\u0018\u00002\u00020\u0001B-\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u0012\b\u0010\u0005\u001a\u0004\u0018\u00010\u0006\u0012\f\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\t0\b\u00a2\u0006\u0002\u0010\nJ-\u0010\f\u001a\u00020\u00032\u0006\u0010\u0002\u001a\u00020\u00032\b\u0010\r\u001a\u0004\u0018\u00010\u00062\f\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\t0\bH\u0002\u00a2\u0006\u0002\u0010\u000eJ\b\u0010\u000f\u001a\u00020\u0003H\u0016J\u0014\u0010\u0010\u001a\u00020\u00032\f\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\t0\bJ\u0014\u0010\u0011\u001a\u000e\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u00130\u0012H\u0016R\u0012\u0010\u0005\u001a\u0004\u0018\u00010\u0006X\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\u000bR\u0014\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\t0\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0014"}, d2={"Lcom/ekoapp/ekosdk/internal/keycreator/UserPostKeyCreator;", "Lcom/ekoapp/ekosdk/internal/keycreator/DynamicQueryStreamKeyCreator;", "userId", "", "sortBy", "isDeleted", "", "postTypes", "", "Lcom/amity/socialcloud/sdk/model/social/post/AmityPost$DataType;", "(Ljava/lang/String;Ljava/lang/String;Ljava/lang/Boolean;Ljava/util/List;)V", "Ljava/lang/Boolean;", "getConditionStatement", "includeDeleted", "(Ljava/lang/String;Ljava/lang/Boolean;Ljava/util/List;)Ljava/lang/String;", "getFilterQuery", "getPostTypesAsArrayString", "toMap", "", "", "amity-sdk_release"})
public final class UserPostKeyCreator
implements DynamicQueryStreamKeyCreator {
    private final String userId;
    private final String sortBy;
    private final Boolean isDeleted;
    private final List<AmityPost.DataType> postTypes;

    @Override
    @NotNull
    public Map<String, Object> toMap() {
        Pair[] pairArray = new Pair[5];
        pairArray[0] = TuplesKt.to((Object)"targetId", (Object)this.userId);
        pairArray[1] = TuplesKt.to((Object)"targetType", (Object)AmityPost.TargetType.USER.getApiKey());
        pairArray[2] = TuplesKt.to((Object)"sortBy", (Object)this.sortBy);
        Boolean bl = this.isDeleted;
        pairArray[3] = TuplesKt.to((Object)"isDeleted", (Object)(bl != null ? bl : false));
        pairArray[4] = TuplesKt.to((Object)"postTypes", (Object)PostRepositoryHelper.INSTANCE.convertPostTypesToString(this.postTypes));
        return MapsKt.mapOf((Pair[])pairArray);
    }

    @Override
    @NotNull
    public String getFilterQuery() {
        return this.getConditionStatement(this.userId, this.isDeleted, this.postTypes);
    }

    private final String getConditionStatement(String userId, Boolean includeDeleted, List<? extends AmityPost.DataType> postTypes) {
        String userFilterStatement = "post.targetType = '" + AmityPost.TargetType.USER.getApiKey() + '\'' + " and post.targetId = '" + userId + '\'';
        String isDeletedFilterStatement = "";
        if (Intrinsics.areEqual((Object)includeDeleted, (Object)false)) {
            isDeletedFilterStatement = " and post.isDeleted = 0";
        } else if (Intrinsics.areEqual((Object)includeDeleted, (Object)true)) {
            isDeletedFilterStatement = " and post.isDeleted = 1";
        }
        String postTypesFilterStatement = "";
        Collection collection = postTypes;
        boolean bl = false;
        if (!collection.isEmpty()) {
            postTypesFilterStatement = " and post.postDataType IN (" + this.getPostTypesAsArrayString(postTypes) + ')';
        }
        Collection collection2 = postTypes;
        boolean bl2 = false;
        boolean bl3 = false;
        String parentPostFilter = collection2 == null || collection2.isEmpty() ? " and post.parentPostId is null" : " and post.targetId is not null";
        return userFilterStatement + isDeletedFilterStatement + postTypesFilterStatement + parentPostFilter;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final String getPostTypesAsArrayString(@NotNull List<? extends AmityPost.DataType> postTypes) {
        Intrinsics.checkNotNullParameter(postTypes, (String)"postTypes");
        StringBuilder typesString = new StringBuilder();
        Iterable $this$forEachIndexed$iv = postTypes;
        boolean $i$f$forEachIndexed = false;
        int index$iv = 0;
        for (Object item$iv : $this$forEachIndexed$iv) {
            void dataType;
            int n = index$iv++;
            boolean bl = false;
            if (n < 0) {
                CollectionsKt.throwIndexOverflow();
            }
            AmityPost.DataType dataType2 = (AmityPost.DataType)item$iv;
            int index = n;
            boolean bl2 = false;
            if (index == 0) {
                typesString.append('\'' + dataType.getApiKey() + '\'');
                continue;
            }
            typesString.append(", '" + dataType.getApiKey() + '\'');
        }
        String string = typesString.toString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"typesString.toString()");
        return string;
    }

    public UserPostKeyCreator(@NotNull String userId, @NotNull String sortBy, @Nullable Boolean isDeleted, @NotNull List<? extends AmityPost.DataType> postTypes) {
        Intrinsics.checkNotNullParameter((Object)userId, (String)"userId");
        Intrinsics.checkNotNullParameter((Object)sortBy, (String)"sortBy");
        Intrinsics.checkNotNullParameter(postTypes, (String)"postTypes");
        this.userId = userId;
        this.sortBy = sortBy;
        this.isDeleted = isDeleted;
        this.postTypes = postTypes;
    }

    @Override
    @Nullable
    public String optionalFilterQuery() {
        return DynamicQueryStreamKeyCreator.DefaultImpls.optionalFilterQuery(this);
    }
}

