/*
 * Decompiled with CFR 0.152.
 */
package com.ekoapp.ekosdk.internal.data.model;

import androidx.room.Entity;
import com.ekoapp.ekosdk.internal.data.model.EkoTagObject;
import com.ekoapp.ekosdk.internal.util.EkoPreconditions;
import com.google.common.base.MoreObjects;
import com.google.common.base.Objects;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0006\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0002\b\u0003\b\u0007\u0018\u0000 \u00102\u00020\u0001:\u0001\u0010B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0005J\u0013\u0010\t\u001a\u00020\n2\b\u0010\u000b\u001a\u0004\u0018\u00010\fH\u0096\u0002J\b\u0010\r\u001a\u00020\u000eH\u0016J\b\u0010\u000f\u001a\u00020\u0003H\u0016R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R\u0011\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\u0007\u00a8\u0006\u0011"}, d2={"Lcom/ekoapp/ekosdk/internal/data/model/EkoMessageTag;", "Lcom/ekoapp/ekosdk/internal/data/model/EkoTagObject;", "messageId", "", "tagName", "(Ljava/lang/String;Ljava/lang/String;)V", "getMessageId", "()Ljava/lang/String;", "getTagName", "equals", "", "obj", "", "hashCode", "", "toString", "Companion", "amity-sdk_release"})
@Entity(tableName="message_tag", primaryKeys={"messageId", "tagName"})
public final class EkoMessageTag
extends EkoTagObject {
    @NotNull
    private final String messageId;
    @NotNull
    private final String tagName;
    @NotNull
    private static final EkoTagObject.EkoTagFactory<EkoMessageTag> factory;
    @NotNull
    public static final Companion Companion;

    public boolean equals(@Nullable Object obj) {
        if (obj == null) {
            return false;
        }
        if (obj == this) {
            return true;
        }
        if (Intrinsics.areEqual(obj.getClass(), this.getClass()) ^ true) {
            return false;
        }
        EkoMessageTag other = (EkoMessageTag)obj;
        return Objects.equal((Object)this.messageId, (Object)other.messageId) && Objects.equal((Object)this.tagName, (Object)other.tagName);
    }

    public int hashCode() {
        return Objects.hashCode((Object[])new Object[]{this.messageId, this.tagName});
    }

    @NotNull
    public String toString() {
        String string = MoreObjects.toStringHelper((Object)this).add("messageId", (Object)this.messageId).add("tagName", (Object)this.tagName).toString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"MoreObjects.toStringHelp\u2026 tagName)\n\t\t\t\t.toString()");
        return string;
    }

    @NotNull
    public final String getMessageId() {
        return this.messageId;
    }

    @NotNull
    public final String getTagName() {
        return this.tagName;
    }

    public EkoMessageTag(@NotNull String messageId, @NotNull String tagName) {
        Intrinsics.checkNotNullParameter((Object)messageId, (String)"messageId");
        Intrinsics.checkNotNullParameter((Object)tagName, (String)"tagName");
        this.messageId = messageId;
        this.tagName = tagName;
    }

    static {
        Companion = new Companion(null);
        factory = new EkoTagObject.EkoTagFactory<EkoMessageTag>(){

            @NotNull
            public EkoMessageTag create(@NotNull String id, @NotNull String tag) {
                Intrinsics.checkNotNullParameter((Object)id, (String)"id");
                Intrinsics.checkNotNullParameter((Object)tag, (String)"tag");
                String messageId = EkoPreconditions.checkValidId(id, "messageId");
                String tagName = EkoPreconditions.checkValidId(tag, "tagName");
                String string = messageId;
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"messageId");
                String string2 = tagName;
                Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"tagName");
                return new EkoMessageTag(string, string2);
            }
        };
    }

    @Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u0017\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\b"}, d2={"Lcom/ekoapp/ekosdk/internal/data/model/EkoMessageTag$Companion;", "", "()V", "factory", "Lcom/ekoapp/ekosdk/internal/data/model/EkoTagObject$EkoTagFactory;", "Lcom/ekoapp/ekosdk/internal/data/model/EkoMessageTag;", "getFactory", "()Lcom/ekoapp/ekosdk/internal/data/model/EkoTagObject$EkoTagFactory;", "amity-sdk_release"})
    public static final class Companion {
        @NotNull
        public final EkoTagObject.EkoTagFactory<EkoMessageTag> getFactory() {
            return factory;
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

