/*
 * Decompiled with CFR 0.152.
 */
package com.amity.socialcloud.sdk.core.data.reaction;

import androidx.paging.PagingConfig;
import androidx.paging.PagingData;
import androidx.paging.PagingSource;
import co.amity.rxbridge.FlowableKt;
import com.amity.socialcloud.sdk.common.ModelMapper;
import com.amity.socialcloud.sdk.core.data.reaction.ReactionLocalDataStore;
import com.amity.socialcloud.sdk.core.data.reaction.ReactionModelMapper;
import com.amity.socialcloud.sdk.core.data.reaction.ReactionRemoteDataStore;
import com.amity.socialcloud.sdk.core.data.reaction.ReactionRepository;
import com.amity.socialcloud.sdk.core.data.reaction.paging.ReactionMediator;
import com.amity.socialcloud.sdk.core.data.session.SessionLocalDataStore;
import com.amity.socialcloud.sdk.model.core.reaction.AmityReaction;
import com.amity.socialcloud.sdk.model.core.reaction.AmityReactionReferenceType;
import com.ekoapp.ekosdk.EkoObjectRepository;
import com.ekoapp.ekosdk.internal.data.UserDatabase;
import com.ekoapp.ekosdk.internal.data.dao.EkoReactionDao;
import com.ekoapp.ekosdk.internal.data.model.EkoReactionEntity;
import com.ekoapp.ekosdk.internal.paging.DynamicQueryStreamPagerCreator;
import io.reactivex.rxjava3.core.Completable;
import io.reactivex.rxjava3.core.CompletableSource;
import io.reactivex.rxjava3.core.Flowable;
import io.reactivex.rxjava3.core.Maybe;
import io.reactivex.rxjava3.functions.Function;
import io.reactivex.rxjava3.schedulers.Schedulers;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.concurrent.Callable;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Ref;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, d1={"\u0000J\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0000\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u001e\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\bJ\u001e\u0010\n\u001a\u00020\u000b2\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\bJ\b\u0010\f\u001a\u00020\rH\u0002J&\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u00100\u000f2\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\b\u0010\t\u001a\u0004\u0018\u00010\bJ&\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\u000b0\u00122\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\bH\u0002J\u001c\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\b0\u00142\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bJ,\u0010\u0015\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00100\u00160\u000f2\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\b\u0010\t\u001a\u0004\u0018\u00010\bJ\u001e\u0010\u0017\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\b\u00a8\u0006\u0018"}, d2={"Lcom/amity/socialcloud/sdk/core/data/reaction/ReactionRepository;", "Lcom/ekoapp/ekosdk/EkoObjectRepository;", "()V", "addReaction", "Lio/reactivex/rxjava3/core/Completable;", "referenceType", "Lcom/amity/socialcloud/sdk/model/core/reaction/AmityReactionReferenceType;", "referenceId", "", "reactionName", "createMyReaction", "Lcom/ekoapp/ekosdk/internal/data/model/EkoReactionEntity;", "getDefaultPageSize", "", "getLatestReaction", "Lio/reactivex/rxjava3/core/Flowable;", "Lcom/amity/socialcloud/sdk/model/core/reaction/AmityReaction;", "getMyReaction", "Lio/reactivex/rxjava3/core/Maybe;", "getMyReactions", "", "getReactionPagingData", "Landroidx/paging/PagingData;", "removeReaction", "amity-sdk_release"})
public final class ReactionRepository
extends EkoObjectRepository {
    private final int getDefaultPageSize() {
        return 15;
    }

    @NotNull
    public final Flowable<PagingData<AmityReaction>> getReactionPagingData(@NotNull AmityReactionReferenceType referenceType, @NotNull String referenceId, @Nullable String reactionName) {
        Intrinsics.checkNotNullParameter((Object)((Object)referenceType), (String)"referenceType");
        Intrinsics.checkNotNullParameter((Object)referenceId, (String)"referenceId");
        DynamicQueryStreamPagerCreator pagerCreator2 = new DynamicQueryStreamPagerCreator(new PagingConfig(this.getDefaultPageSize(), 0, false, 0, 0, 0, 58, null), null, new ReactionMediator(referenceType, referenceId, reactionName), (Function0)new Function0<PagingSource<Integer, EkoReactionEntity>>(referenceType, referenceId, reactionName){
            final /* synthetic */ AmityReactionReferenceType $referenceType;
            final /* synthetic */ String $referenceId;
            final /* synthetic */ String $reactionName;

            @NotNull
            public final PagingSource<Integer, EkoReactionEntity> invoke() {
                return new ReactionLocalDataStore().getReactionsPagingSource(this.$referenceType, this.$referenceId, this.$reactionName);
            }
            {
                this.$referenceType = amityReactionReferenceType;
                this.$referenceId = string;
                this.$reactionName = string2;
                super(0);
            }
        }, (ModelMapper)new ReactionModelMapper(), 2, null);
        return FlowableKt.toRx3(pagerCreator2.create());
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final List<String> getMyReactions(@NotNull AmityReactionReferenceType referenceType, @NotNull String referenceId) {
        void list2;
        Intrinsics.checkNotNullParameter((Object)((Object)referenceType), (String)"referenceType");
        Intrinsics.checkNotNullParameter((Object)referenceId, (String)"referenceId");
        Ref.ObjectRef objectRef = new Ref.ObjectRef();
        objectRef.element = CollectionsKt.emptyList();
        Completable.fromCallable((Callable)new Callable<Object>(referenceType, referenceId, (Ref.ObjectRef)list2){
            final /* synthetic */ AmityReactionReferenceType $referenceType;
            final /* synthetic */ String $referenceId;
            final /* synthetic */ Ref.ObjectRef $list;

            /*
             * WARNING - void declaration
             */
            public final void call() {
                List<EkoReactionEntity> entities;
                EkoReactionDao reactionDao = UserDatabase.get().reactionDao();
                List<EkoReactionEntity> list2 = entities = reactionDao.getAllMyReactionsByReferenceTypeAndReferenceIdNow(this.$referenceType.getValue(), this.$referenceId);
                Intrinsics.checkNotNullExpressionValue(list2, (String)"entities");
                Iterable<E> iterable = list2;
                boolean bl = false;
                if (!iterable.isEmpty()) {
                    Collection<String> collection;
                    void $this$mapTo$iv$iv;
                    void $this$map$iv;
                    iterable = entities;
                    Ref.ObjectRef objectRef = this.$list;
                    boolean $i$f$map = false;
                    void var5_6 = $this$map$iv;
                    Collection destination$iv$iv = new ArrayList<E>(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
                    boolean $i$f$mapTo = false;
                    for (T item$iv$iv : $this$mapTo$iv$iv) {
                        void it;
                        EkoReactionEntity ekoReactionEntity = (EkoReactionEntity)item$iv$iv;
                        collection = destination$iv$iv;
                        boolean bl2 = false;
                        void v1 = it;
                        Intrinsics.checkNotNullExpressionValue((Object)v1, (String)"it");
                        String string = v1.getReactionName();
                        collection.add(string);
                    }
                    collection = (List)destination$iv$iv;
                    objectRef.element = collection;
                }
            }
            {
                this.$referenceType = amityReactionReferenceType;
                this.$referenceId = string;
                this.$list = objectRef;
            }
        }).subscribeOn(Schedulers.io()).blockingAwait();
        return (List)list2.element;
    }

    @NotNull
    public final Flowable<AmityReaction> getLatestReaction(@NotNull AmityReactionReferenceType referenceType, @NotNull String referenceId, @Nullable String reactionName) {
        Intrinsics.checkNotNullParameter((Object)((Object)referenceType), (String)"referenceType");
        Intrinsics.checkNotNullParameter((Object)referenceId, (String)"referenceId");
        Flowable flowable = new ReactionLocalDataStore().getLatestReaction(referenceType, referenceId, reactionName).map((Function)getLatestReaction.1.INSTANCE);
        Intrinsics.checkNotNullExpressionValue((Object)flowable, (String)"ReactionLocalDataStore()\u2026apper().map(it)\n        }");
        return flowable;
    }

    @NotNull
    public final Completable addReaction(@NotNull AmityReactionReferenceType referenceType, @NotNull String referenceId, @NotNull String reactionName) {
        Intrinsics.checkNotNullParameter((Object)((Object)referenceType), (String)"referenceType");
        Intrinsics.checkNotNullParameter((Object)referenceId, (String)"referenceId");
        Intrinsics.checkNotNullParameter((Object)reactionName, (String)"reactionName");
        Maybe maybe = this.getMyReaction(referenceType, referenceId, reactionName).subscribeOn(Schedulers.io());
        Intrinsics.checkNotNullExpressionValue((Object)maybe, (String)"getMyReaction(referenceT\u2026scribeOn(Schedulers.io())");
        Completable completable = maybe.isEmpty().flatMapCompletable((Function)new Function<Boolean, CompletableSource>(this, referenceType, referenceId, reactionName){
            final /* synthetic */ ReactionRepository this$0;
            final /* synthetic */ AmityReactionReferenceType $referenceType;
            final /* synthetic */ String $referenceId;
            final /* synthetic */ String $reactionName;

            public final CompletableSource apply(boolean isEmpty) {
                CompletableSource completableSource;
                if (isEmpty) {
                    EkoReactionEntity reaction = this.this$0.createMyReaction(this.$referenceType, this.$referenceId, this.$reactionName);
                    completableSource = (CompletableSource)new ReactionLocalDataStore().addReaction(reaction).concatWith((CompletableSource)new ReactionRemoteDataStore().addReaction(this.$referenceType, this.$referenceId, this.$reactionName).ignoreElement().onErrorResumeNext((Function)new Function<Throwable, CompletableSource>(reaction){
                        final /* synthetic */ EkoReactionEntity $reaction;

                        public final CompletableSource apply(Throwable it) {
                            return (CompletableSource)new ReactionLocalDataStore().removeReaction(this.$reaction);
                        }
                        {
                            this.$reaction = ekoReactionEntity;
                        }
                    }));
                } else {
                    completableSource = (CompletableSource)Completable.complete();
                }
                return completableSource;
            }
            {
                this.this$0 = reactionRepository;
                this.$referenceType = amityReactionReferenceType;
                this.$referenceId = string;
                this.$reactionName = string2;
            }
        });
        Intrinsics.checkNotNullExpressionValue((Object)completable, (String)"getMyReaction(referenceT\u2026          }\n            }");
        return completable;
    }

    @NotNull
    public final Completable removeReaction(@NotNull AmityReactionReferenceType referenceType, @NotNull String referenceId, @NotNull String reactionName) {
        Intrinsics.checkNotNullParameter((Object)((Object)referenceType), (String)"referenceType");
        Intrinsics.checkNotNullParameter((Object)referenceId, (String)"referenceId");
        Intrinsics.checkNotNullParameter((Object)reactionName, (String)"reactionName");
        Completable completable = this.getMyReaction(referenceType, referenceId, reactionName).subscribeOn(Schedulers.io()).flatMapCompletable((Function)new Function<EkoReactionEntity, CompletableSource>(referenceType, referenceId, reactionName){
            final /* synthetic */ AmityReactionReferenceType $referenceType;
            final /* synthetic */ String $referenceId;
            final /* synthetic */ String $reactionName;

            public final CompletableSource apply(@NotNull EkoReactionEntity removingReaction) {
                Intrinsics.checkNotNullParameter((Object)removingReaction, (String)"removingReaction");
                return (CompletableSource)new ReactionLocalDataStore().removeReaction(removingReaction).concatWith((CompletableSource)new ReactionRemoteDataStore().removeReaction(this.$referenceType, this.$referenceId, this.$reactionName).ignoreElement().onErrorResumeNext((Function)new Function<Throwable, CompletableSource>(removingReaction){
                    final /* synthetic */ EkoReactionEntity $removingReaction;

                    public final CompletableSource apply(Throwable it) {
                        return (CompletableSource)new ReactionLocalDataStore().addReaction(this.$removingReaction);
                    }
                    {
                        this.$removingReaction = ekoReactionEntity;
                    }
                }));
            }
            {
                this.$referenceType = amityReactionReferenceType;
                this.$referenceId = string;
                this.$reactionName = string2;
            }
        });
        Intrinsics.checkNotNullExpressionValue((Object)completable, (String)"getMyReaction(referenceT\u2026          )\n            }");
        return completable;
    }

    private final Maybe<EkoReactionEntity> getMyReaction(AmityReactionReferenceType referenceType, String referenceId, String reactionName) {
        return new ReactionLocalDataStore().getReaction(referenceType, referenceId, reactionName, new SessionLocalDataStore().getActiveUserId());
    }

    @NotNull
    public final EkoReactionEntity createMyReaction(@NotNull AmityReactionReferenceType referenceType, @NotNull String referenceId, @NotNull String reactionName) {
        Intrinsics.checkNotNullParameter((Object)((Object)referenceType), (String)"referenceType");
        Intrinsics.checkNotNullParameter((Object)referenceId, (String)"referenceId");
        Intrinsics.checkNotNullParameter((Object)reactionName, (String)"reactionName");
        return new ReactionLocalDataStore().createReaction(referenceType, referenceId, reactionName, new SessionLocalDataStore().getActiveUserId());
    }
}

