/*
 * Decompiled with CFR 0.152.
 */
package com.amity.socialcloud.sdk.chat.data.message;

import android.net.Uri;
import androidx.paging.PagingConfig;
import androidx.paging.PagingData;
import androidx.paging.PagingSource;
import co.amity.rxbridge.FlowableKt;
import com.amity.socialcloud.sdk.api.chat.message.query.AmityMessageQuerySortOption;
import com.amity.socialcloud.sdk.chat.data.message.MessageLocalDataStore;
import com.amity.socialcloud.sdk.chat.data.message.MessageModelMapper;
import com.amity.socialcloud.sdk.chat.data.message.MessageQueryPersister;
import com.amity.socialcloud.sdk.chat.data.message.MessageRemoteDataStore;
import com.amity.socialcloud.sdk.chat.data.message.MessageRepository;
import com.amity.socialcloud.sdk.chat.data.message.MessageRepository$WhenMappings;
import com.amity.socialcloud.sdk.chat.data.message.flag.MessageFlagLocalDataStore;
import com.amity.socialcloud.sdk.chat.data.message.flag.MessageFlagRemoteDataStore;
import com.amity.socialcloud.sdk.chat.data.message.paging.MessageMediator;
import com.amity.socialcloud.sdk.common.ModelMapper;
import com.amity.socialcloud.sdk.core.data.file.FileLocalDataStore;
import com.amity.socialcloud.sdk.core.data.file.FileRepository;
import com.amity.socialcloud.sdk.model.chat.message.AmityMessage;
import com.amity.socialcloud.sdk.model.core.content.AmityContentFeedType;
import com.amity.socialcloud.sdk.model.core.error.AmityError;
import com.amity.socialcloud.sdk.model.core.error.AmityException;
import com.amity.socialcloud.sdk.model.core.file.AmityAudio;
import com.amity.socialcloud.sdk.model.core.file.AmityFile;
import com.amity.socialcloud.sdk.model.core.file.AmityFileInfo;
import com.amity.socialcloud.sdk.model.core.file.AmityImage;
import com.amity.socialcloud.sdk.model.core.file.AmityVideo;
import com.amity.socialcloud.sdk.model.core.file.upload.AmityUploadResult;
import com.amity.socialcloud.sdk.model.core.mention.AmityMentioneeTarget;
import com.amity.socialcloud.sdk.model.core.tag.AmityTags;
import com.ekoapp.ekosdk.AmityObjectRepository;
import com.ekoapp.ekosdk.internal.EkoMessageEntity;
import com.ekoapp.ekosdk.internal.api.dto.MessageQueryDto;
import com.ekoapp.ekosdk.internal.keycreator.DynamicQueryStreamKeyCreator;
import com.ekoapp.ekosdk.internal.paging.DynamicQueryStreamPagerCreator;
import com.ekoapp.ekosdk.internal.repository.comment.CommentLoadResult;
import com.google.gson.JsonObject;
import io.reactivex.rxjava3.core.Completable;
import io.reactivex.rxjava3.core.CompletableSource;
import io.reactivex.rxjava3.core.Flowable;
import io.reactivex.rxjava3.core.Single;
import io.reactivex.rxjava3.core.SingleSource;
import io.reactivex.rxjava3.functions.Function;
import java.util.List;
import java.util.concurrent.Callable;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, d1={"\u0000\u0096\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\f\b\u0000\u0018\u0000 H2\u000e\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u00030\u0001:\u0001HB\u0005\u00a2\u0006\u0002\u0010\u0004JR\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\b\u0010\t\u001a\u0004\u0018\u00010\b2\b\u0010\n\u001a\u0004\u0018\u00010\u000b2\u0006\u0010\f\u001a\u00020\b2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u00102\b\u0010\u0011\u001a\u0004\u0018\u00010\u000e2\f\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\u00140\u0013J\\\u0010\u0015\u001a\b\u0012\u0004\u0012\u00020\u00020\u00162\u0006\u0010\u0007\u001a\u00020\b2\b\u0010\t\u001a\u0004\u0018\u00010\b2\u0006\u0010\f\u001a\u00020\b2\b\u0010\r\u001a\u0004\u0018\u00010\u000e2\u0006\u0010\u000f\u001a\u00020\u00102\b\u0010\n\u001a\u0004\u0018\u00010\u000b2\b\u0010\u0011\u001a\u0004\u0018\u00010\u000e2\f\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\u00140\u0013H\u0002J\u000e\u0010\u0017\u001a\u00020\u00062\u0006\u0010\u0018\u001a\u00020\bJ\u0010\u0010\u0019\u001a\u00020\u00062\u0006\u0010\u001a\u001a\u00020\bH\u0016J\u000e\u0010\u001b\u001a\u00020\u00062\u0006\u0010\u0018\u001a\u00020\bJ\b\u0010\u001c\u001a\u00020\u001dH\u0002J_\u0010\u001e\u001a\b\u0012\u0004\u0012\u00020\u00030\u001f2\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010 \u001a\u00020!2\b\u0010\t\u001a\u0004\u0018\u00010\b2\u0006\u0010\"\u001a\u00020\u00102\u0006\u0010#\u001a\u00020\u00102\b\u0010$\u001a\u0004\u0018\u00010!2\b\u0010\f\u001a\u0004\u0018\u00010\b2\u0006\u0010%\u001a\u00020&2\u0006\u0010'\u001a\u00020\u001d\u00a2\u0006\u0002\u0010(J]\u0010)\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00030*0\u001f2\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010 \u001a\u00020!2\b\u0010\t\u001a\u0004\u0018\u00010\b2\u0006\u0010\"\u001a\u00020\u00102\u0006\u0010#\u001a\u00020\u00102\b\u0010$\u001a\u0004\u0018\u00010!2\u0006\u0010+\u001a\u00020,2\b\u0010\f\u001a\u0004\u0018\u00010-\u00a2\u0006\u0002\u0010.Jj\u0010/\u001a\u00020\u0006\"\b\b\u0000\u00100*\u0002012\u0006\u0010\u0018\u001a\u00020\b2\u0006\u0010\u0007\u001a\u00020\b2\b\u0010\t\u001a\u0004\u0018\u00010\b2\u0006\u0010\f\u001a\u00020\b2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u00102\b\u0010\u0011\u001a\u0004\u0018\u00010\u000e2\f\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\u00140\u00132\f\u00102\u001a\b\u0012\u0004\u0012\u0002H003H\u0002J\u0014\u00104\u001a\b\u0012\u0004\u0012\u00020!0\u00162\u0006\u0010\u0018\u001a\u00020\bJ_\u00105\u001a\b\u0012\u0004\u0012\u0002060\u00162\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010+\u001a\u00020,2\b\u0010\t\u001a\u0004\u0018\u00010\b2\u0006\u0010 \u001a\u00020!2\b\u0010$\u001a\u0004\u0018\u00010!2\u0006\u0010\"\u001a\u00020\u00102\u0006\u0010#\u001a\u00020\u00102\b\u0010\f\u001a\u0004\u0018\u00010\b2\u0006\u00107\u001a\u00020\u001d\u00a2\u0006\u0002\u00108J_\u00109\u001a\b\u0012\u0004\u0012\u0002060\u00162\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010+\u001a\u00020,2\b\u0010\t\u001a\u0004\u0018\u00010\b2\u0006\u0010 \u001a\u00020!2\b\u0010$\u001a\u0004\u0018\u00010!2\u0006\u0010\"\u001a\u00020\u00102\u0006\u0010#\u001a\u00020\u00102\b\u0010\f\u001a\u0004\u0018\u00010\b2\u0006\u0010:\u001a\u00020\b\u00a2\u0006\u0002\u0010;J\u0014\u0010<\u001a\u000e\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u00030=H\u0016J\u0016\u0010>\u001a\b\u0012\u0004\u0012\u00020\u00020\u001f2\u0006\u0010\u001a\u001a\u00020\bH\u0016J#\u0010?\u001a\b\u0012\u0004\u0012\u00020\u00030\u001f2\u0006\u0010\u0007\u001a\u00020\b2\b\u0010$\u001a\u0004\u0018\u00010!\u00a2\u0006\u0002\u0010@J]\u0010A\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00030\u00130\u001f2\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010 \u001a\u00020!2\b\u0010\t\u001a\u0004\u0018\u00010\b2\u0006\u0010\"\u001a\u00020\u00102\u0006\u0010#\u001a\u00020\u00102\b\u0010$\u001a\u0004\u0018\u00010!2\b\u0010\f\u001a\u0004\u0018\u00010\b2\u0006\u0010+\u001a\u00020,\u00a2\u0006\u0002\u0010BJ\u0012\u0010C\u001a\u0004\u0018\u00010\u00022\u0006\u0010\u001a\u001a\u00020\bH\u0016J^\u0010D\u001a\u00020\u00062\u0006\u0010\u0018\u001a\u00020\b2\u0006\u0010\u0007\u001a\u00020\b2\b\u0010\t\u001a\u0004\u0018\u00010\b2\u0006\u0010\f\u001a\u00020\b2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u00102\n\b\u0002\u0010E\u001a\u0004\u0018\u00010\b2\b\u0010\u0011\u001a\u0004\u0018\u00010\u000e2\f\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\u00140\u0013H\u0002J\u000e\u0010F\u001a\u00020\u00062\u0006\u0010\u0018\u001a\u00020\bJ<\u0010G\u001a\u00020\u00062\u0006\u0010\u0018\u001a\u00020\b2\b\u0010\r\u001a\u0004\u0018\u00010\u000e2\b\u0010\u000f\u001a\u0004\u0018\u00010\u00102\b\u0010\u0011\u001a\u0004\u0018\u00010\u000e2\u000e\u0010\u0012\u001a\n\u0012\u0004\u0012\u00020\u0014\u0018\u00010\u0013\u00a8\u0006I"}, d2={"Lcom/amity/socialcloud/sdk/chat/data/message/MessageRepository;", "Lcom/ekoapp/ekosdk/AmityObjectRepository;", "Lcom/ekoapp/ekosdk/internal/EkoMessageEntity;", "Lcom/amity/socialcloud/sdk/model/chat/message/AmityMessage;", "()V", "createMessage", "Lio/reactivex/rxjava3/core/Completable;", "subChannelId", "", "parentId", "fileUri", "Landroid/net/Uri;", "type", "data", "Lcom/google/gson/JsonObject;", "tags", "Lcom/amity/socialcloud/sdk/model/core/tag/AmityTags;", "metadata", "mentionees", "", "Lcom/amity/socialcloud/sdk/model/core/mention/AmityMentioneeTarget;", "createPreviewMessage", "Lio/reactivex/rxjava3/core/Single;", "deleteMessage", "messageId", "fetchAndSave", "objectId", "flagMessage", "getDefaultPageSize", "", "getLatestMessage", "Lio/reactivex/rxjava3/core/Flowable;", "isFilterByParentId", "", "includingTags", "excludingTags", "isDeleted", "dynamicQueryStreamKeyCreator", "Lcom/ekoapp/ekosdk/internal/keycreator/DynamicQueryStreamKeyCreator;", "nonce", "(Ljava/lang/String;ZLjava/lang/String;Lcom/amity/socialcloud/sdk/model/core/tag/AmityTags;Lcom/amity/socialcloud/sdk/model/core/tag/AmityTags;Ljava/lang/Boolean;Ljava/lang/String;Lcom/ekoapp/ekosdk/internal/keycreator/DynamicQueryStreamKeyCreator;I)Lio/reactivex/rxjava3/core/Flowable;", "getMessagePagingData", "Landroidx/paging/PagingData;", "sortOption", "Lcom/amity/socialcloud/sdk/api/chat/message/query/AmityMessageQuerySortOption;", "Lcom/amity/socialcloud/sdk/model/chat/message/AmityMessage$DataType;", "(Ljava/lang/String;ZLjava/lang/String;Lcom/amity/socialcloud/sdk/model/core/tag/AmityTags;Lcom/amity/socialcloud/sdk/model/core/tag/AmityTags;Ljava/lang/Boolean;Lcom/amity/socialcloud/sdk/api/chat/message/query/AmityMessageQuerySortOption;Lcom/amity/socialcloud/sdk/model/chat/message/AmityMessage$DataType;)Lio/reactivex/rxjava3/core/Flowable;", "handleUploadResult", "T", "Lcom/amity/socialcloud/sdk/model/core/file/AmityFileInfo;", "uploadResult", "Lcom/amity/socialcloud/sdk/model/core/file/upload/AmityUploadResult;", "isFlaggedByMe", "loadFirstPageMessages", "Lcom/ekoapp/ekosdk/internal/repository/comment/CommentLoadResult;", "limit", "(Ljava/lang/String;Lcom/amity/socialcloud/sdk/api/chat/message/query/AmityMessageQuerySortOption;Ljava/lang/String;ZLjava/lang/Boolean;Lcom/amity/socialcloud/sdk/model/core/tag/AmityTags;Lcom/amity/socialcloud/sdk/model/core/tag/AmityTags;Ljava/lang/String;I)Lio/reactivex/rxjava3/core/Single;", "loadMessages", "token", "(Ljava/lang/String;Lcom/amity/socialcloud/sdk/api/chat/message/query/AmityMessageQuerySortOption;Ljava/lang/String;ZLjava/lang/Boolean;Lcom/amity/socialcloud/sdk/model/core/tag/AmityTags;Lcom/amity/socialcloud/sdk/model/core/tag/AmityTags;Ljava/lang/String;Ljava/lang/String;)Lio/reactivex/rxjava3/core/Single;", "mapper", "Lcom/amity/socialcloud/sdk/common/ModelMapper;", "observeFromCache", "observeLatestMessage", "(Ljava/lang/String;Ljava/lang/Boolean;)Lio/reactivex/rxjava3/core/Flowable;", "observeMessages", "(Ljava/lang/String;ZLjava/lang/String;Lcom/amity/socialcloud/sdk/model/core/tag/AmityTags;Lcom/amity/socialcloud/sdk/model/core/tag/AmityTags;Ljava/lang/Boolean;Ljava/lang/String;Lcom/amity/socialcloud/sdk/api/chat/message/query/AmityMessageQuerySortOption;)Lio/reactivex/rxjava3/core/Flowable;", "queryFromCache", "syncMessage", "fileId", "unflagMessage", "updateMessage", "Companion", "amity-sdk_release"})
public final class MessageRepository
extends AmityObjectRepository<EkoMessageEntity, AmityMessage> {
    private static final List<AmityMessage.DataType> fileUploadingTypes;
    @NotNull
    public static final Companion Companion;

    @Override
    @NotNull
    public Completable fetchAndSave(@NotNull String objectId) {
        Intrinsics.checkNotNullParameter((Object)objectId, (String)"objectId");
        Completable completable = new MessageRemoteDataStore().getMessage(objectId).flatMapCompletable((Function)fetchAndSave.1.INSTANCE);
        Intrinsics.checkNotNullExpressionValue((Object)completable, (String)"MessageRemoteDataStore()\u2026persist(it)\n            }");
        return completable;
    }

    @Override
    @Nullable
    public EkoMessageEntity queryFromCache(@NotNull String objectId) {
        Intrinsics.checkNotNullParameter((Object)objectId, (String)"objectId");
        EkoMessageEntity message = new MessageLocalDataStore().getMessage(objectId);
        if (message != null && AmityMessage.State.Companion.enumOf(message.getSyncState()) != AmityMessage.State.SYNCED) {
            throw (Throwable)AmityException.Companion.create("Observing unsynced object is not supported by Live Object.", null, AmityError.UNSUPPORTED);
        }
        return message;
    }

    @Override
    @NotNull
    public ModelMapper<EkoMessageEntity, AmityMessage> mapper() {
        return new MessageModelMapper();
    }

    @Override
    @NotNull
    public Flowable<EkoMessageEntity> observeFromCache(@NotNull String objectId) {
        Intrinsics.checkNotNullParameter((Object)objectId, (String)"objectId");
        return new MessageLocalDataStore().observeMessage(objectId);
    }

    private final int getDefaultPageSize() {
        return 15;
    }

    @NotNull
    public final Completable createMessage(@NotNull String subChannelId, @Nullable String parentId, @Nullable Uri fileUri, @NotNull String type, @NotNull JsonObject data, @NotNull AmityTags tags, @Nullable JsonObject metadata, @NotNull List<AmityMentioneeTarget> mentionees) {
        Intrinsics.checkNotNullParameter((Object)subChannelId, (String)"subChannelId");
        Intrinsics.checkNotNullParameter((Object)type, (String)"type");
        Intrinsics.checkNotNullParameter((Object)data, (String)"data");
        Intrinsics.checkNotNullParameter((Object)tags, (String)"tags");
        Intrinsics.checkNotNullParameter(mentionees, (String)"mentionees");
        List<AmityMentioneeTarget> list2 = mentionees;
        JsonObject jsonObject = metadata;
        AmityTags amityTags = tags;
        JsonObject jsonObject2 = data;
        Uri uri = fileUri;
        Completable completable = this.createPreviewMessage(subChannelId, parentId, type, jsonObject2, amityTags, uri, jsonObject, list2).flatMapCompletable((Function)new Function<EkoMessageEntity, CompletableSource>(this, type, subChannelId, parentId, data, tags, metadata, mentionees, fileUri){
            final /* synthetic */ MessageRepository this$0;
            final /* synthetic */ String $type;
            final /* synthetic */ String $subChannelId;
            final /* synthetic */ String $parentId;
            final /* synthetic */ JsonObject $data;
            final /* synthetic */ AmityTags $tags;
            final /* synthetic */ JsonObject $metadata;
            final /* synthetic */ List $mentionees;
            final /* synthetic */ Uri $fileUri;

            public final CompletableSource apply(EkoMessageEntity it) {
                CompletableSource completableSource;
                String messageId = it.getMessageId();
                AmityMessage.DataType dataType = AmityMessage.DataType.Companion.enumOf(this.$type);
                boolean hasUploadState = MessageRepository.access$getFileUploadingTypes$cp().contains((Object)((Object)dataType));
                if (!hasUploadState) {
                    completableSource = (CompletableSource)MessageRepository.syncMessage$default(this.this$0, messageId, this.$subChannelId, this.$parentId, this.$type, this.$data, this.$tags, null, this.$metadata, this.$mentionees, 64, null);
                } else {
                    Completable completable;
                    Completable completable2 = new MessageLocalDataStore().updateMessageState(messageId, AmityMessage.State.UPLOADING);
                    switch (MessageRepository$WhenMappings.$EnumSwitchMapping$0[dataType.ordinal()]) {
                        case 1: {
                            FileRepository fileRepository = new FileRepository();
                            Uri uri = this.$fileUri;
                            Intrinsics.checkNotNull((Object)uri);
                            completable = fileRepository.uploadImage(messageId, uri).flatMapCompletable((Function)new Function<AmityUploadResult<? extends AmityImage>, CompletableSource>(this, messageId){
                                final /* synthetic */ createMessage.1 this$0;
                                final /* synthetic */ String $messageId;

                                public final CompletableSource apply(AmityUploadResult<AmityImage> it) {
                                    MessageRepository messageRepository = this.this$0.this$0;
                                    String string = this.this$0.$subChannelId;
                                    String string2 = this.this$0.$parentId;
                                    String string3 = this.this$0.$type;
                                    JsonObject jsonObject = this.this$0.$data;
                                    AmityTags amityTags = this.this$0.$tags;
                                    JsonObject jsonObject2 = this.this$0.$metadata;
                                    List list2 = this.this$0.$mentionees;
                                    AmityUploadResult<AmityImage> amityUploadResult = it;
                                    Intrinsics.checkNotNullExpressionValue(amityUploadResult, (String)"it");
                                    return (CompletableSource)MessageRepository.access$handleUploadResult(messageRepository, this.$messageId, string, string2, string3, jsonObject, amityTags, jsonObject2, list2, amityUploadResult);
                                }
                                {
                                    this.this$0 = var1_1;
                                    this.$messageId = string;
                                }
                            });
                            break;
                        }
                        case 2: {
                            FileRepository fileRepository = new FileRepository();
                            Uri uri = this.$fileUri;
                            Intrinsics.checkNotNull((Object)uri);
                            completable = fileRepository.uploadFile(messageId, uri).flatMapCompletable((Function)new Function<AmityUploadResult<? extends AmityFile>, CompletableSource>(this, messageId){
                                final /* synthetic */ createMessage.1 this$0;
                                final /* synthetic */ String $messageId;

                                public final CompletableSource apply(AmityUploadResult<AmityFile> it) {
                                    MessageRepository messageRepository = this.this$0.this$0;
                                    String string = this.this$0.$subChannelId;
                                    String string2 = this.this$0.$parentId;
                                    String string3 = this.this$0.$type;
                                    JsonObject jsonObject = this.this$0.$data;
                                    AmityTags amityTags = this.this$0.$tags;
                                    JsonObject jsonObject2 = this.this$0.$metadata;
                                    List list2 = this.this$0.$mentionees;
                                    AmityUploadResult<AmityFile> amityUploadResult = it;
                                    Intrinsics.checkNotNullExpressionValue(amityUploadResult, (String)"it");
                                    return (CompletableSource)MessageRepository.access$handleUploadResult(messageRepository, this.$messageId, string, string2, string3, jsonObject, amityTags, jsonObject2, list2, amityUploadResult);
                                }
                                {
                                    this.this$0 = var1_1;
                                    this.$messageId = string;
                                }
                            });
                            break;
                        }
                        case 3: {
                            FileRepository fileRepository = new FileRepository();
                            Uri uri = this.$fileUri;
                            Intrinsics.checkNotNull((Object)uri);
                            completable = fileRepository.uploadAudio(messageId, uri).flatMapCompletable((Function)new Function<AmityUploadResult<? extends AmityAudio>, CompletableSource>(this, messageId){
                                final /* synthetic */ createMessage.1 this$0;
                                final /* synthetic */ String $messageId;

                                public final CompletableSource apply(AmityUploadResult<AmityAudio> it) {
                                    MessageRepository messageRepository = this.this$0.this$0;
                                    String string = this.this$0.$subChannelId;
                                    String string2 = this.this$0.$parentId;
                                    String string3 = this.this$0.$type;
                                    JsonObject jsonObject = this.this$0.$data;
                                    AmityTags amityTags = this.this$0.$tags;
                                    JsonObject jsonObject2 = this.this$0.$metadata;
                                    List list2 = this.this$0.$mentionees;
                                    AmityUploadResult<AmityAudio> amityUploadResult = it;
                                    Intrinsics.checkNotNullExpressionValue(amityUploadResult, (String)"it");
                                    return (CompletableSource)MessageRepository.access$handleUploadResult(messageRepository, this.$messageId, string, string2, string3, jsonObject, amityTags, jsonObject2, list2, amityUploadResult);
                                }
                                {
                                    this.this$0 = var1_1;
                                    this.$messageId = string;
                                }
                            });
                            break;
                        }
                        case 4: {
                            FileRepository fileRepository = new FileRepository();
                            Uri uri = this.$fileUri;
                            Intrinsics.checkNotNull((Object)uri);
                            completable = fileRepository.uploadVideo(messageId, uri, AmityContentFeedType.MESSAGE).flatMapCompletable((Function)new Function<AmityUploadResult<? extends AmityVideo>, CompletableSource>(this, messageId){
                                final /* synthetic */ createMessage.1 this$0;
                                final /* synthetic */ String $messageId;

                                public final CompletableSource apply(AmityUploadResult<AmityVideo> it) {
                                    MessageRepository messageRepository = this.this$0.this$0;
                                    String string = this.this$0.$subChannelId;
                                    String string2 = this.this$0.$parentId;
                                    String string3 = this.this$0.$type;
                                    JsonObject jsonObject = this.this$0.$data;
                                    AmityTags amityTags = this.this$0.$tags;
                                    JsonObject jsonObject2 = this.this$0.$metadata;
                                    List list2 = this.this$0.$mentionees;
                                    AmityUploadResult<AmityVideo> amityUploadResult = it;
                                    Intrinsics.checkNotNullExpressionValue(amityUploadResult, (String)"it");
                                    return (CompletableSource)MessageRepository.access$handleUploadResult(messageRepository, this.$messageId, string, string2, string3, jsonObject, amityTags, jsonObject2, list2, amityUploadResult);
                                }
                                {
                                    this.this$0 = var1_1;
                                    this.$messageId = string;
                                }
                            });
                            break;
                        }
                        default: {
                            completable = Completable.complete();
                        }
                    }
                    completableSource = (CompletableSource)completable2.andThen((CompletableSource)completable);
                }
                return completableSource;
            }
            {
                this.this$0 = messageRepository;
                this.$type = string;
                this.$subChannelId = string2;
                this.$parentId = string3;
                this.$data = jsonObject;
                this.$tags = amityTags;
                this.$metadata = jsonObject2;
                this.$mentionees = list2;
                this.$fileUri = uri;
            }
        });
        Intrinsics.checkNotNullExpressionValue((Object)completable, (String)"createPreviewMessage(\n  \u2026          }\n            }");
        return completable;
    }

    private final <T extends AmityFileInfo> Completable handleUploadResult(String messageId, String subChannelId, String parentId, String type, JsonObject data, AmityTags tags, JsonObject metadata, List<AmityMentioneeTarget> mentionees, AmityUploadResult<? extends T> uploadResult) {
        Completable completable;
        AmityUploadResult<? extends T> amityUploadResult = uploadResult;
        if (amityUploadResult instanceof AmityUploadResult.COMPLETE) {
            String fileId = ((AmityFileInfo)((AmityUploadResult.COMPLETE)uploadResult).getFile()).getFileId();
            List<AmityMentioneeTarget> list2 = mentionees;
            JsonObject jsonObject = metadata;
            AmityTags amityTags = tags;
            JsonObject jsonObject2 = data;
            String string = fileId;
            completable = this.syncMessage(messageId, subChannelId, parentId, type, jsonObject2, amityTags, string, jsonObject, list2);
        } else if (amityUploadResult instanceof AmityUploadResult.ERROR) {
            Completable completable2 = new MessageLocalDataStore().updateMessageState(messageId, AmityMessage.State.FAILED).andThen((CompletableSource)Completable.error((Throwable)((AmityUploadResult.ERROR)uploadResult).getError()));
            completable = completable2;
            Intrinsics.checkNotNullExpressionValue((Object)completable2, (String)"MessageLocalDataStore().\u2026uploadResult.getError()))");
        } else if (amityUploadResult instanceof AmityUploadResult.CANCELLED) {
            Completable completable3 = new MessageLocalDataStore().updateMessageState(messageId, AmityMessage.State.FAILED).andThen((CompletableSource)Completable.error((Throwable)AmityException.Companion.create(StringsKt.capitalize((String)type) + " upload cancelled", null, AmityError.UNKNOWN)));
            completable = completable3;
            Intrinsics.checkNotNullExpressionValue((Object)completable3, (String)"MessageLocalDataStore().\u2026  )\n                    )");
        } else {
            Completable completable4 = Completable.complete();
            completable = completable4;
            Intrinsics.checkNotNullExpressionValue((Object)completable4, (String)"Completable.complete()");
        }
        return completable;
    }

    private final Completable syncMessage(String messageId, String subChannelId, String parentId, String type, JsonObject data, AmityTags tags, String fileId, JsonObject metadata, List<AmityMentioneeTarget> mentionees) {
        List<AmityMentioneeTarget> list2 = mentionees;
        JsonObject jsonObject = metadata;
        AmityTags amityTags = tags;
        JsonObject jsonObject2 = data;
        String string = fileId;
        String string2 = type;
        String string3 = parentId;
        String string4 = subChannelId;
        Completable completable = new MessageLocalDataStore().updateMessageState(messageId, AmityMessage.State.SYNCING).andThen((CompletableSource)new MessageRemoteDataStore().createMessage(messageId, string3, string4, string, string2, jsonObject2, amityTags, jsonObject, list2).flatMapCompletable((Function)new Function<MessageQueryDto, CompletableSource>(messageId){
            final /* synthetic */ String $messageId;

            public final CompletableSource apply(MessageQueryDto it) {
                MessageQueryPersister messageQueryPersister = new MessageQueryPersister();
                MessageQueryDto messageQueryDto = it;
                Intrinsics.checkNotNullExpressionValue((Object)messageQueryDto, (String)"it");
                return (CompletableSource)messageQueryPersister.persist(messageQueryDto).andThen((CompletableSource)new MessageLocalDataStore().updateMessageState(this.$messageId, AmityMessage.State.SYNCED));
            }
            {
                this.$messageId = string;
            }
        })).onErrorResumeNext((Function)new Function<Throwable, CompletableSource>(messageId){
            final /* synthetic */ String $messageId;

            public final CompletableSource apply(Throwable it) {
                return (CompletableSource)new MessageLocalDataStore().updateMessageState(this.$messageId, AmityMessage.State.FAILED).andThen((CompletableSource)Completable.error((Throwable)it));
            }
            {
                this.$messageId = string;
            }
        });
        Intrinsics.checkNotNullExpressionValue((Object)completable, (String)"MessageLocalDataStore().\u2026.error(it))\n            }");
        return completable;
    }

    static /* synthetic */ Completable syncMessage$default(MessageRepository messageRepository, String string, String string2, String string3, String string4, JsonObject jsonObject, AmityTags amityTags, String string5, JsonObject jsonObject2, List list2, int n, Object object) {
        if ((n & 0x40) != 0) {
            string5 = null;
        }
        return messageRepository.syncMessage(string, string2, string3, string4, jsonObject, amityTags, string5, jsonObject2, list2);
    }

    private final Single<EkoMessageEntity> createPreviewMessage(String subChannelId, String parentId, String type, JsonObject data, AmityTags tags, Uri fileUri, JsonObject metadata, List<AmityMentioneeTarget> mentionees) {
        List<AmityMentioneeTarget> list2 = mentionees;
        Uri uri = fileUri;
        JsonObject jsonObject = metadata;
        AmityTags amityTags = tags;
        Single single = new MessageLocalDataStore().createMessage(subChannelId, parentId, type, data, jsonObject, amityTags, uri, list2).flatMap((Function)new Function<EkoMessageEntity, SingleSource<? extends EkoMessageEntity>>(fileUri){
            final /* synthetic */ Uri $fileUri;

            public final SingleSource<? extends EkoMessageEntity> apply(EkoMessageEntity message) {
                Completable completable;
                Completable completable2 = new MessageFlagLocalDataStore().createFlag(message.getMessageId());
                if (!MessageRepository.access$getFileUploadingTypes$cp().contains((Object)((Object)message.getDataType()))) {
                    completable = Completable.complete();
                } else {
                    Object object;
                    String fileType;
                    switch (MessageRepository$WhenMappings.$EnumSwitchMapping$1[message.getDataType().ordinal()]) {
                        case 1: {
                            String string = AmityMessage.DataType.IMAGE.getApiKey();
                            break;
                        }
                        case 2: {
                            String string = AmityMessage.DataType.VIDEO.getApiKey();
                            break;
                        }
                        case 3: {
                            String string = AmityMessage.DataType.AUDIO.getApiKey();
                            break;
                        }
                        default: {
                            String string = fileType = AmityMessage.DataType.FILE.getApiKey();
                        }
                    }
                    if ((object = this.$fileUri) == null || (object = object.getPath()) == null) {
                        object = "";
                    }
                    Intrinsics.checkNotNullExpressionValue((Object)object, (String)"fileUri?.path ?: \"\"");
                    Object path = object;
                    completable = new FileLocalDataStore().createLocalFile(message.getMessageId(), fileType, (String)path);
                }
                return (SingleSource)completable2.andThen((CompletableSource)completable).andThen((SingleSource)Single.just((Object)message));
            }
            {
                this.$fileUri = uri;
            }
        });
        Intrinsics.checkNotNullExpressionValue((Object)single, (String)"MessageLocalDataStore().\u2026.just(message))\n        }");
        return single;
    }

    @NotNull
    public final Flowable<AmityMessage> observeLatestMessage(@NotNull String subChannelId, @Nullable Boolean isDeleted) {
        Intrinsics.checkNotNullParameter((Object)subChannelId, (String)"subChannelId");
        Flowable flowable = new MessageLocalDataStore().observeLatestMessage(subChannelId, isDeleted).map((Function)observeLatestMessage.1.INSTANCE);
        Intrinsics.checkNotNullExpressionValue((Object)flowable, (String)"MessageLocalDataStore().\u2026r().map(it)\n            }");
        return flowable;
    }

    @NotNull
    public final Completable updateMessage(@NotNull String messageId, @Nullable JsonObject data, @Nullable AmityTags tags, @Nullable JsonObject metadata, @Nullable List<AmityMentioneeTarget> mentionees) {
        Intrinsics.checkNotNullParameter((Object)messageId, (String)"messageId");
        Completable completable = new MessageRemoteDataStore().updateMessage(messageId, data, tags, metadata, mentionees).flatMapCompletable((Function)updateMessage.1.INSTANCE);
        Intrinsics.checkNotNullExpressionValue((Object)completable, (String)"MessageRemoteDataStore()\u2026persist(it)\n            }");
        return completable;
    }

    @NotNull
    public final Completable deleteMessage(@NotNull String messageId) {
        Intrinsics.checkNotNullParameter((Object)messageId, (String)"messageId");
        Completable completable = Single.fromCallable((Callable)new Callable<String>(messageId){
            final /* synthetic */ String $messageId;

            /*
             * WARNING - void declaration
             */
            public final String call() {
                void var1_1;
                String deletingId = "";
                EkoMessageEntity message = new MessageLocalDataStore().getMessage(this.$messageId);
                if (message == null || Intrinsics.areEqual((Object)message.getSyncState(), (Object)AmityMessage.State.SYNCED.getStateName())) {
                    deletingId = this.$messageId;
                }
                return var1_1;
            }
            {
                this.$messageId = string;
            }
        }).flatMapCompletable((Function)new Function<String, CompletableSource>(messageId){
            final /* synthetic */ String $messageId;

            public final CompletableSource apply(String deletingId) {
                String string = deletingId;
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"deletingId");
                CharSequence charSequence = string;
                boolean bl = false;
                return charSequence.length() > 0 ? (CompletableSource)new MessageRemoteDataStore().deleteMessage(this.$messageId).flatMapCompletable((Function)deleteMessage.1.INSTANCE) : (CompletableSource)new MessageLocalDataStore().hardDeleteMessage(this.$messageId);
            }
            {
                this.$messageId = string;
            }
        });
        Intrinsics.checkNotNullExpressionValue((Object)completable, (String)"Single.fromCallable {\n  \u2026          }\n            }");
        return completable;
    }

    @NotNull
    public final Completable flagMessage(@NotNull String messageId) {
        Intrinsics.checkNotNullParameter((Object)messageId, (String)"messageId");
        Completable completable = new MessageFlagRemoteDataStore().flagMessage(messageId).map((Function)flagMessage.1.INSTANCE).ignoreElement();
        Intrinsics.checkNotNullExpressionValue((Object)completable, (String)"MessageFlagRemoteDataSto\u2026         .ignoreElement()");
        return completable;
    }

    @NotNull
    public final Completable unflagMessage(@NotNull String messageId) {
        Intrinsics.checkNotNullParameter((Object)messageId, (String)"messageId");
        Completable completable = new MessageFlagRemoteDataStore().unflagMessage(messageId).map((Function)unflagMessage.1.INSTANCE).ignoreElement();
        Intrinsics.checkNotNullExpressionValue((Object)completable, (String)"MessageFlagRemoteDataSto\u2026         .ignoreElement()");
        return completable;
    }

    @NotNull
    public final Flowable<List<AmityMessage>> observeMessages(@NotNull String subChannelId, boolean isFilterByParentId, @Nullable String parentId, @NotNull AmityTags includingTags, @NotNull AmityTags excludingTags, @Nullable Boolean isDeleted, @Nullable String type, @NotNull AmityMessageQuerySortOption sortOption) {
        Intrinsics.checkNotNullParameter((Object)subChannelId, (String)"subChannelId");
        Intrinsics.checkNotNullParameter((Object)includingTags, (String)"includingTags");
        Intrinsics.checkNotNullParameter((Object)excludingTags, (String)"excludingTags");
        Intrinsics.checkNotNullParameter((Object)((Object)sortOption), (String)"sortOption");
        Flowable flowable = new MessageLocalDataStore().observeMessages(subChannelId, isFilterByParentId, parentId, includingTags, excludingTags, isDeleted, type, sortOption).map((Function)observeMessages.1.INSTANCE);
        Intrinsics.checkNotNullExpressionValue((Object)flowable, (String)"MessageLocalDataStore().\u2026)\n            }\n        }");
        return flowable;
    }

    @NotNull
    public final Single<CommentLoadResult> loadFirstPageMessages(@NotNull String subChannelId, @NotNull AmityMessageQuerySortOption sortOption, @Nullable String parentId, boolean isFilterByParentId, @Nullable Boolean isDeleted, @NotNull AmityTags includingTags, @NotNull AmityTags excludingTags, @Nullable String type, int limit) {
        Intrinsics.checkNotNullParameter((Object)subChannelId, (String)"subChannelId");
        Intrinsics.checkNotNullParameter((Object)((Object)sortOption), (String)"sortOption");
        Intrinsics.checkNotNullParameter((Object)includingTags, (String)"includingTags");
        Intrinsics.checkNotNullParameter((Object)excludingTags, (String)"excludingTags");
        String string = null;
        Integer n = limit;
        String string2 = sortOption.getApiKey();
        Single single = MessageRemoteDataStore.queryMessages$default(new MessageRemoteDataStore(), subChannelId, isFilterByParentId, parentId, isDeleted, includingTags, excludingTags, type, n, string2, string, 512, null).flatMap((Function)new Function<MessageQueryDto, SingleSource<? extends MessageQueryDto>>(subChannelId){
            final /* synthetic */ String $subChannelId;

            public final SingleSource<? extends MessageQueryDto> apply(MessageQueryDto it) {
                Completable completable = new MessageLocalDataStore().hardDeleteAllFromSubChannel(this.$subChannelId);
                MessageQueryPersister messageQueryPersister = new MessageQueryPersister();
                MessageQueryDto messageQueryDto = it;
                Intrinsics.checkNotNullExpressionValue((Object)messageQueryDto, (String)"it");
                return (SingleSource)completable.andThen((CompletableSource)messageQueryPersister.persist(messageQueryDto)).andThen((SingleSource)Single.just((Object)it));
            }
            {
                this.$subChannelId = string;
            }
        }).map((Function)loadFirstPageMessages.2.INSTANCE);
        Intrinsics.checkNotNullExpressionValue((Object)single, (String)"MessageRemoteDataStore()\u2026token, ids)\n            }");
        return single;
    }

    @NotNull
    public final Single<CommentLoadResult> loadMessages(@NotNull String subChannelId, @NotNull AmityMessageQuerySortOption sortOption, @Nullable String parentId, boolean isFilterByParentId, @Nullable Boolean isDeleted, @NotNull AmityTags includingTags, @NotNull AmityTags excludingTags, @Nullable String type, @NotNull String token) {
        Intrinsics.checkNotNullParameter((Object)subChannelId, (String)"subChannelId");
        Intrinsics.checkNotNullParameter((Object)((Object)sortOption), (String)"sortOption");
        Intrinsics.checkNotNullParameter((Object)includingTags, (String)"includingTags");
        Intrinsics.checkNotNullParameter((Object)excludingTags, (String)"excludingTags");
        Intrinsics.checkNotNullParameter((Object)token, (String)"token");
        Single single = MessageRemoteDataStore.queryMessages$default(new MessageRemoteDataStore(), subChannelId, isFilterByParentId, parentId, isDeleted, includingTags, excludingTags, type, null, sortOption.getApiKey(), token, 128, null).flatMap((Function)loadMessages.1.INSTANCE).map((Function)loadMessages.2.INSTANCE);
        Intrinsics.checkNotNullExpressionValue((Object)single, (String)"MessageRemoteDataStore()\u2026token, ids)\n            }");
        return single;
    }

    @NotNull
    public final Flowable<PagingData<AmityMessage>> getMessagePagingData(@NotNull String subChannelId, boolean isFilterByParentId, @Nullable String parentId, @NotNull AmityTags includingTags, @NotNull AmityTags excludingTags, @Nullable Boolean isDeleted, @NotNull AmityMessageQuerySortOption sortOption, @Nullable AmityMessage.DataType type) {
        Intrinsics.checkNotNullParameter((Object)subChannelId, (String)"subChannelId");
        Intrinsics.checkNotNullParameter((Object)includingTags, (String)"includingTags");
        Intrinsics.checkNotNullParameter((Object)excludingTags, (String)"excludingTags");
        Intrinsics.checkNotNullParameter((Object)((Object)sortOption), (String)"sortOption");
        AmityMessage.DataType dataType = type;
        DynamicQueryStreamPagerCreator pagerCreator2 = new DynamicQueryStreamPagerCreator(new PagingConfig(this.getDefaultPageSize(), 0, true, 0, 0, 0, 58, null), null, new MessageMediator(subChannelId, isFilterByParentId, parentId, includingTags, excludingTags, isDeleted, sortOption, dataType != null ? dataType.getApiKey() : null), (Function0)new Function0<PagingSource<Integer, EkoMessageEntity>>(subChannelId, isFilterByParentId, parentId, includingTags, excludingTags, isDeleted, sortOption, type){
            final /* synthetic */ String $subChannelId;
            final /* synthetic */ boolean $isFilterByParentId;
            final /* synthetic */ String $parentId;
            final /* synthetic */ AmityTags $includingTags;
            final /* synthetic */ AmityTags $excludingTags;
            final /* synthetic */ Boolean $isDeleted;
            final /* synthetic */ AmityMessageQuerySortOption $sortOption;
            final /* synthetic */ AmityMessage.DataType $type;

            @NotNull
            public final PagingSource<Integer, EkoMessageEntity> invoke() {
                AmityMessage.DataType dataType = this.$type;
                return new MessageLocalDataStore().getMessagePagingSource(this.$subChannelId, this.$isFilterByParentId, this.$parentId, this.$includingTags, this.$excludingTags, this.$isDeleted, this.$sortOption, dataType != null ? dataType.getApiKey() : null);
            }
            {
                this.$subChannelId = string;
                this.$isFilterByParentId = bl;
                this.$parentId = string2;
                this.$includingTags = amityTags;
                this.$excludingTags = amityTags2;
                this.$isDeleted = bl2;
                this.$sortOption = amityMessageQuerySortOption;
                this.$type = dataType;
                super(0);
            }
        }, (ModelMapper)new MessageModelMapper(), 2, null);
        return FlowableKt.toRx3(pagerCreator2.create());
    }

    @NotNull
    public final Flowable<AmityMessage> getLatestMessage(@NotNull String subChannelId, boolean isFilterByParentId, @Nullable String parentId, @NotNull AmityTags includingTags, @NotNull AmityTags excludingTags, @Nullable Boolean isDeleted, @Nullable String type, @NotNull DynamicQueryStreamKeyCreator dynamicQueryStreamKeyCreator, int nonce) {
        Intrinsics.checkNotNullParameter((Object)subChannelId, (String)"subChannelId");
        Intrinsics.checkNotNullParameter((Object)includingTags, (String)"includingTags");
        Intrinsics.checkNotNullParameter((Object)excludingTags, (String)"excludingTags");
        Intrinsics.checkNotNullParameter((Object)dynamicQueryStreamKeyCreator, (String)"dynamicQueryStreamKeyCreator");
        Flowable flowable = new MessageLocalDataStore().getLatestMessage(subChannelId, isFilterByParentId, parentId, includingTags, excludingTags, isDeleted, type, dynamicQueryStreamKeyCreator, nonce).map((Function)getLatestMessage.1.INSTANCE);
        Intrinsics.checkNotNullExpressionValue((Object)flowable, (String)"MessageLocalDataStore().\u2026r().map(it)\n            }");
        return flowable;
    }

    @NotNull
    public final Single<Boolean> isFlaggedByMe(@NotNull String messageId) {
        Intrinsics.checkNotNullParameter((Object)messageId, (String)"messageId");
        Single single = new MessageFlagRemoteDataStore().isFlaggedByMe(messageId).map((Function)isFlaggedByMe.1.INSTANCE);
        Intrinsics.checkNotNullExpressionValue((Object)single, (String)"MessageFlagRemoteDataSto\u2026\"isFlagByMe\").asBoolean }");
        return single;
    }

    static {
        Companion = new Companion(null);
        fileUploadingTypes = CollectionsKt.listOf((Object[])new AmityMessage.DataType[]{AmityMessage.DataType.IMAGE, AmityMessage.DataType.FILE, AmityMessage.DataType.AUDIO, AmityMessage.DataType.VIDEO});
    }

    public static final /* synthetic */ List access$getFileUploadingTypes$cp() {
        return fileUploadingTypes;
    }

    public static final /* synthetic */ Completable access$handleUploadResult(MessageRepository $this, String messageId, String subChannelId, String parentId, String type, JsonObject data, AmityTags tags, JsonObject metadata, List mentionees, AmityUploadResult uploadResult) {
        return $this.handleUploadResult(messageId, subChannelId, parentId, type, data, tags, metadata, mentionees, uploadResult);
    }

    @Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, d1={"\u0000\u0016\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u0014\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0006"}, d2={"Lcom/amity/socialcloud/sdk/chat/data/message/MessageRepository$Companion;", "", "()V", "fileUploadingTypes", "", "Lcom/amity/socialcloud/sdk/model/chat/message/AmityMessage$DataType;", "amity-sdk_release"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

