package com.ekoapp.ekosdk.internal.usecase.post

import androidx.paging.PagingData
import androidx.paging.map
import com.amity.socialcloud.sdk.core.data.reaction.ReactionRepository
import com.amity.socialcloud.sdk.core.domain.reaction.ReactionComposerUseCase
import com.amity.socialcloud.sdk.model.core.reaction.AmityReaction
import com.amity.socialcloud.sdk.model.core.reaction.AmityReactionReferenceType
import io.reactivex.rxjava3.core.Flowable
import java.util.concurrent.Executors

internal class ReactionPagingDataUseCase {

    fun execute(referenceType: AmityReactionReferenceType, referenceId: String, reactionName: String?): Flowable<PagingData<AmityReaction>> {
        return ReactionRepository().getReactionPagingData(
            referenceType = referenceType,
            referenceId = referenceId,
            reactionName = reactionName
        ).map { pagingData ->
            pagingData.map(Executors.newSingleThreadExecutor()) { reaction ->
                ReactionComposerUseCase().execute(reaction)
            }
        }
    }

}