package com.ekoapp.ekosdk.internal.usecase.user

import androidx.paging.PagingData
import com.amity.socialcloud.sdk.api.core.AmityCoreClient
import com.amity.socialcloud.sdk.core.data.follow.FollowRepository
import com.amity.socialcloud.sdk.model.core.follow.AmityFollowRelationship
import com.amity.socialcloud.sdk.model.core.follow.AmityFollowStatusFilter
import io.reactivex.rxjava3.core.Flowable

internal class GetMyFollowersPagingDataUseCase {

    fun execute(status: AmityFollowStatusFilter): Flowable<PagingData<AmityFollowRelationship>> {
        return FollowRepository().getFollowersPagingData(AmityCoreClient.getUserId(), status)
    }
}