package com.amity.socialcloud.sdk.chat.data.marker.channel

import com.ekoapp.ekosdk.internal.api.AmityHttpClient
import com.ekoapp.ekosdk.internal.api.dto.ChannelMarkerQueryDto
import com.ekoapp.ekosdk.internal.api.dto.MarkerSyncDto
import io.reactivex.rxjava3.core.Single

internal class ChannelMarkerRemoteDataStore {

    fun queryChannelMarkers(
        channelIds: List<String>? = null
    ): Single<ChannelMarkerQueryDto> {
        return AmityHttpClient.get(ChannelMarkerApi::class).flatMap {
            it.queryChannelMarkers(
                channelIds = channelIds
            )
        }
    }
    
    fun markChannelAsRead(
        channelId: String
    ): Single<MarkerSyncDto> {
        return AmityHttpClient.get(ChannelMarkerApi::class).flatMap {
            it.markChannelAsRead(
                channelId = channelId
            )
        }
    }
}