package com.amity.socialcloud.sdk.model.core.file.upload

import com.amity.socialcloud.sdk.model.core.error.AmityException
import com.amity.socialcloud.sdk.model.core.file.AmityFileInfo

sealed class AmityUploadResult<out T : AmityFileInfo> {
    data class PROGRESS(private val uploadInfo: AmityUploadInfo) : AmityUploadResult<Nothing>() {
        fun getUploadInfo(): AmityUploadInfo {
            return uploadInfo
        }
    }

    data class COMPLETE<out T : AmityFileInfo>(private val file: T) : AmityUploadResult<T>() {
        fun getFile(): T {
            return file
        }
    }

    data class ERROR(private val error: AmityException) : AmityUploadResult<Nothing>() {
        fun getError(): AmityException {
            return error
        }
    }

    object CANCELLED : AmityUploadResult<Nothing>()
}