package com.amity.socialcloud.sdk.core.data.auth

import com.amity.socialcloud.sdk.api.core.endpoint.AmityEndpoint
import com.amity.socialcloud.sdk.model.core.session.AmityUserToken
import io.reactivex.rxjava3.core.Single

internal class TokenRepository {

    fun createToken(
        endpoint: AmityEndpoint,
        apiKey: String,
        userId: String,
        displayName: String? = null,
        secureToken: String? = null
    ): Single<AmityUserToken> {
        return TokenRemoteDataStore().createToken(
            endpoint = endpoint,
            apiKey = apiKey,
            userId = userId,
            displayName = displayName,
            secureToken = secureToken
        ).map {
            AmityUserToken(it.accessToken ?: "")
        }
    }

    //future function
    private fun refreshToken() {}

    //future function
    private fun revokeToken() {}
}