package com.amity.socialcloud.sdk.social.domain.story.markclicked

import com.amity.socialcloud.sdk.core.data.analytics.AnalyticsRepository
import com.amity.socialcloud.sdk.core.data.analytics.AnalyticsService
import com.amity.socialcloud.sdk.core.engine.analytics.AnalyticsEventContentType
import com.amity.socialcloud.sdk.core.engine.analytics.AnalyticsEventSyncPriority
import com.amity.socialcloud.sdk.model.social.story.AmityStory

internal class MarkStoryAsClickedUseCase {

    fun execute(story: AmityStory) {
        if(story.getState() != AmityStory.State.SYNCED) {
            return
        }
        val event = AnalyticsRepository().createAnalyticEvent(
            contentId = story.getStoryId(),
            contentType = AnalyticsEventContentType.STORY,
            activityType = "linkClicked",
            syncPriority = AnalyticsEventSyncPriority.HIGH,
            deduplicationKey = story.getStoryId() + ".linkClicked",
        )
        AnalyticsService().captureEvent(event)

    }
}