/*
 * Decompiled with CFR 0.152.
 */
package com.ekoapp.ekosdk.internal.data.dao;

import androidx.room.Dao;
import androidx.room.Delete;
import androidx.room.Query;
import androidx.room.Transaction;
import com.amity.socialcloud.sdk.api.core.AmityCoreClient;
import com.amity.socialcloud.sdk.model.core.role.AmityRoles;
import com.ekoapp.ekosdk.internal.data.UserDatabase;
import com.ekoapp.ekosdk.internal.data.dao.EkoCommunityDao;
import com.ekoapp.ekosdk.internal.data.dao.EkoCommunityPermissionDao;
import com.ekoapp.ekosdk.internal.data.dao.EkoCommunityRoleDao;
import com.ekoapp.ekosdk.internal.data.dao.EkoObjectDao;
import com.ekoapp.ekosdk.internal.data.dao.EkoPermissionDao;
import com.ekoapp.ekosdk.internal.data.dao.EkoRoleDao;
import com.ekoapp.ekosdk.internal.data.model.CommunityMembershipPermissionEntity;
import com.ekoapp.ekosdk.internal.data.model.CommunityMembershipRoleEntity;
import com.ekoapp.ekosdk.internal.entity.CommunityMembershipEntity;
import com.google.common.base.Objects;
import io.reactivex.rxjava3.core.Flowable;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.joda.time.DateTime;

@Dao
public abstract class EkoCommunityMembershipDao
extends EkoObjectDao<CommunityMembershipEntity> {
    private final EkoCommunityDao communityDao;
    private final EkoCommunityRoleDao communityRoleDao;
    private final EkoCommunityPermissionDao communityPermissionDao;

    public EkoCommunityMembershipDao() {
        UserDatabase db = UserDatabase.get();
        this.communityRoleDao = db.communityRoleDao();
        this.communityPermissionDao = db.communityPermissionDao();
        this.communityDao = db.communityDao();
    }

    @Override
    @Delete
    public abstract void delete(CommunityMembershipEntity var1);

    @Override
    @Query(value="DELETE from community_membership")
    public abstract void deleteAll();

    @Query(value="DELETE from community_membership where community_membership.communityId = :communityId")
    abstract void deleteByCommunityIdImpl(String var1);

    @Query(value="SELECT * from community_membership where communityId = :communityId and userId = :userId LIMIT 1")
    abstract CommunityMembershipEntity getByCommunityIdAndUserIdNowImpl(String var1, String var2);

    public CommunityMembershipEntity getByCommunityIdAndUserIdNow(String communityId, String userId) {
        return this.getByCommunityIdAndUserIdNowImpl(communityId, userId);
    }

    @Query(value="SELECT * from community_membership where id = :id LIMIT 1")
    abstract CommunityMembershipEntity getByIdNowImpl(String var1);

    @Override
    public CommunityMembershipEntity getByIdNow(String id) {
        return this.getByIdNowImpl(id);
    }

    @Query(value="SELECT * from community_membership where communityId = :communityId and userId = :userId LIMIT 1")
    abstract Flowable<CommunityMembershipEntity> getByIdImpl(String var1, String var2);

    public Flowable<CommunityMembershipEntity> getById(String communityId, String userId) {
        return this.getByIdImpl(communityId, userId);
    }

    @Query(value="SELECT * from community_membership where userId in (:ids)")
    abstract List<CommunityMembershipEntity> getByIdsNowImpl(@NotNull List<String> var1);

    @Override
    public List<CommunityMembershipEntity> getByIdsNow(@NotNull List<String> ids) {
        return this.getByIdsNowImpl(ids);
    }

    @Transaction
    public void deleteByCommunityId(String communityId) {
        this.deleteByCommunityIdImpl(communityId);
    }

    @Transaction
    public void updateUser(String userId) {
        this.updateUserImpl(userId);
    }

    @Query(value="UPDATE community_membership set userId = :userId where userId = :userId")
    abstract void updateUserImpl(String var1);

    @Override
    @Transaction
    public void insert(CommunityMembershipEntity membership) {
        super.insert(membership);
        EkoRoleDao.update(membership, this.communityRoleDao, CommunityMembershipRoleEntity::create);
        EkoPermissionDao.update(membership, this.communityPermissionDao, CommunityMembershipPermissionEntity::create);
        this.updateIsJoined(membership);
    }

    @Override
    @Transaction
    public void insert(List<? extends CommunityMembershipEntity> memberships) {
        super.insert(memberships);
        EkoRoleDao.update(memberships, this.communityRoleDao, CommunityMembershipRoleEntity::create);
        EkoPermissionDao.update(memberships, this.communityPermissionDao, CommunityMembershipPermissionEntity::create);
        for (CommunityMembershipEntity communityMembershipEntity : memberships) {
            this.updateIsJoined(communityMembershipEntity);
        }
    }

    @Override
    public void update(CommunityMembershipEntity membership) {
        super.update(membership);
        EkoRoleDao.update(membership, this.communityRoleDao, CommunityMembershipRoleEntity::create);
        EkoPermissionDao.update(membership, this.communityPermissionDao, CommunityMembershipPermissionEntity::create);
        this.updateIsJoined(membership);
    }

    private void updateIsJoined(CommunityMembershipEntity membership) {
        if (Objects.equal((Object)membership.getUserId(), (Object)AmityCoreClient.INSTANCE.getUserId())) {
            this.communityDao.updateIsJoined(membership.getCommunityId());
        }
    }

    @Query(value="SELECT * from community_membership where community_membership.communityId = :communityId and community_membership.communityMembership in (:memberships) and case when :isFilterByRoles then community_membership.userId in (SELECT userId from community_role where communityId = :communityId and roleName in (:roles)) else userId is not null end and community_membership.updatedAt > :now and community_membership.userId not in (SELECT amity_paging_id.id from amity_paging_id where amity_paging_id.hash = (:hash) and amity_paging_id.nonce = (:nonce) ) order by community_membership.updatedAt  desc limit 1")
    abstract Flowable<CommunityMembershipEntity> getLatestCommunityMembershipImpl(String var1, String[] var2, Boolean var3, String[] var4, int var5, int var6, DateTime var7);

    public Flowable<CommunityMembershipEntity> getLatestCommunityMembership(String communityId, List<String> memberships, AmityRoles roles, int hash, int nonce, DateTime now) {
        return this.getLatestCommunityMembershipImpl(communityId, memberships.toArray(new String[0]), !roles.isEmpty(), roles.get().toArray(new String[0]), hash, nonce, now);
    }
}

