/*
 * Decompiled with CFR 0.152.
 */
package com.ekoapp.ekosdk.internal.data.dao;

import android.database.Cursor;
import androidx.room.EntityDeletionOrUpdateAdapter;
import androidx.room.EntityInsertionAdapter;
import androidx.room.RoomDatabase;
import androidx.room.RoomSQLiteQuery;
import androidx.room.SharedSQLiteStatement;
import androidx.room.rxjava3.RxRoom;
import androidx.room.util.CursorUtil;
import androidx.room.util.DBUtil;
import androidx.room.util.StringUtil;
import androidx.sqlite.db.SupportSQLiteQuery;
import androidx.sqlite.db.SupportSQLiteStatement;
import com.amity.socialcloud.sdk.model.core.reaction.AmityReactionMap;
import com.amity.socialcloud.sdk.model.core.tag.AmityTags;
import com.amity.socialcloud.sdk.socket.util.DateTimeTypeConverter;
import com.ekoapp.ekosdk.internal.EkoMessageEntity;
import com.ekoapp.ekosdk.internal.api.dto.EkoMentioneesDto;
import com.ekoapp.ekosdk.internal.data.converter.EkoReactionMapConverter;
import com.ekoapp.ekosdk.internal.data.converter.EkoTagsTypeConverter;
import com.ekoapp.ekosdk.internal.data.converter.JsonObjectTypeConverter;
import com.ekoapp.ekosdk.internal.data.converter.MentioneesConverter;
import com.ekoapp.ekosdk.internal.data.dao.EkoMessageDao;
import com.google.gson.JsonObject;
import io.reactivex.rxjava3.core.Completable;
import io.reactivex.rxjava3.core.Flowable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.Callable;
import org.joda.time.DateTime;

public final class EkoMessageDao_Impl
extends EkoMessageDao {
    private final RoomDatabase __db;
    private final EntityInsertionAdapter<EkoMessageEntity> __insertionAdapterOfEkoMessageEntity;
    private final DateTimeTypeConverter __dateTimeTypeConverter = new DateTimeTypeConverter();
    private final EkoTagsTypeConverter __ekoTagsTypeConverter = new EkoTagsTypeConverter();
    private final EkoReactionMapConverter __ekoReactionMapConverter = new EkoReactionMapConverter();
    private final JsonObjectTypeConverter __jsonObjectTypeConverter = new JsonObjectTypeConverter();
    private final MentioneesConverter __mentioneesConverter = new MentioneesConverter();
    private final EntityDeletionOrUpdateAdapter<EkoMessageEntity> __deletionAdapterOfEkoMessageEntity;
    private final EntityDeletionOrUpdateAdapter<EkoMessageEntity> __updateAdapterOfEkoMessageEntity;
    private final SharedSQLiteStatement __preparedStmtOfDeleteAll;
    private final SharedSQLiteStatement __preparedStmtOfCleanUpSyncingStateOnStartup;
    private final SharedSQLiteStatement __preparedStmtOfCleanUpUploadingStateOnStartup;
    private final SharedSQLiteStatement __preparedStmtOfCleanUpFailedMessages;
    private final SharedSQLiteStatement __preparedStmtOfUpdateSyncState;
    private final SharedSQLiteStatement __preparedStmtOfDeleteAllFromChannel;
    private final SharedSQLiteStatement __preparedStmtOfHardDeleteMessage;
    private final SharedSQLiteStatement __preparedStmtOfSoftDeleteFromChannelByUserIdImpl;
    private final SharedSQLiteStatement __preparedStmtOfUpdateUserImpl;
    private final SharedSQLiteStatement __preparedStmtOfUpdateMarkerHash;

    public EkoMessageDao_Impl(RoomDatabase __db) {
        this.__db = __db;
        this.__insertionAdapterOfEkoMessageEntity = new EntityInsertionAdapter<EkoMessageEntity>(__db){

            public String createQuery() {
                return "INSERT OR REPLACE INTO `message` (`uniqueId`,`messageId`,`subChannelId`,`channelId`,`userId`,`parentId`,`channelSegment`,`childrenNumber`,`editedAt`,`isDeleted`,`flagCount`,`tags`,`reactions`,`reactionCount`,`type`,`data`,`metadata`,`mentionees`,`path`,`syncState`,`messageMarkerHash`,`createdAt`,`updatedAt`,`expiresAt`) VALUES (?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?)";
            }

            public void bind(SupportSQLiteStatement stmt, EkoMessageEntity value) {
                if (value.getUniqueId() == null) {
                    stmt.bindNull(1);
                } else {
                    stmt.bindString(1, value.getUniqueId());
                }
                if (value.getMessageId() == null) {
                    stmt.bindNull(2);
                } else {
                    stmt.bindString(2, value.getMessageId());
                }
                if (value.getSubChannelId() == null) {
                    stmt.bindNull(3);
                } else {
                    stmt.bindString(3, value.getSubChannelId());
                }
                if (value.getChannelId() == null) {
                    stmt.bindNull(4);
                } else {
                    stmt.bindString(4, value.getChannelId());
                }
                if (value.getUserId() == null) {
                    stmt.bindNull(5);
                } else {
                    stmt.bindString(5, value.getUserId());
                }
                if (value.getParentId() == null) {
                    stmt.bindNull(6);
                } else {
                    stmt.bindString(6, value.getParentId());
                }
                stmt.bindLong(7, (long)value.getChannelSegment());
                stmt.bindLong(8, (long)value.getChildrenNumber());
                String _tmp = EkoMessageDao_Impl.this.__dateTimeTypeConverter.dateTimeToString(value.getEditedAt());
                if (_tmp == null) {
                    stmt.bindNull(9);
                } else {
                    stmt.bindString(9, _tmp);
                }
                int _tmp_1 = value.isDeleted() ? 1 : 0;
                stmt.bindLong(10, (long)_tmp_1);
                stmt.bindLong(11, (long)value.getFlagCount());
                String _tmp_2 = EkoMessageDao_Impl.this.__ekoTagsTypeConverter.ekoTagsToString(value.getTags());
                if (_tmp_2 == null) {
                    stmt.bindNull(12);
                } else {
                    stmt.bindString(12, _tmp_2);
                }
                String _tmp_3 = EkoMessageDao_Impl.this.__ekoReactionMapConverter.stringIntMapToString(value.getReactions());
                if (_tmp_3 == null) {
                    stmt.bindNull(13);
                } else {
                    stmt.bindString(13, _tmp_3);
                }
                stmt.bindLong(14, (long)value.getReactionCount());
                if (value.getType() == null) {
                    stmt.bindNull(15);
                } else {
                    stmt.bindString(15, value.getType());
                }
                String _tmp_4 = EkoMessageDao_Impl.this.__jsonObjectTypeConverter.jsonObjectToString(value.getData());
                if (_tmp_4 == null) {
                    stmt.bindNull(16);
                } else {
                    stmt.bindString(16, _tmp_4);
                }
                String _tmp_5 = EkoMessageDao_Impl.this.__jsonObjectTypeConverter.jsonObjectToString(value.getMetadata());
                if (_tmp_5 == null) {
                    stmt.bindNull(17);
                } else {
                    stmt.bindString(17, _tmp_5);
                }
                String _tmp_6 = EkoMessageDao_Impl.this.__mentioneesConverter.mentioneesToJson(value.getMentionees());
                if (_tmp_6 == null) {
                    stmt.bindNull(18);
                } else {
                    stmt.bindString(18, _tmp_6);
                }
                if (value.getPath() == null) {
                    stmt.bindNull(19);
                } else {
                    stmt.bindString(19, value.getPath());
                }
                if (value.getSyncState() == null) {
                    stmt.bindNull(20);
                } else {
                    stmt.bindString(20, value.getSyncState());
                }
                stmt.bindLong(21, (long)value.getMessageMarkerHash());
                String _tmp_7 = EkoMessageDao_Impl.this.__dateTimeTypeConverter.dateTimeToString(value.getCreatedAt());
                if (_tmp_7 == null) {
                    stmt.bindNull(22);
                } else {
                    stmt.bindString(22, _tmp_7);
                }
                String _tmp_8 = EkoMessageDao_Impl.this.__dateTimeTypeConverter.dateTimeToString(value.getUpdatedAt());
                if (_tmp_8 == null) {
                    stmt.bindNull(23);
                } else {
                    stmt.bindString(23, _tmp_8);
                }
                String _tmp_9 = EkoMessageDao_Impl.this.__dateTimeTypeConverter.dateTimeToString(value.getExpiresAt());
                if (_tmp_9 == null) {
                    stmt.bindNull(24);
                } else {
                    stmt.bindString(24, _tmp_9);
                }
            }
        };
        this.__deletionAdapterOfEkoMessageEntity = new EntityDeletionOrUpdateAdapter<EkoMessageEntity>(__db){

            public String createQuery() {
                return "DELETE FROM `message` WHERE `uniqueId` = ?";
            }

            public void bind(SupportSQLiteStatement stmt, EkoMessageEntity value) {
                if (value.getUniqueId() == null) {
                    stmt.bindNull(1);
                } else {
                    stmt.bindString(1, value.getUniqueId());
                }
            }
        };
        this.__updateAdapterOfEkoMessageEntity = new EntityDeletionOrUpdateAdapter<EkoMessageEntity>(__db){

            public String createQuery() {
                return "UPDATE OR ABORT `message` SET `uniqueId` = ?,`messageId` = ?,`subChannelId` = ?,`channelId` = ?,`userId` = ?,`parentId` = ?,`channelSegment` = ?,`childrenNumber` = ?,`editedAt` = ?,`isDeleted` = ?,`flagCount` = ?,`tags` = ?,`reactions` = ?,`reactionCount` = ?,`type` = ?,`data` = ?,`metadata` = ?,`mentionees` = ?,`path` = ?,`syncState` = ?,`messageMarkerHash` = ?,`createdAt` = ?,`updatedAt` = ?,`expiresAt` = ? WHERE `uniqueId` = ?";
            }

            public void bind(SupportSQLiteStatement stmt, EkoMessageEntity value) {
                if (value.getUniqueId() == null) {
                    stmt.bindNull(1);
                } else {
                    stmt.bindString(1, value.getUniqueId());
                }
                if (value.getMessageId() == null) {
                    stmt.bindNull(2);
                } else {
                    stmt.bindString(2, value.getMessageId());
                }
                if (value.getSubChannelId() == null) {
                    stmt.bindNull(3);
                } else {
                    stmt.bindString(3, value.getSubChannelId());
                }
                if (value.getChannelId() == null) {
                    stmt.bindNull(4);
                } else {
                    stmt.bindString(4, value.getChannelId());
                }
                if (value.getUserId() == null) {
                    stmt.bindNull(5);
                } else {
                    stmt.bindString(5, value.getUserId());
                }
                if (value.getParentId() == null) {
                    stmt.bindNull(6);
                } else {
                    stmt.bindString(6, value.getParentId());
                }
                stmt.bindLong(7, (long)value.getChannelSegment());
                stmt.bindLong(8, (long)value.getChildrenNumber());
                String _tmp = EkoMessageDao_Impl.this.__dateTimeTypeConverter.dateTimeToString(value.getEditedAt());
                if (_tmp == null) {
                    stmt.bindNull(9);
                } else {
                    stmt.bindString(9, _tmp);
                }
                int _tmp_1 = value.isDeleted() ? 1 : 0;
                stmt.bindLong(10, (long)_tmp_1);
                stmt.bindLong(11, (long)value.getFlagCount());
                String _tmp_2 = EkoMessageDao_Impl.this.__ekoTagsTypeConverter.ekoTagsToString(value.getTags());
                if (_tmp_2 == null) {
                    stmt.bindNull(12);
                } else {
                    stmt.bindString(12, _tmp_2);
                }
                String _tmp_3 = EkoMessageDao_Impl.this.__ekoReactionMapConverter.stringIntMapToString(value.getReactions());
                if (_tmp_3 == null) {
                    stmt.bindNull(13);
                } else {
                    stmt.bindString(13, _tmp_3);
                }
                stmt.bindLong(14, (long)value.getReactionCount());
                if (value.getType() == null) {
                    stmt.bindNull(15);
                } else {
                    stmt.bindString(15, value.getType());
                }
                String _tmp_4 = EkoMessageDao_Impl.this.__jsonObjectTypeConverter.jsonObjectToString(value.getData());
                if (_tmp_4 == null) {
                    stmt.bindNull(16);
                } else {
                    stmt.bindString(16, _tmp_4);
                }
                String _tmp_5 = EkoMessageDao_Impl.this.__jsonObjectTypeConverter.jsonObjectToString(value.getMetadata());
                if (_tmp_5 == null) {
                    stmt.bindNull(17);
                } else {
                    stmt.bindString(17, _tmp_5);
                }
                String _tmp_6 = EkoMessageDao_Impl.this.__mentioneesConverter.mentioneesToJson(value.getMentionees());
                if (_tmp_6 == null) {
                    stmt.bindNull(18);
                } else {
                    stmt.bindString(18, _tmp_6);
                }
                if (value.getPath() == null) {
                    stmt.bindNull(19);
                } else {
                    stmt.bindString(19, value.getPath());
                }
                if (value.getSyncState() == null) {
                    stmt.bindNull(20);
                } else {
                    stmt.bindString(20, value.getSyncState());
                }
                stmt.bindLong(21, (long)value.getMessageMarkerHash());
                String _tmp_7 = EkoMessageDao_Impl.this.__dateTimeTypeConverter.dateTimeToString(value.getCreatedAt());
                if (_tmp_7 == null) {
                    stmt.bindNull(22);
                } else {
                    stmt.bindString(22, _tmp_7);
                }
                String _tmp_8 = EkoMessageDao_Impl.this.__dateTimeTypeConverter.dateTimeToString(value.getUpdatedAt());
                if (_tmp_8 == null) {
                    stmt.bindNull(23);
                } else {
                    stmt.bindString(23, _tmp_8);
                }
                String _tmp_9 = EkoMessageDao_Impl.this.__dateTimeTypeConverter.dateTimeToString(value.getExpiresAt());
                if (_tmp_9 == null) {
                    stmt.bindNull(24);
                } else {
                    stmt.bindString(24, _tmp_9);
                }
                if (value.getUniqueId() == null) {
                    stmt.bindNull(25);
                } else {
                    stmt.bindString(25, value.getUniqueId());
                }
            }
        };
        this.__preparedStmtOfDeleteAll = new SharedSQLiteStatement(__db){

            public String createQuery() {
                String _query = "DELETE from message";
                return "DELETE from message";
            }
        };
        this.__preparedStmtOfCleanUpSyncingStateOnStartup = new SharedSQLiteStatement(__db){

            public String createQuery() {
                String _query = "UPDATE message set syncState = 'failed' where syncState = 'syncing'";
                return "UPDATE message set syncState = 'failed' where syncState = 'syncing'";
            }
        };
        this.__preparedStmtOfCleanUpUploadingStateOnStartup = new SharedSQLiteStatement(__db){

            public String createQuery() {
                String _query = "UPDATE message set syncState = 'failed' where syncState = 'uploading'";
                return "UPDATE message set syncState = 'failed' where syncState = 'uploading'";
            }
        };
        this.__preparedStmtOfCleanUpFailedMessages = new SharedSQLiteStatement(__db){

            public String createQuery() {
                String _query = "DELETE from message where syncState = 'failed'";
                return "DELETE from message where syncState = 'failed'";
            }
        };
        this.__preparedStmtOfUpdateSyncState = new SharedSQLiteStatement(__db){

            public String createQuery() {
                String _query = "UPDATE message set syncState = ? where messageId = ?";
                return "UPDATE message set syncState = ? where messageId = ?";
            }
        };
        this.__preparedStmtOfDeleteAllFromChannel = new SharedSQLiteStatement(__db){

            public String createQuery() {
                String _query = "DELETE from message where channelId = ?";
                return "DELETE from message where channelId = ?";
            }
        };
        this.__preparedStmtOfHardDeleteMessage = new SharedSQLiteStatement(__db){

            public String createQuery() {
                String _query = "DELETE from message where messageId = ?";
                return "DELETE from message where messageId = ?";
            }
        };
        this.__preparedStmtOfSoftDeleteFromChannelByUserIdImpl = new SharedSQLiteStatement(__db){

            public String createQuery() {
                String _query = "UPDATE message set isDeleted = 1, data = null where channelId = ? and userId = ?";
                return "UPDATE message set isDeleted = 1, data = null where channelId = ? and userId = ?";
            }
        };
        this.__preparedStmtOfUpdateUserImpl = new SharedSQLiteStatement(__db){

            public String createQuery() {
                String _query = "UPDATE message set userId = ? where userId = ?";
                return "UPDATE message set userId = ? where userId = ?";
            }
        };
        this.__preparedStmtOfUpdateMarkerHash = new SharedSQLiteStatement(__db){

            public String createQuery() {
                String _query = "UPDATE message set messageMarkerHash = ? where messageId = ?";
                return "UPDATE message set messageMarkerHash = ? where messageId = ?";
            }
        };
    }

    @Override
    public void insertImpl(EkoMessageEntity object) {
        this.__db.assertNotSuspendingTransaction();
        this.__db.beginTransaction();
        try {
            this.__insertionAdapterOfEkoMessageEntity.insert((Object)object);
            this.__db.setTransactionSuccessful();
        }
        finally {
            this.__db.endTransaction();
        }
    }

    @Override
    public void insertImpl(List<? extends EkoMessageEntity> objects) {
        this.__db.assertNotSuspendingTransaction();
        this.__db.beginTransaction();
        try {
            this.__insertionAdapterOfEkoMessageEntity.insert(objects);
            this.__db.setTransactionSuccessful();
        }
        finally {
            this.__db.endTransaction();
        }
    }

    @Override
    public void delete(EkoMessageEntity object) {
        this.__db.assertNotSuspendingTransaction();
        this.__db.beginTransaction();
        try {
            this.__deletionAdapterOfEkoMessageEntity.handle((Object)object);
            this.__db.setTransactionSuccessful();
        }
        finally {
            this.__db.endTransaction();
        }
    }

    @Override
    public void delete(List<? extends EkoMessageEntity> objects) {
        this.__db.assertNotSuspendingTransaction();
        this.__db.beginTransaction();
        try {
            this.__deletionAdapterOfEkoMessageEntity.handleMultiple(objects);
            this.__db.setTransactionSuccessful();
        }
        finally {
            this.__db.endTransaction();
        }
    }

    @Override
    public void updateImpl(EkoMessageEntity object) {
        this.__db.assertNotSuspendingTransaction();
        this.__db.beginTransaction();
        try {
            this.__updateAdapterOfEkoMessageEntity.handle((Object)object);
            this.__db.setTransactionSuccessful();
        }
        finally {
            this.__db.endTransaction();
        }
    }

    @Override
    public void insert(EkoMessageEntity message) {
        this.__db.beginTransaction();
        try {
            EkoMessageDao_Impl.super.insert(message);
            this.__db.setTransactionSuccessful();
        }
        finally {
            this.__db.endTransaction();
        }
    }

    @Override
    public void insert(List<? extends EkoMessageEntity> messages) {
        this.__db.beginTransaction();
        try {
            EkoMessageDao_Impl.super.insert(messages);
            this.__db.setTransactionSuccessful();
        }
        finally {
            this.__db.endTransaction();
        }
    }

    @Override
    public void update(EkoMessageEntity message) {
        this.__db.beginTransaction();
        try {
            EkoMessageDao_Impl.super.update(message);
            this.__db.setTransactionSuccessful();
        }
        finally {
            this.__db.endTransaction();
        }
    }

    @Override
    public void retainLatestFromChannel(String channelId, int offset) {
        this.__db.beginTransaction();
        try {
            EkoMessageDao_Impl.super.retainLatestFromChannel(channelId, offset);
            this.__db.setTransactionSuccessful();
        }
        finally {
            this.__db.endTransaction();
        }
    }

    @Override
    public void softDeleteFromChannelByUserId(String channelId, String userId) {
        this.__db.beginTransaction();
        try {
            EkoMessageDao_Impl.super.softDeleteFromChannelByUserId(channelId, userId);
            this.__db.setTransactionSuccessful();
        }
        finally {
            this.__db.endTransaction();
        }
    }

    @Override
    public void updateUser(String userId) {
        this.__db.beginTransaction();
        try {
            EkoMessageDao_Impl.super.updateUser(userId);
            this.__db.setTransactionSuccessful();
        }
        finally {
            this.__db.endTransaction();
        }
    }

    @Override
    public void deleteAll() {
        this.__db.assertNotSuspendingTransaction();
        SupportSQLiteStatement _stmt = this.__preparedStmtOfDeleteAll.acquire();
        this.__db.beginTransaction();
        try {
            _stmt.executeUpdateDelete();
            this.__db.setTransactionSuccessful();
        }
        finally {
            this.__db.endTransaction();
            this.__preparedStmtOfDeleteAll.release(_stmt);
        }
    }

    @Override
    public void cleanUpSyncingStateOnStartup() {
        this.__db.assertNotSuspendingTransaction();
        SupportSQLiteStatement _stmt = this.__preparedStmtOfCleanUpSyncingStateOnStartup.acquire();
        this.__db.beginTransaction();
        try {
            _stmt.executeUpdateDelete();
            this.__db.setTransactionSuccessful();
        }
        finally {
            this.__db.endTransaction();
            this.__preparedStmtOfCleanUpSyncingStateOnStartup.release(_stmt);
        }
    }

    @Override
    public void cleanUpUploadingStateOnStartup() {
        this.__db.assertNotSuspendingTransaction();
        SupportSQLiteStatement _stmt = this.__preparedStmtOfCleanUpUploadingStateOnStartup.acquire();
        this.__db.beginTransaction();
        try {
            _stmt.executeUpdateDelete();
            this.__db.setTransactionSuccessful();
        }
        finally {
            this.__db.endTransaction();
            this.__preparedStmtOfCleanUpUploadingStateOnStartup.release(_stmt);
        }
    }

    @Override
    public void cleanUpFailedMessages() {
        this.__db.assertNotSuspendingTransaction();
        SupportSQLiteStatement _stmt = this.__preparedStmtOfCleanUpFailedMessages.acquire();
        this.__db.beginTransaction();
        try {
            _stmt.executeUpdateDelete();
            this.__db.setTransactionSuccessful();
        }
        finally {
            this.__db.endTransaction();
            this.__preparedStmtOfCleanUpFailedMessages.release(_stmt);
        }
    }

    @Override
    public Completable updateSyncState(final String messageId, final String state) {
        return Completable.fromCallable((Callable)new Callable<Void>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public Void call() throws Exception {
                SupportSQLiteStatement _stmt = EkoMessageDao_Impl.this.__preparedStmtOfUpdateSyncState.acquire();
                int _argIndex = 1;
                if (state == null) {
                    _stmt.bindNull(_argIndex);
                } else {
                    _stmt.bindString(_argIndex, state);
                }
                _argIndex = 2;
                if (messageId == null) {
                    _stmt.bindNull(_argIndex);
                } else {
                    _stmt.bindString(_argIndex, messageId);
                }
                EkoMessageDao_Impl.this.__db.beginTransaction();
                try {
                    _stmt.executeUpdateDelete();
                    EkoMessageDao_Impl.this.__db.setTransactionSuccessful();
                    Void void_ = null;
                    return void_;
                }
                finally {
                    EkoMessageDao_Impl.this.__db.endTransaction();
                    EkoMessageDao_Impl.this.__preparedStmtOfUpdateSyncState.release(_stmt);
                }
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void deleteAllFromChannel(String channelId) {
        this.__db.assertNotSuspendingTransaction();
        SupportSQLiteStatement _stmt = this.__preparedStmtOfDeleteAllFromChannel.acquire();
        int _argIndex = 1;
        if (channelId == null) {
            _stmt.bindNull(_argIndex);
        } else {
            _stmt.bindString(_argIndex, channelId);
        }
        this.__db.beginTransaction();
        try {
            _stmt.executeUpdateDelete();
            this.__db.setTransactionSuccessful();
        }
        finally {
            this.__db.endTransaction();
            this.__preparedStmtOfDeleteAllFromChannel.release(_stmt);
        }
    }

    @Override
    public Completable hardDeleteMessage(final String messageId) {
        return Completable.fromCallable((Callable)new Callable<Void>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public Void call() throws Exception {
                SupportSQLiteStatement _stmt = EkoMessageDao_Impl.this.__preparedStmtOfHardDeleteMessage.acquire();
                int _argIndex = 1;
                if (messageId == null) {
                    _stmt.bindNull(_argIndex);
                } else {
                    _stmt.bindString(_argIndex, messageId);
                }
                EkoMessageDao_Impl.this.__db.beginTransaction();
                try {
                    _stmt.executeUpdateDelete();
                    EkoMessageDao_Impl.this.__db.setTransactionSuccessful();
                    Void void_ = null;
                    return void_;
                }
                finally {
                    EkoMessageDao_Impl.this.__db.endTransaction();
                    EkoMessageDao_Impl.this.__preparedStmtOfHardDeleteMessage.release(_stmt);
                }
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void hardDeleteAllFromChannel(String channelId) {
        this.__db.assertNotSuspendingTransaction();
        SupportSQLiteStatement _stmt = this.__preparedStmtOfDeleteAllFromChannel.acquire();
        int _argIndex = 1;
        if (channelId == null) {
            _stmt.bindNull(_argIndex);
        } else {
            _stmt.bindString(_argIndex, channelId);
        }
        this.__db.beginTransaction();
        try {
            _stmt.executeUpdateDelete();
            this.__db.setTransactionSuccessful();
        }
        finally {
            this.__db.endTransaction();
            this.__preparedStmtOfDeleteAllFromChannel.release(_stmt);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void softDeleteFromChannelByUserIdImpl(String channelId, String userId) {
        this.__db.assertNotSuspendingTransaction();
        SupportSQLiteStatement _stmt = this.__preparedStmtOfSoftDeleteFromChannelByUserIdImpl.acquire();
        int _argIndex = 1;
        if (channelId == null) {
            _stmt.bindNull(_argIndex);
        } else {
            _stmt.bindString(_argIndex, channelId);
        }
        _argIndex = 2;
        if (userId == null) {
            _stmt.bindNull(_argIndex);
        } else {
            _stmt.bindString(_argIndex, userId);
        }
        this.__db.beginTransaction();
        try {
            _stmt.executeUpdateDelete();
            this.__db.setTransactionSuccessful();
        }
        finally {
            this.__db.endTransaction();
            this.__preparedStmtOfSoftDeleteFromChannelByUserIdImpl.release(_stmt);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void updateUserImpl(String userId) {
        this.__db.assertNotSuspendingTransaction();
        SupportSQLiteStatement _stmt = this.__preparedStmtOfUpdateUserImpl.acquire();
        int _argIndex = 1;
        if (userId == null) {
            _stmt.bindNull(_argIndex);
        } else {
            _stmt.bindString(_argIndex, userId);
        }
        _argIndex = 2;
        if (userId == null) {
            _stmt.bindNull(_argIndex);
        } else {
            _stmt.bindString(_argIndex, userId);
        }
        this.__db.beginTransaction();
        try {
            _stmt.executeUpdateDelete();
            this.__db.setTransactionSuccessful();
        }
        finally {
            this.__db.endTransaction();
            this.__preparedStmtOfUpdateUserImpl.release(_stmt);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void updateMarkerHash(String messageId, int hash) {
        this.__db.assertNotSuspendingTransaction();
        SupportSQLiteStatement _stmt = this.__preparedStmtOfUpdateMarkerHash.acquire();
        int _argIndex = 1;
        _stmt.bindLong(_argIndex, (long)hash);
        _argIndex = 2;
        if (messageId == null) {
            _stmt.bindNull(_argIndex);
        } else {
            _stmt.bindString(_argIndex, messageId);
        }
        this.__db.beginTransaction();
        try {
            _stmt.executeUpdateDelete();
            this.__db.setTransactionSuccessful();
        }
        finally {
            this.__db.endTransaction();
            this.__preparedStmtOfUpdateMarkerHash.release(_stmt);
        }
    }

    @Override
    public Flowable<EkoMessageEntity> getLatestMessageImpl(String subChannelId, Boolean isDeleted) {
        Integer _tmp_1;
        Integer _tmp;
        String _sql = "SELECT message.* from message where message.subChannelId = ? and message.isDeleted = case when ? is not null then ? else isDeleted end order by channelSegment DESC LIMIT 1";
        final RoomSQLiteQuery _statement = RoomSQLiteQuery.acquire((String)"SELECT message.* from message where message.subChannelId = ? and message.isDeleted = case when ? is not null then ? else isDeleted end order by channelSegment DESC LIMIT 1", (int)3);
        int _argIndex = 1;
        if (subChannelId == null) {
            _statement.bindNull(_argIndex);
        } else {
            _statement.bindString(_argIndex, subChannelId);
        }
        _argIndex = 2;
        Integer n = isDeleted == null ? null : (_tmp = Integer.valueOf(isDeleted != false ? 1 : 0));
        if (_tmp == null) {
            _statement.bindNull(_argIndex);
        } else {
            _statement.bindLong(_argIndex, (long)_tmp.intValue());
        }
        _argIndex = 3;
        Integer n2 = isDeleted == null ? null : (_tmp_1 = Integer.valueOf(isDeleted != false ? 1 : 0));
        if (_tmp_1 == null) {
            _statement.bindNull(_argIndex);
        } else {
            _statement.bindLong(_argIndex, (long)_tmp_1.intValue());
        }
        return RxRoom.createFlowable((RoomDatabase)this.__db, (boolean)false, (String[])new String[]{"message"}, (Callable)new Callable<EkoMessageEntity>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public EkoMessageEntity call() throws Exception {
                try (Cursor _cursor = DBUtil.query((RoomDatabase)EkoMessageDao_Impl.this.__db, (SupportSQLiteQuery)_statement, (boolean)false, null);){
                    EkoMessageEntity _result;
                    int _cursorIndexOfUniqueId = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"uniqueId");
                    int _cursorIndexOfMessageId = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"messageId");
                    int _cursorIndexOfSubChannelId = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"subChannelId");
                    int _cursorIndexOfChannelId = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"channelId");
                    int _cursorIndexOfUserId = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"userId");
                    int _cursorIndexOfParentId = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"parentId");
                    int _cursorIndexOfChannelSegment = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"channelSegment");
                    int _cursorIndexOfChildrenNumber = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"childrenNumber");
                    int _cursorIndexOfEditedAt = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"editedAt");
                    int _cursorIndexOfIsDeleted = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"isDeleted");
                    int _cursorIndexOfFlagCount = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"flagCount");
                    int _cursorIndexOfTags = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"tags");
                    int _cursorIndexOfReactions = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"reactions");
                    int _cursorIndexOfReactionCount = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"reactionCount");
                    int _cursorIndexOfType = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"type");
                    int _cursorIndexOfData = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"data");
                    int _cursorIndexOfMetadata = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"metadata");
                    int _cursorIndexOfMentionees = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"mentionees");
                    int _cursorIndexOfPath = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"path");
                    int _cursorIndexOfSyncState = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"syncState");
                    int _cursorIndexOfMessageMarkerHash = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"messageMarkerHash");
                    int _cursorIndexOfCreatedAt = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"createdAt");
                    int _cursorIndexOfUpdatedAt = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"updatedAt");
                    int _cursorIndexOfExpiresAt = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"expiresAt");
                    if (_cursor.moveToFirst()) {
                        _result = new EkoMessageEntity();
                        String _tmpUniqueId = _cursor.isNull(_cursorIndexOfUniqueId) ? null : _cursor.getString(_cursorIndexOfUniqueId);
                        _result.setUniqueId(_tmpUniqueId);
                        String _tmpMessageId = _cursor.isNull(_cursorIndexOfMessageId) ? null : _cursor.getString(_cursorIndexOfMessageId);
                        _result.setMessageId(_tmpMessageId);
                        String _tmpSubChannelId = _cursor.isNull(_cursorIndexOfSubChannelId) ? null : _cursor.getString(_cursorIndexOfSubChannelId);
                        _result.setSubChannelId(_tmpSubChannelId);
                        String _tmpChannelId = _cursor.isNull(_cursorIndexOfChannelId) ? null : _cursor.getString(_cursorIndexOfChannelId);
                        _result.setChannelId(_tmpChannelId);
                        String _tmpUserId = _cursor.isNull(_cursorIndexOfUserId) ? null : _cursor.getString(_cursorIndexOfUserId);
                        _result.setUserId(_tmpUserId);
                        String _tmpParentId = _cursor.isNull(_cursorIndexOfParentId) ? null : _cursor.getString(_cursorIndexOfParentId);
                        _result.setParentId(_tmpParentId);
                        int _tmpChannelSegment = _cursor.getInt(_cursorIndexOfChannelSegment);
                        _result.setChannelSegment(_tmpChannelSegment);
                        int _tmpChildrenNumber = _cursor.getInt(_cursorIndexOfChildrenNumber);
                        _result.setChildrenNumber(_tmpChildrenNumber);
                        String _tmp_2 = _cursor.isNull(_cursorIndexOfEditedAt) ? null : _cursor.getString(_cursorIndexOfEditedAt);
                        DateTime _tmpEditedAt = EkoMessageDao_Impl.this.__dateTimeTypeConverter.stringToDateTime(_tmp_2);
                        _result.setEditedAt(_tmpEditedAt);
                        int _tmp_3 = _cursor.getInt(_cursorIndexOfIsDeleted);
                        boolean _tmpIsDeleted = _tmp_3 != 0;
                        _result.setDeleted(_tmpIsDeleted);
                        int _tmpFlagCount = _cursor.getInt(_cursorIndexOfFlagCount);
                        _result.setFlagCount(_tmpFlagCount);
                        String _tmp_4 = _cursor.isNull(_cursorIndexOfTags) ? null : _cursor.getString(_cursorIndexOfTags);
                        AmityTags _tmpTags = EkoMessageDao_Impl.this.__ekoTagsTypeConverter.stringToEkoTags(_tmp_4);
                        _result.setTags(_tmpTags);
                        String _tmp_5 = _cursor.isNull(_cursorIndexOfReactions) ? null : _cursor.getString(_cursorIndexOfReactions);
                        AmityReactionMap _tmpReactions = EkoMessageDao_Impl.this.__ekoReactionMapConverter.stringToStringIntMap(_tmp_5);
                        _result.setReactions(_tmpReactions);
                        int _tmpReactionCount = _cursor.getInt(_cursorIndexOfReactionCount);
                        _result.setReactionCount(_tmpReactionCount);
                        String _tmpType = _cursor.isNull(_cursorIndexOfType) ? null : _cursor.getString(_cursorIndexOfType);
                        _result.setType(_tmpType);
                        String _tmp_6 = _cursor.isNull(_cursorIndexOfData) ? null : _cursor.getString(_cursorIndexOfData);
                        JsonObject _tmpData = EkoMessageDao_Impl.this.__jsonObjectTypeConverter.stringToJsonObject(_tmp_6);
                        _result.setData(_tmpData);
                        String _tmp_7 = _cursor.isNull(_cursorIndexOfMetadata) ? null : _cursor.getString(_cursorIndexOfMetadata);
                        JsonObject _tmpMetadata = EkoMessageDao_Impl.this.__jsonObjectTypeConverter.stringToJsonObject(_tmp_7);
                        _result.setMetadata(_tmpMetadata);
                        String _tmp_8 = _cursor.isNull(_cursorIndexOfMentionees) ? null : _cursor.getString(_cursorIndexOfMentionees);
                        List<EkoMentioneesDto> _tmpMentionees = EkoMessageDao_Impl.this.__mentioneesConverter.jsonToMentionees(_tmp_8);
                        _result.setMentionees(_tmpMentionees);
                        String _tmpPath = _cursor.isNull(_cursorIndexOfPath) ? null : _cursor.getString(_cursorIndexOfPath);
                        _result.setPath(_tmpPath);
                        String _tmpSyncState = _cursor.isNull(_cursorIndexOfSyncState) ? null : _cursor.getString(_cursorIndexOfSyncState);
                        _result.setSyncState(_tmpSyncState);
                        int _tmpMessageMarkerHash = _cursor.getInt(_cursorIndexOfMessageMarkerHash);
                        _result.setMessageMarkerHash(_tmpMessageMarkerHash);
                        String _tmp_9 = _cursor.isNull(_cursorIndexOfCreatedAt) ? null : _cursor.getString(_cursorIndexOfCreatedAt);
                        DateTime _tmpCreatedAt = EkoMessageDao_Impl.this.__dateTimeTypeConverter.stringToDateTime(_tmp_9);
                        _result.setCreatedAt(_tmpCreatedAt);
                        String _tmp_10 = _cursor.isNull(_cursorIndexOfUpdatedAt) ? null : _cursor.getString(_cursorIndexOfUpdatedAt);
                        DateTime _tmpUpdatedAt = EkoMessageDao_Impl.this.__dateTimeTypeConverter.stringToDateTime(_tmp_10);
                        _result.setUpdatedAt(_tmpUpdatedAt);
                        String _tmp_11 = _cursor.isNull(_cursorIndexOfExpiresAt) ? null : _cursor.getString(_cursorIndexOfExpiresAt);
                        DateTime _tmpExpiresAt = EkoMessageDao_Impl.this.__dateTimeTypeConverter.stringToDateTime(_tmp_11);
                        _result.setExpiresAt(_tmpExpiresAt);
                    } else {
                        _result = null;
                    }
                    EkoMessageEntity ekoMessageEntity = _result;
                    return ekoMessageEntity;
                }
            }

            protected void finalize() {
                _statement.release();
            }
        });
    }

    @Override
    public Flowable<EkoMessageEntity> getLatestMessageImpl(String subChannelId, Boolean isFilterByParentId, String parentId, boolean isIncludingTags, String[] includingTags, boolean isExcludingTags, String[] excludingTags, Boolean isDeleted, int hash, int nonce, DateTime now) {
        Integer _tmp_5;
        Integer _tmp_4;
        Integer _tmp_1;
        Integer _tmp;
        StringBuilder _stringBuilder = StringUtil.newStringBuilder();
        _stringBuilder.append("SELECT * from message where message.subChannelId = ");
        _stringBuilder.append("?");
        _stringBuilder.append(" and case when ");
        _stringBuilder.append("?");
        _stringBuilder.append(" and ");
        _stringBuilder.append("?");
        _stringBuilder.append(" is not null then message.parentId = ");
        _stringBuilder.append("?");
        _stringBuilder.append("  when ");
        _stringBuilder.append("?");
        _stringBuilder.append(" and ");
        _stringBuilder.append("?");
        _stringBuilder.append(" is null then message.parentId is null  else message.messageId is not null end and case when ");
        _stringBuilder.append("?");
        _stringBuilder.append(" then message.messageId in (SELECT messageId from message_tag where tagName in (");
        int _inputSize = includingTags.length;
        StringUtil.appendPlaceholders((StringBuilder)_stringBuilder, (int)_inputSize);
        _stringBuilder.append(")) else message.messageId is not null end and case when ");
        _stringBuilder.append("?");
        _stringBuilder.append(" then message.messageId not in (SELECT messageId from message_tag where tagName in (");
        int _inputSize_1 = excludingTags.length;
        StringUtil.appendPlaceholders((StringBuilder)_stringBuilder, (int)_inputSize_1);
        _stringBuilder.append(")) else message.messageId is not null end and case when ");
        _stringBuilder.append("?");
        _stringBuilder.append(" is not null then message.isDeleted = ");
        _stringBuilder.append("?");
        _stringBuilder.append(" else message.messageId is not null end and message.updatedAt > ");
        _stringBuilder.append("?");
        _stringBuilder.append(" and message.uniqueId not in (SELECT amity_paging_id.id from amity_paging_id where amity_paging_id.hash = (");
        _stringBuilder.append("?");
        _stringBuilder.append(") and amity_paging_id.nonce = (");
        _stringBuilder.append("?");
        _stringBuilder.append(") ) order by message.updatedAt desc limit 1");
        String _sql = _stringBuilder.toString();
        int _argCount = 13 + _inputSize + _inputSize_1;
        final RoomSQLiteQuery _statement = RoomSQLiteQuery.acquire((String)_sql, (int)_argCount);
        int _argIndex = 1;
        if (subChannelId == null) {
            _statement.bindNull(_argIndex);
        } else {
            _statement.bindString(_argIndex, subChannelId);
        }
        _argIndex = 2;
        Integer n = isFilterByParentId == null ? null : (_tmp = Integer.valueOf(isFilterByParentId != false ? 1 : 0));
        if (_tmp == null) {
            _statement.bindNull(_argIndex);
        } else {
            _statement.bindLong(_argIndex, (long)_tmp.intValue());
        }
        _argIndex = 3;
        if (parentId == null) {
            _statement.bindNull(_argIndex);
        } else {
            _statement.bindString(_argIndex, parentId);
        }
        _argIndex = 4;
        if (parentId == null) {
            _statement.bindNull(_argIndex);
        } else {
            _statement.bindString(_argIndex, parentId);
        }
        _argIndex = 5;
        Integer n2 = isFilterByParentId == null ? null : (_tmp_1 = Integer.valueOf(isFilterByParentId != false ? 1 : 0));
        if (_tmp_1 == null) {
            _statement.bindNull(_argIndex);
        } else {
            _statement.bindLong(_argIndex, (long)_tmp_1.intValue());
        }
        _argIndex = 6;
        if (parentId == null) {
            _statement.bindNull(_argIndex);
        } else {
            _statement.bindString(_argIndex, parentId);
        }
        _argIndex = 7;
        int _tmp_2 = isIncludingTags ? 1 : 0;
        _statement.bindLong(_argIndex, (long)_tmp_2);
        _argIndex = 8;
        for (String _item : includingTags) {
            if (_item == null) {
                _statement.bindNull(_argIndex);
            } else {
                _statement.bindString(_argIndex, _item);
            }
            ++_argIndex;
        }
        _argIndex = 8 + _inputSize;
        int _tmp_3 = isExcludingTags ? 1 : 0;
        _statement.bindLong(_argIndex, (long)_tmp_3);
        _argIndex = 9 + _inputSize;
        for (String _item_1 : excludingTags) {
            if (_item_1 == null) {
                _statement.bindNull(_argIndex);
            } else {
                _statement.bindString(_argIndex, _item_1);
            }
            ++_argIndex;
        }
        _argIndex = 9 + _inputSize + _inputSize_1;
        Integer n3 = isDeleted == null ? null : (_tmp_4 = Integer.valueOf(isDeleted != false ? 1 : 0));
        if (_tmp_4 == null) {
            _statement.bindNull(_argIndex);
        } else {
            _statement.bindLong(_argIndex, (long)_tmp_4.intValue());
        }
        _argIndex = 10 + _inputSize + _inputSize_1;
        Integer n4 = isDeleted == null ? null : (_tmp_5 = Integer.valueOf(isDeleted != false ? 1 : 0));
        if (_tmp_5 == null) {
            _statement.bindNull(_argIndex);
        } else {
            _statement.bindLong(_argIndex, (long)_tmp_5.intValue());
        }
        _argIndex = 11 + _inputSize + _inputSize_1;
        String _tmp_6 = this.__dateTimeTypeConverter.dateTimeToString(now);
        if (_tmp_6 == null) {
            _statement.bindNull(_argIndex);
        } else {
            _statement.bindString(_argIndex, _tmp_6);
        }
        _argIndex = 12 + _inputSize + _inputSize_1;
        _statement.bindLong(_argIndex, (long)hash);
        _argIndex = 13 + _inputSize + _inputSize_1;
        _statement.bindLong(_argIndex, (long)nonce);
        return RxRoom.createFlowable((RoomDatabase)this.__db, (boolean)false, (String[])new String[]{"message", "message_tag", "amity_paging_id"}, (Callable)new Callable<EkoMessageEntity>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public EkoMessageEntity call() throws Exception {
                try (Cursor _cursor = DBUtil.query((RoomDatabase)EkoMessageDao_Impl.this.__db, (SupportSQLiteQuery)_statement, (boolean)false, null);){
                    EkoMessageEntity _result;
                    int _cursorIndexOfUniqueId = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"uniqueId");
                    int _cursorIndexOfMessageId = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"messageId");
                    int _cursorIndexOfSubChannelId = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"subChannelId");
                    int _cursorIndexOfChannelId = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"channelId");
                    int _cursorIndexOfUserId = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"userId");
                    int _cursorIndexOfParentId = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"parentId");
                    int _cursorIndexOfChannelSegment = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"channelSegment");
                    int _cursorIndexOfChildrenNumber = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"childrenNumber");
                    int _cursorIndexOfEditedAt = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"editedAt");
                    int _cursorIndexOfIsDeleted = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"isDeleted");
                    int _cursorIndexOfFlagCount = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"flagCount");
                    int _cursorIndexOfTags = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"tags");
                    int _cursorIndexOfReactions = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"reactions");
                    int _cursorIndexOfReactionCount = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"reactionCount");
                    int _cursorIndexOfType = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"type");
                    int _cursorIndexOfData = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"data");
                    int _cursorIndexOfMetadata = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"metadata");
                    int _cursorIndexOfMentionees = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"mentionees");
                    int _cursorIndexOfPath = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"path");
                    int _cursorIndexOfSyncState = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"syncState");
                    int _cursorIndexOfMessageMarkerHash = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"messageMarkerHash");
                    int _cursorIndexOfCreatedAt = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"createdAt");
                    int _cursorIndexOfUpdatedAt = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"updatedAt");
                    int _cursorIndexOfExpiresAt = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"expiresAt");
                    if (_cursor.moveToFirst()) {
                        _result = new EkoMessageEntity();
                        String _tmpUniqueId = _cursor.isNull(_cursorIndexOfUniqueId) ? null : _cursor.getString(_cursorIndexOfUniqueId);
                        _result.setUniqueId(_tmpUniqueId);
                        String _tmpMessageId = _cursor.isNull(_cursorIndexOfMessageId) ? null : _cursor.getString(_cursorIndexOfMessageId);
                        _result.setMessageId(_tmpMessageId);
                        String _tmpSubChannelId = _cursor.isNull(_cursorIndexOfSubChannelId) ? null : _cursor.getString(_cursorIndexOfSubChannelId);
                        _result.setSubChannelId(_tmpSubChannelId);
                        String _tmpChannelId = _cursor.isNull(_cursorIndexOfChannelId) ? null : _cursor.getString(_cursorIndexOfChannelId);
                        _result.setChannelId(_tmpChannelId);
                        String _tmpUserId = _cursor.isNull(_cursorIndexOfUserId) ? null : _cursor.getString(_cursorIndexOfUserId);
                        _result.setUserId(_tmpUserId);
                        String _tmpParentId = _cursor.isNull(_cursorIndexOfParentId) ? null : _cursor.getString(_cursorIndexOfParentId);
                        _result.setParentId(_tmpParentId);
                        int _tmpChannelSegment = _cursor.getInt(_cursorIndexOfChannelSegment);
                        _result.setChannelSegment(_tmpChannelSegment);
                        int _tmpChildrenNumber = _cursor.getInt(_cursorIndexOfChildrenNumber);
                        _result.setChildrenNumber(_tmpChildrenNumber);
                        String _tmp_7 = _cursor.isNull(_cursorIndexOfEditedAt) ? null : _cursor.getString(_cursorIndexOfEditedAt);
                        DateTime _tmpEditedAt = EkoMessageDao_Impl.this.__dateTimeTypeConverter.stringToDateTime(_tmp_7);
                        _result.setEditedAt(_tmpEditedAt);
                        int _tmp_8 = _cursor.getInt(_cursorIndexOfIsDeleted);
                        boolean _tmpIsDeleted = _tmp_8 != 0;
                        _result.setDeleted(_tmpIsDeleted);
                        int _tmpFlagCount = _cursor.getInt(_cursorIndexOfFlagCount);
                        _result.setFlagCount(_tmpFlagCount);
                        String _tmp_9 = _cursor.isNull(_cursorIndexOfTags) ? null : _cursor.getString(_cursorIndexOfTags);
                        AmityTags _tmpTags = EkoMessageDao_Impl.this.__ekoTagsTypeConverter.stringToEkoTags(_tmp_9);
                        _result.setTags(_tmpTags);
                        String _tmp_10 = _cursor.isNull(_cursorIndexOfReactions) ? null : _cursor.getString(_cursorIndexOfReactions);
                        AmityReactionMap _tmpReactions = EkoMessageDao_Impl.this.__ekoReactionMapConverter.stringToStringIntMap(_tmp_10);
                        _result.setReactions(_tmpReactions);
                        int _tmpReactionCount = _cursor.getInt(_cursorIndexOfReactionCount);
                        _result.setReactionCount(_tmpReactionCount);
                        String _tmpType = _cursor.isNull(_cursorIndexOfType) ? null : _cursor.getString(_cursorIndexOfType);
                        _result.setType(_tmpType);
                        String _tmp_11 = _cursor.isNull(_cursorIndexOfData) ? null : _cursor.getString(_cursorIndexOfData);
                        JsonObject _tmpData = EkoMessageDao_Impl.this.__jsonObjectTypeConverter.stringToJsonObject(_tmp_11);
                        _result.setData(_tmpData);
                        String _tmp_12 = _cursor.isNull(_cursorIndexOfMetadata) ? null : _cursor.getString(_cursorIndexOfMetadata);
                        JsonObject _tmpMetadata = EkoMessageDao_Impl.this.__jsonObjectTypeConverter.stringToJsonObject(_tmp_12);
                        _result.setMetadata(_tmpMetadata);
                        String _tmp_13 = _cursor.isNull(_cursorIndexOfMentionees) ? null : _cursor.getString(_cursorIndexOfMentionees);
                        List<EkoMentioneesDto> _tmpMentionees = EkoMessageDao_Impl.this.__mentioneesConverter.jsonToMentionees(_tmp_13);
                        _result.setMentionees(_tmpMentionees);
                        String _tmpPath = _cursor.isNull(_cursorIndexOfPath) ? null : _cursor.getString(_cursorIndexOfPath);
                        _result.setPath(_tmpPath);
                        String _tmpSyncState = _cursor.isNull(_cursorIndexOfSyncState) ? null : _cursor.getString(_cursorIndexOfSyncState);
                        _result.setSyncState(_tmpSyncState);
                        int _tmpMessageMarkerHash = _cursor.getInt(_cursorIndexOfMessageMarkerHash);
                        _result.setMessageMarkerHash(_tmpMessageMarkerHash);
                        String _tmp_14 = _cursor.isNull(_cursorIndexOfCreatedAt) ? null : _cursor.getString(_cursorIndexOfCreatedAt);
                        DateTime _tmpCreatedAt = EkoMessageDao_Impl.this.__dateTimeTypeConverter.stringToDateTime(_tmp_14);
                        _result.setCreatedAt(_tmpCreatedAt);
                        String _tmp_15 = _cursor.isNull(_cursorIndexOfUpdatedAt) ? null : _cursor.getString(_cursorIndexOfUpdatedAt);
                        DateTime _tmpUpdatedAt = EkoMessageDao_Impl.this.__dateTimeTypeConverter.stringToDateTime(_tmp_15);
                        _result.setUpdatedAt(_tmpUpdatedAt);
                        String _tmp_16 = _cursor.isNull(_cursorIndexOfExpiresAt) ? null : _cursor.getString(_cursorIndexOfExpiresAt);
                        DateTime _tmpExpiresAt = EkoMessageDao_Impl.this.__dateTimeTypeConverter.stringToDateTime(_tmp_16);
                        _result.setExpiresAt(_tmpExpiresAt);
                    } else {
                        _result = null;
                    }
                    EkoMessageEntity ekoMessageEntity = _result;
                    return ekoMessageEntity;
                }
            }

            protected void finalize() {
                _statement.release();
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int getHighestSegment(String subChannelId) {
        String _sql = "SELECT channelSegment from message where subChannelId = ? and syncState = 'synced' order by channelSegment DESC LIMIT 1";
        RoomSQLiteQuery _statement = RoomSQLiteQuery.acquire((String)"SELECT channelSegment from message where subChannelId = ? and syncState = 'synced' order by channelSegment DESC LIMIT 1", (int)1);
        int _argIndex = 1;
        if (subChannelId == null) {
            _statement.bindNull(_argIndex);
        } else {
            _statement.bindString(_argIndex, subChannelId);
        }
        this.__db.assertNotSuspendingTransaction();
        Cursor _cursor = DBUtil.query((RoomDatabase)this.__db, (SupportSQLiteQuery)_statement, (boolean)false, null);
        try {
            int _result = _cursor.moveToFirst() ? _cursor.getInt(0) : 0;
            int n = _result;
            return n;
        }
        finally {
            _cursor.close();
            _statement.release();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<EkoMessageEntity> getOldMessages(String channelId, int offset) {
        String _sql = "SELECT * from message where channelId = ? order by createdAt DESC LIMIT -1 OFFSET ?";
        RoomSQLiteQuery _statement = RoomSQLiteQuery.acquire((String)"SELECT * from message where channelId = ? order by createdAt DESC LIMIT -1 OFFSET ?", (int)2);
        int _argIndex = 1;
        if (channelId == null) {
            _statement.bindNull(_argIndex);
        } else {
            _statement.bindString(_argIndex, channelId);
        }
        _argIndex = 2;
        _statement.bindLong(_argIndex, (long)offset);
        this.__db.assertNotSuspendingTransaction();
        Cursor _cursor = DBUtil.query((RoomDatabase)this.__db, (SupportSQLiteQuery)_statement, (boolean)false, null);
        try {
            int _cursorIndexOfUniqueId = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"uniqueId");
            int _cursorIndexOfMessageId = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"messageId");
            int _cursorIndexOfSubChannelId = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"subChannelId");
            int _cursorIndexOfChannelId = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"channelId");
            int _cursorIndexOfUserId = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"userId");
            int _cursorIndexOfParentId = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"parentId");
            int _cursorIndexOfChannelSegment = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"channelSegment");
            int _cursorIndexOfChildrenNumber = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"childrenNumber");
            int _cursorIndexOfEditedAt = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"editedAt");
            int _cursorIndexOfIsDeleted = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"isDeleted");
            int _cursorIndexOfFlagCount = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"flagCount");
            int _cursorIndexOfTags = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"tags");
            int _cursorIndexOfReactions = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"reactions");
            int _cursorIndexOfReactionCount = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"reactionCount");
            int _cursorIndexOfType = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"type");
            int _cursorIndexOfData = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"data");
            int _cursorIndexOfMetadata = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"metadata");
            int _cursorIndexOfMentionees = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"mentionees");
            int _cursorIndexOfPath = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"path");
            int _cursorIndexOfSyncState = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"syncState");
            int _cursorIndexOfMessageMarkerHash = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"messageMarkerHash");
            int _cursorIndexOfCreatedAt = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"createdAt");
            int _cursorIndexOfUpdatedAt = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"updatedAt");
            int _cursorIndexOfExpiresAt = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"expiresAt");
            ArrayList<EkoMessageEntity> _result = new ArrayList<EkoMessageEntity>(_cursor.getCount());
            while (_cursor.moveToNext()) {
                EkoMessageEntity _item = new EkoMessageEntity();
                String _tmpUniqueId = _cursor.isNull(_cursorIndexOfUniqueId) ? null : _cursor.getString(_cursorIndexOfUniqueId);
                _item.setUniqueId(_tmpUniqueId);
                String _tmpMessageId = _cursor.isNull(_cursorIndexOfMessageId) ? null : _cursor.getString(_cursorIndexOfMessageId);
                _item.setMessageId(_tmpMessageId);
                String _tmpSubChannelId = _cursor.isNull(_cursorIndexOfSubChannelId) ? null : _cursor.getString(_cursorIndexOfSubChannelId);
                _item.setSubChannelId(_tmpSubChannelId);
                String _tmpChannelId = _cursor.isNull(_cursorIndexOfChannelId) ? null : _cursor.getString(_cursorIndexOfChannelId);
                _item.setChannelId(_tmpChannelId);
                String _tmpUserId = _cursor.isNull(_cursorIndexOfUserId) ? null : _cursor.getString(_cursorIndexOfUserId);
                _item.setUserId(_tmpUserId);
                String _tmpParentId = _cursor.isNull(_cursorIndexOfParentId) ? null : _cursor.getString(_cursorIndexOfParentId);
                _item.setParentId(_tmpParentId);
                int _tmpChannelSegment = _cursor.getInt(_cursorIndexOfChannelSegment);
                _item.setChannelSegment(_tmpChannelSegment);
                int _tmpChildrenNumber = _cursor.getInt(_cursorIndexOfChildrenNumber);
                _item.setChildrenNumber(_tmpChildrenNumber);
                String _tmp = _cursor.isNull(_cursorIndexOfEditedAt) ? null : _cursor.getString(_cursorIndexOfEditedAt);
                DateTime _tmpEditedAt = this.__dateTimeTypeConverter.stringToDateTime(_tmp);
                _item.setEditedAt(_tmpEditedAt);
                int _tmp_1 = _cursor.getInt(_cursorIndexOfIsDeleted);
                boolean _tmpIsDeleted = _tmp_1 != 0;
                _item.setDeleted(_tmpIsDeleted);
                int _tmpFlagCount = _cursor.getInt(_cursorIndexOfFlagCount);
                _item.setFlagCount(_tmpFlagCount);
                String _tmp_2 = _cursor.isNull(_cursorIndexOfTags) ? null : _cursor.getString(_cursorIndexOfTags);
                AmityTags _tmpTags = this.__ekoTagsTypeConverter.stringToEkoTags(_tmp_2);
                _item.setTags(_tmpTags);
                String _tmp_3 = _cursor.isNull(_cursorIndexOfReactions) ? null : _cursor.getString(_cursorIndexOfReactions);
                AmityReactionMap _tmpReactions = this.__ekoReactionMapConverter.stringToStringIntMap(_tmp_3);
                _item.setReactions(_tmpReactions);
                int _tmpReactionCount = _cursor.getInt(_cursorIndexOfReactionCount);
                _item.setReactionCount(_tmpReactionCount);
                String _tmpType = _cursor.isNull(_cursorIndexOfType) ? null : _cursor.getString(_cursorIndexOfType);
                _item.setType(_tmpType);
                String _tmp_4 = _cursor.isNull(_cursorIndexOfData) ? null : _cursor.getString(_cursorIndexOfData);
                JsonObject _tmpData = this.__jsonObjectTypeConverter.stringToJsonObject(_tmp_4);
                _item.setData(_tmpData);
                String _tmp_5 = _cursor.isNull(_cursorIndexOfMetadata) ? null : _cursor.getString(_cursorIndexOfMetadata);
                JsonObject _tmpMetadata = this.__jsonObjectTypeConverter.stringToJsonObject(_tmp_5);
                _item.setMetadata(_tmpMetadata);
                String _tmp_6 = _cursor.isNull(_cursorIndexOfMentionees) ? null : _cursor.getString(_cursorIndexOfMentionees);
                List<EkoMentioneesDto> _tmpMentionees = this.__mentioneesConverter.jsonToMentionees(_tmp_6);
                _item.setMentionees(_tmpMentionees);
                String _tmpPath = _cursor.isNull(_cursorIndexOfPath) ? null : _cursor.getString(_cursorIndexOfPath);
                _item.setPath(_tmpPath);
                String _tmpSyncState = _cursor.isNull(_cursorIndexOfSyncState) ? null : _cursor.getString(_cursorIndexOfSyncState);
                _item.setSyncState(_tmpSyncState);
                int _tmpMessageMarkerHash = _cursor.getInt(_cursorIndexOfMessageMarkerHash);
                _item.setMessageMarkerHash(_tmpMessageMarkerHash);
                String _tmp_7 = _cursor.isNull(_cursorIndexOfCreatedAt) ? null : _cursor.getString(_cursorIndexOfCreatedAt);
                DateTime _tmpCreatedAt = this.__dateTimeTypeConverter.stringToDateTime(_tmp_7);
                _item.setCreatedAt(_tmpCreatedAt);
                String _tmp_8 = _cursor.isNull(_cursorIndexOfUpdatedAt) ? null : _cursor.getString(_cursorIndexOfUpdatedAt);
                DateTime _tmpUpdatedAt = this.__dateTimeTypeConverter.stringToDateTime(_tmp_8);
                _item.setUpdatedAt(_tmpUpdatedAt);
                String _tmp_9 = _cursor.isNull(_cursorIndexOfExpiresAt) ? null : _cursor.getString(_cursorIndexOfExpiresAt);
                DateTime _tmpExpiresAt = this.__dateTimeTypeConverter.stringToDateTime(_tmp_9);
                _item.setExpiresAt(_tmpExpiresAt);
                _result.add(_item);
            }
            ArrayList<EkoMessageEntity> arrayList = _result;
            return arrayList;
        }
        finally {
            _cursor.close();
            _statement.release();
        }
    }

    @Override
    public Flowable<EkoMessageEntity> getByIdImpl(String messageId) {
        String _sql = "SELECT message.* from message where message.messageId = ? LIMIT 1";
        final RoomSQLiteQuery _statement = RoomSQLiteQuery.acquire((String)"SELECT message.* from message where message.messageId = ? LIMIT 1", (int)1);
        int _argIndex = 1;
        if (messageId == null) {
            _statement.bindNull(_argIndex);
        } else {
            _statement.bindString(_argIndex, messageId);
        }
        return RxRoom.createFlowable((RoomDatabase)this.__db, (boolean)false, (String[])new String[]{"message"}, (Callable)new Callable<EkoMessageEntity>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public EkoMessageEntity call() throws Exception {
                try (Cursor _cursor = DBUtil.query((RoomDatabase)EkoMessageDao_Impl.this.__db, (SupportSQLiteQuery)_statement, (boolean)false, null);){
                    EkoMessageEntity _result;
                    int _cursorIndexOfUniqueId = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"uniqueId");
                    int _cursorIndexOfMessageId = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"messageId");
                    int _cursorIndexOfSubChannelId = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"subChannelId");
                    int _cursorIndexOfChannelId = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"channelId");
                    int _cursorIndexOfUserId = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"userId");
                    int _cursorIndexOfParentId = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"parentId");
                    int _cursorIndexOfChannelSegment = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"channelSegment");
                    int _cursorIndexOfChildrenNumber = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"childrenNumber");
                    int _cursorIndexOfEditedAt = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"editedAt");
                    int _cursorIndexOfIsDeleted = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"isDeleted");
                    int _cursorIndexOfFlagCount = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"flagCount");
                    int _cursorIndexOfTags = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"tags");
                    int _cursorIndexOfReactions = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"reactions");
                    int _cursorIndexOfReactionCount = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"reactionCount");
                    int _cursorIndexOfType = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"type");
                    int _cursorIndexOfData = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"data");
                    int _cursorIndexOfMetadata = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"metadata");
                    int _cursorIndexOfMentionees = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"mentionees");
                    int _cursorIndexOfPath = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"path");
                    int _cursorIndexOfSyncState = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"syncState");
                    int _cursorIndexOfMessageMarkerHash = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"messageMarkerHash");
                    int _cursorIndexOfCreatedAt = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"createdAt");
                    int _cursorIndexOfUpdatedAt = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"updatedAt");
                    int _cursorIndexOfExpiresAt = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"expiresAt");
                    if (_cursor.moveToFirst()) {
                        _result = new EkoMessageEntity();
                        String _tmpUniqueId = _cursor.isNull(_cursorIndexOfUniqueId) ? null : _cursor.getString(_cursorIndexOfUniqueId);
                        _result.setUniqueId(_tmpUniqueId);
                        String _tmpMessageId = _cursor.isNull(_cursorIndexOfMessageId) ? null : _cursor.getString(_cursorIndexOfMessageId);
                        _result.setMessageId(_tmpMessageId);
                        String _tmpSubChannelId = _cursor.isNull(_cursorIndexOfSubChannelId) ? null : _cursor.getString(_cursorIndexOfSubChannelId);
                        _result.setSubChannelId(_tmpSubChannelId);
                        String _tmpChannelId = _cursor.isNull(_cursorIndexOfChannelId) ? null : _cursor.getString(_cursorIndexOfChannelId);
                        _result.setChannelId(_tmpChannelId);
                        String _tmpUserId = _cursor.isNull(_cursorIndexOfUserId) ? null : _cursor.getString(_cursorIndexOfUserId);
                        _result.setUserId(_tmpUserId);
                        String _tmpParentId = _cursor.isNull(_cursorIndexOfParentId) ? null : _cursor.getString(_cursorIndexOfParentId);
                        _result.setParentId(_tmpParentId);
                        int _tmpChannelSegment = _cursor.getInt(_cursorIndexOfChannelSegment);
                        _result.setChannelSegment(_tmpChannelSegment);
                        int _tmpChildrenNumber = _cursor.getInt(_cursorIndexOfChildrenNumber);
                        _result.setChildrenNumber(_tmpChildrenNumber);
                        String _tmp = _cursor.isNull(_cursorIndexOfEditedAt) ? null : _cursor.getString(_cursorIndexOfEditedAt);
                        DateTime _tmpEditedAt = EkoMessageDao_Impl.this.__dateTimeTypeConverter.stringToDateTime(_tmp);
                        _result.setEditedAt(_tmpEditedAt);
                        int _tmp_1 = _cursor.getInt(_cursorIndexOfIsDeleted);
                        boolean _tmpIsDeleted = _tmp_1 != 0;
                        _result.setDeleted(_tmpIsDeleted);
                        int _tmpFlagCount = _cursor.getInt(_cursorIndexOfFlagCount);
                        _result.setFlagCount(_tmpFlagCount);
                        String _tmp_2 = _cursor.isNull(_cursorIndexOfTags) ? null : _cursor.getString(_cursorIndexOfTags);
                        AmityTags _tmpTags = EkoMessageDao_Impl.this.__ekoTagsTypeConverter.stringToEkoTags(_tmp_2);
                        _result.setTags(_tmpTags);
                        String _tmp_3 = _cursor.isNull(_cursorIndexOfReactions) ? null : _cursor.getString(_cursorIndexOfReactions);
                        AmityReactionMap _tmpReactions = EkoMessageDao_Impl.this.__ekoReactionMapConverter.stringToStringIntMap(_tmp_3);
                        _result.setReactions(_tmpReactions);
                        int _tmpReactionCount = _cursor.getInt(_cursorIndexOfReactionCount);
                        _result.setReactionCount(_tmpReactionCount);
                        String _tmpType = _cursor.isNull(_cursorIndexOfType) ? null : _cursor.getString(_cursorIndexOfType);
                        _result.setType(_tmpType);
                        String _tmp_4 = _cursor.isNull(_cursorIndexOfData) ? null : _cursor.getString(_cursorIndexOfData);
                        JsonObject _tmpData = EkoMessageDao_Impl.this.__jsonObjectTypeConverter.stringToJsonObject(_tmp_4);
                        _result.setData(_tmpData);
                        String _tmp_5 = _cursor.isNull(_cursorIndexOfMetadata) ? null : _cursor.getString(_cursorIndexOfMetadata);
                        JsonObject _tmpMetadata = EkoMessageDao_Impl.this.__jsonObjectTypeConverter.stringToJsonObject(_tmp_5);
                        _result.setMetadata(_tmpMetadata);
                        String _tmp_6 = _cursor.isNull(_cursorIndexOfMentionees) ? null : _cursor.getString(_cursorIndexOfMentionees);
                        List<EkoMentioneesDto> _tmpMentionees = EkoMessageDao_Impl.this.__mentioneesConverter.jsonToMentionees(_tmp_6);
                        _result.setMentionees(_tmpMentionees);
                        String _tmpPath = _cursor.isNull(_cursorIndexOfPath) ? null : _cursor.getString(_cursorIndexOfPath);
                        _result.setPath(_tmpPath);
                        String _tmpSyncState = _cursor.isNull(_cursorIndexOfSyncState) ? null : _cursor.getString(_cursorIndexOfSyncState);
                        _result.setSyncState(_tmpSyncState);
                        int _tmpMessageMarkerHash = _cursor.getInt(_cursorIndexOfMessageMarkerHash);
                        _result.setMessageMarkerHash(_tmpMessageMarkerHash);
                        String _tmp_7 = _cursor.isNull(_cursorIndexOfCreatedAt) ? null : _cursor.getString(_cursorIndexOfCreatedAt);
                        DateTime _tmpCreatedAt = EkoMessageDao_Impl.this.__dateTimeTypeConverter.stringToDateTime(_tmp_7);
                        _result.setCreatedAt(_tmpCreatedAt);
                        String _tmp_8 = _cursor.isNull(_cursorIndexOfUpdatedAt) ? null : _cursor.getString(_cursorIndexOfUpdatedAt);
                        DateTime _tmpUpdatedAt = EkoMessageDao_Impl.this.__dateTimeTypeConverter.stringToDateTime(_tmp_8);
                        _result.setUpdatedAt(_tmpUpdatedAt);
                        String _tmp_9 = _cursor.isNull(_cursorIndexOfExpiresAt) ? null : _cursor.getString(_cursorIndexOfExpiresAt);
                        DateTime _tmpExpiresAt = EkoMessageDao_Impl.this.__dateTimeTypeConverter.stringToDateTime(_tmp_9);
                        _result.setExpiresAt(_tmpExpiresAt);
                    } else {
                        _result = null;
                    }
                    EkoMessageEntity ekoMessageEntity = _result;
                    return ekoMessageEntity;
                }
            }

            protected void finalize() {
                _statement.release();
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String getUniqueIdByMessageIdImpl(String messageId) {
        String _sql = "SELECT message.uniqueId from message where message.messageId = ? LIMIT 1";
        RoomSQLiteQuery _statement = RoomSQLiteQuery.acquire((String)"SELECT message.uniqueId from message where message.messageId = ? LIMIT 1", (int)1);
        int _argIndex = 1;
        if (messageId == null) {
            _statement.bindNull(_argIndex);
        } else {
            _statement.bindString(_argIndex, messageId);
        }
        this.__db.assertNotSuspendingTransaction();
        Cursor _cursor = DBUtil.query((RoomDatabase)this.__db, (SupportSQLiteQuery)_statement, (boolean)false, null);
        try {
            String _result = _cursor.moveToFirst() ? (_cursor.isNull(0) ? null : _cursor.getString(0)) : null;
            String string = _result;
            return string;
        }
        finally {
            _cursor.close();
            _statement.release();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public EkoMessageEntity getByIdNowImpl(String uniqueId) {
        String _sql = "SELECT message.* from message where message.uniqueId = ? LIMIT 1";
        RoomSQLiteQuery _statement = RoomSQLiteQuery.acquire((String)"SELECT message.* from message where message.uniqueId = ? LIMIT 1", (int)1);
        int _argIndex = 1;
        if (uniqueId == null) {
            _statement.bindNull(_argIndex);
        } else {
            _statement.bindString(_argIndex, uniqueId);
        }
        this.__db.assertNotSuspendingTransaction();
        Cursor _cursor = DBUtil.query((RoomDatabase)this.__db, (SupportSQLiteQuery)_statement, (boolean)false, null);
        try {
            EkoMessageEntity _result;
            int _cursorIndexOfUniqueId = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"uniqueId");
            int _cursorIndexOfMessageId = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"messageId");
            int _cursorIndexOfSubChannelId = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"subChannelId");
            int _cursorIndexOfChannelId = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"channelId");
            int _cursorIndexOfUserId = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"userId");
            int _cursorIndexOfParentId = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"parentId");
            int _cursorIndexOfChannelSegment = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"channelSegment");
            int _cursorIndexOfChildrenNumber = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"childrenNumber");
            int _cursorIndexOfEditedAt = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"editedAt");
            int _cursorIndexOfIsDeleted = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"isDeleted");
            int _cursorIndexOfFlagCount = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"flagCount");
            int _cursorIndexOfTags = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"tags");
            int _cursorIndexOfReactions = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"reactions");
            int _cursorIndexOfReactionCount = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"reactionCount");
            int _cursorIndexOfType = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"type");
            int _cursorIndexOfData = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"data");
            int _cursorIndexOfMetadata = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"metadata");
            int _cursorIndexOfMentionees = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"mentionees");
            int _cursorIndexOfPath = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"path");
            int _cursorIndexOfSyncState = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"syncState");
            int _cursorIndexOfMessageMarkerHash = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"messageMarkerHash");
            int _cursorIndexOfCreatedAt = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"createdAt");
            int _cursorIndexOfUpdatedAt = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"updatedAt");
            int _cursorIndexOfExpiresAt = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"expiresAt");
            if (_cursor.moveToFirst()) {
                _result = new EkoMessageEntity();
                String _tmpUniqueId = _cursor.isNull(_cursorIndexOfUniqueId) ? null : _cursor.getString(_cursorIndexOfUniqueId);
                _result.setUniqueId(_tmpUniqueId);
                String _tmpMessageId = _cursor.isNull(_cursorIndexOfMessageId) ? null : _cursor.getString(_cursorIndexOfMessageId);
                _result.setMessageId(_tmpMessageId);
                String _tmpSubChannelId = _cursor.isNull(_cursorIndexOfSubChannelId) ? null : _cursor.getString(_cursorIndexOfSubChannelId);
                _result.setSubChannelId(_tmpSubChannelId);
                String _tmpChannelId = _cursor.isNull(_cursorIndexOfChannelId) ? null : _cursor.getString(_cursorIndexOfChannelId);
                _result.setChannelId(_tmpChannelId);
                String _tmpUserId = _cursor.isNull(_cursorIndexOfUserId) ? null : _cursor.getString(_cursorIndexOfUserId);
                _result.setUserId(_tmpUserId);
                String _tmpParentId = _cursor.isNull(_cursorIndexOfParentId) ? null : _cursor.getString(_cursorIndexOfParentId);
                _result.setParentId(_tmpParentId);
                int _tmpChannelSegment = _cursor.getInt(_cursorIndexOfChannelSegment);
                _result.setChannelSegment(_tmpChannelSegment);
                int _tmpChildrenNumber = _cursor.getInt(_cursorIndexOfChildrenNumber);
                _result.setChildrenNumber(_tmpChildrenNumber);
                String _tmp = _cursor.isNull(_cursorIndexOfEditedAt) ? null : _cursor.getString(_cursorIndexOfEditedAt);
                DateTime _tmpEditedAt = this.__dateTimeTypeConverter.stringToDateTime(_tmp);
                _result.setEditedAt(_tmpEditedAt);
                int _tmp_1 = _cursor.getInt(_cursorIndexOfIsDeleted);
                boolean _tmpIsDeleted = _tmp_1 != 0;
                _result.setDeleted(_tmpIsDeleted);
                int _tmpFlagCount = _cursor.getInt(_cursorIndexOfFlagCount);
                _result.setFlagCount(_tmpFlagCount);
                String _tmp_2 = _cursor.isNull(_cursorIndexOfTags) ? null : _cursor.getString(_cursorIndexOfTags);
                AmityTags _tmpTags = this.__ekoTagsTypeConverter.stringToEkoTags(_tmp_2);
                _result.setTags(_tmpTags);
                String _tmp_3 = _cursor.isNull(_cursorIndexOfReactions) ? null : _cursor.getString(_cursorIndexOfReactions);
                AmityReactionMap _tmpReactions = this.__ekoReactionMapConverter.stringToStringIntMap(_tmp_3);
                _result.setReactions(_tmpReactions);
                int _tmpReactionCount = _cursor.getInt(_cursorIndexOfReactionCount);
                _result.setReactionCount(_tmpReactionCount);
                String _tmpType = _cursor.isNull(_cursorIndexOfType) ? null : _cursor.getString(_cursorIndexOfType);
                _result.setType(_tmpType);
                String _tmp_4 = _cursor.isNull(_cursorIndexOfData) ? null : _cursor.getString(_cursorIndexOfData);
                JsonObject _tmpData = this.__jsonObjectTypeConverter.stringToJsonObject(_tmp_4);
                _result.setData(_tmpData);
                String _tmp_5 = _cursor.isNull(_cursorIndexOfMetadata) ? null : _cursor.getString(_cursorIndexOfMetadata);
                JsonObject _tmpMetadata = this.__jsonObjectTypeConverter.stringToJsonObject(_tmp_5);
                _result.setMetadata(_tmpMetadata);
                String _tmp_6 = _cursor.isNull(_cursorIndexOfMentionees) ? null : _cursor.getString(_cursorIndexOfMentionees);
                List<EkoMentioneesDto> _tmpMentionees = this.__mentioneesConverter.jsonToMentionees(_tmp_6);
                _result.setMentionees(_tmpMentionees);
                String _tmpPath = _cursor.isNull(_cursorIndexOfPath) ? null : _cursor.getString(_cursorIndexOfPath);
                _result.setPath(_tmpPath);
                String _tmpSyncState = _cursor.isNull(_cursorIndexOfSyncState) ? null : _cursor.getString(_cursorIndexOfSyncState);
                _result.setSyncState(_tmpSyncState);
                int _tmpMessageMarkerHash = _cursor.getInt(_cursorIndexOfMessageMarkerHash);
                _result.setMessageMarkerHash(_tmpMessageMarkerHash);
                String _tmp_7 = _cursor.isNull(_cursorIndexOfCreatedAt) ? null : _cursor.getString(_cursorIndexOfCreatedAt);
                DateTime _tmpCreatedAt = this.__dateTimeTypeConverter.stringToDateTime(_tmp_7);
                _result.setCreatedAt(_tmpCreatedAt);
                String _tmp_8 = _cursor.isNull(_cursorIndexOfUpdatedAt) ? null : _cursor.getString(_cursorIndexOfUpdatedAt);
                DateTime _tmpUpdatedAt = this.__dateTimeTypeConverter.stringToDateTime(_tmp_8);
                _result.setUpdatedAt(_tmpUpdatedAt);
                String _tmp_9 = _cursor.isNull(_cursorIndexOfExpiresAt) ? null : _cursor.getString(_cursorIndexOfExpiresAt);
                DateTime _tmpExpiresAt = this.__dateTimeTypeConverter.stringToDateTime(_tmp_9);
                _result.setExpiresAt(_tmpExpiresAt);
            } else {
                _result = null;
            }
            EkoMessageEntity ekoMessageEntity = _result;
            return ekoMessageEntity;
        }
        finally {
            _cursor.close();
            _statement.release();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public EkoMessageEntity getByMessageIdNowImpl(String messageId) {
        String _sql = "SELECT message.* from message where message.messageId = ? LIMIT 1";
        RoomSQLiteQuery _statement = RoomSQLiteQuery.acquire((String)"SELECT message.* from message where message.messageId = ? LIMIT 1", (int)1);
        int _argIndex = 1;
        if (messageId == null) {
            _statement.bindNull(_argIndex);
        } else {
            _statement.bindString(_argIndex, messageId);
        }
        this.__db.assertNotSuspendingTransaction();
        Cursor _cursor = DBUtil.query((RoomDatabase)this.__db, (SupportSQLiteQuery)_statement, (boolean)false, null);
        try {
            EkoMessageEntity _result;
            int _cursorIndexOfUniqueId = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"uniqueId");
            int _cursorIndexOfMessageId = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"messageId");
            int _cursorIndexOfSubChannelId = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"subChannelId");
            int _cursorIndexOfChannelId = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"channelId");
            int _cursorIndexOfUserId = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"userId");
            int _cursorIndexOfParentId = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"parentId");
            int _cursorIndexOfChannelSegment = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"channelSegment");
            int _cursorIndexOfChildrenNumber = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"childrenNumber");
            int _cursorIndexOfEditedAt = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"editedAt");
            int _cursorIndexOfIsDeleted = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"isDeleted");
            int _cursorIndexOfFlagCount = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"flagCount");
            int _cursorIndexOfTags = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"tags");
            int _cursorIndexOfReactions = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"reactions");
            int _cursorIndexOfReactionCount = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"reactionCount");
            int _cursorIndexOfType = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"type");
            int _cursorIndexOfData = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"data");
            int _cursorIndexOfMetadata = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"metadata");
            int _cursorIndexOfMentionees = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"mentionees");
            int _cursorIndexOfPath = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"path");
            int _cursorIndexOfSyncState = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"syncState");
            int _cursorIndexOfMessageMarkerHash = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"messageMarkerHash");
            int _cursorIndexOfCreatedAt = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"createdAt");
            int _cursorIndexOfUpdatedAt = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"updatedAt");
            int _cursorIndexOfExpiresAt = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"expiresAt");
            if (_cursor.moveToFirst()) {
                _result = new EkoMessageEntity();
                String _tmpUniqueId = _cursor.isNull(_cursorIndexOfUniqueId) ? null : _cursor.getString(_cursorIndexOfUniqueId);
                _result.setUniqueId(_tmpUniqueId);
                String _tmpMessageId = _cursor.isNull(_cursorIndexOfMessageId) ? null : _cursor.getString(_cursorIndexOfMessageId);
                _result.setMessageId(_tmpMessageId);
                String _tmpSubChannelId = _cursor.isNull(_cursorIndexOfSubChannelId) ? null : _cursor.getString(_cursorIndexOfSubChannelId);
                _result.setSubChannelId(_tmpSubChannelId);
                String _tmpChannelId = _cursor.isNull(_cursorIndexOfChannelId) ? null : _cursor.getString(_cursorIndexOfChannelId);
                _result.setChannelId(_tmpChannelId);
                String _tmpUserId = _cursor.isNull(_cursorIndexOfUserId) ? null : _cursor.getString(_cursorIndexOfUserId);
                _result.setUserId(_tmpUserId);
                String _tmpParentId = _cursor.isNull(_cursorIndexOfParentId) ? null : _cursor.getString(_cursorIndexOfParentId);
                _result.setParentId(_tmpParentId);
                int _tmpChannelSegment = _cursor.getInt(_cursorIndexOfChannelSegment);
                _result.setChannelSegment(_tmpChannelSegment);
                int _tmpChildrenNumber = _cursor.getInt(_cursorIndexOfChildrenNumber);
                _result.setChildrenNumber(_tmpChildrenNumber);
                String _tmp = _cursor.isNull(_cursorIndexOfEditedAt) ? null : _cursor.getString(_cursorIndexOfEditedAt);
                DateTime _tmpEditedAt = this.__dateTimeTypeConverter.stringToDateTime(_tmp);
                _result.setEditedAt(_tmpEditedAt);
                int _tmp_1 = _cursor.getInt(_cursorIndexOfIsDeleted);
                boolean _tmpIsDeleted = _tmp_1 != 0;
                _result.setDeleted(_tmpIsDeleted);
                int _tmpFlagCount = _cursor.getInt(_cursorIndexOfFlagCount);
                _result.setFlagCount(_tmpFlagCount);
                String _tmp_2 = _cursor.isNull(_cursorIndexOfTags) ? null : _cursor.getString(_cursorIndexOfTags);
                AmityTags _tmpTags = this.__ekoTagsTypeConverter.stringToEkoTags(_tmp_2);
                _result.setTags(_tmpTags);
                String _tmp_3 = _cursor.isNull(_cursorIndexOfReactions) ? null : _cursor.getString(_cursorIndexOfReactions);
                AmityReactionMap _tmpReactions = this.__ekoReactionMapConverter.stringToStringIntMap(_tmp_3);
                _result.setReactions(_tmpReactions);
                int _tmpReactionCount = _cursor.getInt(_cursorIndexOfReactionCount);
                _result.setReactionCount(_tmpReactionCount);
                String _tmpType = _cursor.isNull(_cursorIndexOfType) ? null : _cursor.getString(_cursorIndexOfType);
                _result.setType(_tmpType);
                String _tmp_4 = _cursor.isNull(_cursorIndexOfData) ? null : _cursor.getString(_cursorIndexOfData);
                JsonObject _tmpData = this.__jsonObjectTypeConverter.stringToJsonObject(_tmp_4);
                _result.setData(_tmpData);
                String _tmp_5 = _cursor.isNull(_cursorIndexOfMetadata) ? null : _cursor.getString(_cursorIndexOfMetadata);
                JsonObject _tmpMetadata = this.__jsonObjectTypeConverter.stringToJsonObject(_tmp_5);
                _result.setMetadata(_tmpMetadata);
                String _tmp_6 = _cursor.isNull(_cursorIndexOfMentionees) ? null : _cursor.getString(_cursorIndexOfMentionees);
                List<EkoMentioneesDto> _tmpMentionees = this.__mentioneesConverter.jsonToMentionees(_tmp_6);
                _result.setMentionees(_tmpMentionees);
                String _tmpPath = _cursor.isNull(_cursorIndexOfPath) ? null : _cursor.getString(_cursorIndexOfPath);
                _result.setPath(_tmpPath);
                String _tmpSyncState = _cursor.isNull(_cursorIndexOfSyncState) ? null : _cursor.getString(_cursorIndexOfSyncState);
                _result.setSyncState(_tmpSyncState);
                int _tmpMessageMarkerHash = _cursor.getInt(_cursorIndexOfMessageMarkerHash);
                _result.setMessageMarkerHash(_tmpMessageMarkerHash);
                String _tmp_7 = _cursor.isNull(_cursorIndexOfCreatedAt) ? null : _cursor.getString(_cursorIndexOfCreatedAt);
                DateTime _tmpCreatedAt = this.__dateTimeTypeConverter.stringToDateTime(_tmp_7);
                _result.setCreatedAt(_tmpCreatedAt);
                String _tmp_8 = _cursor.isNull(_cursorIndexOfUpdatedAt) ? null : _cursor.getString(_cursorIndexOfUpdatedAt);
                DateTime _tmpUpdatedAt = this.__dateTimeTypeConverter.stringToDateTime(_tmp_8);
                _result.setUpdatedAt(_tmpUpdatedAt);
                String _tmp_9 = _cursor.isNull(_cursorIndexOfExpiresAt) ? null : _cursor.getString(_cursorIndexOfExpiresAt);
                DateTime _tmpExpiresAt = this.__dateTimeTypeConverter.stringToDateTime(_tmp_9);
                _result.setExpiresAt(_tmpExpiresAt);
            } else {
                _result = null;
            }
            EkoMessageEntity ekoMessageEntity = _result;
            return ekoMessageEntity;
        }
        finally {
            _cursor.close();
            _statement.release();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<EkoMessageEntity> getByIdsNowImpl(List<String> uniqueIds) {
        StringBuilder _stringBuilder = StringUtil.newStringBuilder();
        _stringBuilder.append("SELECT message.* from message where message.uniqueId IN (");
        int _inputSize = uniqueIds.size();
        StringUtil.appendPlaceholders((StringBuilder)_stringBuilder, (int)_inputSize);
        _stringBuilder.append(")");
        String _sql = _stringBuilder.toString();
        int _argCount = 0 + _inputSize;
        RoomSQLiteQuery _statement = RoomSQLiteQuery.acquire((String)_sql, (int)_argCount);
        int _argIndex = 1;
        for (String _item : uniqueIds) {
            if (_item == null) {
                _statement.bindNull(_argIndex);
            } else {
                _statement.bindString(_argIndex, _item);
            }
            ++_argIndex;
        }
        this.__db.assertNotSuspendingTransaction();
        Cursor _cursor = DBUtil.query((RoomDatabase)this.__db, (SupportSQLiteQuery)_statement, (boolean)false, null);
        try {
            int _cursorIndexOfUniqueId = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"uniqueId");
            int _cursorIndexOfMessageId = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"messageId");
            int _cursorIndexOfSubChannelId = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"subChannelId");
            int _cursorIndexOfChannelId = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"channelId");
            int _cursorIndexOfUserId = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"userId");
            int _cursorIndexOfParentId = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"parentId");
            int _cursorIndexOfChannelSegment = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"channelSegment");
            int _cursorIndexOfChildrenNumber = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"childrenNumber");
            int _cursorIndexOfEditedAt = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"editedAt");
            int _cursorIndexOfIsDeleted = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"isDeleted");
            int _cursorIndexOfFlagCount = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"flagCount");
            int _cursorIndexOfTags = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"tags");
            int _cursorIndexOfReactions = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"reactions");
            int _cursorIndexOfReactionCount = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"reactionCount");
            int _cursorIndexOfType = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"type");
            int _cursorIndexOfData = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"data");
            int _cursorIndexOfMetadata = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"metadata");
            int _cursorIndexOfMentionees = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"mentionees");
            int _cursorIndexOfPath = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"path");
            int _cursorIndexOfSyncState = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"syncState");
            int _cursorIndexOfMessageMarkerHash = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"messageMarkerHash");
            int _cursorIndexOfCreatedAt = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"createdAt");
            int _cursorIndexOfUpdatedAt = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"updatedAt");
            int _cursorIndexOfExpiresAt = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"expiresAt");
            ArrayList<EkoMessageEntity> _result = new ArrayList<EkoMessageEntity>(_cursor.getCount());
            while (_cursor.moveToNext()) {
                EkoMessageEntity _item_1 = new EkoMessageEntity();
                String _tmpUniqueId = _cursor.isNull(_cursorIndexOfUniqueId) ? null : _cursor.getString(_cursorIndexOfUniqueId);
                _item_1.setUniqueId(_tmpUniqueId);
                String _tmpMessageId = _cursor.isNull(_cursorIndexOfMessageId) ? null : _cursor.getString(_cursorIndexOfMessageId);
                _item_1.setMessageId(_tmpMessageId);
                String _tmpSubChannelId = _cursor.isNull(_cursorIndexOfSubChannelId) ? null : _cursor.getString(_cursorIndexOfSubChannelId);
                _item_1.setSubChannelId(_tmpSubChannelId);
                String _tmpChannelId = _cursor.isNull(_cursorIndexOfChannelId) ? null : _cursor.getString(_cursorIndexOfChannelId);
                _item_1.setChannelId(_tmpChannelId);
                String _tmpUserId = _cursor.isNull(_cursorIndexOfUserId) ? null : _cursor.getString(_cursorIndexOfUserId);
                _item_1.setUserId(_tmpUserId);
                String _tmpParentId = _cursor.isNull(_cursorIndexOfParentId) ? null : _cursor.getString(_cursorIndexOfParentId);
                _item_1.setParentId(_tmpParentId);
                int _tmpChannelSegment = _cursor.getInt(_cursorIndexOfChannelSegment);
                _item_1.setChannelSegment(_tmpChannelSegment);
                int _tmpChildrenNumber = _cursor.getInt(_cursorIndexOfChildrenNumber);
                _item_1.setChildrenNumber(_tmpChildrenNumber);
                String _tmp = _cursor.isNull(_cursorIndexOfEditedAt) ? null : _cursor.getString(_cursorIndexOfEditedAt);
                DateTime _tmpEditedAt = this.__dateTimeTypeConverter.stringToDateTime(_tmp);
                _item_1.setEditedAt(_tmpEditedAt);
                int _tmp_1 = _cursor.getInt(_cursorIndexOfIsDeleted);
                boolean _tmpIsDeleted = _tmp_1 != 0;
                _item_1.setDeleted(_tmpIsDeleted);
                int _tmpFlagCount = _cursor.getInt(_cursorIndexOfFlagCount);
                _item_1.setFlagCount(_tmpFlagCount);
                String _tmp_2 = _cursor.isNull(_cursorIndexOfTags) ? null : _cursor.getString(_cursorIndexOfTags);
                AmityTags _tmpTags = this.__ekoTagsTypeConverter.stringToEkoTags(_tmp_2);
                _item_1.setTags(_tmpTags);
                String _tmp_3 = _cursor.isNull(_cursorIndexOfReactions) ? null : _cursor.getString(_cursorIndexOfReactions);
                AmityReactionMap _tmpReactions = this.__ekoReactionMapConverter.stringToStringIntMap(_tmp_3);
                _item_1.setReactions(_tmpReactions);
                int _tmpReactionCount = _cursor.getInt(_cursorIndexOfReactionCount);
                _item_1.setReactionCount(_tmpReactionCount);
                String _tmpType = _cursor.isNull(_cursorIndexOfType) ? null : _cursor.getString(_cursorIndexOfType);
                _item_1.setType(_tmpType);
                String _tmp_4 = _cursor.isNull(_cursorIndexOfData) ? null : _cursor.getString(_cursorIndexOfData);
                JsonObject _tmpData = this.__jsonObjectTypeConverter.stringToJsonObject(_tmp_4);
                _item_1.setData(_tmpData);
                String _tmp_5 = _cursor.isNull(_cursorIndexOfMetadata) ? null : _cursor.getString(_cursorIndexOfMetadata);
                JsonObject _tmpMetadata = this.__jsonObjectTypeConverter.stringToJsonObject(_tmp_5);
                _item_1.setMetadata(_tmpMetadata);
                String _tmp_6 = _cursor.isNull(_cursorIndexOfMentionees) ? null : _cursor.getString(_cursorIndexOfMentionees);
                List<EkoMentioneesDto> _tmpMentionees = this.__mentioneesConverter.jsonToMentionees(_tmp_6);
                _item_1.setMentionees(_tmpMentionees);
                String _tmpPath = _cursor.isNull(_cursorIndexOfPath) ? null : _cursor.getString(_cursorIndexOfPath);
                _item_1.setPath(_tmpPath);
                String _tmpSyncState = _cursor.isNull(_cursorIndexOfSyncState) ? null : _cursor.getString(_cursorIndexOfSyncState);
                _item_1.setSyncState(_tmpSyncState);
                int _tmpMessageMarkerHash = _cursor.getInt(_cursorIndexOfMessageMarkerHash);
                _item_1.setMessageMarkerHash(_tmpMessageMarkerHash);
                String _tmp_7 = _cursor.isNull(_cursorIndexOfCreatedAt) ? null : _cursor.getString(_cursorIndexOfCreatedAt);
                DateTime _tmpCreatedAt = this.__dateTimeTypeConverter.stringToDateTime(_tmp_7);
                _item_1.setCreatedAt(_tmpCreatedAt);
                String _tmp_8 = _cursor.isNull(_cursorIndexOfUpdatedAt) ? null : _cursor.getString(_cursorIndexOfUpdatedAt);
                DateTime _tmpUpdatedAt = this.__dateTimeTypeConverter.stringToDateTime(_tmp_8);
                _item_1.setUpdatedAt(_tmpUpdatedAt);
                String _tmp_9 = _cursor.isNull(_cursorIndexOfExpiresAt) ? null : _cursor.getString(_cursorIndexOfExpiresAt);
                DateTime _tmpExpiresAt = this.__dateTimeTypeConverter.stringToDateTime(_tmp_9);
                _item_1.setExpiresAt(_tmpExpiresAt);
                _result.add(_item_1);
            }
            ArrayList<EkoMessageEntity> arrayList = _result;
            return arrayList;
        }
        finally {
            _cursor.close();
            _statement.release();
        }
    }

    @Override
    public Flowable<List<EkoMessageEntity>> observeMessagesWithTypeImpl(String subChannelId, boolean isFilterByParentId, String parentId, boolean isFilterByTags, String[] includingTags, String[] excludingTags, Boolean isDeleted, List<String> type, Boolean isSortedAsc) {
        Integer _tmp_6;
        Integer _tmp_5;
        Integer _tmp_4;
        Integer _tmp_3;
        StringBuilder _stringBuilder = StringUtil.newStringBuilder();
        _stringBuilder.append("SELECT message.* from message where message.subChannelId = ");
        _stringBuilder.append("?");
        _stringBuilder.append(" and case when ");
        _stringBuilder.append("?");
        _stringBuilder.append(" and ");
        _stringBuilder.append("?");
        _stringBuilder.append(" is not null then message.parentId = ");
        _stringBuilder.append("?");
        _stringBuilder.append("  when ");
        _stringBuilder.append("?");
        _stringBuilder.append(" and ");
        _stringBuilder.append("?");
        _stringBuilder.append(" is null then message.parentId is null  else message.messageId is not null end and case when ");
        _stringBuilder.append("?");
        _stringBuilder.append(" then message.messageId in (SELECT messageId from message_tag where tagName in (");
        int _inputSize = includingTags.length;
        StringUtil.appendPlaceholders((StringBuilder)_stringBuilder, (int)_inputSize);
        _stringBuilder.append("))  else message.messageId is not null end and message.messageId not in (SELECT messageId from message_tag where tagName in (");
        int _inputSize_1 = excludingTags.length;
        StringUtil.appendPlaceholders((StringBuilder)_stringBuilder, (int)_inputSize_1);
        _stringBuilder.append(")) and case when ");
        _stringBuilder.append("?");
        _stringBuilder.append(" is not null then message.isDeleted = ");
        _stringBuilder.append("?");
        _stringBuilder.append(" else message.messageId is not null end and message.type IN (");
        int _inputSize_2 = type.size();
        StringUtil.appendPlaceholders((StringBuilder)_stringBuilder, (int)_inputSize_2);
        _stringBuilder.append(") order by case when ");
        _stringBuilder.append("?");
        _stringBuilder.append(" = 1 then message.createdAt end asc, case when ");
        _stringBuilder.append("?");
        _stringBuilder.append(" = 0 then message.createdAt end desc");
        String _sql = _stringBuilder.toString();
        int _argCount = 11 + _inputSize + _inputSize_1 + _inputSize_2;
        final RoomSQLiteQuery _statement = RoomSQLiteQuery.acquire((String)_sql, (int)_argCount);
        int _argIndex = 1;
        if (subChannelId == null) {
            _statement.bindNull(_argIndex);
        } else {
            _statement.bindString(_argIndex, subChannelId);
        }
        _argIndex = 2;
        int _tmp = isFilterByParentId ? 1 : 0;
        _statement.bindLong(_argIndex, (long)_tmp);
        _argIndex = 3;
        if (parentId == null) {
            _statement.bindNull(_argIndex);
        } else {
            _statement.bindString(_argIndex, parentId);
        }
        _argIndex = 4;
        if (parentId == null) {
            _statement.bindNull(_argIndex);
        } else {
            _statement.bindString(_argIndex, parentId);
        }
        _argIndex = 5;
        int _tmp_1 = isFilterByParentId ? 1 : 0;
        _statement.bindLong(_argIndex, (long)_tmp_1);
        _argIndex = 6;
        if (parentId == null) {
            _statement.bindNull(_argIndex);
        } else {
            _statement.bindString(_argIndex, parentId);
        }
        _argIndex = 7;
        int _tmp_2 = isFilterByTags ? 1 : 0;
        _statement.bindLong(_argIndex, (long)_tmp_2);
        _argIndex = 8;
        for (String _item : includingTags) {
            if (_item == null) {
                _statement.bindNull(_argIndex);
            } else {
                _statement.bindString(_argIndex, _item);
            }
            ++_argIndex;
        }
        _argIndex = 8 + _inputSize;
        for (String _item_1 : excludingTags) {
            if (_item_1 == null) {
                _statement.bindNull(_argIndex);
            } else {
                _statement.bindString(_argIndex, _item_1);
            }
            ++_argIndex;
        }
        _argIndex = 8 + _inputSize + _inputSize_1;
        Integer n = isDeleted == null ? null : (_tmp_3 = Integer.valueOf(isDeleted != false ? 1 : 0));
        if (_tmp_3 == null) {
            _statement.bindNull(_argIndex);
        } else {
            _statement.bindLong(_argIndex, (long)_tmp_3.intValue());
        }
        _argIndex = 9 + _inputSize + _inputSize_1;
        Integer n2 = isDeleted == null ? null : (_tmp_4 = Integer.valueOf(isDeleted != false ? 1 : 0));
        if (_tmp_4 == null) {
            _statement.bindNull(_argIndex);
        } else {
            _statement.bindLong(_argIndex, (long)_tmp_4.intValue());
        }
        _argIndex = 10 + _inputSize + _inputSize_1;
        for (String _item_2 : type) {
            if (_item_2 == null) {
                _statement.bindNull(_argIndex);
            } else {
                _statement.bindString(_argIndex, _item_2);
            }
            ++_argIndex;
        }
        _argIndex = 10 + _inputSize + _inputSize_1 + _inputSize_2;
        Integer n3 = isSortedAsc == null ? null : (_tmp_5 = Integer.valueOf(isSortedAsc != false ? 1 : 0));
        if (_tmp_5 == null) {
            _statement.bindNull(_argIndex);
        } else {
            _statement.bindLong(_argIndex, (long)_tmp_5.intValue());
        }
        _argIndex = 11 + _inputSize + _inputSize_1 + _inputSize_2;
        Integer n4 = isSortedAsc == null ? null : (_tmp_6 = Integer.valueOf(isSortedAsc != false ? 1 : 0));
        if (_tmp_6 == null) {
            _statement.bindNull(_argIndex);
        } else {
            _statement.bindLong(_argIndex, (long)_tmp_6.intValue());
        }
        return RxRoom.createFlowable((RoomDatabase)this.__db, (boolean)false, (String[])new String[]{"message", "message_tag"}, (Callable)new Callable<List<EkoMessageEntity>>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public List<EkoMessageEntity> call() throws Exception {
                try (Cursor _cursor = DBUtil.query((RoomDatabase)EkoMessageDao_Impl.this.__db, (SupportSQLiteQuery)_statement, (boolean)false, null);){
                    int _cursorIndexOfUniqueId = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"uniqueId");
                    int _cursorIndexOfMessageId = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"messageId");
                    int _cursorIndexOfSubChannelId = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"subChannelId");
                    int _cursorIndexOfChannelId = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"channelId");
                    int _cursorIndexOfUserId = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"userId");
                    int _cursorIndexOfParentId = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"parentId");
                    int _cursorIndexOfChannelSegment = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"channelSegment");
                    int _cursorIndexOfChildrenNumber = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"childrenNumber");
                    int _cursorIndexOfEditedAt = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"editedAt");
                    int _cursorIndexOfIsDeleted = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"isDeleted");
                    int _cursorIndexOfFlagCount = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"flagCount");
                    int _cursorIndexOfTags = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"tags");
                    int _cursorIndexOfReactions = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"reactions");
                    int _cursorIndexOfReactionCount = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"reactionCount");
                    int _cursorIndexOfType = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"type");
                    int _cursorIndexOfData = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"data");
                    int _cursorIndexOfMetadata = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"metadata");
                    int _cursorIndexOfMentionees = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"mentionees");
                    int _cursorIndexOfPath = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"path");
                    int _cursorIndexOfSyncState = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"syncState");
                    int _cursorIndexOfMessageMarkerHash = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"messageMarkerHash");
                    int _cursorIndexOfCreatedAt = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"createdAt");
                    int _cursorIndexOfUpdatedAt = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"updatedAt");
                    int _cursorIndexOfExpiresAt = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"expiresAt");
                    ArrayList<EkoMessageEntity> _result = new ArrayList<EkoMessageEntity>(_cursor.getCount());
                    while (_cursor.moveToNext()) {
                        EkoMessageEntity _item_3 = new EkoMessageEntity();
                        String _tmpUniqueId = _cursor.isNull(_cursorIndexOfUniqueId) ? null : _cursor.getString(_cursorIndexOfUniqueId);
                        _item_3.setUniqueId(_tmpUniqueId);
                        String _tmpMessageId = _cursor.isNull(_cursorIndexOfMessageId) ? null : _cursor.getString(_cursorIndexOfMessageId);
                        _item_3.setMessageId(_tmpMessageId);
                        String _tmpSubChannelId = _cursor.isNull(_cursorIndexOfSubChannelId) ? null : _cursor.getString(_cursorIndexOfSubChannelId);
                        _item_3.setSubChannelId(_tmpSubChannelId);
                        String _tmpChannelId = _cursor.isNull(_cursorIndexOfChannelId) ? null : _cursor.getString(_cursorIndexOfChannelId);
                        _item_3.setChannelId(_tmpChannelId);
                        String _tmpUserId = _cursor.isNull(_cursorIndexOfUserId) ? null : _cursor.getString(_cursorIndexOfUserId);
                        _item_3.setUserId(_tmpUserId);
                        String _tmpParentId = _cursor.isNull(_cursorIndexOfParentId) ? null : _cursor.getString(_cursorIndexOfParentId);
                        _item_3.setParentId(_tmpParentId);
                        int _tmpChannelSegment = _cursor.getInt(_cursorIndexOfChannelSegment);
                        _item_3.setChannelSegment(_tmpChannelSegment);
                        int _tmpChildrenNumber = _cursor.getInt(_cursorIndexOfChildrenNumber);
                        _item_3.setChildrenNumber(_tmpChildrenNumber);
                        String _tmp_7 = _cursor.isNull(_cursorIndexOfEditedAt) ? null : _cursor.getString(_cursorIndexOfEditedAt);
                        DateTime _tmpEditedAt = EkoMessageDao_Impl.this.__dateTimeTypeConverter.stringToDateTime(_tmp_7);
                        _item_3.setEditedAt(_tmpEditedAt);
                        int _tmp_8 = _cursor.getInt(_cursorIndexOfIsDeleted);
                        boolean _tmpIsDeleted = _tmp_8 != 0;
                        _item_3.setDeleted(_tmpIsDeleted);
                        int _tmpFlagCount = _cursor.getInt(_cursorIndexOfFlagCount);
                        _item_3.setFlagCount(_tmpFlagCount);
                        String _tmp_9 = _cursor.isNull(_cursorIndexOfTags) ? null : _cursor.getString(_cursorIndexOfTags);
                        AmityTags _tmpTags = EkoMessageDao_Impl.this.__ekoTagsTypeConverter.stringToEkoTags(_tmp_9);
                        _item_3.setTags(_tmpTags);
                        String _tmp_10 = _cursor.isNull(_cursorIndexOfReactions) ? null : _cursor.getString(_cursorIndexOfReactions);
                        AmityReactionMap _tmpReactions = EkoMessageDao_Impl.this.__ekoReactionMapConverter.stringToStringIntMap(_tmp_10);
                        _item_3.setReactions(_tmpReactions);
                        int _tmpReactionCount = _cursor.getInt(_cursorIndexOfReactionCount);
                        _item_3.setReactionCount(_tmpReactionCount);
                        String _tmpType = _cursor.isNull(_cursorIndexOfType) ? null : _cursor.getString(_cursorIndexOfType);
                        _item_3.setType(_tmpType);
                        String _tmp_11 = _cursor.isNull(_cursorIndexOfData) ? null : _cursor.getString(_cursorIndexOfData);
                        JsonObject _tmpData = EkoMessageDao_Impl.this.__jsonObjectTypeConverter.stringToJsonObject(_tmp_11);
                        _item_3.setData(_tmpData);
                        String _tmp_12 = _cursor.isNull(_cursorIndexOfMetadata) ? null : _cursor.getString(_cursorIndexOfMetadata);
                        JsonObject _tmpMetadata = EkoMessageDao_Impl.this.__jsonObjectTypeConverter.stringToJsonObject(_tmp_12);
                        _item_3.setMetadata(_tmpMetadata);
                        String _tmp_13 = _cursor.isNull(_cursorIndexOfMentionees) ? null : _cursor.getString(_cursorIndexOfMentionees);
                        List<EkoMentioneesDto> _tmpMentionees = EkoMessageDao_Impl.this.__mentioneesConverter.jsonToMentionees(_tmp_13);
                        _item_3.setMentionees(_tmpMentionees);
                        String _tmpPath = _cursor.isNull(_cursorIndexOfPath) ? null : _cursor.getString(_cursorIndexOfPath);
                        _item_3.setPath(_tmpPath);
                        String _tmpSyncState = _cursor.isNull(_cursorIndexOfSyncState) ? null : _cursor.getString(_cursorIndexOfSyncState);
                        _item_3.setSyncState(_tmpSyncState);
                        int _tmpMessageMarkerHash = _cursor.getInt(_cursorIndexOfMessageMarkerHash);
                        _item_3.setMessageMarkerHash(_tmpMessageMarkerHash);
                        String _tmp_14 = _cursor.isNull(_cursorIndexOfCreatedAt) ? null : _cursor.getString(_cursorIndexOfCreatedAt);
                        DateTime _tmpCreatedAt = EkoMessageDao_Impl.this.__dateTimeTypeConverter.stringToDateTime(_tmp_14);
                        _item_3.setCreatedAt(_tmpCreatedAt);
                        String _tmp_15 = _cursor.isNull(_cursorIndexOfUpdatedAt) ? null : _cursor.getString(_cursorIndexOfUpdatedAt);
                        DateTime _tmpUpdatedAt = EkoMessageDao_Impl.this.__dateTimeTypeConverter.stringToDateTime(_tmp_15);
                        _item_3.setUpdatedAt(_tmpUpdatedAt);
                        String _tmp_16 = _cursor.isNull(_cursorIndexOfExpiresAt) ? null : _cursor.getString(_cursorIndexOfExpiresAt);
                        DateTime _tmpExpiresAt = EkoMessageDao_Impl.this.__dateTimeTypeConverter.stringToDateTime(_tmp_16);
                        _item_3.setExpiresAt(_tmpExpiresAt);
                        _result.add(_item_3);
                    }
                    ArrayList<EkoMessageEntity> arrayList = _result;
                    return arrayList;
                }
            }

            protected void finalize() {
                _statement.release();
            }
        });
    }

    @Override
    public Flowable<List<EkoMessageEntity>> observeMessagesImpl(String subChannelId, boolean isFilterByParentId, String parentId, boolean isFilterByTags, String[] includingTags, String[] excludingTags, Boolean isDeleted, boolean isSortedAsc) {
        Integer _tmp_4;
        Integer _tmp_3;
        StringBuilder _stringBuilder = StringUtil.newStringBuilder();
        _stringBuilder.append("SELECT message.* from message where message.subChannelId = ");
        _stringBuilder.append("?");
        _stringBuilder.append(" and case when ");
        _stringBuilder.append("?");
        _stringBuilder.append(" and ");
        _stringBuilder.append("?");
        _stringBuilder.append(" is not null then message.parentId = ");
        _stringBuilder.append("?");
        _stringBuilder.append("  when ");
        _stringBuilder.append("?");
        _stringBuilder.append(" and ");
        _stringBuilder.append("?");
        _stringBuilder.append(" is null then message.parentId is null  else message.messageId is not null end and case when ");
        _stringBuilder.append("?");
        _stringBuilder.append(" then message.messageId in (SELECT messageId from message_tag where tagName in (");
        int _inputSize = includingTags.length;
        StringUtil.appendPlaceholders((StringBuilder)_stringBuilder, (int)_inputSize);
        _stringBuilder.append("))  else message.messageId is not null end and message.messageId not in (SELECT messageId from message_tag where tagName in (");
        int _inputSize_1 = excludingTags.length;
        StringUtil.appendPlaceholders((StringBuilder)_stringBuilder, (int)_inputSize_1);
        _stringBuilder.append(")) and case when ");
        _stringBuilder.append("?");
        _stringBuilder.append(" is not null then message.isDeleted = ");
        _stringBuilder.append("?");
        _stringBuilder.append(" else message.messageId is not null end order by case when ");
        _stringBuilder.append("?");
        _stringBuilder.append(" = 1 then message.createdAt end asc, case when ");
        _stringBuilder.append("?");
        _stringBuilder.append(" = 0 then message.createdAt end desc");
        String _sql = _stringBuilder.toString();
        int _argCount = 11 + _inputSize + _inputSize_1;
        final RoomSQLiteQuery _statement = RoomSQLiteQuery.acquire((String)_sql, (int)_argCount);
        int _argIndex = 1;
        if (subChannelId == null) {
            _statement.bindNull(_argIndex);
        } else {
            _statement.bindString(_argIndex, subChannelId);
        }
        _argIndex = 2;
        int _tmp = isFilterByParentId ? 1 : 0;
        _statement.bindLong(_argIndex, (long)_tmp);
        _argIndex = 3;
        if (parentId == null) {
            _statement.bindNull(_argIndex);
        } else {
            _statement.bindString(_argIndex, parentId);
        }
        _argIndex = 4;
        if (parentId == null) {
            _statement.bindNull(_argIndex);
        } else {
            _statement.bindString(_argIndex, parentId);
        }
        _argIndex = 5;
        int _tmp_1 = isFilterByParentId ? 1 : 0;
        _statement.bindLong(_argIndex, (long)_tmp_1);
        _argIndex = 6;
        if (parentId == null) {
            _statement.bindNull(_argIndex);
        } else {
            _statement.bindString(_argIndex, parentId);
        }
        _argIndex = 7;
        int _tmp_2 = isFilterByTags ? 1 : 0;
        _statement.bindLong(_argIndex, (long)_tmp_2);
        _argIndex = 8;
        for (String _item : includingTags) {
            if (_item == null) {
                _statement.bindNull(_argIndex);
            } else {
                _statement.bindString(_argIndex, _item);
            }
            ++_argIndex;
        }
        _argIndex = 8 + _inputSize;
        for (String _item_1 : excludingTags) {
            if (_item_1 == null) {
                _statement.bindNull(_argIndex);
            } else {
                _statement.bindString(_argIndex, _item_1);
            }
            ++_argIndex;
        }
        _argIndex = 8 + _inputSize + _inputSize_1;
        Integer n = isDeleted == null ? null : (_tmp_3 = Integer.valueOf(isDeleted != false ? 1 : 0));
        if (_tmp_3 == null) {
            _statement.bindNull(_argIndex);
        } else {
            _statement.bindLong(_argIndex, (long)_tmp_3.intValue());
        }
        _argIndex = 9 + _inputSize + _inputSize_1;
        Integer n2 = isDeleted == null ? null : (_tmp_4 = Integer.valueOf(isDeleted != false ? 1 : 0));
        if (_tmp_4 == null) {
            _statement.bindNull(_argIndex);
        } else {
            _statement.bindLong(_argIndex, (long)_tmp_4.intValue());
        }
        _argIndex = 10 + _inputSize + _inputSize_1;
        int _tmp_5 = isSortedAsc ? 1 : 0;
        _statement.bindLong(_argIndex, (long)_tmp_5);
        _argIndex = 11 + _inputSize + _inputSize_1;
        int _tmp_6 = isSortedAsc ? 1 : 0;
        _statement.bindLong(_argIndex, (long)_tmp_6);
        return RxRoom.createFlowable((RoomDatabase)this.__db, (boolean)false, (String[])new String[]{"message", "message_tag"}, (Callable)new Callable<List<EkoMessageEntity>>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public List<EkoMessageEntity> call() throws Exception {
                try (Cursor _cursor = DBUtil.query((RoomDatabase)EkoMessageDao_Impl.this.__db, (SupportSQLiteQuery)_statement, (boolean)false, null);){
                    int _cursorIndexOfUniqueId = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"uniqueId");
                    int _cursorIndexOfMessageId = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"messageId");
                    int _cursorIndexOfSubChannelId = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"subChannelId");
                    int _cursorIndexOfChannelId = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"channelId");
                    int _cursorIndexOfUserId = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"userId");
                    int _cursorIndexOfParentId = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"parentId");
                    int _cursorIndexOfChannelSegment = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"channelSegment");
                    int _cursorIndexOfChildrenNumber = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"childrenNumber");
                    int _cursorIndexOfEditedAt = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"editedAt");
                    int _cursorIndexOfIsDeleted = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"isDeleted");
                    int _cursorIndexOfFlagCount = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"flagCount");
                    int _cursorIndexOfTags = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"tags");
                    int _cursorIndexOfReactions = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"reactions");
                    int _cursorIndexOfReactionCount = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"reactionCount");
                    int _cursorIndexOfType = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"type");
                    int _cursorIndexOfData = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"data");
                    int _cursorIndexOfMetadata = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"metadata");
                    int _cursorIndexOfMentionees = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"mentionees");
                    int _cursorIndexOfPath = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"path");
                    int _cursorIndexOfSyncState = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"syncState");
                    int _cursorIndexOfMessageMarkerHash = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"messageMarkerHash");
                    int _cursorIndexOfCreatedAt = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"createdAt");
                    int _cursorIndexOfUpdatedAt = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"updatedAt");
                    int _cursorIndexOfExpiresAt = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"expiresAt");
                    ArrayList<EkoMessageEntity> _result = new ArrayList<EkoMessageEntity>(_cursor.getCount());
                    while (_cursor.moveToNext()) {
                        EkoMessageEntity _item_2 = new EkoMessageEntity();
                        String _tmpUniqueId = _cursor.isNull(_cursorIndexOfUniqueId) ? null : _cursor.getString(_cursorIndexOfUniqueId);
                        _item_2.setUniqueId(_tmpUniqueId);
                        String _tmpMessageId = _cursor.isNull(_cursorIndexOfMessageId) ? null : _cursor.getString(_cursorIndexOfMessageId);
                        _item_2.setMessageId(_tmpMessageId);
                        String _tmpSubChannelId = _cursor.isNull(_cursorIndexOfSubChannelId) ? null : _cursor.getString(_cursorIndexOfSubChannelId);
                        _item_2.setSubChannelId(_tmpSubChannelId);
                        String _tmpChannelId = _cursor.isNull(_cursorIndexOfChannelId) ? null : _cursor.getString(_cursorIndexOfChannelId);
                        _item_2.setChannelId(_tmpChannelId);
                        String _tmpUserId = _cursor.isNull(_cursorIndexOfUserId) ? null : _cursor.getString(_cursorIndexOfUserId);
                        _item_2.setUserId(_tmpUserId);
                        String _tmpParentId = _cursor.isNull(_cursorIndexOfParentId) ? null : _cursor.getString(_cursorIndexOfParentId);
                        _item_2.setParentId(_tmpParentId);
                        int _tmpChannelSegment = _cursor.getInt(_cursorIndexOfChannelSegment);
                        _item_2.setChannelSegment(_tmpChannelSegment);
                        int _tmpChildrenNumber = _cursor.getInt(_cursorIndexOfChildrenNumber);
                        _item_2.setChildrenNumber(_tmpChildrenNumber);
                        String _tmp_7 = _cursor.isNull(_cursorIndexOfEditedAt) ? null : _cursor.getString(_cursorIndexOfEditedAt);
                        DateTime _tmpEditedAt = EkoMessageDao_Impl.this.__dateTimeTypeConverter.stringToDateTime(_tmp_7);
                        _item_2.setEditedAt(_tmpEditedAt);
                        int _tmp_8 = _cursor.getInt(_cursorIndexOfIsDeleted);
                        boolean _tmpIsDeleted = _tmp_8 != 0;
                        _item_2.setDeleted(_tmpIsDeleted);
                        int _tmpFlagCount = _cursor.getInt(_cursorIndexOfFlagCount);
                        _item_2.setFlagCount(_tmpFlagCount);
                        String _tmp_9 = _cursor.isNull(_cursorIndexOfTags) ? null : _cursor.getString(_cursorIndexOfTags);
                        AmityTags _tmpTags = EkoMessageDao_Impl.this.__ekoTagsTypeConverter.stringToEkoTags(_tmp_9);
                        _item_2.setTags(_tmpTags);
                        String _tmp_10 = _cursor.isNull(_cursorIndexOfReactions) ? null : _cursor.getString(_cursorIndexOfReactions);
                        AmityReactionMap _tmpReactions = EkoMessageDao_Impl.this.__ekoReactionMapConverter.stringToStringIntMap(_tmp_10);
                        _item_2.setReactions(_tmpReactions);
                        int _tmpReactionCount = _cursor.getInt(_cursorIndexOfReactionCount);
                        _item_2.setReactionCount(_tmpReactionCount);
                        String _tmpType = _cursor.isNull(_cursorIndexOfType) ? null : _cursor.getString(_cursorIndexOfType);
                        _item_2.setType(_tmpType);
                        String _tmp_11 = _cursor.isNull(_cursorIndexOfData) ? null : _cursor.getString(_cursorIndexOfData);
                        JsonObject _tmpData = EkoMessageDao_Impl.this.__jsonObjectTypeConverter.stringToJsonObject(_tmp_11);
                        _item_2.setData(_tmpData);
                        String _tmp_12 = _cursor.isNull(_cursorIndexOfMetadata) ? null : _cursor.getString(_cursorIndexOfMetadata);
                        JsonObject _tmpMetadata = EkoMessageDao_Impl.this.__jsonObjectTypeConverter.stringToJsonObject(_tmp_12);
                        _item_2.setMetadata(_tmpMetadata);
                        String _tmp_13 = _cursor.isNull(_cursorIndexOfMentionees) ? null : _cursor.getString(_cursorIndexOfMentionees);
                        List<EkoMentioneesDto> _tmpMentionees = EkoMessageDao_Impl.this.__mentioneesConverter.jsonToMentionees(_tmp_13);
                        _item_2.setMentionees(_tmpMentionees);
                        String _tmpPath = _cursor.isNull(_cursorIndexOfPath) ? null : _cursor.getString(_cursorIndexOfPath);
                        _item_2.setPath(_tmpPath);
                        String _tmpSyncState = _cursor.isNull(_cursorIndexOfSyncState) ? null : _cursor.getString(_cursorIndexOfSyncState);
                        _item_2.setSyncState(_tmpSyncState);
                        int _tmpMessageMarkerHash = _cursor.getInt(_cursorIndexOfMessageMarkerHash);
                        _item_2.setMessageMarkerHash(_tmpMessageMarkerHash);
                        String _tmp_14 = _cursor.isNull(_cursorIndexOfCreatedAt) ? null : _cursor.getString(_cursorIndexOfCreatedAt);
                        DateTime _tmpCreatedAt = EkoMessageDao_Impl.this.__dateTimeTypeConverter.stringToDateTime(_tmp_14);
                        _item_2.setCreatedAt(_tmpCreatedAt);
                        String _tmp_15 = _cursor.isNull(_cursorIndexOfUpdatedAt) ? null : _cursor.getString(_cursorIndexOfUpdatedAt);
                        DateTime _tmpUpdatedAt = EkoMessageDao_Impl.this.__dateTimeTypeConverter.stringToDateTime(_tmp_15);
                        _item_2.setUpdatedAt(_tmpUpdatedAt);
                        String _tmp_16 = _cursor.isNull(_cursorIndexOfExpiresAt) ? null : _cursor.getString(_cursorIndexOfExpiresAt);
                        DateTime _tmpExpiresAt = EkoMessageDao_Impl.this.__dateTimeTypeConverter.stringToDateTime(_tmp_16);
                        _item_2.setExpiresAt(_tmpExpiresAt);
                        _result.add(_item_2);
                    }
                    ArrayList<EkoMessageEntity> arrayList = _result;
                    return arrayList;
                }
            }

            protected void finalize() {
                _statement.release();
            }
        });
    }

    @Override
    public Flowable<EkoMessageEntity> getLatestMessageWithTypeImpl(String subChannelId, Boolean isFilterByParentId, String parentId, boolean isIncludingTags, String[] includingTags, boolean isExcludingTags, String[] excludingTags, Boolean isDeleted, List<String> type, int hash, int nonce, DateTime now) {
        Integer _tmp_5;
        Integer _tmp_4;
        Integer _tmp_1;
        Integer _tmp;
        StringBuilder _stringBuilder = StringUtil.newStringBuilder();
        _stringBuilder.append("SELECT * from message where message.subChannelId = ");
        _stringBuilder.append("?");
        _stringBuilder.append(" and case when ");
        _stringBuilder.append("?");
        _stringBuilder.append(" and ");
        _stringBuilder.append("?");
        _stringBuilder.append(" is not null then message.parentId = ");
        _stringBuilder.append("?");
        _stringBuilder.append("  when ");
        _stringBuilder.append("?");
        _stringBuilder.append(" and ");
        _stringBuilder.append("?");
        _stringBuilder.append(" is null then message.parentId is null  else message.messageId is not null end and case when ");
        _stringBuilder.append("?");
        _stringBuilder.append(" then message.messageId in (SELECT messageId from message_tag where tagName in (");
        int _inputSize = includingTags.length;
        StringUtil.appendPlaceholders((StringBuilder)_stringBuilder, (int)_inputSize);
        _stringBuilder.append(")) else message.messageId is not null end and case when ");
        _stringBuilder.append("?");
        _stringBuilder.append(" then message.messageId not in (SELECT messageId from message_tag where tagName in (");
        int _inputSize_1 = excludingTags.length;
        StringUtil.appendPlaceholders((StringBuilder)_stringBuilder, (int)_inputSize_1);
        _stringBuilder.append(")) else message.messageId is not null end and case when ");
        _stringBuilder.append("?");
        _stringBuilder.append(" is not null then message.isDeleted = ");
        _stringBuilder.append("?");
        _stringBuilder.append(" else message.messageId is not null end and message.updatedAt > ");
        _stringBuilder.append("?");
        _stringBuilder.append(" and message.uniqueId not in (SELECT amity_paging_id.id from amity_paging_id where amity_paging_id.hash = (");
        _stringBuilder.append("?");
        _stringBuilder.append(") and amity_paging_id.nonce = (");
        _stringBuilder.append("?");
        _stringBuilder.append(") ) and message.type in (");
        int _inputSize_2 = type.size();
        StringUtil.appendPlaceholders((StringBuilder)_stringBuilder, (int)_inputSize_2);
        _stringBuilder.append(") order by message.updatedAt desc limit 1");
        String _sql = _stringBuilder.toString();
        int _argCount = 13 + _inputSize + _inputSize_1 + _inputSize_2;
        final RoomSQLiteQuery _statement = RoomSQLiteQuery.acquire((String)_sql, (int)_argCount);
        int _argIndex = 1;
        if (subChannelId == null) {
            _statement.bindNull(_argIndex);
        } else {
            _statement.bindString(_argIndex, subChannelId);
        }
        _argIndex = 2;
        Integer n = isFilterByParentId == null ? null : (_tmp = Integer.valueOf(isFilterByParentId != false ? 1 : 0));
        if (_tmp == null) {
            _statement.bindNull(_argIndex);
        } else {
            _statement.bindLong(_argIndex, (long)_tmp.intValue());
        }
        _argIndex = 3;
        if (parentId == null) {
            _statement.bindNull(_argIndex);
        } else {
            _statement.bindString(_argIndex, parentId);
        }
        _argIndex = 4;
        if (parentId == null) {
            _statement.bindNull(_argIndex);
        } else {
            _statement.bindString(_argIndex, parentId);
        }
        _argIndex = 5;
        Integer n2 = isFilterByParentId == null ? null : (_tmp_1 = Integer.valueOf(isFilterByParentId != false ? 1 : 0));
        if (_tmp_1 == null) {
            _statement.bindNull(_argIndex);
        } else {
            _statement.bindLong(_argIndex, (long)_tmp_1.intValue());
        }
        _argIndex = 6;
        if (parentId == null) {
            _statement.bindNull(_argIndex);
        } else {
            _statement.bindString(_argIndex, parentId);
        }
        _argIndex = 7;
        int _tmp_2 = isIncludingTags ? 1 : 0;
        _statement.bindLong(_argIndex, (long)_tmp_2);
        _argIndex = 8;
        for (String _item : includingTags) {
            if (_item == null) {
                _statement.bindNull(_argIndex);
            } else {
                _statement.bindString(_argIndex, _item);
            }
            ++_argIndex;
        }
        _argIndex = 8 + _inputSize;
        int _tmp_3 = isExcludingTags ? 1 : 0;
        _statement.bindLong(_argIndex, (long)_tmp_3);
        _argIndex = 9 + _inputSize;
        for (String _item_1 : excludingTags) {
            if (_item_1 == null) {
                _statement.bindNull(_argIndex);
            } else {
                _statement.bindString(_argIndex, _item_1);
            }
            ++_argIndex;
        }
        _argIndex = 9 + _inputSize + _inputSize_1;
        Integer n3 = isDeleted == null ? null : (_tmp_4 = Integer.valueOf(isDeleted != false ? 1 : 0));
        if (_tmp_4 == null) {
            _statement.bindNull(_argIndex);
        } else {
            _statement.bindLong(_argIndex, (long)_tmp_4.intValue());
        }
        _argIndex = 10 + _inputSize + _inputSize_1;
        Integer n4 = isDeleted == null ? null : (_tmp_5 = Integer.valueOf(isDeleted != false ? 1 : 0));
        if (_tmp_5 == null) {
            _statement.bindNull(_argIndex);
        } else {
            _statement.bindLong(_argIndex, (long)_tmp_5.intValue());
        }
        _argIndex = 11 + _inputSize + _inputSize_1;
        String _tmp_6 = this.__dateTimeTypeConverter.dateTimeToString(now);
        if (_tmp_6 == null) {
            _statement.bindNull(_argIndex);
        } else {
            _statement.bindString(_argIndex, _tmp_6);
        }
        _argIndex = 12 + _inputSize + _inputSize_1;
        _statement.bindLong(_argIndex, (long)hash);
        _argIndex = 13 + _inputSize + _inputSize_1;
        _statement.bindLong(_argIndex, (long)nonce);
        _argIndex = 14 + _inputSize + _inputSize_1;
        for (String _item_2 : type) {
            if (_item_2 == null) {
                _statement.bindNull(_argIndex);
            } else {
                _statement.bindString(_argIndex, _item_2);
            }
            ++_argIndex;
        }
        return RxRoom.createFlowable((RoomDatabase)this.__db, (boolean)false, (String[])new String[]{"message", "message_tag", "amity_paging_id"}, (Callable)new Callable<EkoMessageEntity>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public EkoMessageEntity call() throws Exception {
                try (Cursor _cursor = DBUtil.query((RoomDatabase)EkoMessageDao_Impl.this.__db, (SupportSQLiteQuery)_statement, (boolean)false, null);){
                    EkoMessageEntity _result;
                    int _cursorIndexOfUniqueId = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"uniqueId");
                    int _cursorIndexOfMessageId = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"messageId");
                    int _cursorIndexOfSubChannelId = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"subChannelId");
                    int _cursorIndexOfChannelId = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"channelId");
                    int _cursorIndexOfUserId = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"userId");
                    int _cursorIndexOfParentId = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"parentId");
                    int _cursorIndexOfChannelSegment = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"channelSegment");
                    int _cursorIndexOfChildrenNumber = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"childrenNumber");
                    int _cursorIndexOfEditedAt = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"editedAt");
                    int _cursorIndexOfIsDeleted = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"isDeleted");
                    int _cursorIndexOfFlagCount = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"flagCount");
                    int _cursorIndexOfTags = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"tags");
                    int _cursorIndexOfReactions = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"reactions");
                    int _cursorIndexOfReactionCount = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"reactionCount");
                    int _cursorIndexOfType = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"type");
                    int _cursorIndexOfData = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"data");
                    int _cursorIndexOfMetadata = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"metadata");
                    int _cursorIndexOfMentionees = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"mentionees");
                    int _cursorIndexOfPath = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"path");
                    int _cursorIndexOfSyncState = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"syncState");
                    int _cursorIndexOfMessageMarkerHash = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"messageMarkerHash");
                    int _cursorIndexOfCreatedAt = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"createdAt");
                    int _cursorIndexOfUpdatedAt = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"updatedAt");
                    int _cursorIndexOfExpiresAt = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"expiresAt");
                    if (_cursor.moveToFirst()) {
                        _result = new EkoMessageEntity();
                        String _tmpUniqueId = _cursor.isNull(_cursorIndexOfUniqueId) ? null : _cursor.getString(_cursorIndexOfUniqueId);
                        _result.setUniqueId(_tmpUniqueId);
                        String _tmpMessageId = _cursor.isNull(_cursorIndexOfMessageId) ? null : _cursor.getString(_cursorIndexOfMessageId);
                        _result.setMessageId(_tmpMessageId);
                        String _tmpSubChannelId = _cursor.isNull(_cursorIndexOfSubChannelId) ? null : _cursor.getString(_cursorIndexOfSubChannelId);
                        _result.setSubChannelId(_tmpSubChannelId);
                        String _tmpChannelId = _cursor.isNull(_cursorIndexOfChannelId) ? null : _cursor.getString(_cursorIndexOfChannelId);
                        _result.setChannelId(_tmpChannelId);
                        String _tmpUserId = _cursor.isNull(_cursorIndexOfUserId) ? null : _cursor.getString(_cursorIndexOfUserId);
                        _result.setUserId(_tmpUserId);
                        String _tmpParentId = _cursor.isNull(_cursorIndexOfParentId) ? null : _cursor.getString(_cursorIndexOfParentId);
                        _result.setParentId(_tmpParentId);
                        int _tmpChannelSegment = _cursor.getInt(_cursorIndexOfChannelSegment);
                        _result.setChannelSegment(_tmpChannelSegment);
                        int _tmpChildrenNumber = _cursor.getInt(_cursorIndexOfChildrenNumber);
                        _result.setChildrenNumber(_tmpChildrenNumber);
                        String _tmp_7 = _cursor.isNull(_cursorIndexOfEditedAt) ? null : _cursor.getString(_cursorIndexOfEditedAt);
                        DateTime _tmpEditedAt = EkoMessageDao_Impl.this.__dateTimeTypeConverter.stringToDateTime(_tmp_7);
                        _result.setEditedAt(_tmpEditedAt);
                        int _tmp_8 = _cursor.getInt(_cursorIndexOfIsDeleted);
                        boolean _tmpIsDeleted = _tmp_8 != 0;
                        _result.setDeleted(_tmpIsDeleted);
                        int _tmpFlagCount = _cursor.getInt(_cursorIndexOfFlagCount);
                        _result.setFlagCount(_tmpFlagCount);
                        String _tmp_9 = _cursor.isNull(_cursorIndexOfTags) ? null : _cursor.getString(_cursorIndexOfTags);
                        AmityTags _tmpTags = EkoMessageDao_Impl.this.__ekoTagsTypeConverter.stringToEkoTags(_tmp_9);
                        _result.setTags(_tmpTags);
                        String _tmp_10 = _cursor.isNull(_cursorIndexOfReactions) ? null : _cursor.getString(_cursorIndexOfReactions);
                        AmityReactionMap _tmpReactions = EkoMessageDao_Impl.this.__ekoReactionMapConverter.stringToStringIntMap(_tmp_10);
                        _result.setReactions(_tmpReactions);
                        int _tmpReactionCount = _cursor.getInt(_cursorIndexOfReactionCount);
                        _result.setReactionCount(_tmpReactionCount);
                        String _tmpType = _cursor.isNull(_cursorIndexOfType) ? null : _cursor.getString(_cursorIndexOfType);
                        _result.setType(_tmpType);
                        String _tmp_11 = _cursor.isNull(_cursorIndexOfData) ? null : _cursor.getString(_cursorIndexOfData);
                        JsonObject _tmpData = EkoMessageDao_Impl.this.__jsonObjectTypeConverter.stringToJsonObject(_tmp_11);
                        _result.setData(_tmpData);
                        String _tmp_12 = _cursor.isNull(_cursorIndexOfMetadata) ? null : _cursor.getString(_cursorIndexOfMetadata);
                        JsonObject _tmpMetadata = EkoMessageDao_Impl.this.__jsonObjectTypeConverter.stringToJsonObject(_tmp_12);
                        _result.setMetadata(_tmpMetadata);
                        String _tmp_13 = _cursor.isNull(_cursorIndexOfMentionees) ? null : _cursor.getString(_cursorIndexOfMentionees);
                        List<EkoMentioneesDto> _tmpMentionees = EkoMessageDao_Impl.this.__mentioneesConverter.jsonToMentionees(_tmp_13);
                        _result.setMentionees(_tmpMentionees);
                        String _tmpPath = _cursor.isNull(_cursorIndexOfPath) ? null : _cursor.getString(_cursorIndexOfPath);
                        _result.setPath(_tmpPath);
                        String _tmpSyncState = _cursor.isNull(_cursorIndexOfSyncState) ? null : _cursor.getString(_cursorIndexOfSyncState);
                        _result.setSyncState(_tmpSyncState);
                        int _tmpMessageMarkerHash = _cursor.getInt(_cursorIndexOfMessageMarkerHash);
                        _result.setMessageMarkerHash(_tmpMessageMarkerHash);
                        String _tmp_14 = _cursor.isNull(_cursorIndexOfCreatedAt) ? null : _cursor.getString(_cursorIndexOfCreatedAt);
                        DateTime _tmpCreatedAt = EkoMessageDao_Impl.this.__dateTimeTypeConverter.stringToDateTime(_tmp_14);
                        _result.setCreatedAt(_tmpCreatedAt);
                        String _tmp_15 = _cursor.isNull(_cursorIndexOfUpdatedAt) ? null : _cursor.getString(_cursorIndexOfUpdatedAt);
                        DateTime _tmpUpdatedAt = EkoMessageDao_Impl.this.__dateTimeTypeConverter.stringToDateTime(_tmp_15);
                        _result.setUpdatedAt(_tmpUpdatedAt);
                        String _tmp_16 = _cursor.isNull(_cursorIndexOfExpiresAt) ? null : _cursor.getString(_cursorIndexOfExpiresAt);
                        DateTime _tmpExpiresAt = EkoMessageDao_Impl.this.__dateTimeTypeConverter.stringToDateTime(_tmp_16);
                        _result.setExpiresAt(_tmpExpiresAt);
                    } else {
                        _result = null;
                    }
                    EkoMessageEntity ekoMessageEntity = _result;
                    return ekoMessageEntity;
                }
            }

            protected void finalize() {
                _statement.release();
            }
        });
    }

    @Override
    public Flowable<EkoMessageEntity> getLatestUnsyncMessageImpl(String subChannelId, Boolean isFilterByParentId, String parentId, boolean isIncludingTags, String[] includingTags, boolean isExcludingTags, String[] excludingTags, Boolean isDeleted, int hash, int nonce) {
        Integer _tmp_5;
        Integer _tmp_4;
        Integer _tmp_1;
        Integer _tmp;
        StringBuilder _stringBuilder = StringUtil.newStringBuilder();
        _stringBuilder.append("SELECT * from message where message.subChannelId = ");
        _stringBuilder.append("?");
        _stringBuilder.append(" and case when ");
        _stringBuilder.append("?");
        _stringBuilder.append(" and ");
        _stringBuilder.append("?");
        _stringBuilder.append(" is not null then message.parentId = ");
        _stringBuilder.append("?");
        _stringBuilder.append("  when ");
        _stringBuilder.append("?");
        _stringBuilder.append(" and ");
        _stringBuilder.append("?");
        _stringBuilder.append(" is null then message.parentId is null  else message.messageId is not null end and case when ");
        _stringBuilder.append("?");
        _stringBuilder.append(" then message.messageId in (SELECT messageId from message_tag where tagName in (");
        int _inputSize = includingTags.length;
        StringUtil.appendPlaceholders((StringBuilder)_stringBuilder, (int)_inputSize);
        _stringBuilder.append(")) else message.messageId is not null end and case when ");
        _stringBuilder.append("?");
        _stringBuilder.append(" then message.messageId not in (SELECT messageId from message_tag where tagName in (");
        int _inputSize_1 = excludingTags.length;
        StringUtil.appendPlaceholders((StringBuilder)_stringBuilder, (int)_inputSize_1);
        _stringBuilder.append(")) else message.messageId is not null end and case when ");
        _stringBuilder.append("?");
        _stringBuilder.append(" is not null then message.isDeleted = ");
        _stringBuilder.append("?");
        _stringBuilder.append(" else message.messageId is not null end and message.syncState != 'synced'  and message.uniqueId not in (SELECT amity_paging_id.id from amity_paging_id where amity_paging_id.hash = (");
        _stringBuilder.append("?");
        _stringBuilder.append(") and amity_paging_id.nonce = (");
        _stringBuilder.append("?");
        _stringBuilder.append(") ) order by message.updatedAt desc limit 1");
        String _sql = _stringBuilder.toString();
        int _argCount = 12 + _inputSize + _inputSize_1;
        final RoomSQLiteQuery _statement = RoomSQLiteQuery.acquire((String)_sql, (int)_argCount);
        int _argIndex = 1;
        if (subChannelId == null) {
            _statement.bindNull(_argIndex);
        } else {
            _statement.bindString(_argIndex, subChannelId);
        }
        _argIndex = 2;
        Integer n = isFilterByParentId == null ? null : (_tmp = Integer.valueOf(isFilterByParentId != false ? 1 : 0));
        if (_tmp == null) {
            _statement.bindNull(_argIndex);
        } else {
            _statement.bindLong(_argIndex, (long)_tmp.intValue());
        }
        _argIndex = 3;
        if (parentId == null) {
            _statement.bindNull(_argIndex);
        } else {
            _statement.bindString(_argIndex, parentId);
        }
        _argIndex = 4;
        if (parentId == null) {
            _statement.bindNull(_argIndex);
        } else {
            _statement.bindString(_argIndex, parentId);
        }
        _argIndex = 5;
        Integer n2 = isFilterByParentId == null ? null : (_tmp_1 = Integer.valueOf(isFilterByParentId != false ? 1 : 0));
        if (_tmp_1 == null) {
            _statement.bindNull(_argIndex);
        } else {
            _statement.bindLong(_argIndex, (long)_tmp_1.intValue());
        }
        _argIndex = 6;
        if (parentId == null) {
            _statement.bindNull(_argIndex);
        } else {
            _statement.bindString(_argIndex, parentId);
        }
        _argIndex = 7;
        int _tmp_2 = isIncludingTags ? 1 : 0;
        _statement.bindLong(_argIndex, (long)_tmp_2);
        _argIndex = 8;
        for (String _item : includingTags) {
            if (_item == null) {
                _statement.bindNull(_argIndex);
            } else {
                _statement.bindString(_argIndex, _item);
            }
            ++_argIndex;
        }
        _argIndex = 8 + _inputSize;
        int _tmp_3 = isExcludingTags ? 1 : 0;
        _statement.bindLong(_argIndex, (long)_tmp_3);
        _argIndex = 9 + _inputSize;
        for (String _item_1 : excludingTags) {
            if (_item_1 == null) {
                _statement.bindNull(_argIndex);
            } else {
                _statement.bindString(_argIndex, _item_1);
            }
            ++_argIndex;
        }
        _argIndex = 9 + _inputSize + _inputSize_1;
        Integer n3 = isDeleted == null ? null : (_tmp_4 = Integer.valueOf(isDeleted != false ? 1 : 0));
        if (_tmp_4 == null) {
            _statement.bindNull(_argIndex);
        } else {
            _statement.bindLong(_argIndex, (long)_tmp_4.intValue());
        }
        _argIndex = 10 + _inputSize + _inputSize_1;
        Integer n4 = isDeleted == null ? null : (_tmp_5 = Integer.valueOf(isDeleted != false ? 1 : 0));
        if (_tmp_5 == null) {
            _statement.bindNull(_argIndex);
        } else {
            _statement.bindLong(_argIndex, (long)_tmp_5.intValue());
        }
        _argIndex = 11 + _inputSize + _inputSize_1;
        _statement.bindLong(_argIndex, (long)hash);
        _argIndex = 12 + _inputSize + _inputSize_1;
        _statement.bindLong(_argIndex, (long)nonce);
        return RxRoom.createFlowable((RoomDatabase)this.__db, (boolean)false, (String[])new String[]{"message", "message_tag", "amity_paging_id"}, (Callable)new Callable<EkoMessageEntity>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public EkoMessageEntity call() throws Exception {
                try (Cursor _cursor = DBUtil.query((RoomDatabase)EkoMessageDao_Impl.this.__db, (SupportSQLiteQuery)_statement, (boolean)false, null);){
                    EkoMessageEntity _result;
                    int _cursorIndexOfUniqueId = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"uniqueId");
                    int _cursorIndexOfMessageId = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"messageId");
                    int _cursorIndexOfSubChannelId = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"subChannelId");
                    int _cursorIndexOfChannelId = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"channelId");
                    int _cursorIndexOfUserId = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"userId");
                    int _cursorIndexOfParentId = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"parentId");
                    int _cursorIndexOfChannelSegment = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"channelSegment");
                    int _cursorIndexOfChildrenNumber = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"childrenNumber");
                    int _cursorIndexOfEditedAt = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"editedAt");
                    int _cursorIndexOfIsDeleted = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"isDeleted");
                    int _cursorIndexOfFlagCount = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"flagCount");
                    int _cursorIndexOfTags = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"tags");
                    int _cursorIndexOfReactions = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"reactions");
                    int _cursorIndexOfReactionCount = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"reactionCount");
                    int _cursorIndexOfType = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"type");
                    int _cursorIndexOfData = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"data");
                    int _cursorIndexOfMetadata = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"metadata");
                    int _cursorIndexOfMentionees = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"mentionees");
                    int _cursorIndexOfPath = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"path");
                    int _cursorIndexOfSyncState = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"syncState");
                    int _cursorIndexOfMessageMarkerHash = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"messageMarkerHash");
                    int _cursorIndexOfCreatedAt = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"createdAt");
                    int _cursorIndexOfUpdatedAt = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"updatedAt");
                    int _cursorIndexOfExpiresAt = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"expiresAt");
                    if (_cursor.moveToFirst()) {
                        _result = new EkoMessageEntity();
                        String _tmpUniqueId = _cursor.isNull(_cursorIndexOfUniqueId) ? null : _cursor.getString(_cursorIndexOfUniqueId);
                        _result.setUniqueId(_tmpUniqueId);
                        String _tmpMessageId = _cursor.isNull(_cursorIndexOfMessageId) ? null : _cursor.getString(_cursorIndexOfMessageId);
                        _result.setMessageId(_tmpMessageId);
                        String _tmpSubChannelId = _cursor.isNull(_cursorIndexOfSubChannelId) ? null : _cursor.getString(_cursorIndexOfSubChannelId);
                        _result.setSubChannelId(_tmpSubChannelId);
                        String _tmpChannelId = _cursor.isNull(_cursorIndexOfChannelId) ? null : _cursor.getString(_cursorIndexOfChannelId);
                        _result.setChannelId(_tmpChannelId);
                        String _tmpUserId = _cursor.isNull(_cursorIndexOfUserId) ? null : _cursor.getString(_cursorIndexOfUserId);
                        _result.setUserId(_tmpUserId);
                        String _tmpParentId = _cursor.isNull(_cursorIndexOfParentId) ? null : _cursor.getString(_cursorIndexOfParentId);
                        _result.setParentId(_tmpParentId);
                        int _tmpChannelSegment = _cursor.getInt(_cursorIndexOfChannelSegment);
                        _result.setChannelSegment(_tmpChannelSegment);
                        int _tmpChildrenNumber = _cursor.getInt(_cursorIndexOfChildrenNumber);
                        _result.setChildrenNumber(_tmpChildrenNumber);
                        String _tmp_6 = _cursor.isNull(_cursorIndexOfEditedAt) ? null : _cursor.getString(_cursorIndexOfEditedAt);
                        DateTime _tmpEditedAt = EkoMessageDao_Impl.this.__dateTimeTypeConverter.stringToDateTime(_tmp_6);
                        _result.setEditedAt(_tmpEditedAt);
                        int _tmp_7 = _cursor.getInt(_cursorIndexOfIsDeleted);
                        boolean _tmpIsDeleted = _tmp_7 != 0;
                        _result.setDeleted(_tmpIsDeleted);
                        int _tmpFlagCount = _cursor.getInt(_cursorIndexOfFlagCount);
                        _result.setFlagCount(_tmpFlagCount);
                        String _tmp_8 = _cursor.isNull(_cursorIndexOfTags) ? null : _cursor.getString(_cursorIndexOfTags);
                        AmityTags _tmpTags = EkoMessageDao_Impl.this.__ekoTagsTypeConverter.stringToEkoTags(_tmp_8);
                        _result.setTags(_tmpTags);
                        String _tmp_9 = _cursor.isNull(_cursorIndexOfReactions) ? null : _cursor.getString(_cursorIndexOfReactions);
                        AmityReactionMap _tmpReactions = EkoMessageDao_Impl.this.__ekoReactionMapConverter.stringToStringIntMap(_tmp_9);
                        _result.setReactions(_tmpReactions);
                        int _tmpReactionCount = _cursor.getInt(_cursorIndexOfReactionCount);
                        _result.setReactionCount(_tmpReactionCount);
                        String _tmpType = _cursor.isNull(_cursorIndexOfType) ? null : _cursor.getString(_cursorIndexOfType);
                        _result.setType(_tmpType);
                        String _tmp_10 = _cursor.isNull(_cursorIndexOfData) ? null : _cursor.getString(_cursorIndexOfData);
                        JsonObject _tmpData = EkoMessageDao_Impl.this.__jsonObjectTypeConverter.stringToJsonObject(_tmp_10);
                        _result.setData(_tmpData);
                        String _tmp_11 = _cursor.isNull(_cursorIndexOfMetadata) ? null : _cursor.getString(_cursorIndexOfMetadata);
                        JsonObject _tmpMetadata = EkoMessageDao_Impl.this.__jsonObjectTypeConverter.stringToJsonObject(_tmp_11);
                        _result.setMetadata(_tmpMetadata);
                        String _tmp_12 = _cursor.isNull(_cursorIndexOfMentionees) ? null : _cursor.getString(_cursorIndexOfMentionees);
                        List<EkoMentioneesDto> _tmpMentionees = EkoMessageDao_Impl.this.__mentioneesConverter.jsonToMentionees(_tmp_12);
                        _result.setMentionees(_tmpMentionees);
                        String _tmpPath = _cursor.isNull(_cursorIndexOfPath) ? null : _cursor.getString(_cursorIndexOfPath);
                        _result.setPath(_tmpPath);
                        String _tmpSyncState = _cursor.isNull(_cursorIndexOfSyncState) ? null : _cursor.getString(_cursorIndexOfSyncState);
                        _result.setSyncState(_tmpSyncState);
                        int _tmpMessageMarkerHash = _cursor.getInt(_cursorIndexOfMessageMarkerHash);
                        _result.setMessageMarkerHash(_tmpMessageMarkerHash);
                        String _tmp_13 = _cursor.isNull(_cursorIndexOfCreatedAt) ? null : _cursor.getString(_cursorIndexOfCreatedAt);
                        DateTime _tmpCreatedAt = EkoMessageDao_Impl.this.__dateTimeTypeConverter.stringToDateTime(_tmp_13);
                        _result.setCreatedAt(_tmpCreatedAt);
                        String _tmp_14 = _cursor.isNull(_cursorIndexOfUpdatedAt) ? null : _cursor.getString(_cursorIndexOfUpdatedAt);
                        DateTime _tmpUpdatedAt = EkoMessageDao_Impl.this.__dateTimeTypeConverter.stringToDateTime(_tmp_14);
                        _result.setUpdatedAt(_tmpUpdatedAt);
                        String _tmp_15 = _cursor.isNull(_cursorIndexOfExpiresAt) ? null : _cursor.getString(_cursorIndexOfExpiresAt);
                        DateTime _tmpExpiresAt = EkoMessageDao_Impl.this.__dateTimeTypeConverter.stringToDateTime(_tmp_15);
                        _result.setExpiresAt(_tmpExpiresAt);
                    } else {
                        _result = null;
                    }
                    EkoMessageEntity ekoMessageEntity = _result;
                    return ekoMessageEntity;
                }
            }

            protected void finalize() {
                _statement.release();
            }
        });
    }

    @Override
    public Flowable<EkoMessageEntity> getLatestUnsyncMessageWithTypeImpl(String subChannelId, Boolean isFilterByParentId, String parentId, boolean isIncludingTags, String[] includingTags, boolean isExcludingTags, String[] excludingTags, Boolean isDeleted, List<String> type, int hash, int nonce) {
        Integer _tmp_5;
        Integer _tmp_4;
        Integer _tmp_1;
        Integer _tmp;
        StringBuilder _stringBuilder = StringUtil.newStringBuilder();
        _stringBuilder.append("SELECT * from message where message.subChannelId = ");
        _stringBuilder.append("?");
        _stringBuilder.append(" and case when ");
        _stringBuilder.append("?");
        _stringBuilder.append(" and ");
        _stringBuilder.append("?");
        _stringBuilder.append(" is not null then message.parentId = ");
        _stringBuilder.append("?");
        _stringBuilder.append("  when ");
        _stringBuilder.append("?");
        _stringBuilder.append(" and ");
        _stringBuilder.append("?");
        _stringBuilder.append(" is null then message.parentId is null  else message.messageId is not null end and case when ");
        _stringBuilder.append("?");
        _stringBuilder.append(" then message.messageId in (SELECT messageId from message_tag where tagName in (");
        int _inputSize = includingTags.length;
        StringUtil.appendPlaceholders((StringBuilder)_stringBuilder, (int)_inputSize);
        _stringBuilder.append(")) else message.messageId is not null end and case when ");
        _stringBuilder.append("?");
        _stringBuilder.append(" then message.messageId not in (SELECT messageId from message_tag where tagName in (");
        int _inputSize_1 = excludingTags.length;
        StringUtil.appendPlaceholders((StringBuilder)_stringBuilder, (int)_inputSize_1);
        _stringBuilder.append(")) else message.messageId is not null end and case when ");
        _stringBuilder.append("?");
        _stringBuilder.append(" is not null then message.isDeleted = ");
        _stringBuilder.append("?");
        _stringBuilder.append(" else message.messageId is not null end and message.syncState != 'synced'  and message.uniqueId not in (SELECT amity_paging_id.id from amity_paging_id where amity_paging_id.hash = (");
        _stringBuilder.append("?");
        _stringBuilder.append(") and amity_paging_id.nonce = (");
        _stringBuilder.append("?");
        _stringBuilder.append(") ) and message.type in (");
        int _inputSize_2 = type.size();
        StringUtil.appendPlaceholders((StringBuilder)_stringBuilder, (int)_inputSize_2);
        _stringBuilder.append(") order by message.updatedAt desc limit 1");
        String _sql = _stringBuilder.toString();
        int _argCount = 12 + _inputSize + _inputSize_1 + _inputSize_2;
        final RoomSQLiteQuery _statement = RoomSQLiteQuery.acquire((String)_sql, (int)_argCount);
        int _argIndex = 1;
        if (subChannelId == null) {
            _statement.bindNull(_argIndex);
        } else {
            _statement.bindString(_argIndex, subChannelId);
        }
        _argIndex = 2;
        Integer n = isFilterByParentId == null ? null : (_tmp = Integer.valueOf(isFilterByParentId != false ? 1 : 0));
        if (_tmp == null) {
            _statement.bindNull(_argIndex);
        } else {
            _statement.bindLong(_argIndex, (long)_tmp.intValue());
        }
        _argIndex = 3;
        if (parentId == null) {
            _statement.bindNull(_argIndex);
        } else {
            _statement.bindString(_argIndex, parentId);
        }
        _argIndex = 4;
        if (parentId == null) {
            _statement.bindNull(_argIndex);
        } else {
            _statement.bindString(_argIndex, parentId);
        }
        _argIndex = 5;
        Integer n2 = isFilterByParentId == null ? null : (_tmp_1 = Integer.valueOf(isFilterByParentId != false ? 1 : 0));
        if (_tmp_1 == null) {
            _statement.bindNull(_argIndex);
        } else {
            _statement.bindLong(_argIndex, (long)_tmp_1.intValue());
        }
        _argIndex = 6;
        if (parentId == null) {
            _statement.bindNull(_argIndex);
        } else {
            _statement.bindString(_argIndex, parentId);
        }
        _argIndex = 7;
        int _tmp_2 = isIncludingTags ? 1 : 0;
        _statement.bindLong(_argIndex, (long)_tmp_2);
        _argIndex = 8;
        for (String _item : includingTags) {
            if (_item == null) {
                _statement.bindNull(_argIndex);
            } else {
                _statement.bindString(_argIndex, _item);
            }
            ++_argIndex;
        }
        _argIndex = 8 + _inputSize;
        int _tmp_3 = isExcludingTags ? 1 : 0;
        _statement.bindLong(_argIndex, (long)_tmp_3);
        _argIndex = 9 + _inputSize;
        for (String _item_1 : excludingTags) {
            if (_item_1 == null) {
                _statement.bindNull(_argIndex);
            } else {
                _statement.bindString(_argIndex, _item_1);
            }
            ++_argIndex;
        }
        _argIndex = 9 + _inputSize + _inputSize_1;
        Integer n3 = isDeleted == null ? null : (_tmp_4 = Integer.valueOf(isDeleted != false ? 1 : 0));
        if (_tmp_4 == null) {
            _statement.bindNull(_argIndex);
        } else {
            _statement.bindLong(_argIndex, (long)_tmp_4.intValue());
        }
        _argIndex = 10 + _inputSize + _inputSize_1;
        Integer n4 = isDeleted == null ? null : (_tmp_5 = Integer.valueOf(isDeleted != false ? 1 : 0));
        if (_tmp_5 == null) {
            _statement.bindNull(_argIndex);
        } else {
            _statement.bindLong(_argIndex, (long)_tmp_5.intValue());
        }
        _argIndex = 11 + _inputSize + _inputSize_1;
        _statement.bindLong(_argIndex, (long)hash);
        _argIndex = 12 + _inputSize + _inputSize_1;
        _statement.bindLong(_argIndex, (long)nonce);
        _argIndex = 13 + _inputSize + _inputSize_1;
        for (String _item_2 : type) {
            if (_item_2 == null) {
                _statement.bindNull(_argIndex);
            } else {
                _statement.bindString(_argIndex, _item_2);
            }
            ++_argIndex;
        }
        return RxRoom.createFlowable((RoomDatabase)this.__db, (boolean)false, (String[])new String[]{"message", "message_tag", "amity_paging_id"}, (Callable)new Callable<EkoMessageEntity>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public EkoMessageEntity call() throws Exception {
                try (Cursor _cursor = DBUtil.query((RoomDatabase)EkoMessageDao_Impl.this.__db, (SupportSQLiteQuery)_statement, (boolean)false, null);){
                    EkoMessageEntity _result;
                    int _cursorIndexOfUniqueId = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"uniqueId");
                    int _cursorIndexOfMessageId = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"messageId");
                    int _cursorIndexOfSubChannelId = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"subChannelId");
                    int _cursorIndexOfChannelId = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"channelId");
                    int _cursorIndexOfUserId = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"userId");
                    int _cursorIndexOfParentId = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"parentId");
                    int _cursorIndexOfChannelSegment = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"channelSegment");
                    int _cursorIndexOfChildrenNumber = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"childrenNumber");
                    int _cursorIndexOfEditedAt = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"editedAt");
                    int _cursorIndexOfIsDeleted = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"isDeleted");
                    int _cursorIndexOfFlagCount = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"flagCount");
                    int _cursorIndexOfTags = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"tags");
                    int _cursorIndexOfReactions = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"reactions");
                    int _cursorIndexOfReactionCount = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"reactionCount");
                    int _cursorIndexOfType = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"type");
                    int _cursorIndexOfData = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"data");
                    int _cursorIndexOfMetadata = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"metadata");
                    int _cursorIndexOfMentionees = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"mentionees");
                    int _cursorIndexOfPath = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"path");
                    int _cursorIndexOfSyncState = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"syncState");
                    int _cursorIndexOfMessageMarkerHash = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"messageMarkerHash");
                    int _cursorIndexOfCreatedAt = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"createdAt");
                    int _cursorIndexOfUpdatedAt = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"updatedAt");
                    int _cursorIndexOfExpiresAt = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"expiresAt");
                    if (_cursor.moveToFirst()) {
                        _result = new EkoMessageEntity();
                        String _tmpUniqueId = _cursor.isNull(_cursorIndexOfUniqueId) ? null : _cursor.getString(_cursorIndexOfUniqueId);
                        _result.setUniqueId(_tmpUniqueId);
                        String _tmpMessageId = _cursor.isNull(_cursorIndexOfMessageId) ? null : _cursor.getString(_cursorIndexOfMessageId);
                        _result.setMessageId(_tmpMessageId);
                        String _tmpSubChannelId = _cursor.isNull(_cursorIndexOfSubChannelId) ? null : _cursor.getString(_cursorIndexOfSubChannelId);
                        _result.setSubChannelId(_tmpSubChannelId);
                        String _tmpChannelId = _cursor.isNull(_cursorIndexOfChannelId) ? null : _cursor.getString(_cursorIndexOfChannelId);
                        _result.setChannelId(_tmpChannelId);
                        String _tmpUserId = _cursor.isNull(_cursorIndexOfUserId) ? null : _cursor.getString(_cursorIndexOfUserId);
                        _result.setUserId(_tmpUserId);
                        String _tmpParentId = _cursor.isNull(_cursorIndexOfParentId) ? null : _cursor.getString(_cursorIndexOfParentId);
                        _result.setParentId(_tmpParentId);
                        int _tmpChannelSegment = _cursor.getInt(_cursorIndexOfChannelSegment);
                        _result.setChannelSegment(_tmpChannelSegment);
                        int _tmpChildrenNumber = _cursor.getInt(_cursorIndexOfChildrenNumber);
                        _result.setChildrenNumber(_tmpChildrenNumber);
                        String _tmp_6 = _cursor.isNull(_cursorIndexOfEditedAt) ? null : _cursor.getString(_cursorIndexOfEditedAt);
                        DateTime _tmpEditedAt = EkoMessageDao_Impl.this.__dateTimeTypeConverter.stringToDateTime(_tmp_6);
                        _result.setEditedAt(_tmpEditedAt);
                        int _tmp_7 = _cursor.getInt(_cursorIndexOfIsDeleted);
                        boolean _tmpIsDeleted = _tmp_7 != 0;
                        _result.setDeleted(_tmpIsDeleted);
                        int _tmpFlagCount = _cursor.getInt(_cursorIndexOfFlagCount);
                        _result.setFlagCount(_tmpFlagCount);
                        String _tmp_8 = _cursor.isNull(_cursorIndexOfTags) ? null : _cursor.getString(_cursorIndexOfTags);
                        AmityTags _tmpTags = EkoMessageDao_Impl.this.__ekoTagsTypeConverter.stringToEkoTags(_tmp_8);
                        _result.setTags(_tmpTags);
                        String _tmp_9 = _cursor.isNull(_cursorIndexOfReactions) ? null : _cursor.getString(_cursorIndexOfReactions);
                        AmityReactionMap _tmpReactions = EkoMessageDao_Impl.this.__ekoReactionMapConverter.stringToStringIntMap(_tmp_9);
                        _result.setReactions(_tmpReactions);
                        int _tmpReactionCount = _cursor.getInt(_cursorIndexOfReactionCount);
                        _result.setReactionCount(_tmpReactionCount);
                        String _tmpType = _cursor.isNull(_cursorIndexOfType) ? null : _cursor.getString(_cursorIndexOfType);
                        _result.setType(_tmpType);
                        String _tmp_10 = _cursor.isNull(_cursorIndexOfData) ? null : _cursor.getString(_cursorIndexOfData);
                        JsonObject _tmpData = EkoMessageDao_Impl.this.__jsonObjectTypeConverter.stringToJsonObject(_tmp_10);
                        _result.setData(_tmpData);
                        String _tmp_11 = _cursor.isNull(_cursorIndexOfMetadata) ? null : _cursor.getString(_cursorIndexOfMetadata);
                        JsonObject _tmpMetadata = EkoMessageDao_Impl.this.__jsonObjectTypeConverter.stringToJsonObject(_tmp_11);
                        _result.setMetadata(_tmpMetadata);
                        String _tmp_12 = _cursor.isNull(_cursorIndexOfMentionees) ? null : _cursor.getString(_cursorIndexOfMentionees);
                        List<EkoMentioneesDto> _tmpMentionees = EkoMessageDao_Impl.this.__mentioneesConverter.jsonToMentionees(_tmp_12);
                        _result.setMentionees(_tmpMentionees);
                        String _tmpPath = _cursor.isNull(_cursorIndexOfPath) ? null : _cursor.getString(_cursorIndexOfPath);
                        _result.setPath(_tmpPath);
                        String _tmpSyncState = _cursor.isNull(_cursorIndexOfSyncState) ? null : _cursor.getString(_cursorIndexOfSyncState);
                        _result.setSyncState(_tmpSyncState);
                        int _tmpMessageMarkerHash = _cursor.getInt(_cursorIndexOfMessageMarkerHash);
                        _result.setMessageMarkerHash(_tmpMessageMarkerHash);
                        String _tmp_13 = _cursor.isNull(_cursorIndexOfCreatedAt) ? null : _cursor.getString(_cursorIndexOfCreatedAt);
                        DateTime _tmpCreatedAt = EkoMessageDao_Impl.this.__dateTimeTypeConverter.stringToDateTime(_tmp_13);
                        _result.setCreatedAt(_tmpCreatedAt);
                        String _tmp_14 = _cursor.isNull(_cursorIndexOfUpdatedAt) ? null : _cursor.getString(_cursorIndexOfUpdatedAt);
                        DateTime _tmpUpdatedAt = EkoMessageDao_Impl.this.__dateTimeTypeConverter.stringToDateTime(_tmp_14);
                        _result.setUpdatedAt(_tmpUpdatedAt);
                        String _tmp_15 = _cursor.isNull(_cursorIndexOfExpiresAt) ? null : _cursor.getString(_cursorIndexOfExpiresAt);
                        DateTime _tmpExpiresAt = EkoMessageDao_Impl.this.__dateTimeTypeConverter.stringToDateTime(_tmp_15);
                        _result.setExpiresAt(_tmpExpiresAt);
                    } else {
                        _result = null;
                    }
                    EkoMessageEntity ekoMessageEntity = _result;
                    return ekoMessageEntity;
                }
            }

            protected void finalize() {
                _statement.release();
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<EkoMessageEntity> getCacheBeforeMessageIdImpl(String messageId) {
        String _sql = "SELECT * FROM message WHERE createdAt < (SELECT createdAt FROM message WHERE messageId = ?) ORDER BY createdAt DESC LIMIT 20";
        RoomSQLiteQuery _statement = RoomSQLiteQuery.acquire((String)"SELECT * FROM message WHERE createdAt < (SELECT createdAt FROM message WHERE messageId = ?) ORDER BY createdAt DESC LIMIT 20", (int)1);
        int _argIndex = 1;
        if (messageId == null) {
            _statement.bindNull(_argIndex);
        } else {
            _statement.bindString(_argIndex, messageId);
        }
        this.__db.assertNotSuspendingTransaction();
        Cursor _cursor = DBUtil.query((RoomDatabase)this.__db, (SupportSQLiteQuery)_statement, (boolean)false, null);
        try {
            int _cursorIndexOfUniqueId = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"uniqueId");
            int _cursorIndexOfMessageId = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"messageId");
            int _cursorIndexOfSubChannelId = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"subChannelId");
            int _cursorIndexOfChannelId = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"channelId");
            int _cursorIndexOfUserId = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"userId");
            int _cursorIndexOfParentId = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"parentId");
            int _cursorIndexOfChannelSegment = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"channelSegment");
            int _cursorIndexOfChildrenNumber = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"childrenNumber");
            int _cursorIndexOfEditedAt = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"editedAt");
            int _cursorIndexOfIsDeleted = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"isDeleted");
            int _cursorIndexOfFlagCount = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"flagCount");
            int _cursorIndexOfTags = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"tags");
            int _cursorIndexOfReactions = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"reactions");
            int _cursorIndexOfReactionCount = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"reactionCount");
            int _cursorIndexOfType = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"type");
            int _cursorIndexOfData = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"data");
            int _cursorIndexOfMetadata = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"metadata");
            int _cursorIndexOfMentionees = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"mentionees");
            int _cursorIndexOfPath = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"path");
            int _cursorIndexOfSyncState = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"syncState");
            int _cursorIndexOfMessageMarkerHash = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"messageMarkerHash");
            int _cursorIndexOfCreatedAt = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"createdAt");
            int _cursorIndexOfUpdatedAt = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"updatedAt");
            int _cursorIndexOfExpiresAt = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"expiresAt");
            ArrayList<EkoMessageEntity> _result = new ArrayList<EkoMessageEntity>(_cursor.getCount());
            while (_cursor.moveToNext()) {
                EkoMessageEntity _item = new EkoMessageEntity();
                String _tmpUniqueId = _cursor.isNull(_cursorIndexOfUniqueId) ? null : _cursor.getString(_cursorIndexOfUniqueId);
                _item.setUniqueId(_tmpUniqueId);
                String _tmpMessageId = _cursor.isNull(_cursorIndexOfMessageId) ? null : _cursor.getString(_cursorIndexOfMessageId);
                _item.setMessageId(_tmpMessageId);
                String _tmpSubChannelId = _cursor.isNull(_cursorIndexOfSubChannelId) ? null : _cursor.getString(_cursorIndexOfSubChannelId);
                _item.setSubChannelId(_tmpSubChannelId);
                String _tmpChannelId = _cursor.isNull(_cursorIndexOfChannelId) ? null : _cursor.getString(_cursorIndexOfChannelId);
                _item.setChannelId(_tmpChannelId);
                String _tmpUserId = _cursor.isNull(_cursorIndexOfUserId) ? null : _cursor.getString(_cursorIndexOfUserId);
                _item.setUserId(_tmpUserId);
                String _tmpParentId = _cursor.isNull(_cursorIndexOfParentId) ? null : _cursor.getString(_cursorIndexOfParentId);
                _item.setParentId(_tmpParentId);
                int _tmpChannelSegment = _cursor.getInt(_cursorIndexOfChannelSegment);
                _item.setChannelSegment(_tmpChannelSegment);
                int _tmpChildrenNumber = _cursor.getInt(_cursorIndexOfChildrenNumber);
                _item.setChildrenNumber(_tmpChildrenNumber);
                String _tmp = _cursor.isNull(_cursorIndexOfEditedAt) ? null : _cursor.getString(_cursorIndexOfEditedAt);
                DateTime _tmpEditedAt = this.__dateTimeTypeConverter.stringToDateTime(_tmp);
                _item.setEditedAt(_tmpEditedAt);
                int _tmp_1 = _cursor.getInt(_cursorIndexOfIsDeleted);
                boolean _tmpIsDeleted = _tmp_1 != 0;
                _item.setDeleted(_tmpIsDeleted);
                int _tmpFlagCount = _cursor.getInt(_cursorIndexOfFlagCount);
                _item.setFlagCount(_tmpFlagCount);
                String _tmp_2 = _cursor.isNull(_cursorIndexOfTags) ? null : _cursor.getString(_cursorIndexOfTags);
                AmityTags _tmpTags = this.__ekoTagsTypeConverter.stringToEkoTags(_tmp_2);
                _item.setTags(_tmpTags);
                String _tmp_3 = _cursor.isNull(_cursorIndexOfReactions) ? null : _cursor.getString(_cursorIndexOfReactions);
                AmityReactionMap _tmpReactions = this.__ekoReactionMapConverter.stringToStringIntMap(_tmp_3);
                _item.setReactions(_tmpReactions);
                int _tmpReactionCount = _cursor.getInt(_cursorIndexOfReactionCount);
                _item.setReactionCount(_tmpReactionCount);
                String _tmpType = _cursor.isNull(_cursorIndexOfType) ? null : _cursor.getString(_cursorIndexOfType);
                _item.setType(_tmpType);
                String _tmp_4 = _cursor.isNull(_cursorIndexOfData) ? null : _cursor.getString(_cursorIndexOfData);
                JsonObject _tmpData = this.__jsonObjectTypeConverter.stringToJsonObject(_tmp_4);
                _item.setData(_tmpData);
                String _tmp_5 = _cursor.isNull(_cursorIndexOfMetadata) ? null : _cursor.getString(_cursorIndexOfMetadata);
                JsonObject _tmpMetadata = this.__jsonObjectTypeConverter.stringToJsonObject(_tmp_5);
                _item.setMetadata(_tmpMetadata);
                String _tmp_6 = _cursor.isNull(_cursorIndexOfMentionees) ? null : _cursor.getString(_cursorIndexOfMentionees);
                List<EkoMentioneesDto> _tmpMentionees = this.__mentioneesConverter.jsonToMentionees(_tmp_6);
                _item.setMentionees(_tmpMentionees);
                String _tmpPath = _cursor.isNull(_cursorIndexOfPath) ? null : _cursor.getString(_cursorIndexOfPath);
                _item.setPath(_tmpPath);
                String _tmpSyncState = _cursor.isNull(_cursorIndexOfSyncState) ? null : _cursor.getString(_cursorIndexOfSyncState);
                _item.setSyncState(_tmpSyncState);
                int _tmpMessageMarkerHash = _cursor.getInt(_cursorIndexOfMessageMarkerHash);
                _item.setMessageMarkerHash(_tmpMessageMarkerHash);
                String _tmp_7 = _cursor.isNull(_cursorIndexOfCreatedAt) ? null : _cursor.getString(_cursorIndexOfCreatedAt);
                DateTime _tmpCreatedAt = this.__dateTimeTypeConverter.stringToDateTime(_tmp_7);
                _item.setCreatedAt(_tmpCreatedAt);
                String _tmp_8 = _cursor.isNull(_cursorIndexOfUpdatedAt) ? null : _cursor.getString(_cursorIndexOfUpdatedAt);
                DateTime _tmpUpdatedAt = this.__dateTimeTypeConverter.stringToDateTime(_tmp_8);
                _item.setUpdatedAt(_tmpUpdatedAt);
                String _tmp_9 = _cursor.isNull(_cursorIndexOfExpiresAt) ? null : _cursor.getString(_cursorIndexOfExpiresAt);
                DateTime _tmpExpiresAt = this.__dateTimeTypeConverter.stringToDateTime(_tmp_9);
                _item.setExpiresAt(_tmpExpiresAt);
                _result.add(_item);
            }
            ArrayList<EkoMessageEntity> arrayList = _result;
            return arrayList;
        }
        finally {
            _cursor.close();
            _statement.release();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<EkoMessageEntity> getCacheAfterMessageIdImpl(String messageId) {
        String _sql = "SELECT * FROM message WHERE createdAt > (SELECT createdAt FROM message WHERE messageId = ?) ORDER BY createdAt ASC LIMIT 20";
        RoomSQLiteQuery _statement = RoomSQLiteQuery.acquire((String)"SELECT * FROM message WHERE createdAt > (SELECT createdAt FROM message WHERE messageId = ?) ORDER BY createdAt ASC LIMIT 20", (int)1);
        int _argIndex = 1;
        if (messageId == null) {
            _statement.bindNull(_argIndex);
        } else {
            _statement.bindString(_argIndex, messageId);
        }
        this.__db.assertNotSuspendingTransaction();
        Cursor _cursor = DBUtil.query((RoomDatabase)this.__db, (SupportSQLiteQuery)_statement, (boolean)false, null);
        try {
            int _cursorIndexOfUniqueId = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"uniqueId");
            int _cursorIndexOfMessageId = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"messageId");
            int _cursorIndexOfSubChannelId = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"subChannelId");
            int _cursorIndexOfChannelId = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"channelId");
            int _cursorIndexOfUserId = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"userId");
            int _cursorIndexOfParentId = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"parentId");
            int _cursorIndexOfChannelSegment = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"channelSegment");
            int _cursorIndexOfChildrenNumber = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"childrenNumber");
            int _cursorIndexOfEditedAt = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"editedAt");
            int _cursorIndexOfIsDeleted = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"isDeleted");
            int _cursorIndexOfFlagCount = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"flagCount");
            int _cursorIndexOfTags = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"tags");
            int _cursorIndexOfReactions = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"reactions");
            int _cursorIndexOfReactionCount = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"reactionCount");
            int _cursorIndexOfType = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"type");
            int _cursorIndexOfData = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"data");
            int _cursorIndexOfMetadata = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"metadata");
            int _cursorIndexOfMentionees = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"mentionees");
            int _cursorIndexOfPath = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"path");
            int _cursorIndexOfSyncState = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"syncState");
            int _cursorIndexOfMessageMarkerHash = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"messageMarkerHash");
            int _cursorIndexOfCreatedAt = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"createdAt");
            int _cursorIndexOfUpdatedAt = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"updatedAt");
            int _cursorIndexOfExpiresAt = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"expiresAt");
            ArrayList<EkoMessageEntity> _result = new ArrayList<EkoMessageEntity>(_cursor.getCount());
            while (_cursor.moveToNext()) {
                EkoMessageEntity _item = new EkoMessageEntity();
                String _tmpUniqueId = _cursor.isNull(_cursorIndexOfUniqueId) ? null : _cursor.getString(_cursorIndexOfUniqueId);
                _item.setUniqueId(_tmpUniqueId);
                String _tmpMessageId = _cursor.isNull(_cursorIndexOfMessageId) ? null : _cursor.getString(_cursorIndexOfMessageId);
                _item.setMessageId(_tmpMessageId);
                String _tmpSubChannelId = _cursor.isNull(_cursorIndexOfSubChannelId) ? null : _cursor.getString(_cursorIndexOfSubChannelId);
                _item.setSubChannelId(_tmpSubChannelId);
                String _tmpChannelId = _cursor.isNull(_cursorIndexOfChannelId) ? null : _cursor.getString(_cursorIndexOfChannelId);
                _item.setChannelId(_tmpChannelId);
                String _tmpUserId = _cursor.isNull(_cursorIndexOfUserId) ? null : _cursor.getString(_cursorIndexOfUserId);
                _item.setUserId(_tmpUserId);
                String _tmpParentId = _cursor.isNull(_cursorIndexOfParentId) ? null : _cursor.getString(_cursorIndexOfParentId);
                _item.setParentId(_tmpParentId);
                int _tmpChannelSegment = _cursor.getInt(_cursorIndexOfChannelSegment);
                _item.setChannelSegment(_tmpChannelSegment);
                int _tmpChildrenNumber = _cursor.getInt(_cursorIndexOfChildrenNumber);
                _item.setChildrenNumber(_tmpChildrenNumber);
                String _tmp = _cursor.isNull(_cursorIndexOfEditedAt) ? null : _cursor.getString(_cursorIndexOfEditedAt);
                DateTime _tmpEditedAt = this.__dateTimeTypeConverter.stringToDateTime(_tmp);
                _item.setEditedAt(_tmpEditedAt);
                int _tmp_1 = _cursor.getInt(_cursorIndexOfIsDeleted);
                boolean _tmpIsDeleted = _tmp_1 != 0;
                _item.setDeleted(_tmpIsDeleted);
                int _tmpFlagCount = _cursor.getInt(_cursorIndexOfFlagCount);
                _item.setFlagCount(_tmpFlagCount);
                String _tmp_2 = _cursor.isNull(_cursorIndexOfTags) ? null : _cursor.getString(_cursorIndexOfTags);
                AmityTags _tmpTags = this.__ekoTagsTypeConverter.stringToEkoTags(_tmp_2);
                _item.setTags(_tmpTags);
                String _tmp_3 = _cursor.isNull(_cursorIndexOfReactions) ? null : _cursor.getString(_cursorIndexOfReactions);
                AmityReactionMap _tmpReactions = this.__ekoReactionMapConverter.stringToStringIntMap(_tmp_3);
                _item.setReactions(_tmpReactions);
                int _tmpReactionCount = _cursor.getInt(_cursorIndexOfReactionCount);
                _item.setReactionCount(_tmpReactionCount);
                String _tmpType = _cursor.isNull(_cursorIndexOfType) ? null : _cursor.getString(_cursorIndexOfType);
                _item.setType(_tmpType);
                String _tmp_4 = _cursor.isNull(_cursorIndexOfData) ? null : _cursor.getString(_cursorIndexOfData);
                JsonObject _tmpData = this.__jsonObjectTypeConverter.stringToJsonObject(_tmp_4);
                _item.setData(_tmpData);
                String _tmp_5 = _cursor.isNull(_cursorIndexOfMetadata) ? null : _cursor.getString(_cursorIndexOfMetadata);
                JsonObject _tmpMetadata = this.__jsonObjectTypeConverter.stringToJsonObject(_tmp_5);
                _item.setMetadata(_tmpMetadata);
                String _tmp_6 = _cursor.isNull(_cursorIndexOfMentionees) ? null : _cursor.getString(_cursorIndexOfMentionees);
                List<EkoMentioneesDto> _tmpMentionees = this.__mentioneesConverter.jsonToMentionees(_tmp_6);
                _item.setMentionees(_tmpMentionees);
                String _tmpPath = _cursor.isNull(_cursorIndexOfPath) ? null : _cursor.getString(_cursorIndexOfPath);
                _item.setPath(_tmpPath);
                String _tmpSyncState = _cursor.isNull(_cursorIndexOfSyncState) ? null : _cursor.getString(_cursorIndexOfSyncState);
                _item.setSyncState(_tmpSyncState);
                int _tmpMessageMarkerHash = _cursor.getInt(_cursorIndexOfMessageMarkerHash);
                _item.setMessageMarkerHash(_tmpMessageMarkerHash);
                String _tmp_7 = _cursor.isNull(_cursorIndexOfCreatedAt) ? null : _cursor.getString(_cursorIndexOfCreatedAt);
                DateTime _tmpCreatedAt = this.__dateTimeTypeConverter.stringToDateTime(_tmp_7);
                _item.setCreatedAt(_tmpCreatedAt);
                String _tmp_8 = _cursor.isNull(_cursorIndexOfUpdatedAt) ? null : _cursor.getString(_cursorIndexOfUpdatedAt);
                DateTime _tmpUpdatedAt = this.__dateTimeTypeConverter.stringToDateTime(_tmp_8);
                _item.setUpdatedAt(_tmpUpdatedAt);
                String _tmp_9 = _cursor.isNull(_cursorIndexOfExpiresAt) ? null : _cursor.getString(_cursorIndexOfExpiresAt);
                DateTime _tmpExpiresAt = this.__dateTimeTypeConverter.stringToDateTime(_tmp_9);
                _item.setExpiresAt(_tmpExpiresAt);
                _result.add(_item);
            }
            ArrayList<EkoMessageEntity> arrayList = _result;
            return arrayList;
        }
        finally {
            _cursor.close();
            _statement.release();
        }
    }

    public static List<Class<?>> getRequiredConverters() {
        return Collections.emptyList();
    }
}

